/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.util.OptionHelper;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;

public class Loader {
    static final String TSTR = "Caught Exception while in Loader.getResource. This may be innocuous.";
    private static boolean ignoreTCL = false;
    public static final String IGNORE_TCL_PROPERTY_NAME = "logback.ignoreTCL";

    public static ClassLoader systemClassloaderIfNull(ClassLoader classLoader) {
        if (classLoader == null) {
            return ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    public static Set<URL> getResources(String object, ClassLoader object2) throws IOException {
        HashSet<URL> hashSet = new HashSet<URL>();
        object = ((ClassLoader)object2).getResources((String)object);
        while (object.hasMoreElements()) {
            object2 = (URL)object.nextElement();
            hashSet.add((URL)object2);
        }
        return hashSet;
    }

    public static URL getResource(String string, ClassLoader classLoader) {
        try {
            return classLoader.getResource(string);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static URL getResourceBySelfClassLoader(String string) {
        return Loader.getResource(string, Loader.getClassLoaderOfClass(Loader.class));
    }

    public static ClassLoader getTCL() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static Class<?> loadClass(String string, Context object) throws ClassNotFoundException {
        object = Loader.getClassLoaderOfObject(object);
        return ((ClassLoader)object).loadClass(string);
    }

    public static ClassLoader getClassLoaderOfObject(Object object) {
        if (object == null) {
            throw new NullPointerException("Argument cannot be null");
        }
        return Loader.getClassLoaderOfClass(object.getClass());
    }

    public static boolean isClassLoadable(String string, Context context) {
        try {
            Loader.loadClass(string, context);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static ClassLoader getClassLoaderOfClass(Class<?> object) {
        object = ((Class)object).getClassLoader();
        return Loader.systemClassloaderIfNull((ClassLoader)object);
    }

    public static Class<?> loadClass(String string) throws ClassNotFoundException {
        if (ignoreTCL) {
            return Class.forName(string);
        }
        try {
            return Loader.getTCL().loadClass(string);
        }
        catch (Throwable throwable) {
            return Class.forName(string);
        }
    }

    static {
        String string = OptionHelper.getSystemProperty(IGNORE_TCL_PROPERTY_NAME, null);
        if (string != null) {
            ignoreTCL = OptionHelper.toBoolean(string, true);
        }
    }
}

