/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core;

import com.fasterxml.jackson.core.Base64Variant$PaddingReadBehaviour;
import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import java.io.Serializable;
import java.util.Arrays;

public final class Base64Variant
implements Serializable {
    private static final int INT_SPACE = 32;
    private static final long serialVersionUID = 1L;
    protected static final char PADDING_CHAR_NONE = '\u0000';
    public static final int BASE64_VALUE_INVALID = -1;
    public static final int BASE64_VALUE_PADDING = -2;
    private final transient int[] _asciiToBase64;
    private final transient char[] _base64ToAsciiC;
    private final transient byte[] _base64ToAsciiB;
    final String _name;
    private final char _paddingChar;
    private final int _maxLineLength;
    private final boolean _writePadding;
    private final Base64Variant$PaddingReadBehaviour _paddingReadBehaviour;

    public Base64Variant(String string, String string2, boolean bl2, char c2, int n2) {
        this._asciiToBase64 = new int[128];
        this._base64ToAsciiC = new char[64];
        this._base64ToAsciiB = new byte[64];
        this._name = string;
        this._writePadding = bl2;
        this._paddingChar = c2;
        this._maxLineLength = n2;
        int n3 = string2.length();
        if (n3 != 64) {
            throw new IllegalArgumentException("Base64Alphabet length must be exactly 64 (was " + n3 + ")");
        }
        string2.getChars(0, n3, this._base64ToAsciiC, 0);
        Arrays.fill(this._asciiToBase64, -1);
        int n4 = 0;
        while (n4 < n3) {
            n2 = this._base64ToAsciiC[n4];
            this._base64ToAsciiB[n4] = (byte)n2;
            this._asciiToBase64[n2] = n4++;
        }
        if (bl2) {
            this._asciiToBase64[c2] = -2;
        }
        this._paddingReadBehaviour = bl2 ? Base64Variant$PaddingReadBehaviour.PADDING_REQUIRED : Base64Variant$PaddingReadBehaviour.PADDING_FORBIDDEN;
    }

    public Base64Variant(Base64Variant base64Variant, String string, int n2) {
        this(base64Variant, string, base64Variant._writePadding, base64Variant._paddingChar, n2);
    }

    public Base64Variant(Base64Variant base64Variant, String string, boolean bl2, char c2, int n2) {
        this(base64Variant, string, bl2, c2, base64Variant._paddingReadBehaviour, n2);
    }

    private Base64Variant(Base64Variant object, String object2, boolean bl2, char c2, Base64Variant$PaddingReadBehaviour base64Variant$PaddingReadBehaviour, int n2) {
        this._asciiToBase64 = new int[128];
        this._base64ToAsciiC = new char[64];
        this._base64ToAsciiB = new byte[64];
        this._name = object2;
        object2 = ((Base64Variant)object)._base64ToAsciiB;
        System.arraycopy(((Base64Variant)object)._base64ToAsciiB, 0, this._base64ToAsciiB, 0, ((Object)object2).length);
        object2 = ((Base64Variant)object)._base64ToAsciiC;
        System.arraycopy(((Base64Variant)object)._base64ToAsciiC, 0, this._base64ToAsciiC, 0, ((Object)object2).length);
        object = ((Base64Variant)object)._asciiToBase64;
        System.arraycopy(((Base64Variant)object)._asciiToBase64, 0, this._asciiToBase64, 0, ((Object)object).length);
        this._writePadding = bl2;
        this._paddingChar = c2;
        this._maxLineLength = n2;
        this._paddingReadBehaviour = base64Variant$PaddingReadBehaviour;
    }

    private Base64Variant(Base64Variant base64Variant, Base64Variant$PaddingReadBehaviour base64Variant$PaddingReadBehaviour) {
        Base64Variant base64Variant2 = base64Variant;
        this(base64Variant2, base64Variant2._name, base64Variant._writePadding, base64Variant._paddingChar, base64Variant$PaddingReadBehaviour, base64Variant._maxLineLength);
    }

    public final Base64Variant withPaddingAllowed() {
        return this.withReadPadding(Base64Variant$PaddingReadBehaviour.PADDING_ALLOWED);
    }

    public final Base64Variant withPaddingRequired() {
        return this.withReadPadding(Base64Variant$PaddingReadBehaviour.PADDING_REQUIRED);
    }

    public final Base64Variant withPaddingForbidden() {
        return this.withReadPadding(Base64Variant$PaddingReadBehaviour.PADDING_FORBIDDEN);
    }

    public final Base64Variant withReadPadding(Base64Variant$PaddingReadBehaviour base64Variant$PaddingReadBehaviour) {
        if (base64Variant$PaddingReadBehaviour == this._paddingReadBehaviour) {
            return this;
        }
        return new Base64Variant(this, base64Variant$PaddingReadBehaviour);
    }

    public final Base64Variant withWritePadding(boolean bl2) {
        if (bl2 == this._writePadding) {
            return this;
        }
        Base64Variant base64Variant = this;
        return new Base64Variant(base64Variant, base64Variant._name, bl2, this._paddingChar, this._maxLineLength);
    }

    protected final Object readResolve() {
        Base64Variant base64Variant = Base64Variants.valueOf(this._name);
        if (this._writePadding != base64Variant._writePadding || this._paddingChar != base64Variant._paddingChar || this._paddingReadBehaviour != base64Variant._paddingReadBehaviour || this._maxLineLength != base64Variant._maxLineLength) {
            return new Base64Variant(base64Variant, this._name, this._writePadding, this._paddingChar, this._paddingReadBehaviour, this._maxLineLength);
        }
        return base64Variant;
    }

    public final String getName() {
        return this._name;
    }

    public final boolean usesPadding() {
        return this._writePadding;
    }

    public final boolean requiresPaddingOnRead() {
        return this._paddingReadBehaviour == Base64Variant$PaddingReadBehaviour.PADDING_REQUIRED;
    }

    public final boolean acceptsPaddingOnRead() {
        return this._paddingReadBehaviour != Base64Variant$PaddingReadBehaviour.PADDING_FORBIDDEN;
    }

    public final boolean usesPaddingChar(char c2) {
        return c2 == this._paddingChar;
    }

    public final boolean usesPaddingChar(int n2) {
        return n2 == this._paddingChar;
    }

    public final Base64Variant$PaddingReadBehaviour paddingReadBehaviour() {
        return this._paddingReadBehaviour;
    }

    public final char getPaddingChar() {
        return this._paddingChar;
    }

    public final byte getPaddingByte() {
        return (byte)this._paddingChar;
    }

    public final int getMaxLineLength() {
        return this._maxLineLength;
    }

    public final int decodeBase64Char(char c2) {
        if (c2 <= '\u007f') {
            return this._asciiToBase64[c2];
        }
        return -1;
    }

    public final int decodeBase64Char(int n2) {
        if (n2 <= 127) {
            return this._asciiToBase64[n2];
        }
        return -1;
    }

    public final int decodeBase64Byte(byte by2) {
        if (by2 < 0) {
            return -1;
        }
        return this._asciiToBase64[by2];
    }

    public final char encodeBase64BitsAsChar(int n2) {
        return this._base64ToAsciiC[n2];
    }

    public final int encodeBase64Chunk(int n2, char[] cArray, int n3) {
        cArray[n3++] = this._base64ToAsciiC[n2 >> 18 & 0x3F];
        cArray[n3++] = this._base64ToAsciiC[n2 >> 12 & 0x3F];
        cArray[n3++] = this._base64ToAsciiC[n2 >> 6 & 0x3F];
        cArray[n3++] = this._base64ToAsciiC[n2 & 0x3F];
        return n3;
    }

    public final void encodeBase64Chunk(StringBuilder stringBuilder, int n2) {
        stringBuilder.append(this._base64ToAsciiC[n2 >> 18 & 0x3F]);
        stringBuilder.append(this._base64ToAsciiC[n2 >> 12 & 0x3F]);
        stringBuilder.append(this._base64ToAsciiC[n2 >> 6 & 0x3F]);
        stringBuilder.append(this._base64ToAsciiC[n2 & 0x3F]);
    }

    public final int encodeBase64Partial(int n2, int n3, char[] cArray, int n4) {
        cArray[n4++] = this._base64ToAsciiC[n2 >> 18 & 0x3F];
        cArray[n4++] = this._base64ToAsciiC[n2 >> 12 & 0x3F];
        if (this.usesPadding()) {
            cArray[n4++] = n3 == 2 ? this._base64ToAsciiC[n2 >> 6 & 0x3F] : this._paddingChar;
            cArray[n4++] = this._paddingChar;
        } else if (n3 == 2) {
            cArray[n4++] = this._base64ToAsciiC[n2 >> 6 & 0x3F];
        }
        return n4;
    }

    public final void encodeBase64Partial(StringBuilder stringBuilder, int n2, int n3) {
        stringBuilder.append(this._base64ToAsciiC[n2 >> 18 & 0x3F]);
        stringBuilder.append(this._base64ToAsciiC[n2 >> 12 & 0x3F]);
        if (this.usesPadding()) {
            stringBuilder.append(n3 == 2 ? this._base64ToAsciiC[n2 >> 6 & 0x3F] : this._paddingChar);
            stringBuilder.append(this._paddingChar);
            return;
        }
        if (n3 == 2) {
            stringBuilder.append(this._base64ToAsciiC[n2 >> 6 & 0x3F]);
        }
    }

    public final byte encodeBase64BitsAsByte(int n2) {
        return this._base64ToAsciiB[n2];
    }

    public final int encodeBase64Chunk(int n2, byte[] byArray, int n3) {
        byArray[n3++] = this._base64ToAsciiB[n2 >> 18 & 0x3F];
        byArray[n3++] = this._base64ToAsciiB[n2 >> 12 & 0x3F];
        byArray[n3++] = this._base64ToAsciiB[n2 >> 6 & 0x3F];
        byArray[n3++] = this._base64ToAsciiB[n2 & 0x3F];
        return n3;
    }

    public final int encodeBase64Partial(int n2, int n3, byte[] byArray, int n4) {
        byArray[n4++] = this._base64ToAsciiB[n2 >> 18 & 0x3F];
        byArray[n4++] = this._base64ToAsciiB[n2 >> 12 & 0x3F];
        if (this.usesPadding()) {
            byte by2 = (byte)this._paddingChar;
            byArray[n4++] = n3 == 2 ? this._base64ToAsciiB[n2 >> 6 & 0x3F] : by2;
            byArray[n4++] = by2;
        } else if (n3 == 2) {
            byArray[n4++] = this._base64ToAsciiB[n2 >> 6 & 0x3F];
        }
        return n4;
    }

    public final String encode(byte[] byArray) {
        return this.encode(byArray, false);
    }

    public final String encode(byte[] byArray, boolean bl2) {
        int n2;
        int n3;
        int n4 = n3 = byArray.length;
        StringBuilder stringBuilder = new StringBuilder(n4 + (n4 >> 2) + (n3 >> 3));
        if (bl2) {
            stringBuilder.append('\"');
        }
        int n5 = this.getMaxLineLength() >> 2;
        int n6 = 0;
        int n7 = n3 - 3;
        while (n6 <= n7) {
            n2 = byArray[n6++] << 8;
            n2 |= byArray[n6++] & 0xFF;
            n2 = n2 << 8 | byArray[n6++] & 0xFF;
            this.encodeBase64Chunk(stringBuilder, n2);
            if (--n5 > 0) continue;
            stringBuilder.append('\\');
            stringBuilder.append('n');
            n5 = this.getMaxLineLength() >> 2;
        }
        n2 = n3 - n6;
        if (n2 > 0) {
            n3 = byArray[n6++] << 16;
            if (n2 == 2) {
                n3 |= (byArray[n6] & 0xFF) << 8;
            }
            this.encodeBase64Partial(stringBuilder, n3, n2);
        }
        if (bl2) {
            stringBuilder.append('\"');
        }
        return stringBuilder.toString();
    }

    public final String encode(byte[] byArray, boolean bl2, String string) {
        int n2;
        int n3;
        int n4 = n3 = byArray.length;
        StringBuilder stringBuilder = new StringBuilder(n4 + (n4 >> 2) + (n3 >> 3));
        if (bl2) {
            stringBuilder.append('\"');
        }
        int n5 = this.getMaxLineLength() >> 2;
        int n6 = 0;
        int n7 = n3 - 3;
        while (n6 <= n7) {
            n2 = byArray[n6++] << 8;
            n2 |= byArray[n6++] & 0xFF;
            n2 = n2 << 8 | byArray[n6++] & 0xFF;
            this.encodeBase64Chunk(stringBuilder, n2);
            if (--n5 > 0) continue;
            stringBuilder.append(string);
            n5 = this.getMaxLineLength() >> 2;
        }
        n2 = n3 - n6;
        if (n2 > 0) {
            int n8 = byArray[n6++] << 16;
            if (n2 == 2) {
                n8 |= (byArray[n6] & 0xFF) << 8;
            }
            this.encodeBase64Partial(stringBuilder, n8, n2);
        }
        if (bl2) {
            stringBuilder.append('\"');
        }
        return stringBuilder.toString();
    }

    public final byte[] decode(String string) throws IllegalArgumentException {
        ByteArrayBuilder byteArrayBuilder = new ByteArrayBuilder();
        this.decode(string, byteArrayBuilder);
        return byteArrayBuilder.toByteArray();
    }

    public final void decode(String string, ByteArrayBuilder byteArrayBuilder) throws IllegalArgumentException {
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3) {
            char c2;
            if ((c2 = string.charAt(n2++)) <= ' ') continue;
            int n4 = this.decodeBase64Char(c2);
            if (n4 < 0) {
                this._reportInvalidBase64(c2, 0, null);
            }
            int n5 = n4;
            if (n2 >= n3) {
                this._reportBase64EOF();
            }
            if ((n4 = this.decodeBase64Char(c2 = string.charAt(n2++))) < 0) {
                this._reportInvalidBase64(c2, 1, null);
            }
            n5 = n5 << 6 | n4;
            if (n2 >= n3) {
                if (!this.requiresPaddingOnRead()) {
                    byteArrayBuilder.append(n5 >>= 4);
                    return;
                }
                this._reportBase64EOF();
            }
            if ((n4 = this.decodeBase64Char(c2 = string.charAt(n2++))) < 0) {
                if (n4 != -2) {
                    this._reportInvalidBase64(c2, 2, null);
                }
                if (!this.acceptsPaddingOnRead()) {
                    this._reportBase64UnexpectedPadding();
                }
                if (n2 >= n3) {
                    this._reportBase64EOF();
                }
                if (!this.usesPaddingChar(c2 = string.charAt(n2++))) {
                    this._reportInvalidBase64(c2, 3, "expected padding character '" + this.getPaddingChar() + "'");
                }
                byteArrayBuilder.append(n5 >>= 4);
                continue;
            }
            n5 = n5 << 6 | n4;
            if (n2 >= n3) {
                if (!this.requiresPaddingOnRead()) {
                    byteArrayBuilder.appendTwoBytes(n5 >>= 2);
                    return;
                }
                this._reportBase64EOF();
            }
            if ((n4 = this.decodeBase64Char(c2 = string.charAt(n2++))) < 0) {
                if (n4 != -2) {
                    this._reportInvalidBase64(c2, 3, null);
                }
                if (!this.acceptsPaddingOnRead()) {
                    this._reportBase64UnexpectedPadding();
                }
                byteArrayBuilder.appendTwoBytes(n5 >>= 2);
                continue;
            }
            n5 = n5 << 6 | n4;
            byteArrayBuilder.appendThreeBytes(n5);
        }
    }

    public final String toString() {
        return this._name;
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        object = (Base64Variant)object;
        return ((Base64Variant)object)._paddingChar == this._paddingChar && ((Base64Variant)object)._maxLineLength == this._maxLineLength && ((Base64Variant)object)._writePadding == this._writePadding && ((Base64Variant)object)._paddingReadBehaviour == this._paddingReadBehaviour && this._name.equals(((Base64Variant)object)._name);
    }

    public final int hashCode() {
        return this._name.hashCode();
    }

    protected final void _reportInvalidBase64(char c2, int n2, String string) throws IllegalArgumentException {
        String string2 = c2 <= ' ' ? "Illegal white space character (code 0x" + Integer.toHexString(c2) + ") as character #" + (n2 + 1) + " of 4-char base64 unit: can only used between units" : (this.usesPaddingChar(c2) ? "Unexpected padding character ('" + this.getPaddingChar() + "') as character #" + (n2 + 1) + " of 4-char base64 unit: padding only legal as 3rd or 4th character" : (!Character.isDefined(c2) || Character.isISOControl(c2) ? "Illegal character (code 0x" + Integer.toHexString(c2) + ") in base64 content" : "Illegal character '" + c2 + "' (code 0x" + Integer.toHexString(c2) + ") in base64 content"));
        if (string != null) {
            string2 = string2 + ": " + string;
        }
        throw new IllegalArgumentException(string2);
    }

    protected final void _reportBase64EOF() throws IllegalArgumentException {
        throw new IllegalArgumentException(this.missingPaddingMessage());
    }

    protected final void _reportBase64UnexpectedPadding() throws IllegalArgumentException {
        throw new IllegalArgumentException(this.unexpectedPaddingMessage());
    }

    protected final String unexpectedPaddingMessage() {
        return String.format("Unexpected end of base64-encoded String: base64 variant '%s' expects no padding at the end while decoding. This Base64Variant might have been incorrectly configured", this.getName());
    }

    public final String missingPaddingMessage() {
        return String.format("Unexpected end of base64-encoded String: base64 variant '%s' expects padding (one or more '%c' characters) at the end. This Base64Variant might have been incorrectly configured", this.getName(), Character.valueOf(this.getPaddingChar()));
    }
}

