/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core;

import com.fasterxml.jackson.core.JsonPointer$PointerParent;
import com.fasterxml.jackson.core.JsonPointer$PointerSegment;
import com.fasterxml.jackson.core.JsonPointer$Serialization;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.io.NumberInput;
import java.io.Serializable;
import java.util.ArrayList;

public class JsonPointer
implements Serializable {
    public static final char ESC = '~';
    public static final String ESC_SLASH = "~1";
    public static final String ESC_TILDE = "~0";
    private static final long serialVersionUID = 1L;
    public static final char SEPARATOR = '/';
    protected static final JsonPointer EMPTY = new JsonPointer();
    protected final JsonPointer _nextSegment;
    protected volatile JsonPointer _head;
    protected final String _asString;
    protected final int _asStringOffset;
    protected final String _matchingPropertyName;
    protected final int _matchingElementIndex;
    protected int _hashCode;

    protected JsonPointer() {
        this._nextSegment = null;
        this._matchingPropertyName = null;
        this._matchingElementIndex = -1;
        this._asString = "";
        this._asStringOffset = 0;
    }

    protected JsonPointer(String string, int n2, String string2, JsonPointer jsonPointer) {
        this._asString = string;
        this._asStringOffset = n2;
        this._nextSegment = jsonPointer;
        this._matchingPropertyName = string2;
        this._matchingElementIndex = JsonPointer._parseIndex(string2);
    }

    protected JsonPointer(String string, int n2, String string2, int n3, JsonPointer jsonPointer) {
        this._asString = string;
        this._asStringOffset = n2;
        this._nextSegment = jsonPointer;
        this._matchingPropertyName = string2;
        this._matchingElementIndex = n3;
    }

    protected JsonPointer(JsonPointer jsonPointer, JsonPointer jsonPointer2) {
        this._asString = jsonPointer._asString;
        this._asStringOffset = jsonPointer._asStringOffset;
        this._nextSegment = jsonPointer2;
        this._matchingPropertyName = jsonPointer._matchingPropertyName;
        this._matchingElementIndex = jsonPointer._matchingElementIndex;
    }

    protected JsonPointer(JsonPointer jsonPointer, String string, int n2) {
        this._asString = string;
        this._asStringOffset = n2;
        this._nextSegment = null;
        this._matchingPropertyName = jsonPointer._matchingPropertyName;
        this._matchingElementIndex = jsonPointer._matchingElementIndex;
    }

    public static JsonPointer compile(String string) throws IllegalArgumentException {
        if (string == null || string.length() == 0) {
            return EMPTY;
        }
        if (string.charAt(0) != '/') {
            throw new IllegalArgumentException("Invalid input: JSON Pointer expression must start with '/': \"" + string + "\"");
        }
        return JsonPointer._parseTail(string);
    }

    public static JsonPointer valueOf(String string) {
        return JsonPointer.compile(string);
    }

    public static JsonPointer empty() {
        return EMPTY;
    }

    public static JsonPointer forPath(JsonStreamContext object, boolean bl2) {
        if (object == null) {
            return EMPTY;
        }
        if (!(((JsonStreamContext)object).hasPathSegment() || bl2 && ((JsonStreamContext)object).inRoot() && ((JsonStreamContext)object).hasCurrentIndex())) {
            object = ((JsonStreamContext)object).getParent();
        }
        Object object2 = null;
        int n2 = 0;
        while (object != null) {
            if (((JsonStreamContext)object).inObject()) {
                String string = ((JsonStreamContext)object).getCurrentName();
                if (string == null) {
                    string = "";
                }
                n2 += 2 + string.length();
                object2 = new JsonPointer$PointerSegment((JsonPointer$PointerSegment)object2, string, -1);
            } else if (((JsonStreamContext)object).inArray() || bl2) {
                int n3 = ((JsonStreamContext)object).getCurrentIndex();
                n2 += 6;
                object2 = new JsonPointer$PointerSegment((JsonPointer$PointerSegment)object2, null, n3);
            }
            object = ((JsonStreamContext)object).getParent();
        }
        if (object2 == null) {
            return EMPTY;
        }
        StringBuilder stringBuilder = new StringBuilder(n2);
        object = null;
        while (object2 != null) {
            object = object2;
            ((JsonPointer$PointerSegment)object2).pathOffset = stringBuilder.length();
            stringBuilder.append('/');
            if (((JsonPointer$PointerSegment)object2).property != null) {
                JsonPointer._appendEscaped(stringBuilder, ((JsonPointer$PointerSegment)object2).property);
            } else {
                stringBuilder.append(((JsonPointer$PointerSegment)object2).index);
            }
            object2 = ((JsonPointer$PointerSegment)object2).next;
        }
        String string = stringBuilder.toString();
        object2 = EMPTY;
        while (object != null) {
            if (((JsonPointer$PointerSegment)object).property != null) {
                object2 = new JsonPointer(string, ((JsonPointer$PointerSegment)object).pathOffset, ((JsonPointer$PointerSegment)object).property, (JsonPointer)object2);
            } else {
                n2 = ((JsonPointer$PointerSegment)object).index;
                object2 = new JsonPointer(string, ((JsonPointer$PointerSegment)object).pathOffset, String.valueOf(n2), n2, (JsonPointer)object2);
            }
            object = ((JsonPointer$PointerSegment)object).prev;
        }
        return object2;
    }

    private static void _appendEscaped(StringBuilder stringBuilder, String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '/') {
                stringBuilder.append(ESC_SLASH);
                continue;
            }
            if (c2 == '~') {
                stringBuilder.append(ESC_TILDE);
                continue;
            }
            stringBuilder.append(c2);
        }
    }

    public int length() {
        return this._asString.length() - this._asStringOffset;
    }

    public boolean matches() {
        return this._nextSegment == null;
    }

    public String getMatchingProperty() {
        return this._matchingPropertyName;
    }

    public int getMatchingIndex() {
        return this._matchingElementIndex;
    }

    public boolean mayMatchProperty() {
        return this._matchingPropertyName != null;
    }

    public boolean mayMatchElement() {
        return this._matchingElementIndex >= 0;
    }

    public JsonPointer last() {
        JsonPointer jsonPointer;
        JsonPointer jsonPointer2 = this;
        if (jsonPointer2 == EMPTY) {
            return null;
        }
        while ((jsonPointer = jsonPointer2._nextSegment) != EMPTY) {
            jsonPointer2 = jsonPointer;
        }
        return jsonPointer2;
    }

    public JsonPointer append(JsonPointer jsonPointer) {
        if (this == EMPTY) {
            return jsonPointer;
        }
        if (jsonPointer == EMPTY) {
            return this;
        }
        String string = this.toString();
        return JsonPointer.compile(string + jsonPointer.toString());
    }

    public JsonPointer appendProperty(String string) {
        if (string == null) {
            return this;
        }
        StringBuilder stringBuilder = this.toStringBuilder(string.length() + 2).append('/');
        JsonPointer._appendEscaped(stringBuilder, string);
        return JsonPointer.compile(stringBuilder.toString());
    }

    public JsonPointer appendIndex(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Negative index cannot be appended");
        }
        return JsonPointer.compile(this.toStringBuilder(8).append('/').append(n2).toString());
    }

    public boolean matchesProperty(String string) {
        return this._nextSegment != null && this._matchingPropertyName.equals(string);
    }

    public JsonPointer matchProperty(String string) {
        if (this._nextSegment != null && this._matchingPropertyName.equals(string)) {
            return this._nextSegment;
        }
        return null;
    }

    public boolean matchesElement(int n2) {
        return n2 == this._matchingElementIndex && n2 >= 0;
    }

    public JsonPointer matchElement(int n2) {
        if (n2 != this._matchingElementIndex || n2 < 0) {
            return null;
        }
        return this._nextSegment;
    }

    public JsonPointer tail() {
        return this._nextSegment;
    }

    public JsonPointer head() {
        JsonPointer jsonPointer = this._head;
        if (jsonPointer == null) {
            if (this != EMPTY) {
                jsonPointer = this._constructHead();
            }
            this._head = jsonPointer;
        }
        return jsonPointer;
    }

    public String toString() {
        if (this._asStringOffset <= 0) {
            return this._asString;
        }
        return this._asString.substring(this._asStringOffset);
    }

    protected StringBuilder toStringBuilder(int n2) {
        if (this._asStringOffset <= 0) {
            return new StringBuilder(this._asString);
        }
        int n3 = this._asString.length();
        StringBuilder stringBuilder = new StringBuilder(n3 - this._asStringOffset + n2);
        stringBuilder.append(this._asString, this._asStringOffset, n3);
        return stringBuilder;
    }

    public int hashCode() {
        int n2 = this._hashCode;
        if (n2 == 0) {
            n2 = this.toString().hashCode();
            if (n2 == 0) {
                n2 = -1;
            }
            this._hashCode = n2;
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof JsonPointer)) {
            return false;
        }
        object = (JsonPointer)object;
        JsonPointer jsonPointer = this;
        return jsonPointer._compare(jsonPointer._asString, this._asStringOffset, ((JsonPointer)object)._asString, ((JsonPointer)object)._asStringOffset);
    }

    private final boolean _compare(String string, int n2, String string2, int n3) {
        int n4 = string.length();
        if (n4 - n2 != string2.length() - n3) {
            return false;
        }
        while (n2 < n4) {
            if (string.charAt(n2++) == string2.charAt(n3++)) continue;
            return false;
        }
        return true;
    }

    private static final int _parseIndex(String string) {
        int n2 = string.length();
        if (n2 == 0 || n2 > 10) {
            return -1;
        }
        char c2 = string.charAt(0);
        if (c2 <= '0') {
            if (n2 == 1 && c2 == '0') {
                return 0;
            }
            return -1;
        }
        if (c2 > '9') {
            return -1;
        }
        for (int i2 = 1; i2 < n2; ++i2) {
            c2 = string.charAt(i2);
            if (c2 <= '9' && c2 >= '0') continue;
            return -1;
        }
        if (n2 == 10) {
            long l2 = Long.parseLong(string);
            if (l2 > Integer.MAX_VALUE) {
                return -1;
            }
            return (int)l2;
        }
        return NumberInput.parseInt(string);
    }

    protected static JsonPointer _parseTail(String string) {
        JsonPointer$PointerParent jsonPointer$PointerParent = null;
        int n2 = 1;
        int n3 = string.length();
        int n4 = 0;
        while (n2 < n3) {
            char c2 = string.charAt(n2);
            if (c2 == '/') {
                jsonPointer$PointerParent = new JsonPointer$PointerParent(jsonPointer$PointerParent, n4, string.substring(n4 + 1, n2));
                n4 = n2++;
                continue;
            }
            if (c2 != '~' || ++n2 >= n3) continue;
            CharSequence charSequence = new StringBuilder(32);
            n2 = JsonPointer._extractEscapedSegment(string, n4 + 1, n2, charSequence);
            charSequence = charSequence.toString();
            if (n2 < 0) {
                return JsonPointer._buildPath(string, n4, (String)charSequence, jsonPointer$PointerParent);
            }
            jsonPointer$PointerParent = new JsonPointer$PointerParent(jsonPointer$PointerParent, n4, (String)charSequence);
            n4 = n2++;
        }
        return JsonPointer._buildPath(string, n4, string.substring(n4 + 1), jsonPointer$PointerParent);
    }

    private static JsonPointer _buildPath(String string, int n2, String string2, JsonPointer$PointerParent jsonPointer$PointerParent) {
        JsonPointer jsonPointer = new JsonPointer(string, n2, string2, EMPTY);
        while (jsonPointer$PointerParent != null) {
            jsonPointer = new JsonPointer(string, jsonPointer$PointerParent.fullPathOffset, jsonPointer$PointerParent.segment, jsonPointer);
            jsonPointer$PointerParent = jsonPointer$PointerParent.parent;
        }
        return jsonPointer;
    }

    protected static int _extractEscapedSegment(String string, int n2, int n3, StringBuilder stringBuilder) {
        int n4 = string.length();
        int n5 = n3 - 1 - n2;
        if (n5 > 0) {
            stringBuilder.append(string, n2, n3 - 1);
        }
        block0: while (true) {
            n3 += JsonPointer._appendEscape(stringBuilder, string.charAt(n3));
            while (n3 < n4) {
                char c2 = string.charAt(n3);
                n2 = c2;
                if (c2 == '/') {
                    return n3;
                }
                if (n2 == 126 && ++n3 < n4) continue block0;
                stringBuilder.append((char)n2);
            }
            break;
        }
        return -1;
    }

    private static int _appendEscape(StringBuilder stringBuilder, char c2) {
        if (c2 == '0') {
            stringBuilder.append('~');
            return 1;
        }
        if (c2 == '1') {
            stringBuilder.append('/');
            return 1;
        }
        stringBuilder.append('~');
        return 0;
    }

    protected JsonPointer _constructHead() {
        JsonPointer jsonPointer;
        JsonPointer jsonPointer2 = this.last();
        if (jsonPointer2 == this) {
            return EMPTY;
        }
        ArrayList<JsonPointer> arrayList = new ArrayList<JsonPointer>();
        JsonPointer jsonPointer3 = this;
        String string = this.toString();
        string = string.substring(0, string.length() - jsonPointer2.length());
        int n2 = -this._asStringOffset;
        while (jsonPointer3 != jsonPointer2) {
            jsonPointer = new JsonPointer(jsonPointer3, string, jsonPointer3._asStringOffset + n2);
            arrayList.add(jsonPointer);
            jsonPointer3 = jsonPointer3._nextSegment;
        }
        jsonPointer = EMPTY;
        for (int i2 = arrayList.size() - 1; i2 >= 0; --i2) {
            jsonPointer = new JsonPointer((JsonPointer)arrayList.get(i2), jsonPointer);
        }
        return jsonPointer;
    }

    private Object writeReplace() {
        return new JsonPointer$Serialization(this.toString());
    }
}

