/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core;

import com.fasterxml.jackson.core.JsonParser$Feature;
import com.fasterxml.jackson.core.util.JacksonFeature;

public enum StreamReadFeature implements JacksonFeature
{
    AUTO_CLOSE_SOURCE(JsonParser$Feature.AUTO_CLOSE_SOURCE),
    STRICT_DUPLICATE_DETECTION(JsonParser$Feature.STRICT_DUPLICATE_DETECTION),
    IGNORE_UNDEFINED(JsonParser$Feature.IGNORE_UNDEFINED),
    INCLUDE_SOURCE_IN_LOCATION(JsonParser$Feature.INCLUDE_SOURCE_IN_LOCATION),
    USE_FAST_DOUBLE_PARSER(JsonParser$Feature.USE_FAST_DOUBLE_PARSER),
    USE_FAST_BIG_NUMBER_PARSER(JsonParser$Feature.USE_FAST_BIG_NUMBER_PARSER);

    private final boolean _defaultState;
    private final int _mask;
    private final JsonParser$Feature _mappedFeature;

    private StreamReadFeature(JsonParser$Feature jsonParser$Feature) {
        this._mappedFeature = jsonParser$Feature;
        this._mask = jsonParser$Feature.getMask();
        this._defaultState = jsonParser$Feature.enabledByDefault();
    }

    public static int collectDefaults() {
        int n2 = 0;
        for (StreamReadFeature streamReadFeature : StreamReadFeature.values()) {
            if (!streamReadFeature.enabledByDefault()) continue;
            n2 |= streamReadFeature.getMask();
        }
        return n2;
    }

    @Override
    public final boolean enabledByDefault() {
        return this._defaultState;
    }

    @Override
    public final boolean enabledIn(int n2) {
        return (n2 & this._mask) != 0;
    }

    @Override
    public final int getMask() {
        return this._mask;
    }

    public final JsonParser$Feature mappedFeature() {
        return this._mappedFeature;
    }
}

