/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.base;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.core.exc.InputCoercionException;
import com.fasterxml.jackson.core.exc.StreamConstraintsException;
import com.fasterxml.jackson.core.io.JsonEOFException;
import com.fasterxml.jackson.core.io.NumberInput;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.core.util.VersionUtil;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;

public abstract class ParserMinimalBase
extends JsonParser {
    protected static final int INT_TAB = 9;
    protected static final int INT_LF = 10;
    protected static final int INT_CR = 13;
    protected static final int INT_SPACE = 32;
    protected static final int INT_RS = 30;
    protected static final int INT_LBRACKET = 91;
    protected static final int INT_RBRACKET = 93;
    protected static final int INT_LCURLY = 123;
    protected static final int INT_RCURLY = 125;
    protected static final int INT_QUOTE = 34;
    protected static final int INT_APOS = 39;
    protected static final int INT_BACKSLASH = 92;
    protected static final int INT_SLASH = 47;
    protected static final int INT_ASTERISK = 42;
    protected static final int INT_COLON = 58;
    protected static final int INT_COMMA = 44;
    protected static final int INT_HASH = 35;
    protected static final int INT_0 = 48;
    protected static final int INT_9 = 57;
    protected static final int INT_MINUS = 45;
    protected static final int INT_PLUS = 43;
    protected static final int INT_PERIOD = 46;
    protected static final int INT_e = 101;
    protected static final int INT_E = 69;
    protected static final char CHAR_NULL = '\u0000';
    protected static final byte[] NO_BYTES = new byte[0];
    protected static final int[] NO_INTS = new int[0];
    protected static final int NR_UNKNOWN = 0;
    protected static final int NR_INT = 1;
    protected static final int NR_LONG = 2;
    protected static final int NR_BIGINT = 4;
    protected static final int NR_DOUBLE = 8;
    protected static final int NR_BIGDECIMAL = 16;
    protected static final int NR_FLOAT = 32;
    protected static final BigInteger BI_MIN_INT = BigInteger.valueOf(Integer.MIN_VALUE);
    protected static final BigInteger BI_MAX_INT = BigInteger.valueOf(Integer.MAX_VALUE);
    protected static final BigInteger BI_MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
    protected static final BigInteger BI_MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    protected static final BigDecimal BD_MIN_LONG = new BigDecimal(BI_MIN_LONG);
    protected static final BigDecimal BD_MAX_LONG = new BigDecimal(BI_MAX_LONG);
    protected static final BigDecimal BD_MIN_INT = new BigDecimal(BI_MIN_INT);
    protected static final BigDecimal BD_MAX_INT = new BigDecimal(BI_MAX_INT);
    protected static final long MIN_INT_L = Integer.MIN_VALUE;
    protected static final long MAX_INT_L = Integer.MAX_VALUE;
    protected static final double MIN_LONG_D = -9.223372036854776E18;
    protected static final double MAX_LONG_D = 9.223372036854776E18;
    protected static final double MIN_INT_D = -2.147483648E9;
    protected static final double MAX_INT_D = 2.147483647E9;
    @Deprecated
    protected static final int MAX_ERROR_TOKEN_LENGTH = 256;
    protected final StreamReadConstraints _streamReadConstraints;
    protected JsonToken _currToken;
    protected long _tokenCount;
    protected final boolean _trackMaxTokenCount;
    protected JsonToken _lastClearedToken;

    @Deprecated
    protected ParserMinimalBase() {
        this._streamReadConstraints = StreamReadConstraints.defaults();
        this._trackMaxTokenCount = this._streamReadConstraints.hasMaxTokenCount();
    }

    @Deprecated
    protected ParserMinimalBase(int n2) {
        this(n2, null);
    }

    protected ParserMinimalBase(StreamReadConstraints streamReadConstraints) {
        this._streamReadConstraints = streamReadConstraints == null ? StreamReadConstraints.defaults() : streamReadConstraints;
        this._trackMaxTokenCount = this._streamReadConstraints.hasMaxTokenCount();
    }

    protected ParserMinimalBase(int n2, StreamReadConstraints streamReadConstraints) {
        super(n2);
        this._streamReadConstraints = streamReadConstraints == null ? StreamReadConstraints.defaults() : streamReadConstraints;
        this._trackMaxTokenCount = this._streamReadConstraints.hasMaxTokenCount();
    }

    @Override
    public StreamReadConstraints streamReadConstraints() {
        return this._streamReadConstraints;
    }

    @Override
    public abstract JsonToken nextToken() throws IOException;

    @Override
    public JsonToken currentToken() {
        return this._currToken;
    }

    @Override
    public int currentTokenId() {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == null) {
            return 0;
        }
        return jsonToken.id();
    }

    @Override
    public JsonToken getCurrentToken() {
        return this._currToken;
    }

    @Override
    @Deprecated
    public int getCurrentTokenId() {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == null) {
            return 0;
        }
        return jsonToken.id();
    }

    @Override
    public boolean hasCurrentToken() {
        return this._currToken != null;
    }

    @Override
    public boolean hasTokenId(int n2) {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == null) {
            return n2 == 0;
        }
        return jsonToken.id() == n2;
    }

    @Override
    public boolean hasToken(JsonToken jsonToken) {
        return this._currToken == jsonToken;
    }

    @Override
    public boolean isExpectedStartArrayToken() {
        return this._currToken == JsonToken.START_ARRAY;
    }

    @Override
    public boolean isExpectedStartObjectToken() {
        return this._currToken == JsonToken.START_OBJECT;
    }

    @Override
    public boolean isExpectedNumberIntToken() {
        return this._currToken == JsonToken.VALUE_NUMBER_INT;
    }

    @Override
    public JsonToken nextValue() throws IOException {
        JsonToken jsonToken = ((JsonParser)this).nextToken();
        if (jsonToken == JsonToken.FIELD_NAME) {
            jsonToken = ((JsonParser)this).nextToken();
        }
        return jsonToken;
    }

    @Override
    public JsonParser skipChildren() throws IOException {
        if (this._currToken != JsonToken.START_OBJECT && this._currToken != JsonToken.START_ARRAY) {
            return this;
        }
        int n2 = 1;
        while (true) {
            JsonToken jsonToken;
            if ((jsonToken = ((JsonParser)this).nextToken()) == null) {
                this._handleEOF();
                return this;
            }
            if (jsonToken.isStructStart()) {
                ++n2;
                continue;
            }
            if (jsonToken.isStructEnd()) {
                if (--n2 != 0) continue;
                return this;
            }
            if (jsonToken != JsonToken.NOT_AVAILABLE) continue;
            this._reportError("Not enough content available for `skipChildren()`: non-blocking parser? (%s)", this.getClass().getName());
        }
    }

    protected abstract void _handleEOF() throws JsonParseException;

    @Override
    @Deprecated
    public abstract String getCurrentName() throws IOException;

    @Override
    public abstract void close() throws IOException;

    @Override
    public abstract boolean isClosed();

    @Override
    public abstract JsonStreamContext getParsingContext();

    @Override
    public long currentTokenCount() {
        return this._tokenCount;
    }

    @Override
    public void clearCurrentToken() {
        if (this._currToken != null) {
            this._lastClearedToken = this._currToken;
            this._currToken = null;
        }
    }

    @Override
    public JsonToken getLastClearedToken() {
        return this._lastClearedToken;
    }

    @Override
    public abstract void overrideCurrentName(String var1);

    @Override
    public abstract String getText() throws IOException;

    @Override
    public abstract char[] getTextCharacters() throws IOException;

    @Override
    public abstract boolean hasTextCharacters();

    @Override
    public abstract int getTextLength() throws IOException;

    @Override
    public abstract int getTextOffset() throws IOException;

    @Override
    public abstract byte[] getBinaryValue(Base64Variant var1) throws IOException;

    @Override
    public boolean getValueAsBoolean(boolean bl2) throws IOException {
        Object object = this._currToken;
        if (object != null) {
            switch (object.id()) {
                case 6: {
                    object = ((JsonParser)this).getText().trim();
                    if ("true".equals(object)) {
                        return true;
                    }
                    if ("false".equals(object)) {
                        return false;
                    }
                    if (!this._hasTextualNull((String)object)) break;
                    return false;
                }
                case 7: {
                    return this.getIntValue() != 0;
                }
                case 9: {
                    return true;
                }
                case 10: 
                case 11: {
                    return false;
                }
                case 12: {
                    object = this.getEmbeddedObject();
                    if (!(object instanceof Boolean)) break;
                    return (Boolean)object;
                }
            }
        }
        return bl2;
    }

    @Override
    public int getValueAsInt() throws IOException {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return this.getIntValue();
        }
        return ((JsonParser)this).getValueAsInt(0);
    }

    @Override
    public int getValueAsInt(int n2) throws IOException {
        Object object = this._currToken;
        if (object == JsonToken.VALUE_NUMBER_INT || object == JsonToken.VALUE_NUMBER_FLOAT) {
            return this.getIntValue();
        }
        if (object != null) {
            switch (object.id()) {
                case 6: {
                    object = ((JsonParser)this).getText();
                    if (this._hasTextualNull((String)object)) {
                        return 0;
                    }
                    return NumberInput.parseAsInt((String)object, n2);
                }
                case 9: {
                    return 1;
                }
                case 10: {
                    return 0;
                }
                case 11: {
                    return 0;
                }
                case 12: {
                    object = this.getEmbeddedObject();
                    if (!(object instanceof Number)) break;
                    return ((Number)object).intValue();
                }
            }
        }
        return n2;
    }

    @Override
    public long getValueAsLong() throws IOException {
        JsonToken jsonToken = this._currToken;
        if (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return this.getLongValue();
        }
        return ((JsonParser)this).getValueAsLong(0L);
    }

    @Override
    public long getValueAsLong(long l2) throws IOException {
        Object object = this._currToken;
        if (object == JsonToken.VALUE_NUMBER_INT || object == JsonToken.VALUE_NUMBER_FLOAT) {
            return this.getLongValue();
        }
        if (object != null) {
            switch (object.id()) {
                case 6: {
                    object = ((JsonParser)this).getText();
                    if (this._hasTextualNull((String)object)) {
                        return 0L;
                    }
                    return NumberInput.parseAsLong((String)object, l2);
                }
                case 9: {
                    return 1L;
                }
                case 10: 
                case 11: {
                    return 0L;
                }
                case 12: {
                    object = this.getEmbeddedObject();
                    if (!(object instanceof Number)) break;
                    return ((Number)object).longValue();
                }
            }
        }
        return l2;
    }

    @Override
    public double getValueAsDouble(double d2) throws IOException {
        Object object = this._currToken;
        if (object != null) {
            switch (object.id()) {
                case 6: {
                    object = ((JsonParser)this).getText();
                    if (this._hasTextualNull((String)object)) {
                        return 0.0;
                    }
                    this._streamReadConstraints.validateFPLength(((String)object).length());
                    return NumberInput.parseAsDouble((String)object, d2);
                }
                case 7: 
                case 8: {
                    return this.getDoubleValue();
                }
                case 9: {
                    return 1.0;
                }
                case 10: 
                case 11: {
                    return 0.0;
                }
                case 12: {
                    object = this.getEmbeddedObject();
                    if (!(object instanceof Number)) break;
                    return ((Number)object).doubleValue();
                }
            }
        }
        return d2;
    }

    @Override
    public String getValueAsString() throws IOException {
        return ((JsonParser)this).getValueAsString(null);
    }

    @Override
    public String getValueAsString(String string) throws IOException {
        if (this._currToken == JsonToken.VALUE_STRING) {
            return ((JsonParser)this).getText();
        }
        if (this._currToken == JsonToken.FIELD_NAME) {
            return this.currentName();
        }
        if (this._currToken == null || this._currToken == JsonToken.VALUE_NULL || !this._currToken.isScalarValue()) {
            return string;
        }
        return ((JsonParser)this).getText();
    }

    protected void _decodeBase64(String string, ByteArrayBuilder byteArrayBuilder, Base64Variant base64Variant) throws IOException {
        try {
            base64Variant.decode(string, byteArrayBuilder);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this._reportError(illegalArgumentException.getMessage());
            return;
        }
    }

    protected boolean _hasTextualNull(String string) {
        return "null".equals(string);
    }

    protected void _reportInputCoercion(String string, JsonToken jsonToken, Class<?> clazz) throws InputCoercionException {
        throw new InputCoercionException((JsonParser)this, string, jsonToken, clazz);
    }

    protected void _reportInvalidEOF() throws JsonParseException {
        this._reportInvalidEOF(" in " + (Object)((Object)this._currToken), this._currToken);
    }

    protected void _reportInvalidEOFInValue(JsonToken jsonToken) throws JsonParseException {
        String string = jsonToken == JsonToken.VALUE_STRING ? " in a String value" : (jsonToken == JsonToken.VALUE_NUMBER_INT || jsonToken == JsonToken.VALUE_NUMBER_FLOAT ? " in a Number value" : " in a value");
        this._reportInvalidEOF(string, jsonToken);
    }

    protected void _reportInvalidEOF(String string, JsonToken jsonToken) throws JsonParseException {
        throw new JsonEOFException((JsonParser)this, jsonToken, "Unexpected end-of-input" + string);
    }

    protected void reportInvalidNumber(String string) throws JsonParseException {
        throw this._constructReadException("Invalid numeric value: " + string);
    }

    protected void _reportMissingRootWS(int n2) throws JsonParseException {
        this._reportUnexpectedChar(n2, "Expected space separating root-level values");
    }

    protected void reportOverflowInt() throws IOException {
        ParserMinimalBase parserMinimalBase = this;
        parserMinimalBase.reportOverflowInt(((JsonParser)parserMinimalBase).getText());
    }

    protected void reportOverflowInt(String string) throws IOException {
        this.reportOverflowInt(string, ((JsonParser)this).currentToken());
    }

    protected void reportOverflowInt(String string, JsonToken jsonToken) throws IOException {
        this._reportInputCoercion(String.format("Numeric value (%s) out of range of int (%d - %s)", this._longIntegerDesc(string), Integer.MIN_VALUE, Integer.MAX_VALUE), jsonToken, Integer.TYPE);
    }

    protected void reportOverflowLong() throws IOException {
        ParserMinimalBase parserMinimalBase = this;
        parserMinimalBase.reportOverflowLong(((JsonParser)parserMinimalBase).getText());
    }

    protected void reportOverflowLong(String string) throws IOException {
        this.reportOverflowLong(string, ((JsonParser)this).currentToken());
    }

    protected void reportOverflowLong(String string, JsonToken jsonToken) throws IOException {
        this._reportInputCoercion(String.format("Numeric value (%s) out of range of long (%d - %s)", this._longIntegerDesc(string), Long.MIN_VALUE, Long.MAX_VALUE), jsonToken, Long.TYPE);
    }

    protected String _longIntegerDesc(String string) {
        int n2 = string.length();
        if (n2 < 1000) {
            return string;
        }
        if (string.startsWith("-")) {
            --n2;
        }
        return String.format("[Integer with %d digits]", n2);
    }

    protected String _longNumberDesc(String string) {
        int n2 = string.length();
        if (n2 < 1000) {
            return string;
        }
        if (string.startsWith("-")) {
            --n2;
        }
        return String.format("[number with %d characters]", n2);
    }

    protected void _reportUnexpectedChar(int n2, String string) throws JsonParseException {
        if (n2 < 0) {
            this._reportInvalidEOF();
        }
        String string2 = String.format("Unexpected character (%s)", ParserMinimalBase._getCharDesc(n2));
        if (string != null) {
            string2 = string2 + ": " + string;
        }
        throw this._constructReadException(string2, this._currentLocationMinusOne());
    }

    protected <T> T _reportUnexpectedNumberChar(int n2, String string) throws JsonParseException {
        String string2 = String.format("Unexpected character (%s) in numeric value", ParserMinimalBase._getCharDesc(n2));
        if (string != null) {
            string2 = string2 + ": " + string;
        }
        throw this._constructReadException(string2, this._currentLocationMinusOne());
    }

    @Deprecated
    protected void reportUnexpectedNumberChar(int n2, String string) throws JsonParseException {
        this._reportUnexpectedNumberChar(n2, string);
    }

    protected void _throwInvalidSpace(int n2) throws JsonParseException {
        char c2 = (char)n2;
        String string = "Illegal character (" + ParserMinimalBase._getCharDesc(c2) + "): only regular white space (\\r, \\n, \\t) is allowed between tokens";
        if (n2 == 30) {
            string = string + " (consider enabling `JsonReadFeature.ALLOW_RS_CONTROL_CHAR` to allow use of Record Separators (\\u001E))";
        }
        throw this._constructReadException(string);
    }

    protected final JsonParseException _constructError(String string, Throwable throwable) {
        return this._constructReadException(string, throwable);
    }

    protected JsonLocation _currentLocationMinusOne() {
        return this.currentLocation();
    }

    protected static final String _getCharDesc(int n2) {
        char c2 = (char)n2;
        if (Character.isISOControl(c2)) {
            return "(CTRL-CHAR, code " + n2 + ")";
        }
        if (n2 > 255) {
            return "'" + c2 + "' (code " + n2 + " / 0x" + Integer.toHexString(n2) + ")";
        }
        return "'" + c2 + "' (code " + n2 + ")";
    }

    protected final void _reportError(String string) throws JsonParseException {
        throw this._constructReadException(string);
    }

    protected final void _reportError(String string, Object object) throws JsonParseException {
        throw this._constructReadException(string, object);
    }

    protected final void _reportError(String string, Object object, Object object2) throws JsonParseException {
        throw this._constructReadException(string, object, object2);
    }

    protected final void _throwInternal() {
        VersionUtil.throwInternal();
    }

    protected final <T> T _throwInternalReturnAny() {
        return VersionUtil.throwInternalReturnAny();
    }

    protected final void _wrapError(String string, Throwable throwable) throws JsonParseException {
        throw this._constructReadException(string, throwable);
    }

    protected final JsonToken _updateToken(JsonToken jsonToken) throws StreamConstraintsException {
        this._currToken = jsonToken;
        if (this._trackMaxTokenCount) {
            this._streamReadConstraints.validateTokenCount(++this._tokenCount);
        }
        return jsonToken;
    }

    protected final JsonToken _nullSafeUpdateToken(JsonToken jsonToken) throws StreamConstraintsException {
        this._currToken = jsonToken;
        if (this._trackMaxTokenCount && jsonToken != null) {
            this._streamReadConstraints.validateTokenCount(++this._tokenCount);
        }
        return jsonToken;
    }

    protected final JsonToken _updateTokenToNull() {
        this._currToken = null;
        return null;
    }

    protected final JsonToken _updateTokenToNA() {
        this._currToken = JsonToken.NOT_AVAILABLE;
        return this._currToken;
    }

    @Deprecated
    protected static byte[] _asciiBytes(String string) {
        byte[] byArray = new byte[string.length()];
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray[i2] = (byte)string.charAt(i2);
        }
        return byArray;
    }

    @Deprecated
    protected static String _ascii(byte[] byArray) {
        return new String(byArray, StandardCharsets.US_ASCII);
    }
}

