/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_2;

import com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_2.FastDoubleMath;
import com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_2.FastIntegerMath;

class FastFloatMath {
    private static final int FLOAT_EXPONENT_BIAS = 127;
    private static final int FLOAT_SIGNIFICAND_WIDTH = 24;
    private static final int FLOAT_MIN_EXPONENT_POWER_OF_TEN = -45;
    private static final int FLOAT_MAX_EXPONENT_POWER_OF_TEN = 38;
    private static final int FLOAT_MIN_EXPONENT_POWER_OF_TWO = -126;
    private static final int FLOAT_MAX_EXPONENT_POWER_OF_TWO = 127;
    private static final float[] FLOAT_POWER_OF_TEN = new float[]{1.0f, 10.0f, 100.0f, 1000.0f, 10000.0f, 100000.0f, 1000000.0f, 1.0E7f, 1.0E8f, 1.0E9f, 1.0E10f};

    private FastFloatMath() {
    }

    static float tryDecFloatToFloatTruncated(boolean bl2, long l2, int n2, boolean bl3, int n3) {
        float f2;
        if (l2 == 0L) {
            if (bl2) {
                return -0.0f;
            }
            return 0.0f;
        }
        if (bl3) {
            if (-45 <= n3 && n3 <= 38) {
                float f3 = FastFloatMath.tryDecToFloatWithFastAlgorithm(bl2, l2, n3);
                float f4 = FastFloatMath.tryDecToFloatWithFastAlgorithm(bl2, l2 + 1L, n3);
                if (!Float.isNaN(f3) && f4 == f3) {
                    return f3;
                }
            }
            f2 = Float.NaN;
        } else {
            f2 = -45 <= n2 && n2 <= 38 ? FastFloatMath.tryDecToFloatWithFastAlgorithm(bl2, l2, n2) : Float.NaN;
        }
        return f2;
    }

    static float tryHexFloatToFloatTruncated(boolean bl2, long l2, int n2, boolean bl3, int n3) {
        int n4 = n2 = bl3 ? n3 : n2;
        if (-126 <= n2 && n2 <= 127) {
            float f2 = (float)l2 + (l2 < 0L ? 1.8446744E19f : 0.0f);
            f2 = FastFloatMath.fastScalb(f2, n2);
            if (bl2) {
                return -f2;
            }
            return f2;
        }
        return Float.NaN;
    }

    /*
     * WARNING - void declaration
     */
    static float tryDecToFloatWithFastAlgorithm(boolean bl2, long l2, int n2) {
        void var1_2;
        int n3;
        if (-10 <= n3 && n3 <= 10 && Long.compareUnsigned((long)var1_2, 0xFFFFFFL) <= 0) {
            float l3 = (float)var1_2;
            l3 = n3 < 0 ? (l3 /= FLOAT_POWER_OF_TEN[-n3]) : (l3 *= FLOAT_POWER_OF_TEN[n3]);
            if (bl2) {
                return -l3;
            }
            return l3;
        }
        long l3 = FastDoubleMath.MANTISSA_64[n3 - -325];
        long l4 = (217706L * (long)n3 >> 16) + 127L + 64L;
        n3 = Long.numberOfLeadingZeros((long)var1_2);
        void var9_7 = var1_2 << n3;
        long l5 = FastIntegerMath.unsignedMultiplyHigh((long)var9_7, l3);
        long l6 = l5 >>> 63;
        long l7 = l5 >>> (int)(l6 + 38L);
        n3 += (int)(1L ^ l6);
        if ((l5 & 0x3FFFFFFFFFL) == 0x3FFFFFFFFFL || (l5 & 0x3FFFFFFFFFL) == 0L && (l7 & 3L) == 1L) {
            return Float.NaN;
        }
        ++l7;
        if ((l7 >>>= 1) >= 0x1000000L) {
            l7 = 0x800000L;
            --n3;
        }
        l7 &= 0xFFFFFFFFFF7FFFFFL;
        long l8 = l4 - (long)n3;
        if (l8 < 1L || l8 > 254L) {
            return Float.NaN;
        }
        int n4 = (int)(l7 | l8 << 23 | (bl2 ? 0x80000000L : 0L));
        return Float.intBitsToFloat(n4);
    }

    static float fastScalb(float f2, int n2) {
        return f2 * Float.intBitsToFloat(n2 + 127 << 23);
    }
}

