/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_2;

import com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_2.FastDoubleSwar;
import com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_2.FftMultiplier$ComplexVector;
import com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_2.FftMultiplier$MutableComplex;
import java.math.BigInteger;

class FftMultiplier {
    public static final double COS_0_25 = Math.cos(0.7853981633974483);
    public static final double SIN_0_25 = Math.sin(0.7853981633974483);
    private static final int FFT_THRESHOLD = 33220;
    private static final int MAX_MAG_LENGTH = 0x4000000;
    private static final int ROOTS3_CACHE_SIZE = 20;
    private static final int ROOTS_CACHE2_SIZE = 20;
    private static final int TOOM_COOK_THRESHOLD = 1920;
    private static volatile FftMultiplier$ComplexVector[] ROOTS2_CACHE = new FftMultiplier$ComplexVector[20];
    private static volatile FftMultiplier$ComplexVector[] ROOTS3_CACHE = new FftMultiplier$ComplexVector[20];

    FftMultiplier() {
    }

    static int bitsPerFftPoint(int n2) {
        if (n2 <= 9728) {
            return 19;
        }
        if (n2 <= 18432) {
            return 18;
        }
        if (n2 <= 69632) {
            return 17;
        }
        if (n2 <= 262144) {
            return 16;
        }
        if (n2 <= 983040) {
            return 15;
        }
        if (n2 <= 0x380000) {
            return 14;
        }
        if (n2 <= 0xD00000) {
            return 13;
        }
        if (n2 <= 0x1800000) {
            return 12;
        }
        if (n2 <= 0x5800000) {
            return 11;
        }
        if (n2 <= 0x14000000) {
            return 10;
        }
        if (n2 <= 0x48000000) {
            return 9;
        }
        return 8;
    }

    private static FftMultiplier$ComplexVector calculateRootsOfUnity(int n2) {
        if (n2 == 1) {
            FftMultiplier$ComplexVector fftMultiplier$ComplexVector = new FftMultiplier$ComplexVector(1);
            fftMultiplier$ComplexVector.real(0, 1.0);
            fftMultiplier$ComplexVector.imag(0, 0.0);
            return fftMultiplier$ComplexVector;
        }
        FftMultiplier$ComplexVector fftMultiplier$ComplexVector = new FftMultiplier$ComplexVector(n2);
        fftMultiplier$ComplexVector.set(0, 1.0, 0.0);
        double d2 = COS_0_25;
        double d3 = SIN_0_25;
        fftMultiplier$ComplexVector.set(n2 / 2, d2, d3);
        double d4 = 1.5707963267948966 / (double)n2;
        for (int i2 = 1; i2 < n2 / 2; ++i2) {
            double d5 = d4 * (double)i2;
            d2 = Math.cos(d5);
            d3 = Math.sin(d5);
            fftMultiplier$ComplexVector.set(i2, d2, d3);
            fftMultiplier$ComplexVector.set(n2 - i2, d3, d2);
        }
        return fftMultiplier$ComplexVector;
    }

    private static void fft(FftMultiplier$ComplexVector fftMultiplier$ComplexVector, FftMultiplier$ComplexVector[] fftMultiplier$ComplexVectorArray) {
        int n2 = FftMultiplier$ComplexVector.access$000(fftMultiplier$ComplexVector);
        int n3 = 31 - Integer.numberOfLeadingZeros(n2);
        FftMultiplier$MutableComplex fftMultiplier$MutableComplex = new FftMultiplier$MutableComplex();
        FftMultiplier$MutableComplex fftMultiplier$MutableComplex2 = new FftMultiplier$MutableComplex();
        FftMultiplier$MutableComplex fftMultiplier$MutableComplex3 = new FftMultiplier$MutableComplex();
        FftMultiplier$MutableComplex fftMultiplier$MutableComplex4 = new FftMultiplier$MutableComplex();
        FftMultiplier$MutableComplex fftMultiplier$MutableComplex5 = new FftMultiplier$MutableComplex();
        FftMultiplier$MutableComplex fftMultiplier$MutableComplex6 = new FftMultiplier$MutableComplex();
        while (n3 >= 2) {
            FftMultiplier$ComplexVector fftMultiplier$ComplexVector2 = fftMultiplier$ComplexVectorArray[n3 - 2];
            int n4 = 1 << n3;
            for (int i2 = 0; i2 < n2; i2 += n4) {
                for (int i3 = 0; i3 < n4 / 4; ++i3) {
                    fftMultiplier$MutableComplex5.set(fftMultiplier$ComplexVector2, i3);
                    fftMultiplier$MutableComplex5.squareInto(fftMultiplier$MutableComplex6);
                    int n5 = i2 + i3;
                    int n6 = i2 + i3 + n4 / 4;
                    int n7 = i2 + i3 + n4 / 2;
                    int n8 = i2 + i3 + n4 * 3 / 4;
                    fftMultiplier$ComplexVector.addInto(n5, fftMultiplier$ComplexVector, n6, fftMultiplier$MutableComplex);
                    fftMultiplier$MutableComplex.add(fftMultiplier$ComplexVector, n7);
                    fftMultiplier$MutableComplex.add(fftMultiplier$ComplexVector, n8);
                    fftMultiplier$ComplexVector.subtractTimesIInto(n5, fftMultiplier$ComplexVector, n6, fftMultiplier$MutableComplex2);
                    fftMultiplier$MutableComplex2.subtract(fftMultiplier$ComplexVector, n7);
                    fftMultiplier$MutableComplex2.addTimesI(fftMultiplier$ComplexVector, n8);
                    fftMultiplier$MutableComplex2.multiplyConjugate(fftMultiplier$MutableComplex5);
                    fftMultiplier$ComplexVector.subtractInto(n5, fftMultiplier$ComplexVector, n6, fftMultiplier$MutableComplex3);
                    fftMultiplier$MutableComplex3.add(fftMultiplier$ComplexVector, n7);
                    fftMultiplier$MutableComplex3.subtract(fftMultiplier$ComplexVector, n8);
                    fftMultiplier$MutableComplex3.multiplyConjugate(fftMultiplier$MutableComplex6);
                    fftMultiplier$ComplexVector.addTimesIInto(n5, fftMultiplier$ComplexVector, n6, fftMultiplier$MutableComplex4);
                    fftMultiplier$MutableComplex4.subtract(fftMultiplier$ComplexVector, n7);
                    fftMultiplier$MutableComplex4.subtractTimesI(fftMultiplier$ComplexVector, n8);
                    fftMultiplier$MutableComplex4.multiply(fftMultiplier$MutableComplex5);
                    fftMultiplier$MutableComplex.copyInto(fftMultiplier$ComplexVector, n5);
                    fftMultiplier$MutableComplex2.copyInto(fftMultiplier$ComplexVector, n6);
                    fftMultiplier$MutableComplex3.copyInto(fftMultiplier$ComplexVector, n7);
                    fftMultiplier$MutableComplex4.copyInto(fftMultiplier$ComplexVector, n8);
                }
            }
            n3 -= 2;
        }
        if (n3 > 0) {
            for (int i4 = 0; i4 < n2; i4 += 2) {
                fftMultiplier$ComplexVector.copyInto(i4, fftMultiplier$MutableComplex);
                fftMultiplier$ComplexVector.copyInto(i4 + 1, fftMultiplier$MutableComplex2);
                fftMultiplier$ComplexVector.add(i4, fftMultiplier$MutableComplex2);
                fftMultiplier$MutableComplex.subtractInto(fftMultiplier$MutableComplex2, fftMultiplier$ComplexVector, i4 + 1);
            }
        }
    }

    private static void fft3(FftMultiplier$ComplexVector fftMultiplier$ComplexVector, FftMultiplier$ComplexVector fftMultiplier$ComplexVector2, FftMultiplier$ComplexVector fftMultiplier$ComplexVector3, int n2, double d2) {
        double d3 = (double)n2 * -0.5 * Math.sqrt(3.0);
        for (n2 = 0; n2 < FftMultiplier$ComplexVector.access$000(fftMultiplier$ComplexVector); ++n2) {
            double d4 = fftMultiplier$ComplexVector.real(n2) + fftMultiplier$ComplexVector2.real(n2) + fftMultiplier$ComplexVector3.real(n2);
            double d5 = fftMultiplier$ComplexVector.imag(n2) + fftMultiplier$ComplexVector2.imag(n2) + fftMultiplier$ComplexVector3.imag(n2);
            double d6 = d3 * (fftMultiplier$ComplexVector3.imag(n2) - fftMultiplier$ComplexVector2.imag(n2));
            double d7 = d3 * (fftMultiplier$ComplexVector2.real(n2) - fftMultiplier$ComplexVector3.real(n2));
            double d8 = 0.5 * (fftMultiplier$ComplexVector2.real(n2) + fftMultiplier$ComplexVector3.real(n2));
            double d9 = 0.5 * (fftMultiplier$ComplexVector2.imag(n2) + fftMultiplier$ComplexVector3.imag(n2));
            double d10 = fftMultiplier$ComplexVector.real(n2) - d8 + d6;
            double d11 = fftMultiplier$ComplexVector.imag(n2) + d7 - d9;
            double d12 = fftMultiplier$ComplexVector.real(n2) - d8 - d6;
            double d13 = fftMultiplier$ComplexVector.imag(n2) - d7 - d9;
            fftMultiplier$ComplexVector.real(n2, d4 * d2);
            fftMultiplier$ComplexVector.imag(n2, d5 * d2);
            fftMultiplier$ComplexVector2.real(n2, d10 * d2);
            fftMultiplier$ComplexVector2.imag(n2, d11 * d2);
            fftMultiplier$ComplexVector3.real(n2, d12 * d2);
            fftMultiplier$ComplexVector3.imag(n2, d13 * d2);
        }
    }

    private static void fftMixedRadix(FftMultiplier$ComplexVector fftMultiplier$ComplexVector, FftMultiplier$ComplexVector[] fftMultiplier$ComplexVectorArray, FftMultiplier$ComplexVector fftMultiplier$ComplexVector2) {
        int n2;
        int n3 = FftMultiplier$ComplexVector.access$000(fftMultiplier$ComplexVector) / 3;
        FftMultiplier$ComplexVector fftMultiplier$ComplexVector3 = new FftMultiplier$ComplexVector(fftMultiplier$ComplexVector, 0, n3);
        int n4 = n3;
        FftMultiplier$ComplexVector fftMultiplier$ComplexVector4 = new FftMultiplier$ComplexVector(fftMultiplier$ComplexVector, n4, n4 << 1);
        FftMultiplier$ComplexVector fftMultiplier$ComplexVector5 = new FftMultiplier$ComplexVector(fftMultiplier$ComplexVector, n3 << 1, FftMultiplier$ComplexVector.access$000(fftMultiplier$ComplexVector));
        FftMultiplier.fft3(fftMultiplier$ComplexVector3, fftMultiplier$ComplexVector4, fftMultiplier$ComplexVector5, 1, 1.0);
        FftMultiplier$MutableComplex fftMultiplier$MutableComplex = new FftMultiplier$MutableComplex();
        for (n2 = 0; n2 < FftMultiplier$ComplexVector.access$000(fftMultiplier$ComplexVector) / 4; ++n2) {
            fftMultiplier$MutableComplex.set(fftMultiplier$ComplexVector2, n2);
            fftMultiplier$ComplexVector4.multiplyConjugate(n2, fftMultiplier$MutableComplex);
            fftMultiplier$ComplexVector5.multiplyConjugate(n2, fftMultiplier$MutableComplex);
            fftMultiplier$ComplexVector5.multiplyConjugate(n2, fftMultiplier$MutableComplex);
        }
        for (n2 = FftMultiplier$ComplexVector.access$000(fftMultiplier$ComplexVector) / 4; n2 < n3; ++n2) {
            fftMultiplier$MutableComplex.set(fftMultiplier$ComplexVector2, n2 - FftMultiplier$ComplexVector.access$000(fftMultiplier$ComplexVector) / 4);
            fftMultiplier$ComplexVector4.multiplyConjugateTimesI(n2, fftMultiplier$MutableComplex);
            fftMultiplier$ComplexVector5.multiplyConjugateTimesI(n2, fftMultiplier$MutableComplex);
            fftMultiplier$ComplexVector5.multiplyConjugateTimesI(n2, fftMultiplier$MutableComplex);
        }
        FftMultiplier.fft(fftMultiplier$ComplexVector3, fftMultiplier$ComplexVectorArray);
        FftMultiplier.fft(fftMultiplier$ComplexVector4, fftMultiplier$ComplexVectorArray);
        FftMultiplier.fft(fftMultiplier$ComplexVector5, fftMultiplier$ComplexVectorArray);
    }

    static BigInteger fromFftVector(FftMultiplier$ComplexVector fftMultiplier$ComplexVector, int n2, int n3) {
        assert (n3 <= 25) : n3 + " does not fit into an int with slack";
        int n4 = (int)Math.min((long)FftMultiplier$ComplexVector.access$000(fftMultiplier$ComplexVector), 0x80000000L / (long)n3 + 1L);
        int n5 = (int)(8L * ((long)n4 * (long)n3 + 31L) / 32L);
        byte[] byArray = new byte[n5];
        int n6 = 1 << n3;
        --n6;
        int n7 = 32 - n3;
        long l2 = 0L;
        int n8 = byArray.length << 3;
        int n9 = 0;
        int n10 = Math.min(Math.max(0, (n8 -= n3) >> 3), byArray.length - 4);
        for (int i2 = 0; i2 <= 1; ++i2) {
            for (int i3 = 0; i3 < n4; ++i3) {
                long l3 = Math.round(fftMultiplier$ComplexVector.part(i3, i2)) + l2;
                l2 = l3 >> n3;
                int n11 = Math.min(Math.max(0, n8 >> 3), byArray.length - 4);
                n9 >>>= n10 - n11 << 3;
                n10 = n7 - n8 + (n11 << 3);
                n9 = (int)((long)n9 | (l3 & (long)n6) << n10);
                FastDoubleSwar.writeIntBE(byArray, n11, n9);
                n10 = n11;
                n8 -= n3;
            }
        }
        return new BigInteger(n2, byArray);
    }

    private static FftMultiplier$ComplexVector[] getRootsOfUnity2(int n2) {
        FftMultiplier$ComplexVector[] fftMultiplier$ComplexVectorArray = new FftMultiplier$ComplexVector[n2 + 1];
        while (n2 >= 0) {
            if (n2 < 20) {
                if (ROOTS2_CACHE[n2] == null) {
                    FftMultiplier.ROOTS2_CACHE[n2] = FftMultiplier.calculateRootsOfUnity(1 << n2);
                }
                fftMultiplier$ComplexVectorArray[n2] = ROOTS2_CACHE[n2];
            } else {
                fftMultiplier$ComplexVectorArray[n2] = FftMultiplier.calculateRootsOfUnity(1 << n2);
            }
            n2 -= 2;
        }
        return fftMultiplier$ComplexVectorArray;
    }

    private static FftMultiplier$ComplexVector getRootsOfUnity3(int n2) {
        if (n2 < 20) {
            if (ROOTS3_CACHE[n2] == null) {
                FftMultiplier.ROOTS3_CACHE[n2] = FftMultiplier.calculateRootsOfUnity(3 << n2);
            }
            return ROOTS3_CACHE[n2];
        }
        return FftMultiplier.calculateRootsOfUnity(3 << n2);
    }

    private static void ifft(FftMultiplier$ComplexVector fftMultiplier$ComplexVector, FftMultiplier$ComplexVector[] fftMultiplier$ComplexVectorArray) {
        int n2 = FftMultiplier$ComplexVector.access$000(fftMultiplier$ComplexVector);
        int n3 = 31 - Integer.numberOfLeadingZeros(n2);
        FftMultiplier$MutableComplex fftMultiplier$MutableComplex = new FftMultiplier$MutableComplex();
        FftMultiplier$MutableComplex fftMultiplier$MutableComplex2 = new FftMultiplier$MutableComplex();
        FftMultiplier$MutableComplex fftMultiplier$MutableComplex3 = new FftMultiplier$MutableComplex();
        FftMultiplier$MutableComplex fftMultiplier$MutableComplex4 = new FftMultiplier$MutableComplex();
        FftMultiplier$MutableComplex fftMultiplier$MutableComplex5 = new FftMultiplier$MutableComplex();
        FftMultiplier$MutableComplex fftMultiplier$MutableComplex6 = new FftMultiplier$MutableComplex();
        FftMultiplier$MutableComplex fftMultiplier$MutableComplex7 = new FftMultiplier$MutableComplex();
        FftMultiplier$MutableComplex fftMultiplier$MutableComplex8 = new FftMultiplier$MutableComplex();
        int n4 = 1;
        if (n3 % 2 != 0) {
            for (int i2 = 0; i2 < n2; i2 += 2) {
                fftMultiplier$ComplexVector.copyInto(i2 + 1, fftMultiplier$MutableComplex3);
                fftMultiplier$ComplexVector.copyInto(i2, fftMultiplier$MutableComplex);
                fftMultiplier$ComplexVector.add(i2, fftMultiplier$MutableComplex3);
                fftMultiplier$MutableComplex.subtractInto(fftMultiplier$MutableComplex3, fftMultiplier$ComplexVector, i2 + 1);
            }
            ++n4;
        }
        FftMultiplier$MutableComplex fftMultiplier$MutableComplex9 = new FftMultiplier$MutableComplex();
        FftMultiplier$MutableComplex fftMultiplier$MutableComplex10 = new FftMultiplier$MutableComplex();
        while (n4 <= n3) {
            FftMultiplier$ComplexVector fftMultiplier$ComplexVector2 = fftMultiplier$ComplexVectorArray[n4 - 1];
            int n5 = 1 << n4 + 1;
            for (int i3 = 0; i3 < n2; i3 += n5) {
                for (int i4 = 0; i4 < n5 / 4; ++i4) {
                    fftMultiplier$MutableComplex9.set(fftMultiplier$ComplexVector2, i4);
                    fftMultiplier$MutableComplex9.squareInto(fftMultiplier$MutableComplex10);
                    int n6 = i3 + i4;
                    int n7 = i3 + i4 + n5 / 4;
                    int n8 = i3 + i4 + n5 / 2;
                    int n9 = i3 + i4 + n5 * 3 / 4;
                    fftMultiplier$ComplexVector.copyInto(n6, fftMultiplier$MutableComplex);
                    fftMultiplier$ComplexVector.multiplyInto(n7, fftMultiplier$MutableComplex9, fftMultiplier$MutableComplex2);
                    fftMultiplier$ComplexVector.multiplyInto(n8, fftMultiplier$MutableComplex10, fftMultiplier$MutableComplex3);
                    fftMultiplier$ComplexVector.multiplyConjugateInto(n9, fftMultiplier$MutableComplex9, fftMultiplier$MutableComplex4);
                    fftMultiplier$MutableComplex.addInto(fftMultiplier$MutableComplex2, fftMultiplier$MutableComplex5);
                    fftMultiplier$MutableComplex5.add(fftMultiplier$MutableComplex3);
                    fftMultiplier$MutableComplex5.add(fftMultiplier$MutableComplex4);
                    fftMultiplier$MutableComplex.addTimesIInto(fftMultiplier$MutableComplex2, fftMultiplier$MutableComplex6);
                    fftMultiplier$MutableComplex6.subtract(fftMultiplier$MutableComplex3);
                    fftMultiplier$MutableComplex6.subtractTimesI(fftMultiplier$MutableComplex4);
                    fftMultiplier$MutableComplex.subtractInto(fftMultiplier$MutableComplex2, fftMultiplier$MutableComplex7);
                    fftMultiplier$MutableComplex7.add(fftMultiplier$MutableComplex3);
                    fftMultiplier$MutableComplex7.subtract(fftMultiplier$MutableComplex4);
                    fftMultiplier$MutableComplex.subtractTimesIInto(fftMultiplier$MutableComplex2, fftMultiplier$MutableComplex8);
                    fftMultiplier$MutableComplex8.subtract(fftMultiplier$MutableComplex3);
                    fftMultiplier$MutableComplex8.addTimesI(fftMultiplier$MutableComplex4);
                    fftMultiplier$MutableComplex5.copyInto(fftMultiplier$ComplexVector, n6);
                    fftMultiplier$MutableComplex6.copyInto(fftMultiplier$ComplexVector, n7);
                    fftMultiplier$MutableComplex7.copyInto(fftMultiplier$ComplexVector, n8);
                    fftMultiplier$MutableComplex8.copyInto(fftMultiplier$ComplexVector, n9);
                }
            }
            n4 += 2;
        }
        for (int i5 = 0; i5 < n2; ++i5) {
            fftMultiplier$ComplexVector.timesTwoToThe(i5, -n3);
        }
    }

    private static void ifftMixedRadix(FftMultiplier$ComplexVector fftMultiplier$ComplexVector, FftMultiplier$ComplexVector[] object, FftMultiplier$ComplexVector fftMultiplier$ComplexVector2) {
        int n2;
        int n3 = FftMultiplier$ComplexVector.access$000(fftMultiplier$ComplexVector) / 3;
        FftMultiplier$ComplexVector fftMultiplier$ComplexVector3 = new FftMultiplier$ComplexVector(fftMultiplier$ComplexVector, 0, n3);
        int n4 = n3;
        FftMultiplier$ComplexVector fftMultiplier$ComplexVector4 = new FftMultiplier$ComplexVector(fftMultiplier$ComplexVector, n4, n4 << 1);
        FftMultiplier$ComplexVector fftMultiplier$ComplexVector5 = new FftMultiplier$ComplexVector(fftMultiplier$ComplexVector, n3 << 1, FftMultiplier$ComplexVector.access$000(fftMultiplier$ComplexVector));
        FftMultiplier.ifft(fftMultiplier$ComplexVector3, (FftMultiplier$ComplexVector[])object);
        FftMultiplier.ifft(fftMultiplier$ComplexVector4, (FftMultiplier$ComplexVector[])object);
        FftMultiplier.ifft(fftMultiplier$ComplexVector5, (FftMultiplier$ComplexVector[])object);
        object = new FftMultiplier$MutableComplex();
        for (n2 = 0; n2 < FftMultiplier$ComplexVector.access$000(fftMultiplier$ComplexVector) / 4; ++n2) {
            ((FftMultiplier$MutableComplex)object).set(fftMultiplier$ComplexVector2, n2);
            fftMultiplier$ComplexVector4.multiply(n2, (FftMultiplier$MutableComplex)object);
            fftMultiplier$ComplexVector5.multiply(n2, (FftMultiplier$MutableComplex)object);
            fftMultiplier$ComplexVector5.multiply(n2, (FftMultiplier$MutableComplex)object);
        }
        for (n2 = FftMultiplier$ComplexVector.access$000(fftMultiplier$ComplexVector) / 4; n2 < n3; ++n2) {
            ((FftMultiplier$MutableComplex)object).set(fftMultiplier$ComplexVector2, n2 - FftMultiplier$ComplexVector.access$000(fftMultiplier$ComplexVector) / 4);
            fftMultiplier$ComplexVector4.multiplyByIAnd(n2, (FftMultiplier$MutableComplex)object);
            fftMultiplier$ComplexVector5.multiplyByIAnd(n2, (FftMultiplier$MutableComplex)object);
            fftMultiplier$ComplexVector5.multiplyByIAnd(n2, (FftMultiplier$MutableComplex)object);
        }
        FftMultiplier.fft3(fftMultiplier$ComplexVector3, fftMultiplier$ComplexVector4, fftMultiplier$ComplexVector5, -1, 0.3333333333333333);
    }

    static BigInteger multiply(BigInteger bigInteger, BigInteger bigInteger2) {
        int n2;
        assert (bigInteger != null) : "a==null";
        assert (bigInteger2 != null) : "b==null";
        if (bigInteger2.signum() == 0 || bigInteger.signum() == 0) {
            return BigInteger.ZERO;
        }
        if (bigInteger2 == bigInteger) {
            return FftMultiplier.square(bigInteger2);
        }
        int n3 = bigInteger.bitLength();
        if ((long)n3 + (long)(n2 = bigInteger2.bitLength()) > 0x80000000L) {
            throw new ArithmeticException("BigInteger would overflow supported range");
        }
        if (n3 > 1920 && n2 > 1920 && (n3 > 33220 || n2 > 33220)) {
            return FftMultiplier.multiplyFft(bigInteger, bigInteger2);
        }
        return bigInteger.multiply(bigInteger2);
    }

    static BigInteger multiplyFft(BigInteger object, BigInteger object2) {
        int n2;
        int n3;
        int n4;
        int n5 = ((BigInteger)object).signum() * ((BigInteger)object2).signum();
        object = ((BigInteger)(((BigInteger)object).signum() < 0 ? ((BigInteger)object).negate() : object)).toByteArray();
        object2 = ((BigInteger)(((BigInteger)object2).signum() < 0 ? ((BigInteger)object2).negate() : object2)).toByteArray();
        int n6 = Math.max(((Object)object).length, ((Object)object2).length) << 3;
        int n7 = FftMultiplier.bitsPerFftPoint(n6);
        if ((n6 = (n6 + n7 - 1) / n7 + 1) < (n4 = (n3 = 1 << (n2 = 32 - Integer.numberOfLeadingZeros(n6 - 1))) * 3 / 4) && n2 > 3) {
            FftMultiplier$ComplexVector[] fftMultiplier$ComplexVectorArray = FftMultiplier.getRootsOfUnity2(n2 - 2);
            FftMultiplier$ComplexVector fftMultiplier$ComplexVector = FftMultiplier.getRootsOfUnity3(n2 - 2);
            FftMultiplier$ComplexVector fftMultiplier$ComplexVector2 = FftMultiplier.getRootsOfUnity3(n2 - 4);
            object = FftMultiplier.toFftVector((byte[])object, n4, n7);
            ((FftMultiplier$ComplexVector)object).applyWeights(fftMultiplier$ComplexVector);
            FftMultiplier.fftMixedRadix((FftMultiplier$ComplexVector)object, fftMultiplier$ComplexVectorArray, fftMultiplier$ComplexVector2);
            object2 = FftMultiplier.toFftVector((byte[])object2, n4, n7);
            ((FftMultiplier$ComplexVector)object2).applyWeights(fftMultiplier$ComplexVector);
            FftMultiplier.fftMixedRadix((FftMultiplier$ComplexVector)object2, fftMultiplier$ComplexVectorArray, fftMultiplier$ComplexVector2);
            ((FftMultiplier$ComplexVector)object).multiplyPointwise((FftMultiplier$ComplexVector)object2);
            FftMultiplier.ifftMixedRadix((FftMultiplier$ComplexVector)object, fftMultiplier$ComplexVectorArray, fftMultiplier$ComplexVector2);
            ((FftMultiplier$ComplexVector)object).applyInverseWeights(fftMultiplier$ComplexVector);
            return FftMultiplier.fromFftVector((FftMultiplier$ComplexVector)object, n5, n7);
        }
        FftMultiplier$ComplexVector[] fftMultiplier$ComplexVectorArray = FftMultiplier.getRootsOfUnity2(n2);
        FftMultiplier$ComplexVector fftMultiplier$ComplexVector = FftMultiplier.toFftVector((byte[])object, n3, n7);
        fftMultiplier$ComplexVector.applyWeights(fftMultiplier$ComplexVectorArray[n2]);
        FftMultiplier.fft(fftMultiplier$ComplexVector, fftMultiplier$ComplexVectorArray);
        FftMultiplier$ComplexVector fftMultiplier$ComplexVector3 = FftMultiplier.toFftVector((byte[])object2, n3, n7);
        fftMultiplier$ComplexVector3.applyWeights(fftMultiplier$ComplexVectorArray[n2]);
        FftMultiplier.fft(fftMultiplier$ComplexVector3, fftMultiplier$ComplexVectorArray);
        fftMultiplier$ComplexVector.multiplyPointwise(fftMultiplier$ComplexVector3);
        FftMultiplier.ifft(fftMultiplier$ComplexVector, fftMultiplier$ComplexVectorArray);
        fftMultiplier$ComplexVector.applyInverseWeights(fftMultiplier$ComplexVectorArray[n2]);
        return FftMultiplier.fromFftVector(fftMultiplier$ComplexVector, n5, n7);
    }

    static BigInteger square(BigInteger bigInteger) {
        if (bigInteger.signum() == 0) {
            return BigInteger.ZERO;
        }
        if (bigInteger.bitLength() < 33220) {
            BigInteger bigInteger2 = bigInteger;
            return bigInteger2.multiply(bigInteger2);
        }
        return FftMultiplier.squareFft(bigInteger);
    }

    static BigInteger squareFft(BigInteger object) {
        int n2;
        int n3;
        int n4;
        byte[] byArray = ((BigInteger)object).toByteArray();
        object = byArray;
        int n5 = byArray.length << 3;
        int n6 = FftMultiplier.bitsPerFftPoint(n5);
        if ((n5 = (n5 + n6 - 1) / n6 + 1) < (n4 = (n3 = 1 << (n2 = 32 - Integer.numberOfLeadingZeros(n5 - 1))) * 3 / 4)) {
            n5 = n4;
            object = FftMultiplier.toFftVector((byte[])object, n5, n6);
            FftMultiplier$ComplexVector[] fftMultiplier$ComplexVectorArray = FftMultiplier.getRootsOfUnity2(n2 - 2);
            FftMultiplier$ComplexVector fftMultiplier$ComplexVector = FftMultiplier.getRootsOfUnity3(n2 - 2);
            FftMultiplier$ComplexVector fftMultiplier$ComplexVector2 = FftMultiplier.getRootsOfUnity3(n2 - 4);
            ((FftMultiplier$ComplexVector)object).applyWeights(fftMultiplier$ComplexVector);
            FftMultiplier.fftMixedRadix((FftMultiplier$ComplexVector)object, fftMultiplier$ComplexVectorArray, fftMultiplier$ComplexVector2);
            ((FftMultiplier$ComplexVector)object).squarePointwise();
            FftMultiplier.ifftMixedRadix((FftMultiplier$ComplexVector)object, fftMultiplier$ComplexVectorArray, fftMultiplier$ComplexVector2);
            ((FftMultiplier$ComplexVector)object).applyInverseWeights(fftMultiplier$ComplexVector);
            return FftMultiplier.fromFftVector((FftMultiplier$ComplexVector)object, 1, n6);
        }
        n5 = n3;
        object = FftMultiplier.toFftVector((byte[])object, n5, n6);
        FftMultiplier$ComplexVector[] fftMultiplier$ComplexVectorArray = FftMultiplier.getRootsOfUnity2(n2);
        ((FftMultiplier$ComplexVector)object).applyWeights(fftMultiplier$ComplexVectorArray[n2]);
        FftMultiplier.fft((FftMultiplier$ComplexVector)object, fftMultiplier$ComplexVectorArray);
        ((FftMultiplier$ComplexVector)object).squarePointwise();
        FftMultiplier.ifft((FftMultiplier$ComplexVector)object, fftMultiplier$ComplexVectorArray);
        ((FftMultiplier$ComplexVector)object).applyInverseWeights(fftMultiplier$ComplexVectorArray[n2]);
        return FftMultiplier.fromFftVector((FftMultiplier$ComplexVector)object, 1, n6);
    }

    static FftMultiplier$ComplexVector toFftVector(byte[] byArray, int n2, int n3) {
        assert (n3 <= 25) : n3 + " does not fit into an int with slack";
        FftMultiplier$ComplexVector fftMultiplier$ComplexVector = new FftMultiplier$ComplexVector(n2);
        if (byArray.length < 4) {
            byte[] byArray2 = new byte[4];
            System.arraycopy(byArray, 0, byArray2, 4 - byArray.length, byArray.length);
            byArray = byArray2;
        }
        int n4 = 1 << n3;
        int n5 = n4 / 2;
        int n6 = n4 - 1;
        int n7 = 32 - n3;
        int n8 = byArray.length << 3;
        int n9 = 0;
        int n10 = 0;
        n8 -= n3;
        while (n8 > -n3) {
            int n11 = Math.min(Math.max(0, n8 >> 3), byArray.length - 4);
            int n12 = n7 - n8 + (n11 << 3);
            n11 = FastDoubleSwar.readIntBE(byArray, n11) >>> n12 & n6;
            n9 = n5 - (n11 += n9) >>> 31;
            fftMultiplier$ComplexVector.real(n10, n11 -= n4 & -n9);
            ++n10;
            n8 -= n3;
        }
        if (n9 > 0) {
            fftMultiplier$ComplexVector.real(n10, n9);
        }
        return fftMultiplier$ComplexVector;
    }
}

