/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_2;

import com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_2.AbstractBigDecimalParser;
import com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_2.FastDoubleSwar;
import com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_2.FastIntegerMath;
import com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_2.FftMultiplier;
import com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_2.ParseDigitsTaskByteArray;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.NavigableMap;

final class JavaBigDecimalFromByteArray
extends AbstractBigDecimalParser {
    public final BigDecimal parseBigDecimalString(byte[] byArray, int n2, int n3) {
        try {
            long l2;
            int n4;
            int n5;
            int n6 = JavaBigDecimalFromByteArray.checkBounds(byArray.length, n2, n3);
            if (JavaBigDecimalFromByteArray.hasManyDigits(n3)) {
                return this.parseBigDecimalStringWithManyDigits(byArray, n2, n3);
            }
            long l3 = 0L;
            n3 = -1;
            int n7 = n2;
            char c2 = JavaBigDecimalFromByteArray.charAt(byArray, n7, n6);
            boolean bl2 = false;
            boolean bl3 = c2 == '-';
            if ((bl3 || c2 == '+') && (c2 = JavaBigDecimalFromByteArray.charAt(byArray, ++n7, n6)) == '\u0000') {
                throw new NumberFormatException("illegal syntax");
            }
            n2 = n7;
            while (n7 < n6) {
                c2 = byArray[n7];
                char c3 = (char)(c2 - 48);
                n5 = c3;
                if (c3 < '\n') {
                    l3 = 10L * l3 + (long)n5;
                } else {
                    if (c2 != '.') break;
                    bl2 |= n3 >= 0;
                    n3 = n7;
                    while (n7 < n6 - 4 && (n4 = FastDoubleSwar.tryToParseFourDigits(byArray, n7 + 1)) >= 0) {
                        l3 = 10000L * l3 + (long)n4;
                        n7 += 4;
                    }
                }
                ++n7;
            }
            n4 = n7;
            if (n3 < 0) {
                n5 = n4 - n2;
                n3 = n4;
                l2 = 0L;
            } else {
                n5 = n4 - n2 - 1;
                l2 = n3 - n4 + 1;
            }
            long l4 = 0L;
            if ((c2 | 0x20) == 101) {
                byte by2;
                n4 = n7++;
                c2 = JavaBigDecimalFromByteArray.charAt(byArray, n7, n6);
                boolean bl4 = c2 == '-';
                if (bl4 || c2 == '+') {
                    c2 = JavaBigDecimalFromByteArray.charAt(byArray, ++n7, n6);
                }
                bl2 |= (c2 = (char)(c2 - 48)) >= '\n';
                do {
                    if (l4 < Integer.MAX_VALUE) {
                        l4 = 10L * l4 + (long)c2;
                    }
                    by2 = JavaBigDecimalFromByteArray.charAt(byArray, ++n7, n6);
                    c2 = (char)by2;
                } while ((c2 = (char)(by2 - 48)) < '\n');
                if (bl4) {
                    l4 = -l4;
                }
                l2 += l4;
            } else {
                n4 = n6;
            }
            JavaBigDecimalFromByteArray.checkParsedBigDecimalBounds(bl2 |= n5 == 0, n7, n6, n5, l2);
            if (n5 < 19) {
                return new BigDecimal(bl3 ? -l3 : l3).scaleByPowerOfTen((int)l2);
            }
            int n8 = n3;
            return this.valueOfBigDecimalString(byArray, n2, n8, n8 + 1, n4, bl3, (int)l2);
        }
        catch (ArithmeticException arithmeticException) {
            NumberFormatException numberFormatException = new NumberFormatException("value exceeds limits");
            numberFormatException.initCause(arithmeticException);
            throw numberFormatException;
        }
    }

    final BigDecimal parseBigDecimalStringWithManyDigits(byte[] byArray, int n2, int n3) {
        long l2;
        int n4;
        int n5 = -1;
        int n6 = -1;
        int n7 = n2 + n3;
        int n8 = n2;
        char c2 = JavaBigDecimalFromByteArray.charAt(byArray, n8, n7);
        boolean bl2 = false;
        boolean bl3 = c2 == '-';
        if ((bl3 || c2 == '+') && (c2 = JavaBigDecimalFromByteArray.charAt(byArray, ++n8, n7)) == '\u0000') {
            throw new NumberFormatException("illegal syntax");
        }
        n2 = n8;
        int n9 = Math.min(n7 - 8, 0x40000000);
        while (n8 < n9 && FastDoubleSwar.isEightZeroes(byArray, n8)) {
            n8 += 8;
        }
        while (n8 < n7 && byArray[n8] == 48) {
            ++n8;
        }
        n3 = n8;
        while (n8 < n9 && FastDoubleSwar.isEightDigits(byArray, n8)) {
            n8 += 8;
        }
        while (n8 < n7 && FastDoubleSwar.isDigit((byte)(c2 = byArray[n8]))) {
            ++n8;
        }
        if (c2 == '.') {
            n6 = n8++;
            while (n8 < n9 && FastDoubleSwar.isEightZeroes(byArray, n8)) {
                n8 += 8;
            }
            while (n8 < n7 && byArray[n8] == 48) {
                ++n8;
            }
            n5 = n8;
            while (n8 < n9 && FastDoubleSwar.isEightDigits(byArray, n8)) {
                n8 += 8;
            }
            while (n8 < n7 && FastDoubleSwar.isDigit((byte)(c2 = byArray[n8]))) {
                ++n8;
            }
        }
        n9 = n8;
        if (n6 < 0) {
            n4 = n9 - n3;
            n6 = n9;
            n5 = n9;
            l2 = 0L;
        } else {
            n4 = n3 == n6 ? n9 - n5 : n9 - n3 - 1;
            l2 = n6 - n9 + 1;
        }
        long l3 = 0L;
        if ((c2 | 0x20) == 101) {
            byte by2;
            n9 = n8++;
            c2 = JavaBigDecimalFromByteArray.charAt(byArray, n8, n7);
            boolean bl4 = c2 == '-';
            if (bl4 || c2 == '+') {
                c2 = JavaBigDecimalFromByteArray.charAt(byArray, ++n8, n7);
            }
            bl2 = false | (c2 = (char)(c2 - 48)) >= '\n';
            do {
                if (l3 < Integer.MAX_VALUE) {
                    l3 = 10L * l3 + (long)c2;
                }
                by2 = JavaBigDecimalFromByteArray.charAt(byArray, ++n8, n7);
                c2 = (char)by2;
            } while ((c2 = (char)(by2 - 48)) < '\n');
            if (bl4) {
                l3 = -l3;
            }
            l2 += l3;
        } else {
            n9 = n7;
        }
        JavaBigDecimalFromByteArray.checkParsedBigDecimalBounds(bl2 |= n2 == n6 && n6 == n9, n8, n7, n4, l2);
        return this.valueOfBigDecimalString(byArray, n3, n6, n5, n9, bl3, (int)l2);
    }

    final BigDecimal valueOfBigDecimalString(byte[] object, int n2, int n3, int n4, int n5, boolean bl2, int n6) {
        BigInteger bigInteger;
        int n7 = n5 - n3 - 1;
        int n8 = n5 - n4;
        int n9 = n3 - n2;
        NavigableMap<Integer, BigInteger> navigableMap = null;
        if (n9 > 0) {
            if (n9 > 400) {
                navigableMap = FastIntegerMath.createPowersOfTenFloor16Map();
                FastIntegerMath.fillPowersOfNFloor16Recursive(navigableMap, n2, n3);
                bigInteger = ParseDigitsTaskByteArray.parseDigitsRecursive(object, n2, n3, navigableMap, 400);
            } else {
                bigInteger = ParseDigitsTaskByteArray.parseDigitsIterative(object, n2, n3);
            }
        } else {
            bigInteger = BigInteger.ZERO;
        }
        if (n7 > 0) {
            if (n8 > 400) {
                if (navigableMap == null) {
                    navigableMap = FastIntegerMath.createPowersOfTenFloor16Map();
                }
                FastIntegerMath.fillPowersOfNFloor16Recursive(navigableMap, n4, n5);
                object = ParseDigitsTaskByteArray.parseDigitsRecursive(object, n4, n5, navigableMap, 400);
            } else {
                object = ParseDigitsTaskByteArray.parseDigitsIterative(object, n4, n5);
            }
            if (bigInteger.signum() != 0) {
                BigInteger bigInteger2 = FastIntegerMath.computePowerOfTen(navigableMap, n7);
                object = FftMultiplier.multiply(bigInteger, bigInteger2).add((BigInteger)object);
            }
        } else {
            object = bigInteger;
        }
        return new BigDecimal((BigInteger)(bl2 ? object.negate() : object), -n6);
    }
}

