/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_2;

import com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_2.AbstractBigIntegerParser;
import com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_2.AbstractNumberParser;
import com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_2.FastDoubleSwar;
import com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_2.FastIntegerMath;
import com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_2.ParseDigitsTaskCharSequence;
import java.math.BigInteger;
import java.util.NavigableMap;

class JavaBigIntegerFromCharSequence
extends AbstractBigIntegerParser {
    JavaBigIntegerFromCharSequence() {
    }

    public BigInteger parseBigIntegerString(CharSequence charSequence, int n2, int n3, int n4) throws NumberFormatException {
        try {
            int n5 = charSequence.length();
            int n6 = AbstractNumberParser.checkBounds(n5, n2, n3);
            n5 = n2;
            char c2 = charSequence.charAt(n5);
            boolean bl2 = c2 == '-';
            if ((bl2 || c2 == '+') && (c2 = JavaBigIntegerFromCharSequence.charAt(charSequence, ++n5, n6)) == '\u0000') {
                throw new NumberFormatException("illegal syntax");
            }
            switch (n4) {
                case 10: {
                    return this.parseDecDigits(charSequence, n5, n6, bl2);
                }
                case 16: {
                    return this.parseHexDigits(charSequence, n5, n6, bl2);
                }
            }
            return new BigInteger(charSequence.subSequence(n2, n3).toString(), n4);
        }
        catch (ArithmeticException arithmeticException) {
            NumberFormatException numberFormatException = new NumberFormatException("value exceeds limits");
            numberFormatException.initCause(arithmeticException);
            throw numberFormatException;
        }
    }

    private BigInteger parseDecDigits(CharSequence charSequence, int n2, int n3, boolean bl2) {
        int n4 = n3 - n2;
        if (JavaBigIntegerFromCharSequence.hasManyDigits(n4)) {
            return this.parseManyDecDigits(charSequence, n2, n3, bl2);
        }
        long l2 = FastDoubleSwar.tryToParseUpTo7Digits(charSequence, n2, n4 = n2 + (n4 & 7));
        boolean bl3 = l2 >= 0L;
        for (n2 = n4; n2 < n3; n2 += 8) {
            n4 = FastDoubleSwar.tryToParseEightDigits(charSequence, n2);
            bl3 &= n4 >= 0;
            l2 = l2 * 100000000L + (long)n4;
        }
        if (!bl3) {
            throw new NumberFormatException("illegal syntax");
        }
        return BigInteger.valueOf(bl2 ? -l2 : l2);
    }

    private BigInteger parseHexDigits(CharSequence charSequence, int n2, int n3, boolean bl2) {
        int n4;
        int n5 = n3 - (n2 = this.skipZeroes(charSequence, n2, n3));
        if (n5 <= 0) {
            return BigInteger.ZERO;
        }
        JavaBigIntegerFromCharSequence.checkHexBigIntegerBounds(n5);
        byte[] byArray = new byte[(n5 + 1 >> 1) + 1];
        int n6 = 1;
        boolean bl3 = false;
        if ((n5 & 1) != 0) {
            char c2 = charSequence.charAt(n2++);
            n5 = c2;
            n4 = JavaBigIntegerFromCharSequence.lookupHex(c2);
            ++n6;
            byArray[1] = (byte)n4;
            bl3 = n4 < 0;
        }
        n5 = n2 + (n3 - n2 & 7);
        while (n2 < n5) {
            n4 = charSequence.charAt(n2);
            char c3 = charSequence.charAt(n2 + 1);
            int n7 = JavaBigIntegerFromCharSequence.lookupHex((char)n4);
            n4 = JavaBigIntegerFromCharSequence.lookupHex(c3);
            byArray[n6++] = (byte)(n7 << 4 | n4);
            bl3 |= n4 < 0 || n7 < 0;
            n2 += 2;
        }
        while (n2 < n3) {
            long l2 = FastDoubleSwar.tryToParseEightHexDigits(charSequence, n2);
            FastDoubleSwar.writeIntBE(byArray, n6, (int)l2);
            bl3 |= l2 < 0L;
            n2 += 8;
            n6 += 4;
        }
        if (bl3) {
            throw new NumberFormatException("illegal syntax");
        }
        BigInteger bigInteger = new BigInteger(byArray);
        if (bl2) {
            return bigInteger.negate();
        }
        return bigInteger;
    }

    private BigInteger parseManyDecDigits(CharSequence object, int n2, int n3, boolean bl2) {
        n2 = this.skipZeroes((CharSequence)object, n2, n3);
        int n4 = n3 - n2;
        JavaBigIntegerFromCharSequence.checkDecBigIntegerBounds(n4);
        NavigableMap<Integer, BigInteger> navigableMap = FastIntegerMath.fillPowersOf10Floor16(n2, n3);
        object = ParseDigitsTaskCharSequence.parseDigitsRecursive((CharSequence)object, n2, n3, navigableMap, 400);
        if (bl2) {
            return ((BigInteger)object).negate();
        }
        return object;
    }

    private int skipZeroes(CharSequence charSequence, int n2, int n3) {
        while (n2 < n3 && charSequence.charAt(n2) == '0') {
            ++n2;
        }
        return n2;
    }
}

