/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_2;

import com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_2.AbstractJavaFloatingPointBitsFromCharArray;
import com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_2.FastFloatMath;

final class JavaFloatBitsFromCharArray
extends AbstractJavaFloatingPointBitsFromCharArray {
    @Override
    final long nan() {
        return Float.floatToRawIntBits(Float.NaN);
    }

    @Override
    final long negativeInfinity() {
        return Float.floatToRawIntBits(Float.NEGATIVE_INFINITY);
    }

    @Override
    final long positiveInfinity() {
        return Float.floatToRawIntBits(Float.POSITIVE_INFINITY);
    }

    @Override
    final long valueOfFloatLiteral(char[] cArray, int n2, int n3, boolean bl2, long l2, int n4, boolean bl3, int n5) {
        float f2 = FastFloatMath.tryDecFloatToFloatTruncated(bl2, l2, n4, bl3, n5);
        if (Float.isNaN(f2)) {
            return Float.floatToRawIntBits(Float.parseFloat(new String(cArray, n2, n3 - n2)));
        }
        return Float.floatToRawIntBits(f2);
    }

    @Override
    final long valueOfHexLiteral(char[] cArray, int n2, int n3, boolean bl2, long l2, int n4, boolean bl3, int n5) {
        float f2 = FastFloatMath.tryHexFloatToFloatTruncated(bl2, l2, n4, bl3, n5);
        return Float.floatToRawIntBits(Float.isNaN(f2) ? Float.parseFloat(new String(cArray, n2, n3 - n2)) : f2);
    }
}

