/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io;

import com.fasterxml.jackson.core.internal.shaded.fdp.v2_19_2.JavaBigDecimalParser;
import java.math.BigDecimal;

public final class BigDecimalParser {
    static final int MAX_CHARS_TO_REPORT = 1000;
    private static final int SIZE_FOR_SWITCH_TO_FASTDOUBLEPARSER = 500;

    private BigDecimalParser() {
    }

    public static BigDecimal parse(String string) {
        try {
            if (string.length() < 500) {
                return new BigDecimal(string);
            }
            return JavaBigDecimalParser.parseBigDecimal(string);
        }
        catch (ArithmeticException | NumberFormatException runtimeException) {
            RuntimeException runtimeException2 = runtimeException;
            throw BigDecimalParser._parseFailure(runtimeException, string);
        }
    }

    public static BigDecimal parse(char[] cArray, int n2, int n3) {
        try {
            if (n3 < 500) {
                return new BigDecimal(cArray, n2, n3);
            }
            return JavaBigDecimalParser.parseBigDecimal(cArray, n2, n3);
        }
        catch (ArithmeticException | NumberFormatException runtimeException) {
            RuntimeException runtimeException2 = runtimeException;
            throw BigDecimalParser._parseFailure(runtimeException, cArray, n2, n3);
        }
    }

    public static BigDecimal parse(char[] cArray) {
        return BigDecimalParser.parse(cArray, 0, cArray.length);
    }

    public static BigDecimal parseWithFastParser(String string) {
        try {
            return JavaBigDecimalParser.parseBigDecimal(string);
        }
        catch (ArithmeticException | NumberFormatException runtimeException) {
            RuntimeException runtimeException2 = runtimeException;
            throw BigDecimalParser._parseFailure(runtimeException, string);
        }
    }

    public static BigDecimal parseWithFastParser(char[] cArray, int n2, int n3) {
        try {
            return JavaBigDecimalParser.parseBigDecimal(cArray, n2, n3);
        }
        catch (ArithmeticException | NumberFormatException runtimeException) {
            RuntimeException runtimeException2 = runtimeException;
            throw BigDecimalParser._parseFailure(runtimeException, cArray, n2, n3);
        }
    }

    private static NumberFormatException _parseFailure(Exception object, String string) {
        if ((object = ((Throwable)object).getMessage()) == null) {
            object = "Not a valid number representation";
        }
        string = BigDecimalParser._getValueDesc(string);
        return new NumberFormatException(BigDecimalParser._generateExceptionMessage(string, (String)object));
    }

    private static NumberFormatException _parseFailure(Exception object, char[] object2, int n2, int n3) {
        if ((object = ((Throwable)object).getMessage()) == null) {
            object = "Not a valid number representation";
        }
        object2 = BigDecimalParser._getValueDesc(object2, n2, n3);
        return new NumberFormatException(BigDecimalParser._generateExceptionMessage((String)object2, (String)object));
    }

    private static String _getValueDesc(String string) {
        int n2 = string.length();
        if (n2 <= 1000) {
            return String.format("\"%s\"", string);
        }
        return String.format("\"%s\" (truncated to %d chars (from %d))", string.substring(0, 1000), 1000, n2);
    }

    private static String _getValueDesc(char[] cArray, int n2, int n3) {
        if (n3 <= 1000) {
            return String.format("\"%s\"", new String(cArray, n2, n3));
        }
        return String.format("\"%s\" (truncated to %d chars (from %d))", new String(cArray, n2, 1000), 1000, n3);
    }

    private static String _generateExceptionMessage(String string, String string2) {
        return String.format("Value %s can not be deserialized as `java.math.BigDecimal`, reason:  %s", string, string2);
    }
}

