/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.json;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonGenerator$Feature;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.CharTypes;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.io.NumberOutput;
import com.fasterxml.jackson.core.json.JsonGeneratorImpl;
import com.fasterxml.jackson.core.json.JsonWriteFeature;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;

public class UTF8JsonGenerator
extends JsonGeneratorImpl {
    private static final byte BYTE_u = 117;
    private static final byte BYTE_0 = 48;
    private static final byte BYTE_LBRACKET = 91;
    private static final byte BYTE_RBRACKET = 93;
    private static final byte BYTE_LCURLY = 123;
    private static final byte BYTE_RCURLY = 125;
    private static final byte BYTE_BACKSLASH = 92;
    private static final byte BYTE_COMMA = 44;
    private static final byte BYTE_COLON = 58;
    private static final int MAX_BYTES_TO_BUFFER = 512;
    private static final byte[] HEX_BYTES_UPPER = CharTypes.copyHexBytes(true);
    private static final byte[] HEX_BYTES_LOWER = CharTypes.copyHexBytes(false);
    private static final byte[] NULL_BYTES = new byte[]{110, 117, 108, 108};
    private static final byte[] TRUE_BYTES = new byte[]{116, 114, 117, 101};
    private static final byte[] FALSE_BYTES = new byte[]{102, 97, 108, 115, 101};
    protected final OutputStream _outputStream;
    protected byte _quoteChar;
    protected byte[] _outputBuffer;
    protected int _outputTail;
    protected final int _outputEnd;
    protected final int _outputMaxContiguous;
    protected char[] _charBuffer;
    protected final int _charBufferLength;
    protected byte[] _entityBuffer;
    protected boolean _bufferRecyclable;

    public UTF8JsonGenerator(IOContext iOContext, int n2, ObjectCodec objectCodec, OutputStream outputStream, char c2) {
        super(iOContext, n2, objectCodec);
        this._outputStream = outputStream;
        this._quoteChar = (byte)c2;
        n2 = ((JsonGenerator)this).isEnabled(JsonWriteFeature.ESCAPE_FORWARD_SLASHES.mappedFeature()) ? 1 : 0;
        if (c2 != '\"' || n2 != 0) {
            this._outputEscapes = CharTypes.get7BitOutputEscapes(c2, n2 != 0);
        }
        this._bufferRecyclable = true;
        this._outputBuffer = iOContext.allocWriteEncodingBuffer();
        this._outputEnd = this._outputBuffer.length;
        this._outputMaxContiguous = this._outputEnd >> 3;
        this._charBuffer = iOContext.allocConcatBuffer();
        this._charBufferLength = this._charBuffer.length;
        if (((JsonGenerator)this).isEnabled(JsonWriteFeature.ESCAPE_NON_ASCII.mappedFeature())) {
            ((JsonGenerator)this).setHighestNonEscapedChar(127);
        }
    }

    public UTF8JsonGenerator(IOContext iOContext, int n2, ObjectCodec objectCodec, OutputStream outputStream, char c2, byte[] byArray, int n3, boolean bl2) {
        super(iOContext, n2, objectCodec);
        this._outputStream = outputStream;
        this._quoteChar = (byte)c2;
        n2 = ((JsonGenerator)this).isEnabled(JsonWriteFeature.ESCAPE_FORWARD_SLASHES.mappedFeature()) ? 1 : 0;
        if (c2 != '\"' || n2 != 0) {
            this._outputEscapes = CharTypes.get7BitOutputEscapes(c2, n2 != 0);
        }
        this._bufferRecyclable = bl2;
        this._outputTail = n3;
        this._outputBuffer = byArray;
        this._outputEnd = this._outputBuffer.length;
        this._outputMaxContiguous = this._outputEnd >> 3;
        this._charBuffer = iOContext.allocConcatBuffer();
        this._charBufferLength = this._charBuffer.length;
    }

    @Deprecated
    public UTF8JsonGenerator(IOContext iOContext, int n2, ObjectCodec objectCodec, OutputStream outputStream) {
        this(iOContext, n2, objectCodec, outputStream, '\"');
    }

    @Deprecated
    public UTF8JsonGenerator(IOContext iOContext, int n2, ObjectCodec objectCodec, OutputStream outputStream, byte[] byArray, int n3, boolean bl2) {
        this(iOContext, n2, objectCodec, outputStream, '\"', byArray, n3, bl2);
    }

    @Override
    public Object getOutputTarget() {
        return this._outputStream;
    }

    @Override
    public int getOutputBuffered() {
        return this._outputTail;
    }

    @Override
    public void writeFieldName(String string) throws IOException {
        if (this._cfgPrettyPrinter != null) {
            this._writePPFieldName(string);
            return;
        }
        int n2 = this._writeContext.writeFieldName(string);
        if (n2 == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        if (n2 == 1) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 44;
        }
        if (this._cfgUnqNames) {
            this._writeStringSegments(string, false);
            return;
        }
        n2 = string.length();
        if (n2 > this._charBufferLength) {
            this._writeStringSegments(string, true);
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        if (n2 <= this._outputMaxContiguous) {
            if (this._outputTail + n2 > this._outputEnd) {
                this._flushBuffer();
            }
            this._writeStringSegment(string, 0, n2);
        } else {
            this._writeStringSegments(string, 0, n2);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public void writeFieldName(SerializableString serializableString) throws IOException {
        if (this._cfgPrettyPrinter != null) {
            this._writePPFieldName(serializableString);
            return;
        }
        int n2 = this._writeContext.writeFieldName(serializableString.getValue());
        if (n2 == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        if (n2 == 1) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 44;
        }
        if (this._cfgUnqNames) {
            this._writeUnq(serializableString);
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        n2 = serializableString.appendQuotedUTF8(this._outputBuffer, this._outputTail);
        if (n2 < 0) {
            this._writeBytes(serializableString.asQuotedUTF8());
        } else {
            this._outputTail += n2;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    private final void _writeUnq(SerializableString serializableString) throws IOException {
        int n2 = serializableString.appendQuotedUTF8(this._outputBuffer, this._outputTail);
        if (n2 < 0) {
            this._writeBytes(serializableString.asQuotedUTF8());
            return;
        }
        this._outputTail += n2;
    }

    @Override
    public final void writeStartArray() throws IOException {
        this._verifyValueWrite("start an array");
        this._writeContext = this._writeContext.createChildArrayContext();
        ((JsonGenerator)this).streamWriteConstraints().validateNestingDepth(this._writeContext.getNestingDepth());
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartArray(this);
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 91;
    }

    @Override
    public final void writeStartArray(Object object) throws IOException {
        this._verifyValueWrite("start an array");
        this._writeContext = this._writeContext.createChildArrayContext(object);
        ((JsonGenerator)this).streamWriteConstraints().validateNestingDepth(this._writeContext.getNestingDepth());
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartArray(this);
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 91;
    }

    @Override
    public void writeStartArray(Object object, int n2) throws IOException {
        this._verifyValueWrite("start an array");
        this._writeContext = this._writeContext.createChildArrayContext(object);
        ((JsonGenerator)this).streamWriteConstraints().validateNestingDepth(this._writeContext.getNestingDepth());
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartArray(this);
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 91;
    }

    @Override
    public final void writeEndArray() throws IOException {
        if (!this._writeContext.inArray()) {
            this._reportError("Current context not Array but " + this._writeContext.typeDesc());
        }
        if (this._cfgPrettyPrinter != null) {
            UTF8JsonGenerator uTF8JsonGenerator = this;
            this._cfgPrettyPrinter.writeEndArray(uTF8JsonGenerator, uTF8JsonGenerator._writeContext.getEntryCount());
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 93;
        }
        this._writeContext = this._writeContext.clearAndGetParent();
    }

    @Override
    public final void writeStartObject() throws IOException {
        this._verifyValueWrite("start an object");
        this._writeContext = this._writeContext.createChildObjectContext();
        ((JsonGenerator)this).streamWriteConstraints().validateNestingDepth(this._writeContext.getNestingDepth());
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartObject(this);
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 123;
    }

    @Override
    public void writeStartObject(Object object) throws IOException {
        this._verifyValueWrite("start an object");
        object = this._writeContext.createChildObjectContext(object);
        ((JsonGenerator)this).streamWriteConstraints().validateNestingDepth(((JsonStreamContext)object).getNestingDepth());
        this._writeContext = object;
        if (this._cfgPrettyPrinter != null) {
            this._cfgPrettyPrinter.writeStartObject(this);
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = 123;
    }

    @Override
    public void writeStartObject(Object object, int n2) throws IOException {
        ((JsonGenerator)this).writeStartObject(object);
    }

    @Override
    public final void writeEndObject() throws IOException {
        if (!this._writeContext.inObject()) {
            this._reportError("Current context not Object but " + this._writeContext.typeDesc());
        }
        if (this._cfgPrettyPrinter != null) {
            UTF8JsonGenerator uTF8JsonGenerator = this;
            this._cfgPrettyPrinter.writeEndObject(uTF8JsonGenerator, uTF8JsonGenerator._writeContext.getEntryCount());
        } else {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = 125;
        }
        this._writeContext = this._writeContext.clearAndGetParent();
    }

    protected final void _writePPFieldName(String string) throws IOException {
        int n2 = this._writeContext.writeFieldName(string);
        if (n2 == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        if (n2 == 1) {
            this._cfgPrettyPrinter.writeObjectEntrySeparator(this);
        } else {
            this._cfgPrettyPrinter.beforeObjectEntries(this);
        }
        if (this._cfgUnqNames) {
            this._writeStringSegments(string, false);
            return;
        }
        n2 = string.length();
        if (n2 > this._charBufferLength) {
            this._writeStringSegments(string, true);
            return;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        string.getChars(0, n2, this._charBuffer, 0);
        if (n2 <= this._outputMaxContiguous) {
            if (this._outputTail + n2 > this._outputEnd) {
                this._flushBuffer();
            }
            UTF8JsonGenerator uTF8JsonGenerator = this;
            uTF8JsonGenerator._writeStringSegment(uTF8JsonGenerator._charBuffer, 0, n2);
        } else {
            UTF8JsonGenerator uTF8JsonGenerator = this;
            uTF8JsonGenerator._writeStringSegments(uTF8JsonGenerator._charBuffer, 0, n2);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    protected final void _writePPFieldName(SerializableString serializableString) throws IOException {
        int n2;
        int n3 = this._writeContext.writeFieldName(serializableString.getValue());
        if (n3 == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        if (n3 == 1) {
            this._cfgPrettyPrinter.writeObjectEntrySeparator(this);
        } else {
            this._cfgPrettyPrinter.beforeObjectEntries(this);
        }
        if ((n3 = !this._cfgUnqNames ? 1 : 0) != 0) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = this._quoteChar;
        }
        if ((n2 = serializableString.appendQuotedUTF8(this._outputBuffer, this._outputTail)) < 0) {
            this._writeBytes(serializableString.asQuotedUTF8());
        } else {
            this._outputTail += n2;
        }
        if (n3 != 0) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = this._quoteChar;
        }
    }

    @Override
    public void writeString(String string) throws IOException {
        this._verifyValueWrite("write a string");
        if (string == null) {
            this._writeNull();
            return;
        }
        int n2 = string.length();
        if (n2 > this._outputMaxContiguous) {
            this._writeStringSegments(string, true);
            return;
        }
        if (this._outputTail + n2 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        this._writeStringSegment(string, 0, n2);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public void writeString(Reader reader, int n2) throws IOException {
        this._verifyValueWrite("write a string");
        if (reader == null) {
            this._reportError("null reader");
            return;
        }
        int n3 = n2 >= 0 ? n2 : Integer.MAX_VALUE;
        char[] cArray = this._charBuffer;
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        while (n3 > 0) {
            int n4 = Math.min(n3, cArray.length);
            if ((n4 = reader.read(cArray, 0, n4)) <= 0) break;
            if (this._outputTail + n2 >= this._outputEnd) {
                this._flushBuffer();
            }
            this._writeStringSegments(cArray, 0, n4);
            n3 -= n4;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        if (n3 > 0 && n2 >= 0) {
            this._reportError("Didn't read enough from reader");
        }
    }

    @Override
    public void writeString(char[] cArray, int n2, int n3) throws IOException {
        this._verifyValueWrite("write a string");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        if (n3 <= this._outputMaxContiguous) {
            if (this._outputTail + n3 > this._outputEnd) {
                this._flushBuffer();
            }
            this._writeStringSegment(cArray, n2, n3);
        } else {
            this._writeStringSegments(cArray, n2, n3);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public final void writeString(SerializableString serializableString) throws IOException {
        this._verifyValueWrite("write a string");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        int n2 = serializableString.appendQuotedUTF8(this._outputBuffer, this._outputTail);
        if (n2 < 0) {
            this._writeBytes(serializableString.asQuotedUTF8());
        } else {
            this._outputTail += n2;
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public void writeRawUTF8String(byte[] byArray, int n2, int n3) throws IOException {
        this._checkRangeBoundsForByteArray(byArray, n2, n3);
        this._verifyValueWrite("write a string");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        this._writeBytes(byArray, n2, n3);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public void writeUTF8String(byte[] byArray, int n2, int n3) throws IOException {
        this._checkRangeBoundsForByteArray(byArray, n2, n3);
        this._verifyValueWrite("write a string");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        if (n3 <= this._outputMaxContiguous) {
            this._writeUTF8Segment(byArray, n2, n3);
        } else {
            this._writeUTF8Segments(byArray, n2, n3);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public void writeRaw(String string) throws IOException {
        char[] cArray;
        int n2 = string.length();
        if (n2 <= (cArray = this._charBuffer).length) {
            string.getChars(0, n2, cArray, 0);
            ((JsonGenerator)this).writeRaw(cArray, 0, n2);
            return;
        }
        ((JsonGenerator)this).writeRaw(string, 0, n2);
    }

    @Override
    public void writeRaw(String string, int n2, int n3) throws IOException {
        this._checkRangeBoundsForString(string, n2, n3);
        char[] cArray = this._charBuffer;
        int n4 = this._charBuffer.length;
        if (n3 <= n4) {
            int n5 = n2;
            string.getChars(n5, n5 + n3, cArray, 0);
            ((JsonGenerator)this).writeRaw(cArray, 0, n3);
            return;
        }
        n4 = Math.min(n4, (this._outputEnd >> 2) + (this._outputEnd >> 4));
        int n6 = n4 * 3;
        while (n3 > 0) {
            char c2;
            int n7 = Math.min(n4, n3);
            int n8 = n2;
            string.getChars(n8, n8 + n7, cArray, 0);
            if (this._outputTail + n6 > this._outputEnd) {
                this._flushBuffer();
            }
            if (n7 > 1 && (c2 = cArray[n7 - 1]) >= '\ud800' && c2 <= '\udbff') {
                --n7;
            }
            this._writeRawSegment(cArray, 0, n7);
            n2 += n7;
            n3 -= n7;
        }
    }

    @Override
    public void writeRaw(SerializableString serializableString) throws IOException {
        int n2 = serializableString.appendUnquotedUTF8(this._outputBuffer, this._outputTail);
        if (n2 < 0) {
            this._writeBytes(serializableString.asUnquotedUTF8());
            return;
        }
        this._outputTail += n2;
    }

    @Override
    public void writeRawValue(SerializableString serializableString) throws IOException {
        this._verifyValueWrite("write a raw (unencoded) value");
        int n2 = serializableString.appendUnquotedUTF8(this._outputBuffer, this._outputTail);
        if (n2 < 0) {
            this._writeBytes(serializableString.asUnquotedUTF8());
            return;
        }
        this._outputTail += n2;
    }

    @Override
    public final void writeRaw(char[] cArray, int n2, int n3) throws IOException {
        this._checkRangeBoundsForCharArray(cArray, n2, n3);
        int n4 = n3;
        int n5 = n4 + n4 + n3;
        if (this._outputTail + n5 > this._outputEnd) {
            if (this._outputEnd < n5) {
                this._writeSegmentedRaw(cArray, n2, n3);
                return;
            }
            this._flushBuffer();
        }
        n3 += n2;
        block0: while (n2 < n3) {
            while ((n5 = cArray[n2]) <= 127) {
                this._outputBuffer[this._outputTail++] = (byte)n5;
                if (++n2 >= n3) break block0;
            }
            if ((n5 = cArray[n2++]) < 2048) {
                this._outputBuffer[this._outputTail++] = (byte)(0xC0 | n5 >> 6);
                this._outputBuffer[this._outputTail++] = (byte)(0x80 | n5 & 0x3F);
                continue;
            }
            n2 = this._outputRawMultiByteChar(n5, cArray, n2, n3);
        }
    }

    @Override
    public void writeRaw(char c2) throws IOException {
        if (this._outputTail + 3 >= this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray = this._outputBuffer;
        if (c2 <= '\u007f') {
            byArray[this._outputTail++] = (byte)c2;
            return;
        }
        if (c2 < '\u0800') {
            byArray[this._outputTail++] = (byte)(0xC0 | c2 >> 6);
            byArray[this._outputTail++] = (byte)(0x80 | c2 & 0x3F);
            return;
        }
        this._outputRawMultiByteChar(c2, null, 0, 0);
    }

    private final void _writeSegmentedRaw(char[] cArray, int n2, int n3) throws IOException {
        int n4 = this._outputEnd;
        byte[] byArray = this._outputBuffer;
        n3 = n2 + n3;
        block0: while (n2 < n3) {
            char c2;
            while ((c2 = cArray[n2]) <= '\u007f') {
                if (this._outputTail >= n4) {
                    this._flushBuffer();
                }
                byArray[this._outputTail++] = (byte)c2;
                if (++n2 >= n3) break block0;
            }
            if (this._outputTail + 3 >= this._outputEnd) {
                this._flushBuffer();
            }
            if ((c2 = cArray[n2++]) < '\u0800') {
                byArray[this._outputTail++] = (byte)(0xC0 | c2 >> 6);
                byArray[this._outputTail++] = (byte)(0x80 | c2 & 0x3F);
                continue;
            }
            n2 = this._outputRawMultiByteChar(c2, cArray, n2, n3);
        }
    }

    private void _writeRawSegment(char[] cArray, int n2, int n3) throws IOException {
        block0: while (n2 < n3) {
            char c2;
            while ((c2 = cArray[n2]) <= '\u007f') {
                this._outputBuffer[this._outputTail++] = (byte)c2;
                if (++n2 >= n3) break block0;
            }
            if ((c2 = cArray[n2++]) < '\u0800') {
                this._outputBuffer[this._outputTail++] = (byte)(0xC0 | c2 >> 6);
                this._outputBuffer[this._outputTail++] = (byte)(0x80 | c2 & 0x3F);
                continue;
            }
            n2 = this._outputRawMultiByteChar(c2, cArray, n2, n3);
        }
    }

    @Override
    public void writeBinary(Base64Variant base64Variant, byte[] byArray, int n2, int n3) throws IOException, JsonGenerationException {
        this._checkRangeBoundsForByteArray(byArray, n2, n3);
        this._verifyValueWrite("write a binary value");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        int n4 = n2;
        this._writeBinary(base64Variant, byArray, n4, n4 + n3);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public int writeBinary(Base64Variant base64Variant, InputStream inputStream, int n2) throws IOException, JsonGenerationException {
        int n3;
        this._verifyValueWrite("write a binary value");
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        byte[] byArray = this._ioContext.allocBase64Buffer();
        try {
            if (n2 < 0) {
                n3 = this._writeBinary(base64Variant, inputStream, byArray);
            } else {
                n3 = this._writeBinary(base64Variant, inputStream, byArray, n2);
                if (n3 > 0) {
                    this._reportError("Too few bytes available: missing " + n3 + " bytes (out of " + n2 + ")");
                }
                n3 = n2;
            }
        }
        finally {
            this._ioContext.releaseBase64Buffer(byArray);
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        return n3;
    }

    @Override
    public void writeNumber(short s2) throws IOException {
        this._verifyValueWrite("write a number");
        if (this._outputTail + 6 >= this._outputEnd) {
            this._flushBuffer();
        }
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedShort(s2);
            return;
        }
        this._outputTail = NumberOutput.outputInt((int)s2, this._outputBuffer, this._outputTail);
    }

    private final void _writeQuotedShort(short s2) throws IOException {
        if (this._outputTail + 8 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        this._outputTail = NumberOutput.outputInt((int)s2, this._outputBuffer, this._outputTail);
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public void writeNumber(int n2) throws IOException {
        this._verifyValueWrite("write a number");
        if (this._outputTail + 11 >= this._outputEnd) {
            this._flushBuffer();
        }
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedInt(n2);
            return;
        }
        this._outputTail = NumberOutput.outputInt(n2, this._outputBuffer, this._outputTail);
    }

    private final void _writeQuotedInt(int n2) throws IOException {
        if (this._outputTail + 13 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        this._outputTail = NumberOutput.outputInt(n2, this._outputBuffer, this._outputTail);
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public void writeNumber(long l2) throws IOException {
        this._verifyValueWrite("write a number");
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedLong(l2);
            return;
        }
        if (this._outputTail + 21 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputTail = NumberOutput.outputLong(l2, this._outputBuffer, this._outputTail);
    }

    private final void _writeQuotedLong(long l2) throws IOException {
        if (this._outputTail + 23 >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        this._outputTail = NumberOutput.outputLong(l2, this._outputBuffer, this._outputTail);
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public void writeNumber(BigInteger bigInteger) throws IOException {
        this._verifyValueWrite("write a number");
        if (bigInteger == null) {
            this._writeNull();
            return;
        }
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedRaw(bigInteger.toString());
            return;
        }
        ((JsonGenerator)this).writeRaw(bigInteger.toString());
    }

    @Override
    public void writeNumber(double d2) throws IOException {
        if (this._cfgNumbersAsStrings || NumberOutput.notFinite(d2) && JsonGenerator$Feature.QUOTE_NON_NUMERIC_NUMBERS.enabledIn(this._features)) {
            ((JsonGenerator)this).writeString(NumberOutput.toString(d2, ((JsonGenerator)this).isEnabled(JsonGenerator$Feature.USE_FAST_DOUBLE_WRITER)));
            return;
        }
        this._verifyValueWrite("write a number");
        ((JsonGenerator)this).writeRaw(NumberOutput.toString(d2, ((JsonGenerator)this).isEnabled(JsonGenerator$Feature.USE_FAST_DOUBLE_WRITER)));
    }

    @Override
    public void writeNumber(float f2) throws IOException {
        if (this._cfgNumbersAsStrings || NumberOutput.notFinite(f2) && JsonGenerator$Feature.QUOTE_NON_NUMERIC_NUMBERS.enabledIn(this._features)) {
            ((JsonGenerator)this).writeString(NumberOutput.toString(f2, ((JsonGenerator)this).isEnabled(JsonGenerator$Feature.USE_FAST_DOUBLE_WRITER)));
            return;
        }
        this._verifyValueWrite("write a number");
        ((JsonGenerator)this).writeRaw(NumberOutput.toString(f2, ((JsonGenerator)this).isEnabled(JsonGenerator$Feature.USE_FAST_DOUBLE_WRITER)));
    }

    @Override
    public void writeNumber(BigDecimal bigDecimal) throws IOException {
        this._verifyValueWrite("write a number");
        if (bigDecimal == null) {
            this._writeNull();
            return;
        }
        if (this._cfgNumbersAsStrings) {
            UTF8JsonGenerator uTF8JsonGenerator = this;
            uTF8JsonGenerator._writeQuotedRaw(uTF8JsonGenerator._asString(bigDecimal));
            return;
        }
        UTF8JsonGenerator uTF8JsonGenerator = this;
        ((JsonGenerator)uTF8JsonGenerator).writeRaw(uTF8JsonGenerator._asString(bigDecimal));
    }

    @Override
    public void writeNumber(String string) throws IOException {
        this._verifyValueWrite("write a number");
        if (string == null) {
            this._writeNull();
            return;
        }
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedRaw(string);
            return;
        }
        ((JsonGenerator)this).writeRaw(string);
    }

    @Override
    public void writeNumber(char[] cArray, int n2, int n3) throws IOException {
        this._verifyValueWrite("write a number");
        if (this._cfgNumbersAsStrings) {
            this._writeQuotedRaw(cArray, n2, n3);
            return;
        }
        ((JsonGenerator)this).writeRaw(cArray, n2, n3);
    }

    private final void _writeQuotedRaw(String string) throws IOException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        ((JsonGenerator)this).writeRaw(string);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    private void _writeQuotedRaw(char[] cArray, int n2, int n3) throws IOException {
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
        ((JsonGenerator)this).writeRaw(cArray, n2, n3);
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = this._quoteChar;
    }

    @Override
    public void writeBoolean(boolean bl2) throws IOException {
        this._verifyValueWrite("write a boolean value");
        if (this._outputTail + 5 >= this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray = bl2 ? TRUE_BYTES : FALSE_BYTES;
        int n2 = byArray.length;
        System.arraycopy(byArray, 0, this._outputBuffer, this._outputTail, n2);
        this._outputTail += n2;
    }

    @Override
    public void writeNull() throws IOException {
        this._verifyValueWrite("write a null");
        this._writeNull();
    }

    @Override
    protected final void _verifyValueWrite(String object) throws IOException {
        int n2;
        int n3 = this._writeContext.writeValue();
        if (this._cfgPrettyPrinter != null) {
            this._verifyPrettyValueWrite((String)object, n3);
            return;
        }
        switch (n3) {
            default: {
                return;
            }
            case 1: {
                n2 = 44;
                break;
            }
            case 2: {
                n2 = 58;
                break;
            }
            case 3: {
                if (this._rootValueSeparator != null) {
                    byte[] byArray = this._rootValueSeparator.asUnquotedUTF8();
                    object = byArray;
                    if (byArray.length > 0) {
                        this._writeBytes((byte[])object);
                    }
                }
                return;
            }
            case 5: {
                this._reportCantWriteValueExpectName((String)object);
                return;
            }
        }
        if (this._outputTail >= this._outputEnd) {
            this._flushBuffer();
        }
        this._outputBuffer[this._outputTail++] = n2;
    }

    @Override
    public void flush() throws IOException {
        this._flushBuffer();
        if (this._outputStream != null && ((JsonGenerator)this).isEnabled(JsonGenerator$Feature.FLUSH_PASSED_TO_STREAM)) {
            this._outputStream.flush();
        }
    }

    @Override
    public void close() throws IOException {
        Object object;
        super.close();
        IOException iOException = null;
        try {
            if (this._outputBuffer != null && ((JsonGenerator)this).isEnabled(JsonGenerator$Feature.AUTO_CLOSE_JSON_CONTENT)) {
                while (true) {
                    if (((JsonStreamContext)(object = ((JsonGenerator)this).getOutputContext())).inArray()) {
                        ((JsonGenerator)this).writeEndArray();
                        continue;
                    }
                    if (!((JsonStreamContext)object).inObject()) break;
                    ((JsonGenerator)this).writeEndObject();
                }
            }
            this._flushBuffer();
        }
        catch (IOException iOException2) {
            object = iOException2;
            iOException = iOException2;
        }
        this._outputTail = 0;
        if (this._outputStream != null) {
            try {
                if (this._ioContext.isResourceManaged() || ((JsonGenerator)this).isEnabled(JsonGenerator$Feature.AUTO_CLOSE_TARGET)) {
                    this._outputStream.close();
                } else if (((JsonGenerator)this).isEnabled(JsonGenerator$Feature.FLUSH_PASSED_TO_STREAM)) {
                    this._outputStream.flush();
                }
            }
            catch (IOException | RuntimeException exception) {
                if (iOException != null) {
                    exception.addSuppressed(iOException);
                }
                throw exception;
            }
        }
        this._releaseBuffers();
        if (iOException != null) {
            throw iOException;
        }
    }

    @Override
    protected void _releaseBuffers() {
        Object[] objectArray = this._outputBuffer;
        if (this._outputBuffer != null && this._bufferRecyclable) {
            this._outputBuffer = null;
            this._ioContext.releaseWriteEncodingBuffer((byte[])objectArray);
        }
        objectArray = this._charBuffer;
        if (this._charBuffer != null) {
            this._charBuffer = null;
            this._ioContext.releaseConcatBuffer((char[])objectArray);
        }
    }

    private final void _writeBytes(byte[] byArray) throws IOException {
        int n2 = byArray.length;
        if (this._outputTail + n2 > this._outputEnd) {
            this._flushBuffer();
            if (n2 > 512) {
                this._outputStream.write(byArray, 0, n2);
                return;
            }
        }
        System.arraycopy(byArray, 0, this._outputBuffer, this._outputTail, n2);
        this._outputTail += n2;
    }

    private final void _writeBytes(byte[] byArray, int n2, int n3) throws IOException {
        if (this._outputTail + n3 > this._outputEnd) {
            this._flushBuffer();
            if (n3 > 512) {
                this._outputStream.write(byArray, n2, n3);
                return;
            }
        }
        System.arraycopy(byArray, n2, this._outputBuffer, this._outputTail, n3);
        this._outputTail += n3;
    }

    private final void _writeStringSegments(String string, boolean bl2) throws IOException {
        int n2;
        if (bl2) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = this._quoteChar;
        }
        int n3 = 0;
        for (int i2 = string.length(); i2 > 0; i2 -= n2) {
            n2 = Math.min(this._outputMaxContiguous, i2);
            if (this._outputTail + n2 > this._outputEnd) {
                this._flushBuffer();
            }
            this._writeStringSegment(string, n3, n2);
            n3 += n2;
        }
        if (bl2) {
            if (this._outputTail >= this._outputEnd) {
                this._flushBuffer();
            }
            this._outputBuffer[this._outputTail++] = this._quoteChar;
        }
    }

    private final void _writeStringSegments(char[] cArray, int n2, int n3) throws IOException {
        int n4;
        do {
            if (this._outputTail + (n4 = Math.min(this._outputMaxContiguous, n3)) > this._outputEnd) {
                this._flushBuffer();
            }
            this._writeStringSegment(cArray, n2, n4);
            n2 += n4;
        } while ((n3 -= n4) > 0);
    }

    private final void _writeStringSegments(String string, int n2, int n3) throws IOException {
        int n4;
        do {
            if (this._outputTail + (n4 = Math.min(this._outputMaxContiguous, n3)) > this._outputEnd) {
                this._flushBuffer();
            }
            this._writeStringSegment(string, n2, n4);
            n2 += n4;
        } while ((n3 -= n4) > 0);
    }

    private final void _writeStringSegment(char[] cArray, int n2, int n3) throws IOException {
        char c2;
        n3 += n2;
        int n4 = this._outputTail;
        byte[] byArray = this._outputBuffer;
        int[] nArray = this._outputEscapes;
        while (n2 < n3 && (c2 = cArray[n2]) <= '\u007f' && nArray[c2] == 0) {
            byArray[n4++] = (byte)c2;
            ++n2;
        }
        this._outputTail = n4;
        if (n2 < n3) {
            if (this._characterEscapes != null) {
                this._writeCustomStringSegment2(cArray, n2, n3);
                return;
            }
            if (this._maximumNonEscapedChar == 0) {
                this._writeStringSegment2(cArray, n2, n3);
                return;
            }
            this._writeStringSegmentASCII2(cArray, n2, n3);
        }
    }

    private final void _writeStringSegment(String string, int n2, int n3) throws IOException {
        char c2;
        n3 += n2;
        int n4 = this._outputTail;
        byte[] byArray = this._outputBuffer;
        int[] nArray = this._outputEscapes;
        while (n2 < n3 && (c2 = string.charAt(n2)) <= '\u007f' && nArray[c2] == 0) {
            byArray[n4++] = (byte)c2;
            ++n2;
        }
        this._outputTail = n4;
        if (n2 < n3) {
            if (this._characterEscapes != null) {
                this._writeCustomStringSegment2(string, n2, n3);
                return;
            }
            if (this._maximumNonEscapedChar == 0) {
                this._writeStringSegment2(string, n2, n3);
                return;
            }
            this._writeStringSegmentASCII2(string, n2, n3);
        }
    }

    private final void _writeStringSegment2(char[] cArray, int n2, int n3) throws IOException {
        if (this._outputTail + 6 * (n3 - n2) > this._outputEnd) {
            this._flushBuffer();
        }
        int n4 = this._outputTail;
        byte[] byArray = this._outputBuffer;
        int[] nArray = this._outputEscapes;
        while (n2 < n3) {
            char c2;
            char c3;
            if ((c3 = cArray[n2++]) <= '\u007f') {
                if (nArray[c3] == 0) {
                    byArray[n4++] = (byte)c3;
                    continue;
                }
                c2 = nArray[c3];
                if (c2 > '\u0000') {
                    byArray[n4++] = 92;
                    byArray[n4++] = (byte)c2;
                    continue;
                }
                n4 = this._writeGenericEscape(c3, n4);
                continue;
            }
            if (c3 <= '\u07ff') {
                byArray[n4++] = (byte)(0xC0 | c3 >> 6);
                byArray[n4++] = (byte)(0x80 | c3 & 0x3F);
                continue;
            }
            if (UTF8JsonGenerator._isStartOfSurrogatePair(c3)) {
                boolean bl2 = JsonGenerator$Feature.COMBINE_UNICODE_SURROGATES_IN_UTF8.enabledIn(this._features);
                c2 = (char)(bl2 ? 1 : 0);
                if (bl2 && n2 < n3) {
                    c3 = c3;
                    c2 = cArray[n2++];
                    n4 = this._outputSurrogatePair(c3, c2, n4);
                    continue;
                }
            }
            n4 = this._outputMultiByteChar(c3, n4);
        }
        this._outputTail = n4;
    }

    private final void _writeStringSegment2(String string, int n2, int n3) throws IOException {
        if (this._outputTail + 6 * (n3 - n2) > this._outputEnd) {
            this._flushBuffer();
        }
        int n4 = this._outputTail;
        byte[] byArray = this._outputBuffer;
        int[] nArray = this._outputEscapes;
        while (n2 < n3) {
            char c2;
            char c3;
            if ((c3 = string.charAt(n2++)) <= '\u007f') {
                if (nArray[c3] == 0) {
                    byArray[n4++] = (byte)c3;
                    continue;
                }
                c2 = nArray[c3];
                if (c2 > '\u0000') {
                    byArray[n4++] = 92;
                    byArray[n4++] = (byte)c2;
                    continue;
                }
                n4 = this._writeGenericEscape(c3, n4);
                continue;
            }
            if (c3 <= '\u07ff') {
                byArray[n4++] = (byte)(0xC0 | c3 >> 6);
                byArray[n4++] = (byte)(0x80 | c3 & 0x3F);
                continue;
            }
            if (UTF8JsonGenerator._isStartOfSurrogatePair(c3)) {
                boolean bl2 = JsonGenerator$Feature.COMBINE_UNICODE_SURROGATES_IN_UTF8.enabledIn(this._features);
                c2 = (char)(bl2 ? 1 : 0);
                if (bl2 && n2 < n3) {
                    c3 = c3;
                    c2 = string.charAt(n2++);
                    n4 = this._outputSurrogatePair(c3, c2, n4);
                    continue;
                }
            }
            n4 = this._outputMultiByteChar(c3, n4);
        }
        this._outputTail = n4;
    }

    private final void _writeStringSegmentASCII2(char[] cArray, int n2, int n3) throws IOException {
        if (this._outputTail + 6 * (n3 - n2) > this._outputEnd) {
            this._flushBuffer();
        }
        int n4 = this._outputTail;
        byte[] byArray = this._outputBuffer;
        int[] nArray = this._outputEscapes;
        int n5 = this._maximumNonEscapedChar;
        while (n2 < n3) {
            char c2;
            if ((c2 = cArray[n2++]) <= '\u007f') {
                if (nArray[c2] == 0) {
                    byArray[n4++] = (byte)c2;
                    continue;
                }
                int n6 = nArray[c2];
                if (n6 > 0) {
                    byArray[n4++] = 92;
                    byArray[n4++] = (byte)n6;
                    continue;
                }
                n4 = this._writeGenericEscape(c2, n4);
                continue;
            }
            if (c2 > n5) {
                n4 = this._writeGenericEscape(c2, n4);
                continue;
            }
            if (c2 <= '\u07ff') {
                byArray[n4++] = (byte)(0xC0 | c2 >> 6);
                byArray[n4++] = (byte)(0x80 | c2 & 0x3F);
                continue;
            }
            n4 = this._outputMultiByteChar(c2, n4);
        }
        this._outputTail = n4;
    }

    private final void _writeStringSegmentASCII2(String string, int n2, int n3) throws IOException {
        if (this._outputTail + 6 * (n3 - n2) > this._outputEnd) {
            this._flushBuffer();
        }
        int n4 = this._outputTail;
        byte[] byArray = this._outputBuffer;
        int[] nArray = this._outputEscapes;
        int n5 = this._maximumNonEscapedChar;
        while (n2 < n3) {
            char c2;
            if ((c2 = string.charAt(n2++)) <= '\u007f') {
                if (nArray[c2] == 0) {
                    byArray[n4++] = (byte)c2;
                    continue;
                }
                int n6 = nArray[c2];
                if (n6 > 0) {
                    byArray[n4++] = 92;
                    byArray[n4++] = (byte)n6;
                    continue;
                }
                n4 = this._writeGenericEscape(c2, n4);
                continue;
            }
            if (c2 > n5) {
                n4 = this._writeGenericEscape(c2, n4);
                continue;
            }
            if (c2 <= '\u07ff') {
                byArray[n4++] = (byte)(0xC0 | c2 >> 6);
                byArray[n4++] = (byte)(0x80 | c2 & 0x3F);
                continue;
            }
            n4 = this._outputMultiByteChar(c2, n4);
        }
        this._outputTail = n4;
    }

    private final void _writeCustomStringSegment2(char[] cArray, int n2, int n3) throws IOException {
        if (this._outputTail + 6 * (n3 - n2) > this._outputEnd) {
            this._flushBuffer();
        }
        int n4 = this._outputTail;
        byte[] byArray = this._outputBuffer;
        int[] nArray = this._outputEscapes;
        int n5 = this._maximumNonEscapedChar <= 0 ? 65535 : this._maximumNonEscapedChar;
        CharacterEscapes characterEscapes = this._characterEscapes;
        while (n2 < n3) {
            char c2;
            int n6;
            if ((n6 = cArray[n2++]) <= 127) {
                if (nArray[n6] == 0) {
                    byArray[n4++] = (byte)n6;
                    continue;
                }
                int n7 = nArray[n6];
                if (n7 > 0) {
                    byArray[n4++] = 92;
                    byArray[n4++] = (byte)n7;
                    continue;
                }
                if (n7 == -2) {
                    SerializableString serializableString = characterEscapes.getEscapeSequence(n6);
                    if (serializableString == null) {
                        this._reportError("Invalid custom escape definitions; custom escape not found for character code 0x" + Integer.toHexString(n6) + ", although was supposed to have one");
                    }
                    n4 = this._writeCustomEscape(byArray, n4, serializableString, n3 - n2);
                    continue;
                }
                n4 = this._writeGenericEscape(n6, n4);
                continue;
            }
            if (n6 > n5) {
                n4 = this._writeGenericEscape(n6, n4);
                continue;
            }
            SerializableString serializableString = characterEscapes.getEscapeSequence(n6);
            if (serializableString != null) {
                n4 = this._writeCustomEscape(byArray, n4, serializableString, n3 - n2);
                continue;
            }
            if (n6 <= 2047) {
                byArray[n4++] = (byte)(0xC0 | n6 >> 6);
                byArray[n4++] = (byte)(0x80 | n6 & 0x3F);
                continue;
            }
            if (UTF8JsonGenerator._isStartOfSurrogatePair(n6) && (c2 = JsonGenerator$Feature.COMBINE_UNICODE_SURROGATES_IN_UTF8.enabledIn(this._features)) != '\u0000' && n2 < n3) {
                n6 = (char)n6;
                c2 = cArray[n2++];
                n4 = this._outputSurrogatePair((char)n6, c2, n4);
                continue;
            }
            n4 = this._outputMultiByteChar(n6, n4);
        }
        this._outputTail = n4;
    }

    private final void _writeCustomStringSegment2(String string, int n2, int n3) throws IOException {
        if (this._outputTail + 6 * (n3 - n2) > this._outputEnd) {
            this._flushBuffer();
        }
        int n4 = this._outputTail;
        byte[] byArray = this._outputBuffer;
        int[] nArray = this._outputEscapes;
        int n5 = this._maximumNonEscapedChar <= 0 ? 65535 : this._maximumNonEscapedChar;
        CharacterEscapes characterEscapes = this._characterEscapes;
        while (n2 < n3) {
            char c2;
            int n6;
            if ((n6 = string.charAt(n2++)) <= 127) {
                if (nArray[n6] == 0) {
                    byArray[n4++] = (byte)n6;
                    continue;
                }
                int n7 = nArray[n6];
                if (n7 > 0) {
                    byArray[n4++] = 92;
                    byArray[n4++] = (byte)n7;
                    continue;
                }
                if (n7 == -2) {
                    SerializableString serializableString = characterEscapes.getEscapeSequence(n6);
                    if (serializableString == null) {
                        this._reportError("Invalid custom escape definitions; custom escape not found for character code 0x" + Integer.toHexString(n6) + ", although was supposed to have one");
                    }
                    n4 = this._writeCustomEscape(byArray, n4, serializableString, n3 - n2);
                    continue;
                }
                n4 = this._writeGenericEscape(n6, n4);
                continue;
            }
            if (n6 > n5) {
                n4 = this._writeGenericEscape(n6, n4);
                continue;
            }
            SerializableString serializableString = characterEscapes.getEscapeSequence(n6);
            if (serializableString != null) {
                n4 = this._writeCustomEscape(byArray, n4, serializableString, n3 - n2);
                continue;
            }
            if (n6 <= 2047) {
                byArray[n4++] = (byte)(0xC0 | n6 >> 6);
                byArray[n4++] = (byte)(0x80 | n6 & 0x3F);
                continue;
            }
            if (UTF8JsonGenerator._isStartOfSurrogatePair(n6) && (c2 = JsonGenerator$Feature.COMBINE_UNICODE_SURROGATES_IN_UTF8.enabledIn(this._features)) != '\u0000' && n2 < n3) {
                n6 = (char)n6;
                c2 = string.charAt(n2++);
                n4 = this._outputSurrogatePair((char)n6, c2, n4);
                continue;
            }
            n4 = this._outputMultiByteChar(n6, n4);
        }
        this._outputTail = n4;
    }

    private final int _writeCustomEscape(byte[] byArray, int n2, SerializableString object, int n3) throws IOException, JsonGenerationException {
        byte[] byArray2 = object.asUnquotedUTF8();
        object = byArray2;
        int n4 = byArray2.length;
        if (n4 > 6) {
            return this._handleLongCustomEscape(byArray, n2, this._outputEnd, (byte[])object, n3);
        }
        System.arraycopy(object, 0, byArray, n2, n4);
        return n2 + n4;
    }

    private final int _handleLongCustomEscape(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws IOException, JsonGenerationException {
        int n5 = byArray2.length;
        if (n2 + n5 > n3) {
            this._outputTail = n2;
            this._flushBuffer();
            n2 = this._outputTail;
            if (n5 > byArray.length) {
                this._outputStream.write(byArray2, 0, n5);
                return n2;
            }
        }
        System.arraycopy(byArray2, 0, byArray, n2, n5);
        if ((n2 += n5) + n4 * 6 > n3) {
            this._outputTail = n2;
            this._flushBuffer();
            return this._outputTail;
        }
        return n2;
    }

    private final void _writeUTF8Segments(byte[] byArray, int n2, int n3) throws IOException, JsonGenerationException {
        int n4;
        do {
            n4 = Math.min(this._outputMaxContiguous, n3);
            this._writeUTF8Segment(byArray, n2, n4);
            n2 += n4;
        } while ((n3 -= n4) > 0);
    }

    private final void _writeUTF8Segment(byte[] byArray, int n2, int n3) throws IOException, JsonGenerationException {
        int[] nArray = this._outputEscapes;
        int n4 = n2;
        int n5 = n2 + n3;
        while (n4 < n5) {
            byte by2;
            if ((by2 = byArray[n4++]) < 0 || nArray[by2] == 0) continue;
            this._writeUTF8Segment2(byArray, n2, n3);
            return;
        }
        if (this._outputTail + n3 > this._outputEnd) {
            this._flushBuffer();
        }
        System.arraycopy(byArray, n2, this._outputBuffer, this._outputTail, n3);
        this._outputTail += n3;
    }

    private final void _writeUTF8Segment2(byte[] byArray, int n2, int n3) throws IOException, JsonGenerationException {
        int n4 = this._outputTail;
        if (n4 + n3 * 6 > this._outputEnd) {
            this._flushBuffer();
            n4 = this._outputTail;
        }
        byte[] byArray2 = this._outputBuffer;
        int[] nArray = this._outputEscapes;
        n3 += n2;
        while (n2 < n3) {
            int n5;
            int n6 = n5 = byArray[n2++];
            if (n5 < 0 || nArray[n6] == 0) {
                byArray2[n4++] = n5;
                continue;
            }
            n5 = nArray[n6];
            if (n5 > 0) {
                byArray2[n4++] = 92;
                byArray2[n4++] = (byte)n5;
                continue;
            }
            n4 = this._writeGenericEscape(n6, n4);
        }
        this._outputTail = n4;
    }

    protected final void _writeBinary(Base64Variant base64Variant, byte[] byArray, int n2, int n3) throws IOException, JsonGenerationException {
        int n4;
        int n5 = n3 - 3;
        int n6 = this._outputEnd - 6;
        int n7 = base64Variant.getMaxLineLength() >> 2;
        while (n2 <= n5) {
            if (this._outputTail > n6) {
                this._flushBuffer();
            }
            n4 = byArray[n2++] << 8;
            n4 |= byArray[n2++] & 0xFF;
            n4 = n4 << 8 | byArray[n2++] & 0xFF;
            this._outputTail = base64Variant.encodeBase64Chunk(n4, this._outputBuffer, this._outputTail);
            if (--n7 > 0) continue;
            this._outputBuffer[this._outputTail++] = 92;
            this._outputBuffer[this._outputTail++] = 110;
            n7 = base64Variant.getMaxLineLength() >> 2;
        }
        n4 = n3 - n2;
        if (n4 > 0) {
            if (this._outputTail > n6) {
                this._flushBuffer();
            }
            n3 = byArray[n2++] << 16;
            if (n4 == 2) {
                n3 |= (byArray[n2] & 0xFF) << 8;
            }
            this._outputTail = base64Variant.encodeBase64Partial(n3, n4, this._outputBuffer, this._outputTail);
        }
    }

    protected final int _writeBinary(Base64Variant base64Variant, InputStream inputStream, byte[] byArray, int n2) throws IOException, JsonGenerationException {
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = -3;
        int n7 = this._outputEnd - 6;
        int n8 = base64Variant.getMaxLineLength() >> 2;
        while (n2 > 2) {
            if (n4 > n6) {
                n5 = this._readMore(inputStream, byArray, n4, n5, n2);
                n4 = 0;
                if (n5 < 3) break;
                n6 = n5 - 3;
            }
            if (this._outputTail > n7) {
                this._flushBuffer();
            }
            n3 = byArray[n4++] << 8;
            n3 |= byArray[n4++] & 0xFF;
            n3 = n3 << 8 | byArray[n4++] & 0xFF;
            n2 -= 3;
            this._outputTail = base64Variant.encodeBase64Chunk(n3, this._outputBuffer, this._outputTail);
            if (--n8 > 0) continue;
            this._outputBuffer[this._outputTail++] = 92;
            this._outputBuffer[this._outputTail++] = 110;
            n8 = base64Variant.getMaxLineLength() >> 2;
        }
        if (n2 > 0 && (n5 = this._readMore(inputStream, byArray, n4, n5, n2)) > 0) {
            int n9;
            if (this._outputTail > n7) {
                this._flushBuffer();
            }
            n3 = byArray[0] << 16;
            if (1 < n5) {
                n3 |= (byArray[1] & 0xFF) << 8;
                n9 = 2;
            } else {
                n9 = 1;
            }
            this._outputTail = base64Variant.encodeBase64Partial(n3, n9, this._outputBuffer, this._outputTail);
            n2 -= n9;
        }
        return n2;
    }

    protected final int _writeBinary(Base64Variant base64Variant, InputStream inputStream, byte[] byArray) throws IOException, JsonGenerationException {
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = -3;
        int n6 = 0;
        int n7 = this._outputEnd - 6;
        int n8 = base64Variant.getMaxLineLength() >> 2;
        while (true) {
            if (n3 > n5) {
                n4 = this._readMore(inputStream, byArray, n3, n4, byArray.length);
                n3 = 0;
                if (n4 < 3) break;
                n5 = n4 - 3;
            }
            if (this._outputTail > n7) {
                this._flushBuffer();
            }
            n2 = byArray[n3++] << 8;
            n2 |= byArray[n3++] & 0xFF;
            n2 = n2 << 8 | byArray[n3++] & 0xFF;
            n6 += 3;
            this._outputTail = base64Variant.encodeBase64Chunk(n2, this._outputBuffer, this._outputTail);
            if (--n8 > 0) continue;
            this._outputBuffer[this._outputTail++] = 92;
            this._outputBuffer[this._outputTail++] = 110;
            n8 = base64Variant.getMaxLineLength() >> 2;
        }
        if (n4 > 0) {
            if (this._outputTail > n7) {
                this._flushBuffer();
            }
            n2 = byArray[0] << 16;
            int n9 = 1;
            if (1 < n4) {
                n2 |= (byArray[1] & 0xFF) << 8;
                n9 = 2;
            }
            n6 += n9;
            this._outputTail = base64Variant.encodeBase64Partial(n2, n9, this._outputBuffer, this._outputTail);
        }
        return n6;
    }

    private final int _readMore(InputStream inputStream, byte[] byArray, int n2, int n3, int n4) throws IOException {
        int n5 = 0;
        while (n2 < n3) {
            byArray[n5++] = byArray[n2++];
        }
        n3 = n5;
        n4 = Math.min(n4, byArray.length);
        while ((n2 = n4 - n3) != 0) {
            if ((n2 = inputStream.read(byArray, n3, n2)) < 0) {
                return n3;
            }
            if ((n3 += n2) < 3) continue;
        }
        return n3;
    }

    private final int _outputRawMultiByteChar(int n2, char[] objectArray, int n3, int n4) throws IOException {
        if (n2 >= 55296 && n2 <= 57343) {
            if (n3 >= n4 || objectArray == null) {
                this._reportError(String.format("Split surrogate on writeRaw() input (last character): first character 0x%4x", n2));
            } else {
                this._outputSurrogates(n2, objectArray[n3]);
            }
            return n3 + 1;
        }
        objectArray = this._outputBuffer;
        this._outputBuffer[this._outputTail++] = (byte)(0xE0 | n2 >> 12);
        objectArray[this._outputTail++] = (char)(0x80 | n2 >> 6 & 0x3F);
        objectArray[this._outputTail++] = (char)(0x80 | n2 & 0x3F);
        return n3;
    }

    protected final void _outputSurrogates(int n2, int n3) throws IOException {
        n2 = this._decodeSurrogate(n2, n3);
        if (this._outputTail + 4 > this._outputEnd) {
            this._flushBuffer();
        }
        byte[] byArray = this._outputBuffer;
        this._outputBuffer[this._outputTail++] = (byte)(0xF0 | n2 >> 18);
        byArray[this._outputTail++] = (byte)(0x80 | n2 >> 12 & 0x3F);
        byArray[this._outputTail++] = (byte)(0x80 | n2 >> 6 & 0x3F);
        byArray[this._outputTail++] = (byte)(0x80 | n2 & 0x3F);
    }

    private int _outputSurrogatePair(char c2, char c3, int n2) {
        c2 = (char)(65536 + ((c2 & 0x3FF) << 10) + (c3 & 0x3FF));
        this._outputBuffer[n2++] = (byte)(240 + (c2 >> 18 & 7));
        this._outputBuffer[n2++] = (byte)(128 + (c2 >> 12 & 0x3F));
        this._outputBuffer[n2++] = (byte)(128 + (c2 >> 6 & 0x3F));
        this._outputBuffer[n2++] = (byte)(128 + (c2 & 0x3F));
        return n2;
    }

    private final int _outputMultiByteChar(int n2, int n3) throws IOException {
        byte[] byArray = this.getHexBytes();
        byte[] byArray2 = this._outputBuffer;
        if (n2 >= 55296 && n2 <= 57343) {
            byArray2[n3++] = 92;
            byArray2[n3++] = 117;
            byArray2[n3++] = byArray[n2 >> 12 & 0xF];
            byArray2[n3++] = byArray[n2 >> 8 & 0xF];
            byArray2[n3++] = byArray[n2 >> 4 & 0xF];
            byArray2[n3++] = byArray[n2 & 0xF];
        } else {
            byArray2[n3++] = (byte)(0xE0 | n2 >> 12);
            byArray2[n3++] = (byte)(0x80 | n2 >> 6 & 0x3F);
            byArray2[n3++] = (byte)(0x80 | n2 & 0x3F);
        }
        return n3;
    }

    private final void _writeNull() throws IOException {
        if (this._outputTail + 4 >= this._outputEnd) {
            this._flushBuffer();
        }
        System.arraycopy(NULL_BYTES, 0, this._outputBuffer, this._outputTail, 4);
        this._outputTail += 4;
    }

    private int _writeGenericEscape(int n2, int n3) throws IOException {
        byte[] byArray = this._outputBuffer;
        byte[] byArray2 = this.getHexBytes();
        byArray[n3++] = 92;
        byArray[n3++] = 117;
        if (n2 > 255) {
            int n4 = n2 >> 8 & 0xFF;
            byArray[n3++] = byArray2[n4 >> 4];
            byArray[n3++] = byArray2[n4 & 0xF];
            n2 &= 0xFF;
        } else {
            byArray[n3++] = 48;
            byArray[n3++] = 48;
        }
        byArray[n3++] = byArray2[n2 >> 4];
        byArray[n3++] = byArray2[n2 & 0xF];
        return n3;
    }

    protected final void _flushBuffer() throws IOException {
        int n2 = this._outputTail;
        if (n2 > 0) {
            this._outputTail = 0;
            this._outputStream.write(this._outputBuffer, 0, n2);
        }
    }

    private byte[] getHexBytes() {
        if (this._cfgWriteHexUppercase) {
            return HEX_BYTES_UPPER;
        }
        return HEX_BYTES_LOWER;
    }

    private static boolean _isStartOfSurrogatePair(int n2) {
        return (n2 & 0xFC00) == 55296;
    }
}

