/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.sym;

import com.fasterxml.jackson.core.JsonFactory$Feature;
import com.fasterxml.jackson.core.exc.StreamConstraintsException;
import com.fasterxml.jackson.core.sym.ByteQuadsCanonicalizer$TableInfo;
import com.fasterxml.jackson.core.util.InternCache;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;

public final class ByteQuadsCanonicalizer {
    private static final int DEFAULT_T_SIZE = 64;
    private static final int MAX_T_SIZE = 65536;
    private static final int MIN_HASH_SIZE = 16;
    protected static final int MAX_ENTRIES_FOR_REUSE = 6000;
    protected final ByteQuadsCanonicalizer _parent;
    protected final AtomicReference<ByteQuadsCanonicalizer$TableInfo> _tableInfo;
    protected final int _seed;
    protected final InternCache _interner;
    protected final boolean _failOnDoS;
    protected int[] _hashArea;
    protected int _hashSize;
    protected int _secondaryStart;
    protected int _tertiaryStart;
    protected int _tertiaryShift;
    protected int _count;
    protected String[] _names;
    protected int _spilloverEnd;
    protected int _longNameOffset;
    protected boolean _hashShared;
    private static final int MULT = 33;
    private static final int MULT2 = 65599;
    private static final int MULT3 = 31;

    private ByteQuadsCanonicalizer(int n2, int n3) {
        this._parent = null;
        this._count = 0;
        this._hashShared = true;
        this._seed = n3;
        this._interner = null;
        this._failOnDoS = true;
        if (n2 < 16) {
            n2 = 16;
        } else {
            int n4 = n2;
            if ((n4 & n4 - 1) != 0) {
                n3 = 16;
                while (n3 < n2) {
                    int n5 = n3;
                    n3 = n5 + n5;
                }
                n2 = n3;
            }
        }
        this._tableInfo = new AtomicReference<ByteQuadsCanonicalizer$TableInfo>(ByteQuadsCanonicalizer$TableInfo.createInitial(n2));
    }

    private ByteQuadsCanonicalizer(ByteQuadsCanonicalizer byteQuadsCanonicalizer, int n2, ByteQuadsCanonicalizer$TableInfo byteQuadsCanonicalizer$TableInfo, boolean bl2, boolean bl3) {
        this._parent = byteQuadsCanonicalizer;
        this._seed = n2;
        this._interner = bl2 ? InternCache.instance : null;
        this._failOnDoS = bl3;
        this._tableInfo = null;
        this._count = byteQuadsCanonicalizer$TableInfo.count;
        this._hashSize = byteQuadsCanonicalizer$TableInfo.size;
        this._secondaryStart = this._hashSize << 2;
        this._tertiaryStart = this._secondaryStart + (this._secondaryStart >> 1);
        this._tertiaryShift = byteQuadsCanonicalizer$TableInfo.tertiaryShift;
        this._hashArea = byteQuadsCanonicalizer$TableInfo.mainHash;
        this._names = byteQuadsCanonicalizer$TableInfo.names;
        this._spilloverEnd = byteQuadsCanonicalizer$TableInfo.spilloverEnd;
        this._longNameOffset = byteQuadsCanonicalizer$TableInfo.longNameOffset;
        this._hashShared = true;
    }

    private ByteQuadsCanonicalizer(ByteQuadsCanonicalizer$TableInfo byteQuadsCanonicalizer$TableInfo) {
        int n2;
        this._parent = null;
        this._seed = 0;
        this._interner = null;
        this._failOnDoS = true;
        this._tableInfo = null;
        this._count = -1;
        this._hashArea = byteQuadsCanonicalizer$TableInfo.mainHash;
        this._names = byteQuadsCanonicalizer$TableInfo.names;
        this._hashSize = byteQuadsCanonicalizer$TableInfo.size;
        this._secondaryStart = n2 = this._hashArea.length;
        this._tertiaryStart = n2;
        this._tertiaryShift = 1;
        this._spilloverEnd = n2;
        this._longNameOffset = n2;
        this._hashShared = true;
    }

    public static ByteQuadsCanonicalizer createRoot() {
        long l2 = System.currentTimeMillis();
        int n2 = (int)l2 + (int)(l2 >>> 32) | 1;
        return ByteQuadsCanonicalizer.createRoot(n2);
    }

    protected static ByteQuadsCanonicalizer createRoot(int n2) {
        return new ByteQuadsCanonicalizer(64, n2);
    }

    public final ByteQuadsCanonicalizer makeChild(int n2) {
        ByteQuadsCanonicalizer byteQuadsCanonicalizer = this;
        return new ByteQuadsCanonicalizer(byteQuadsCanonicalizer, byteQuadsCanonicalizer._seed, this._tableInfo.get(), JsonFactory$Feature.INTERN_FIELD_NAMES.enabledIn(n2), JsonFactory$Feature.FAIL_ON_SYMBOL_HASH_OVERFLOW.enabledIn(n2));
    }

    public final ByteQuadsCanonicalizer makeChildOrPlaceholder(int n2) {
        if (JsonFactory$Feature.CANONICALIZE_FIELD_NAMES.enabledIn(n2)) {
            ByteQuadsCanonicalizer byteQuadsCanonicalizer = this;
            return new ByteQuadsCanonicalizer(byteQuadsCanonicalizer, byteQuadsCanonicalizer._seed, this._tableInfo.get(), JsonFactory$Feature.INTERN_FIELD_NAMES.enabledIn(n2), JsonFactory$Feature.FAIL_ON_SYMBOL_HASH_OVERFLOW.enabledIn(n2));
        }
        return new ByteQuadsCanonicalizer(this._tableInfo.get());
    }

    public final void release() {
        if (this._parent != null && this.maybeDirty()) {
            this._parent.mergeChild(new ByteQuadsCanonicalizer$TableInfo(this));
            this._hashShared = true;
        }
    }

    private void mergeChild(ByteQuadsCanonicalizer$TableInfo byteQuadsCanonicalizer$TableInfo) {
        int n2 = byteQuadsCanonicalizer$TableInfo.count;
        ByteQuadsCanonicalizer$TableInfo byteQuadsCanonicalizer$TableInfo2 = this._tableInfo.get();
        if (n2 == byteQuadsCanonicalizer$TableInfo2.count) {
            return;
        }
        if (n2 > 6000) {
            byteQuadsCanonicalizer$TableInfo = ByteQuadsCanonicalizer$TableInfo.createInitial(64);
        }
        this._tableInfo.compareAndSet(byteQuadsCanonicalizer$TableInfo2, byteQuadsCanonicalizer$TableInfo);
    }

    public final int size() {
        if (this._tableInfo != null) {
            return this._tableInfo.get().count;
        }
        return this._count;
    }

    public final int bucketCount() {
        return this._hashSize;
    }

    public final boolean maybeDirty() {
        return !this._hashShared;
    }

    public final int hashSeed() {
        return this._seed;
    }

    public final boolean isCanonicalizing() {
        return this._parent != null;
    }

    public final int primaryCount() {
        int n2 = 0;
        int n3 = this._secondaryStart;
        for (int i2 = 3; i2 < n3; i2 += 4) {
            if (this._hashArea[i2] == 0) continue;
            ++n2;
        }
        return n2;
    }

    public final int secondaryCount() {
        int n2 = 0;
        int n3 = this._tertiaryStart;
        for (int i2 = this._secondaryStart + 3; i2 < n3; i2 += 4) {
            if (this._hashArea[i2] == 0) continue;
            ++n2;
        }
        return n2;
    }

    public final int tertiaryCount() {
        int n2;
        int n3 = 0;
        int n4 = n2 + this._hashSize;
        for (n2 = this._tertiaryStart + 3; n2 < n4; n2 += 4) {
            if (this._hashArea[n2] == 0) continue;
            ++n3;
        }
        return n3;
    }

    public final int spilloverCount() {
        return this._spilloverEnd - this._spilloverStart() >> 2;
    }

    public final int totalCount() {
        int n2 = 0;
        int n3 = this._hashSize << 3;
        for (int i2 = 3; i2 < n3; i2 += 4) {
            if (this._hashArea[i2] == 0) continue;
            ++n2;
        }
        return n2;
    }

    public final String toString() {
        int n2 = this.primaryCount();
        int n3 = this.secondaryCount();
        int n4 = this.tertiaryCount();
        int n5 = this.spilloverCount();
        int n6 = this.totalCount();
        return String.format("[%s: size=%d, hashSize=%d, %d/%d/%d/%d pri/sec/ter/spill (=%s), total:%d]", this.getClass().getName(), this._count, this._hashSize, n2, n3, n4, n5, n2 + n3 + n4 + n5, n6);
    }

    public final String findName(int n2) {
        int n3;
        ByteQuadsCanonicalizer byteQuadsCanonicalizer = this;
        int n4 = byteQuadsCanonicalizer._calcOffset(byteQuadsCanonicalizer.calcHash(n2));
        int[] nArray = this._hashArea;
        int n5 = this._hashArea[n4 + 3];
        if (n5 == 1) {
            if (nArray[n4] == n2) {
                return this._names[n4 >> 2];
            }
        } else if (n5 == 0) {
            return null;
        }
        if ((n5 = nArray[(n3 = this._secondaryStart + (n4 >> 3 << 2)) + 3]) == 1) {
            if (nArray[n3] == n2) {
                return this._names[n3 >> 2];
            }
        } else if (n5 == 0) {
            return null;
        }
        return this._findSecondary(n4, n2);
    }

    public final String findName(int n2, int n3) {
        int n4;
        ByteQuadsCanonicalizer byteQuadsCanonicalizer = this;
        int n5 = byteQuadsCanonicalizer._calcOffset(byteQuadsCanonicalizer.calcHash(n2, n3));
        int[] nArray = this._hashArea;
        int n6 = this._hashArea[n5 + 3];
        if (n6 == 2) {
            if (n2 == nArray[n5] && n3 == nArray[n5 + 1]) {
                return this._names[n5 >> 2];
            }
        } else if (n6 == 0) {
            return null;
        }
        if ((n6 = nArray[(n4 = this._secondaryStart + (n5 >> 3 << 2)) + 3]) == 2) {
            if (n2 == nArray[n4] && n3 == nArray[n4 + 1]) {
                return this._names[n4 >> 2];
            }
        } else if (n6 == 0) {
            return null;
        }
        return this._findSecondary(n5, n2, n3);
    }

    public final String findName(int n2, int n3, int n4) {
        int n5;
        ByteQuadsCanonicalizer byteQuadsCanonicalizer = this;
        int n6 = byteQuadsCanonicalizer._calcOffset(byteQuadsCanonicalizer.calcHash(n2, n3, n4));
        int[] nArray = this._hashArea;
        int n7 = this._hashArea[n6 + 3];
        if (n7 == 3) {
            if (n2 == nArray[n6] && nArray[n6 + 1] == n3 && nArray[n6 + 2] == n4) {
                return this._names[n6 >> 2];
            }
        } else if (n7 == 0) {
            return null;
        }
        if ((n7 = nArray[(n5 = this._secondaryStart + (n6 >> 3 << 2)) + 3]) == 3) {
            if (n2 == nArray[n5] && nArray[n5 + 1] == n3 && nArray[n5 + 2] == n4) {
                return this._names[n5 >> 2];
            }
        } else if (n7 == 0) {
            return null;
        }
        return this._findSecondary(n6, n2, n3, n4);
    }

    public final String findName(int[] nArray, int n2) {
        if (n2 < 4) {
            switch (n2) {
                case 3: {
                    return this.findName(nArray[0], nArray[1], nArray[2]);
                }
                case 2: {
                    return this.findName(nArray[0], nArray[1]);
                }
                case 1: {
                    return this.findName(nArray[0]);
                }
            }
            return "";
        }
        int n3 = this.calcHash(nArray, n2);
        int n4 = this._calcOffset(n3);
        int[] nArray2 = this._hashArea;
        int n5 = this._hashArea[n4 + 3];
        if (n3 == nArray2[n4] && n5 == n2 && this._verifyLongName(nArray, n2, nArray2[n4 + 1])) {
            return this._names[n4 >> 2];
        }
        if (n5 == 0) {
            return null;
        }
        n5 = this._secondaryStart + (n4 >> 3 << 2);
        int n6 = nArray2[n5 + 3];
        if (n3 == nArray2[n5] && n6 == n2 && this._verifyLongName(nArray, n2, nArray2[n5 + 1])) {
            return this._names[n5 >> 2];
        }
        return this._findSecondary(n4, n3, nArray, n2);
    }

    private final int _calcOffset(int n2) {
        return (n2 &= this._hashSize - 1) << 2;
    }

    private String _findSecondary(int n2, int n3) {
        int[] nArray = this._hashArea;
        int n4 = 1 << this._tertiaryShift;
        n4 = n2 + n4;
        for (n2 = this._tertiaryStart + (n2 >> this._tertiaryShift + 2 << this._tertiaryShift); n2 < n4; n2 += 4) {
            int n5 = nArray[n2 + 3];
            if (n3 == nArray[n2] && 1 == n5) {
                return this._names[n2 >> 2];
            }
            if (n5 != 0) continue;
            return null;
        }
        for (n2 = this._spilloverStart(); n2 < this._spilloverEnd; n2 += 4) {
            if (n3 != nArray[n2] || 1 != nArray[n2 + 3]) continue;
            return this._names[n2 >> 2];
        }
        return null;
    }

    private String _findSecondary(int n2, int n3, int n4) {
        int[] nArray = this._hashArea;
        int n5 = 1 << this._tertiaryShift;
        n5 = n2 + n5;
        for (n2 = this._tertiaryStart + (n2 >> this._tertiaryShift + 2 << this._tertiaryShift); n2 < n5; n2 += 4) {
            int n6 = nArray[n2 + 3];
            if (n3 == nArray[n2] && n4 == nArray[n2 + 1] && 2 == n6) {
                return this._names[n2 >> 2];
            }
            if (n6 != 0) continue;
            return null;
        }
        for (n2 = this._spilloverStart(); n2 < this._spilloverEnd; n2 += 4) {
            if (n3 != nArray[n2] || n4 != nArray[n2 + 1] || 2 != nArray[n2 + 3]) continue;
            return this._names[n2 >> 2];
        }
        return null;
    }

    private String _findSecondary(int n2, int n3, int n4, int n5) {
        int[] nArray = this._hashArea;
        int n6 = 1 << this._tertiaryShift;
        n6 = n2 + n6;
        for (n2 = this._tertiaryStart + (n2 >> this._tertiaryShift + 2 << this._tertiaryShift); n2 < n6; n2 += 4) {
            int n7 = nArray[n2 + 3];
            if (n3 == nArray[n2] && n4 == nArray[n2 + 1] && n5 == nArray[n2 + 2] && 3 == n7) {
                return this._names[n2 >> 2];
            }
            if (n7 != 0) continue;
            return null;
        }
        for (n2 = this._spilloverStart(); n2 < this._spilloverEnd; n2 += 4) {
            if (n3 != nArray[n2] || n4 != nArray[n2 + 1] || n5 != nArray[n2 + 2] || 3 != nArray[n2 + 3]) continue;
            return this._names[n2 >> 2];
        }
        return null;
    }

    private String _findSecondary(int n2, int n3, int[] nArray, int n4) {
        int[] nArray2 = this._hashArea;
        int n5 = 1 << this._tertiaryShift;
        n5 = n2 + n5;
        for (n2 = this._tertiaryStart + (n2 >> this._tertiaryShift + 2 << this._tertiaryShift); n2 < n5; n2 += 4) {
            int n6 = nArray2[n2 + 3];
            if (n3 == nArray2[n2] && n4 == n6 && this._verifyLongName(nArray, n4, nArray2[n2 + 1])) {
                return this._names[n2 >> 2];
            }
            if (n6 != 0) continue;
            return null;
        }
        for (n2 = this._spilloverStart(); n2 < this._spilloverEnd; n2 += 4) {
            if (n3 != nArray2[n2] || n4 != nArray2[n2 + 3] || !this._verifyLongName(nArray, n4, nArray2[n2 + 1])) continue;
            return this._names[n2 >> 2];
        }
        return null;
    }

    private boolean _verifyLongName(int[] nArray, int n2, int n3) {
        int[] nArray2 = this._hashArea;
        int n4 = 0;
        switch (n2) {
            default: {
                return this._verifyLongName2(nArray, n2, n3);
            }
            case 8: {
                ++n4;
                if (nArray[0] != nArray2[n3++]) {
                    return false;
                }
            }
            case 7: {
                if (nArray[n4++] != nArray2[n3++]) {
                    return false;
                }
            }
            case 6: {
                if (nArray[n4++] != nArray2[n3++]) {
                    return false;
                }
            }
            case 5: {
                if (nArray[n4++] == nArray2[n3++]) break;
                return false;
            }
            case 4: 
        }
        if (nArray[n4++] != nArray2[n3++]) {
            return false;
        }
        if (nArray[n4++] != nArray2[n3++]) {
            return false;
        }
        if (nArray[n4++] != nArray2[n3++]) {
            return false;
        }
        return nArray[n4] == nArray2[n3];
    }

    private boolean _verifyLongName2(int[] nArray, int n2, int n3) {
        int n4 = 0;
        do {
            if (nArray[n4++] == this._hashArea[n3++]) continue;
            return false;
        } while (n4 < n2);
        return true;
    }

    public final String addName(String string, int n2) throws StreamConstraintsException {
        this._verifySharing();
        if (this._interner != null) {
            string = this._interner.intern(string);
        }
        ByteQuadsCanonicalizer byteQuadsCanonicalizer = this;
        int n3 = byteQuadsCanonicalizer._findOffsetForAdd(byteQuadsCanonicalizer.calcHash(n2));
        this._hashArea[n3] = n2;
        this._hashArea[n3 + 3] = 1;
        this._names[n3 >> 2] = string;
        ++this._count;
        return string;
    }

    public final String addName(String string, int n2, int n3) throws StreamConstraintsException {
        this._verifySharing();
        if (this._interner != null) {
            string = this._interner.intern(string);
        }
        int n4 = this.calcHash(n2, n3);
        n4 = this._findOffsetForAdd(n4);
        this._hashArea[n4] = n2;
        this._hashArea[n4 + 1] = n3;
        this._hashArea[n4 + 3] = 2;
        this._names[n4 >> 2] = string;
        ++this._count;
        return string;
    }

    public final String addName(String string, int n2, int n3, int n4) throws StreamConstraintsException {
        this._verifySharing();
        if (this._interner != null) {
            string = this._interner.intern(string);
        }
        ByteQuadsCanonicalizer byteQuadsCanonicalizer = this;
        int n5 = byteQuadsCanonicalizer._findOffsetForAdd(byteQuadsCanonicalizer.calcHash(n2, n3, n4));
        this._hashArea[n5] = n2;
        this._hashArea[n5 + 1] = n3;
        this._hashArea[n5 + 2] = n4;
        this._hashArea[n5 + 3] = 3;
        this._names[n5 >> 2] = string;
        ++this._count;
        return string;
    }

    public final String addName(String string, int[] nArray, int n2) throws StreamConstraintsException {
        this._verifySharing();
        if (this._interner != null) {
            string = this._interner.intern(string);
        }
        switch (n2) {
            case 1: {
                ByteQuadsCanonicalizer byteQuadsCanonicalizer = this;
                int n3 = byteQuadsCanonicalizer._findOffsetForAdd(byteQuadsCanonicalizer.calcHash(nArray[0]));
                this._hashArea[n3] = nArray[0];
                this._hashArea[n3 + 3] = 1;
                break;
            }
            case 2: {
                ByteQuadsCanonicalizer byteQuadsCanonicalizer = this;
                int n3 = byteQuadsCanonicalizer._findOffsetForAdd(byteQuadsCanonicalizer.calcHash(nArray[0], nArray[1]));
                this._hashArea[n3] = nArray[0];
                this._hashArea[n3 + 1] = nArray[1];
                this._hashArea[n3 + 3] = 2;
                break;
            }
            case 3: {
                ByteQuadsCanonicalizer byteQuadsCanonicalizer = this;
                int n3 = byteQuadsCanonicalizer._findOffsetForAdd(byteQuadsCanonicalizer.calcHash(nArray[0], nArray[1], nArray[2]));
                this._hashArea[n3] = nArray[0];
                this._hashArea[n3 + 1] = nArray[1];
                this._hashArea[n3 + 2] = nArray[2];
                this._hashArea[n3 + 3] = 3;
                break;
            }
            default: {
                int n4;
                int n5 = this.calcHash(nArray, n2);
                int n3 = this._findOffsetForAdd(n5);
                this._hashArea[n3] = n5;
                this._hashArea[n3 + 1] = n4 = this._appendLongName(nArray, n2);
                this._hashArea[n3 + 3] = n2;
            }
        }
        this._names[n3 >> 2] = string;
        ++this._count;
        return string;
    }

    private void _verifySharing() {
        if (this._hashShared) {
            if (this._parent == null) {
                if (this._count == 0) {
                    throw new IllegalStateException("Internal error: Cannot add names to Root symbol table");
                }
                throw new IllegalStateException("Internal error: Cannot add names to Placeholder symbol table");
            }
            this._hashArea = Arrays.copyOf(this._hashArea, this._hashArea.length);
            this._names = Arrays.copyOf(this._names, this._names.length);
            this._hashShared = false;
        }
    }

    private int _findOffsetForAdd(int n2) throws StreamConstraintsException {
        int n3 = this._calcOffset(n2);
        int[] nArray = this._hashArea;
        if (this._hashArea[n3 + 3] == 0) {
            return n3;
        }
        if (this._checkNeedForRehash()) {
            return this._resizeAndFindOffsetForAdd(n2);
        }
        int n4 = this._secondaryStart + (n3 >> 3 << 2);
        if (nArray[n4 + 3] == 0) {
            return n4;
        }
        n4 = this._tertiaryStart + (n3 >> this._tertiaryShift + 2 << this._tertiaryShift);
        n3 = 1 << this._tertiaryShift;
        int n5 = n4 + n3;
        while (n4 < n5) {
            if (nArray[n4 + 3] == 0) {
                return n4;
            }
            n4 += 4;
        }
        n3 = this._spilloverEnd;
        this._spilloverEnd += 4;
        n5 = this._hashSize << 3;
        if (this._spilloverEnd >= n5) {
            if (this._failOnDoS) {
                this._reportTooManyCollisions();
            }
            return this._resizeAndFindOffsetForAdd(n2);
        }
        return n3;
    }

    private int _resizeAndFindOffsetForAdd(int n2) throws StreamConstraintsException {
        this.rehash();
        n2 = this._calcOffset(n2);
        int[] nArray = this._hashArea;
        if (this._hashArea[n2 + 3] == 0) {
            return n2;
        }
        int n3 = this._secondaryStart + (n2 >> 3 << 2);
        if (nArray[n3 + 3] == 0) {
            return n3;
        }
        n3 = this._tertiaryStart + (n2 >> this._tertiaryShift + 2 << this._tertiaryShift);
        n2 = 1 << this._tertiaryShift;
        n2 = n3 + n2;
        while (n3 < n2) {
            if (nArray[n3 + 3] == 0) {
                return n3;
            }
            n3 += 4;
        }
        n2 = this._spilloverEnd;
        this._spilloverEnd += 4;
        return n2;
    }

    static int multiplyByFourFifths(int n2) {
        return (int)((long)n2 * 0xCCCCCCCDL >>> 32);
    }

    private boolean _checkNeedForRehash() {
        int n2;
        return this._count > this._hashSize >> 1 && ((n2 = this._spilloverEnd - this._spilloverStart() >> 2) > 1 + this._count >> 7 || this._count > ByteQuadsCanonicalizer.multiplyByFourFifths(this._hashSize));
    }

    private int _appendLongName(int[] nArray, int n2) {
        int n3 = this._longNameOffset;
        int n4 = n3 + n2;
        if (n4 < 0) {
            throw new IllegalStateException(String.format("Internal error: long name offset overflow; start=%s, qlen=%s", n3, n2));
        }
        if (n4 > this._hashArea.length) {
            int n5 = n4 - this._hashArea.length;
            int n6 = Math.min(4096, this._hashSize);
            n5 = this._hashArea.length + Math.max(n5, n6);
            this._hashArea = Arrays.copyOf(this._hashArea, n5);
        }
        System.arraycopy(nArray, 0, this._hashArea, n3, n2);
        this._longNameOffset = n4;
        return n3;
    }

    public final int calcHash(int n2) {
        n2 ^= this._seed;
        n2 += n2 >>> 16;
        n2 ^= n2 << 3;
        n2 += n2 >>> 12;
        return n2;
    }

    public final int calcHash(int n2, int n3) {
        n2 += n2 >>> 15;
        n2 ^= n2 >>> 9;
        n2 += n3 * 33;
        n2 ^= this._seed;
        n2 += n2 >>> 16;
        n2 ^= n2 >>> 4;
        n2 += n2 << 3;
        return n2;
    }

    public final int calcHash(int n2, int n3, int n4) {
        n2 ^= this._seed;
        n2 += n2 >>> 9;
        n2 *= 31;
        n2 += n3;
        n2 *= 33;
        n2 += n2 >>> 15;
        n2 ^= n4;
        n2 += n2 >>> 4;
        n2 += n2 >>> 15;
        n2 ^= n2 << 9;
        return n2;
    }

    public final int calcHash(int[] nArray, int n2) {
        if (n2 < 4) {
            throw new IllegalArgumentException("qlen is too short, needs to be at least 4");
        }
        int n3 = nArray[0] ^ this._seed;
        n3 += n3 >>> 9;
        n3 += nArray[1];
        n3 += n3 >>> 15;
        n3 *= 33;
        n3 ^= nArray[2];
        n3 += n3 >>> 4;
        for (int i2 = 3; i2 < n2; ++i2) {
            int n4 = nArray[i2];
            n4 ^= n4 >> 21;
            n3 += n4;
        }
        n3 *= 65599;
        n3 += n3 >>> 19;
        n3 ^= n3 << 5;
        return n3;
    }

    private void rehash() throws StreamConstraintsException {
        this._hashShared = false;
        int[] nArray = this._hashArea;
        String[] stringArray = this._names;
        int n2 = this._hashSize;
        int n3 = this._count;
        int n4 = n2;
        int n5 = n4 + n4;
        int n6 = this._spilloverEnd;
        if (n5 > 65536) {
            this.nukeSymbols(true);
            return;
        }
        this._hashArea = new int[nArray.length + (n2 << 3)];
        this._hashSize = n5;
        this._secondaryStart = n5 << 2;
        this._tertiaryStart = this._secondaryStart + (this._secondaryStart >> 1);
        this._tertiaryShift = ByteQuadsCanonicalizer._calcTertiaryShift(n5);
        this._names = new String[stringArray.length << 1];
        this.nukeSymbols(false);
        n2 = 0;
        int[] nArray2 = new int[16];
        block5: for (int i2 = 0; i2 < n6; i2 += 4) {
            int n7 = nArray[i2 + 3];
            if (n7 == 0) continue;
            ++n2;
            String string = stringArray[i2 >> 2];
            switch (n7) {
                case 1: {
                    nArray2[0] = nArray[i2];
                    this.addName(string, nArray2, 1);
                    continue block5;
                }
                case 2: {
                    nArray2[0] = nArray[i2];
                    nArray2[1] = nArray[i2 + 1];
                    this.addName(string, nArray2, 2);
                    continue block5;
                }
                case 3: {
                    nArray2[0] = nArray[i2];
                    nArray2[1] = nArray[i2 + 1];
                    nArray2[2] = nArray[i2 + 2];
                    this.addName(string, nArray2, 3);
                    continue block5;
                }
                default: {
                    if (n7 > nArray2.length) {
                        nArray2 = new int[n7];
                    }
                    int n8 = nArray[i2 + 1];
                    System.arraycopy(nArray, n8, nArray2, 0, n7);
                    this.addName(string, nArray2, n7);
                }
            }
        }
        if (n2 != n3) {
            throw new IllegalStateException("Internal error: Failed rehash(), old count=" + n3 + ", copyCount=" + n2);
        }
    }

    private void nukeSymbols(boolean bl2) {
        this._count = 0;
        this._spilloverEnd = this._spilloverStart();
        this._longNameOffset = this._hashSize << 3;
        if (bl2) {
            Arrays.fill(this._hashArea, 0);
            Arrays.fill(this._names, null);
        }
    }

    private final int _spilloverStart() {
        int n2 = this._hashSize;
        return (n2 << 3) - n2;
    }

    protected final void _reportTooManyCollisions() throws StreamConstraintsException {
        if (this._hashSize <= 1024) {
            return;
        }
        throw new StreamConstraintsException("Spill-over slots in symbol table with " + this._count + " entries, hash area of " + this._hashSize + " slots is now full (all " + (this._hashSize >> 3) + " slots -- suspect a DoS attack based on hash collisions. You can disable the check via `JsonFactory.Feature.FAIL_ON_SYMBOL_HASH_OVERFLOW`");
    }

    static int _calcTertiaryShift(int n2) {
        if ((n2 >>= 2) < 64) {
            return 4;
        }
        if (n2 <= 256) {
            return 5;
        }
        if (n2 <= 1024) {
            return 6;
        }
        return 7;
    }
}

