/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.sym;

import com.fasterxml.jackson.core.JsonFactory$Feature;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.core.TokenStreamFactory;
import com.fasterxml.jackson.core.exc.StreamConstraintsException;
import com.fasterxml.jackson.core.sym.CharsToNameCanonicalizer$Bucket;
import com.fasterxml.jackson.core.sym.CharsToNameCanonicalizer$TableInfo;
import com.fasterxml.jackson.core.util.InternCache;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import java.util.concurrent.atomic.AtomicReference;

public final class CharsToNameCanonicalizer {
    public static final int HASH_MULT = 33;
    private static final int DEFAULT_T_SIZE = 64;
    private static final int MAX_T_SIZE = 65536;
    static final int MAX_ENTRIES_FOR_REUSE = 12000;
    static final int MAX_COLL_CHAIN_LENGTH = 150;
    protected final CharsToNameCanonicalizer _parent;
    protected final AtomicReference<CharsToNameCanonicalizer$TableInfo> _tableInfo;
    protected final StreamReadConstraints _streamReadConstraints;
    protected final int _seed;
    protected final int _factoryFeatures;
    protected boolean _canonicalize;
    protected String[] _symbols;
    protected CharsToNameCanonicalizer$Bucket[] _buckets;
    protected int _size;
    protected int _sizeThreshold;
    protected int _indexMask;
    protected int _longestCollisionList;
    protected boolean _hashShared;
    protected BitSet _overflows;

    private CharsToNameCanonicalizer(StreamReadConstraints streamReadConstraints, int n2, int n3) {
        this._parent = null;
        this._seed = n3;
        this._streamReadConstraints = streamReadConstraints;
        this._canonicalize = true;
        this._factoryFeatures = n2;
        this._hashShared = false;
        this._longestCollisionList = 0;
        this._tableInfo = new AtomicReference<CharsToNameCanonicalizer$TableInfo>(CharsToNameCanonicalizer$TableInfo.createInitial(64));
    }

    private CharsToNameCanonicalizer(CharsToNameCanonicalizer charsToNameCanonicalizer, StreamReadConstraints streamReadConstraints, int n2, int n3, CharsToNameCanonicalizer$TableInfo charsToNameCanonicalizer$TableInfo) {
        this._parent = charsToNameCanonicalizer;
        this._streamReadConstraints = streamReadConstraints;
        this._seed = n3;
        this._tableInfo = null;
        this._factoryFeatures = n2;
        this._canonicalize = JsonFactory$Feature.CANONICALIZE_FIELD_NAMES.enabledIn(n2);
        this._symbols = charsToNameCanonicalizer$TableInfo.symbols;
        this._buckets = charsToNameCanonicalizer$TableInfo.buckets;
        this._size = charsToNameCanonicalizer$TableInfo.size;
        this._longestCollisionList = charsToNameCanonicalizer$TableInfo.longestCollisionList;
        int n4 = this._symbols.length;
        this._sizeThreshold = CharsToNameCanonicalizer._thresholdSize(n4);
        this._indexMask = n4 - 1;
        this._hashShared = true;
    }

    private static int _thresholdSize(int n2) {
        int n3 = n2;
        return n3 - (n3 >> 2);
    }

    @Deprecated
    public static CharsToNameCanonicalizer createRoot() {
        return CharsToNameCanonicalizer.createRoot(null);
    }

    @Deprecated
    public static CharsToNameCanonicalizer createRoot(int n2) {
        return CharsToNameCanonicalizer.createRoot(null, n2);
    }

    public static CharsToNameCanonicalizer createRoot(TokenStreamFactory tokenStreamFactory) {
        return CharsToNameCanonicalizer.createRoot(tokenStreamFactory, 0);
    }

    public static CharsToNameCanonicalizer createRoot(TokenStreamFactory tokenStreamFactory, int n2) {
        int n3;
        StreamReadConstraints streamReadConstraints;
        if (n2 == 0) {
            n2 = System.identityHashCode(tokenStreamFactory);
        }
        if (tokenStreamFactory == null) {
            streamReadConstraints = StreamReadConstraints.defaults();
            n3 = 0;
        } else {
            streamReadConstraints = tokenStreamFactory.streamReadConstraints();
            n3 = tokenStreamFactory.getFactoryFeatures();
        }
        return new CharsToNameCanonicalizer(streamReadConstraints, n3, n2);
    }

    public final CharsToNameCanonicalizer makeChild() {
        CharsToNameCanonicalizer charsToNameCanonicalizer = this;
        return new CharsToNameCanonicalizer(charsToNameCanonicalizer, charsToNameCanonicalizer._streamReadConstraints, this._factoryFeatures, this._seed, this._tableInfo.get());
    }

    @Deprecated
    public final CharsToNameCanonicalizer makeChild(int n2) {
        return this.makeChild();
    }

    public final void release() {
        if (!this.maybeDirty()) {
            return;
        }
        if (this._parent != null && this._canonicalize) {
            this._parent.mergeChild(new CharsToNameCanonicalizer$TableInfo(this));
            this._hashShared = true;
        }
    }

    private void mergeChild(CharsToNameCanonicalizer$TableInfo charsToNameCanonicalizer$TableInfo) {
        int n2 = charsToNameCanonicalizer$TableInfo.size;
        CharsToNameCanonicalizer$TableInfo charsToNameCanonicalizer$TableInfo2 = this._tableInfo.get();
        if (n2 == charsToNameCanonicalizer$TableInfo2.size) {
            return;
        }
        if (n2 > 12000) {
            charsToNameCanonicalizer$TableInfo = CharsToNameCanonicalizer$TableInfo.createInitial(64);
        }
        this._tableInfo.compareAndSet(charsToNameCanonicalizer$TableInfo2, charsToNameCanonicalizer$TableInfo);
    }

    public final int size() {
        if (this._tableInfo != null) {
            return this._tableInfo.get().size;
        }
        return this._size;
    }

    public final int bucketCount() {
        return this._symbols.length;
    }

    public final boolean maybeDirty() {
        return !this._hashShared;
    }

    public final int hashSeed() {
        return this._seed;
    }

    public final int collisionCount() {
        int n2 = 0;
        CharsToNameCanonicalizer$Bucket[] charsToNameCanonicalizer$BucketArray = this._buckets;
        int n3 = this._buckets.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            CharsToNameCanonicalizer$Bucket charsToNameCanonicalizer$Bucket = charsToNameCanonicalizer$BucketArray[i2];
            if (charsToNameCanonicalizer$Bucket == null) continue;
            n2 += charsToNameCanonicalizer$Bucket.length;
        }
        return n2;
    }

    public final int maxCollisionLength() {
        return this._longestCollisionList;
    }

    public final String findSymbol(char[] cArray, int n2, int n3, int n4) throws IOException {
        if (n3 <= 0) {
            return "";
        }
        if (!this._canonicalize) {
            this._streamReadConstraints.validateNameLength(n3);
            return new String(cArray, n2, n3);
        }
        int n5 = this._hashToIndex(n4);
        String string = this._symbols[n5];
        if (string != null) {
            CharsToNameCanonicalizer$Bucket charsToNameCanonicalizer$Bucket;
            if (string.length() == n3) {
                int n6 = 0;
                while (string.charAt(n6) == cArray[n2 + n6]) {
                    if (++n6 != n3) continue;
                    return string;
                }
            }
            if ((charsToNameCanonicalizer$Bucket = this._buckets[n5 >> 1]) != null) {
                string = charsToNameCanonicalizer$Bucket.has(cArray, n2, n3);
                if (string != null) {
                    return string;
                }
                string = this._findSymbol2(cArray, n2, n3, charsToNameCanonicalizer$Bucket.next);
                if (string != null) {
                    return string;
                }
            }
        }
        this._streamReadConstraints.validateNameLength(n3);
        return this._addSymbol(cArray, n2, n3, n4, n5);
    }

    private String _findSymbol2(char[] cArray, int n2, int n3, CharsToNameCanonicalizer$Bucket charsToNameCanonicalizer$Bucket) {
        while (charsToNameCanonicalizer$Bucket != null) {
            String string = charsToNameCanonicalizer$Bucket.has(cArray, n2, n3);
            if (string != null) {
                return string;
            }
            charsToNameCanonicalizer$Bucket = charsToNameCanonicalizer$Bucket.next;
        }
        return null;
    }

    private String _addSymbol(char[] object, int n2, int n3, int n4, int n5) throws IOException {
        if (this._hashShared) {
            this.copyArrays();
            this._hashShared = false;
        } else if (this._size >= this._sizeThreshold) {
            this.rehash();
            CharsToNameCanonicalizer charsToNameCanonicalizer = this;
            n5 = charsToNameCanonicalizer._hashToIndex(charsToNameCanonicalizer.calcHash((char[])object, n2, n3));
        }
        object = new String((char[])object, n2, n3);
        if (JsonFactory$Feature.INTERN_FIELD_NAMES.enabledIn(this._factoryFeatures)) {
            object = InternCache.instance.intern((String)object);
        }
        ++this._size;
        if (this._symbols[n5] == null) {
            this._symbols[n5] = object;
        } else {
            n2 = n5 >> 1;
            CharsToNameCanonicalizer$Bucket charsToNameCanonicalizer$Bucket = new CharsToNameCanonicalizer$Bucket((String)object, this._buckets[n2]);
            n4 = charsToNameCanonicalizer$Bucket.length;
            if (n4 > 150) {
                this._handleSpillOverflow(n2, charsToNameCanonicalizer$Bucket, n5);
            } else {
                this._buckets[n2] = charsToNameCanonicalizer$Bucket;
                this._longestCollisionList = Math.max(n4, this._longestCollisionList);
            }
        }
        return object;
    }

    /*
     * Unable to fully structure code
     */
    private void _handleSpillOverflow(int var1_1, CharsToNameCanonicalizer$Bucket var2_2, int var3_3) throws IOException {
        block3: {
            if (this._overflows != null) break block3;
            this._overflows = new BitSet();
            ** GOTO lbl-1000
        }
        if (this._overflows.get(var1_1)) {
            if (JsonFactory$Feature.FAIL_ON_SYMBOL_HASH_OVERFLOW.enabledIn(this._factoryFeatures)) {
                this._reportTooManyCollisions(150);
            }
            this._canonicalize = false;
        } else lbl-1000:
        // 2 sources

        {
            this._overflows.set(var1_1);
        }
        this._symbols[var3_3] = var2_2.symbol;
        this._buckets[var1_1] = null;
        this._size -= var2_2.length;
        this._longestCollisionList = -1;
    }

    public final int _hashToIndex(int n2) {
        int n3 = n2;
        n2 = n3 + (n3 >>> 15);
        n2 ^= n2 << 7;
        n2 += n2 >>> 3;
        return n2 & this._indexMask;
    }

    public final int calcHash(char[] cArray, int n2, int n3) {
        int n4 = this._seed;
        int n5 = n2;
        n2 += n3;
        while (n5 < n2) {
            n4 = n4 * 33 + cArray[n5];
            ++n5;
        }
        if (n4 == 0) {
            return 1;
        }
        return n4;
    }

    public final int calcHash(String string) {
        int n2 = string.length();
        int n3 = this._seed;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 = n3 * 33 + string.charAt(i2);
        }
        if (n3 == 0) {
            return 1;
        }
        return n3;
    }

    private void copyArrays() {
        Object[] objectArray = this._symbols;
        this._symbols = Arrays.copyOf(objectArray, objectArray.length);
        objectArray = this._buckets;
        this._buckets = (CharsToNameCanonicalizer$Bucket[])Arrays.copyOf(objectArray, objectArray.length);
    }

    private void rehash() throws IOException {
        int n2;
        int n3 = this._symbols.length;
        int n4 = n3 + n3;
        if (n4 > 65536) {
            this._size = 0;
            this._canonicalize = false;
            this._symbols = new String[64];
            this._buckets = new CharsToNameCanonicalizer$Bucket[32];
            this._indexMask = 63;
            this._hashShared = false;
            return;
        }
        Object object = this._symbols;
        CharsToNameCanonicalizer$Bucket[] charsToNameCanonicalizer$BucketArray = this._buckets;
        this._symbols = new String[n4];
        this._buckets = new CharsToNameCanonicalizer$Bucket[n4 >> 1];
        this._indexMask = n4 - 1;
        this._sizeThreshold = CharsToNameCanonicalizer._thresholdSize(n4);
        n4 = 0;
        int n5 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            CharsToNameCanonicalizer$Bucket charsToNameCanonicalizer$Bucket;
            String string = object[n2];
            if (string == null) continue;
            ++n4;
            CharsToNameCanonicalizer charsToNameCanonicalizer = this;
            int n6 = charsToNameCanonicalizer._hashToIndex(charsToNameCanonicalizer.calcHash(string));
            if (this._symbols[n6] == null) {
                this._symbols[n6] = string;
                continue;
            }
            int n7 = n6 >> 1;
            this._buckets[n7] = charsToNameCanonicalizer$Bucket = new CharsToNameCanonicalizer$Bucket(string, this._buckets[n7]);
            n5 = Math.max(n5, charsToNameCanonicalizer$Bucket.length);
        }
        n2 = n3 >> 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            CharsToNameCanonicalizer$Bucket charsToNameCanonicalizer$Bucket = charsToNameCanonicalizer$BucketArray[i2];
            while (charsToNameCanonicalizer$Bucket != null) {
                ++n4;
                String string = charsToNameCanonicalizer$Bucket.symbol;
                CharsToNameCanonicalizer charsToNameCanonicalizer = this;
                int n8 = charsToNameCanonicalizer._hashToIndex(charsToNameCanonicalizer.calcHash(string));
                if (this._symbols[n8] == null) {
                    this._symbols[n8] = string;
                } else {
                    n3 = n8 >> 1;
                    this._buckets[n3] = object = new CharsToNameCanonicalizer$Bucket(string, this._buckets[n3]);
                    n5 = Math.max(n5, object.length);
                }
                charsToNameCanonicalizer$Bucket = charsToNameCanonicalizer$Bucket.next;
            }
        }
        this._longestCollisionList = n5;
        this._overflows = null;
        if (n4 != this._size) {
            throw new IllegalStateException(String.format("Internal error on SymbolTable.rehash(): had %d entries; now have %d", this._size, n4));
        }
    }

    protected final void _reportTooManyCollisions(int n2) throws StreamConstraintsException {
        throw new StreamConstraintsException("Longest collision chain in symbol table (of size " + this._size + ") now exceeds maximum, " + n2 + " -- suspect a DoS attack based on hash collisions");
    }

    protected final void verifyInternalConsistency() {
        int n2;
        int n3 = 0;
        for (String string : this._symbols) {
            if (string == null) continue;
            ++n3;
        }
        int n4 = n2 >> 1;
        for (int i2 = 0; i2 < n4; ++i2) {
            CharsToNameCanonicalizer$Bucket charsToNameCanonicalizer$Bucket = this._buckets[i2];
            while (charsToNameCanonicalizer$Bucket != null) {
                ++n3;
                charsToNameCanonicalizer$Bucket = charsToNameCanonicalizer$Bucket.next;
            }
        }
        if (n3 != this._size) {
            throw new IllegalStateException(String.format("Internal error: expected internal size %d vs calculated count %d", this._size, n3));
        }
    }
}

