/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter$FixedSpaceIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter$Indenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter$NopIndenter;
import com.fasterxml.jackson.core.util.Instantiatable;
import com.fasterxml.jackson.core.util.Separators;
import com.fasterxml.jackson.core.util.Separators$Spacing;
import java.io.IOException;
import java.io.Serializable;

public class DefaultPrettyPrinter
implements PrettyPrinter,
Instantiatable<DefaultPrettyPrinter>,
Serializable {
    private static final long serialVersionUID = 1L;
    @Deprecated
    public static final SerializedString DEFAULT_ROOT_VALUE_SEPARATOR = new SerializedString(" ");
    protected DefaultPrettyPrinter$Indenter _arrayIndenter = DefaultPrettyPrinter$FixedSpaceIndenter.instance;
    protected DefaultPrettyPrinter$Indenter _objectIndenter = DefaultIndenter.SYSTEM_LINEFEED_INSTANCE;
    protected SerializableString _rootSeparator;
    @Deprecated
    protected boolean _spacesInObjectEntries = true;
    protected transient int _nesting;
    protected Separators _separators;
    protected String _objectFieldValueSeparatorWithSpaces;
    protected String _objectEntrySeparator;
    protected String _objectEmptySeparator;
    protected String _arrayValueSeparator;
    protected String _arrayEmptySeparator;

    public DefaultPrettyPrinter() {
        this(DEFAULT_SEPARATORS);
    }

    @Deprecated
    public DefaultPrettyPrinter(String string) {
        this(string == null ? null : new SerializedString(string));
    }

    @Deprecated
    public DefaultPrettyPrinter(SerializableString serializableString) {
        this(DEFAULT_SEPARATORS.withRootSeparator(serializableString.getValue()));
    }

    @Deprecated
    public DefaultPrettyPrinter(DefaultPrettyPrinter defaultPrettyPrinter, SerializableString serializableString) {
        this._arrayIndenter = defaultPrettyPrinter._arrayIndenter;
        this._objectIndenter = defaultPrettyPrinter._objectIndenter;
        this._spacesInObjectEntries = defaultPrettyPrinter._spacesInObjectEntries;
        this._nesting = defaultPrettyPrinter._nesting;
        this._separators = defaultPrettyPrinter._separators;
        this._objectFieldValueSeparatorWithSpaces = defaultPrettyPrinter._objectFieldValueSeparatorWithSpaces;
        this._objectEntrySeparator = defaultPrettyPrinter._objectEntrySeparator;
        this._objectEmptySeparator = defaultPrettyPrinter._objectEmptySeparator;
        this._arrayValueSeparator = defaultPrettyPrinter._arrayValueSeparator;
        this._arrayEmptySeparator = defaultPrettyPrinter._arrayEmptySeparator;
        this._rootSeparator = serializableString;
    }

    public DefaultPrettyPrinter(Separators separators) {
        this._separators = separators;
        this._rootSeparator = separators.getRootSeparator() == null ? null : new SerializedString(separators.getRootSeparator());
        this._objectFieldValueSeparatorWithSpaces = separators.getObjectFieldValueSpacing().apply(separators.getObjectFieldValueSeparator());
        this._objectEntrySeparator = separators.getObjectEntrySpacing().apply(separators.getObjectEntrySeparator());
        this._objectEmptySeparator = separators.getObjectEmptySeparator();
        this._arrayValueSeparator = separators.getArrayValueSpacing().apply(separators.getArrayValueSeparator());
        this._arrayEmptySeparator = separators.getArrayEmptySeparator();
    }

    public DefaultPrettyPrinter(DefaultPrettyPrinter defaultPrettyPrinter) {
        this._rootSeparator = defaultPrettyPrinter._rootSeparator;
        this._arrayIndenter = defaultPrettyPrinter._arrayIndenter;
        this._objectIndenter = defaultPrettyPrinter._objectIndenter;
        this._spacesInObjectEntries = defaultPrettyPrinter._spacesInObjectEntries;
        this._nesting = defaultPrettyPrinter._nesting;
        this._separators = defaultPrettyPrinter._separators;
        this._objectFieldValueSeparatorWithSpaces = defaultPrettyPrinter._objectFieldValueSeparatorWithSpaces;
        this._objectEntrySeparator = defaultPrettyPrinter._objectEntrySeparator;
        this._objectEmptySeparator = defaultPrettyPrinter._objectEmptySeparator;
        this._arrayValueSeparator = defaultPrettyPrinter._arrayValueSeparator;
        this._arrayEmptySeparator = defaultPrettyPrinter._arrayEmptySeparator;
    }

    @Deprecated
    public DefaultPrettyPrinter withRootSeparator(SerializableString object) {
        if (this._rootSeparator == object || object != null && object.equals(this._rootSeparator)) {
            return this;
        }
        object = this._separators.withRootSeparator(object == null ? null : object.getValue());
        return new DefaultPrettyPrinter(this).withSeparators((Separators)object);
    }

    @Deprecated
    public DefaultPrettyPrinter withRootSeparator(String string) {
        return this.withRootSeparator(string == null ? null : new SerializedString(string));
    }

    public void indentArraysWith(DefaultPrettyPrinter$Indenter defaultPrettyPrinter$Indenter) {
        this._arrayIndenter = defaultPrettyPrinter$Indenter == null ? DefaultPrettyPrinter$NopIndenter.instance : defaultPrettyPrinter$Indenter;
    }

    public void indentObjectsWith(DefaultPrettyPrinter$Indenter defaultPrettyPrinter$Indenter) {
        this._objectIndenter = defaultPrettyPrinter$Indenter == null ? DefaultPrettyPrinter$NopIndenter.instance : defaultPrettyPrinter$Indenter;
    }

    public DefaultPrettyPrinter withArrayIndenter(DefaultPrettyPrinter$Indenter defaultPrettyPrinter$Indenter) {
        if (defaultPrettyPrinter$Indenter == null) {
            defaultPrettyPrinter$Indenter = DefaultPrettyPrinter$NopIndenter.instance;
        }
        if (this._arrayIndenter == defaultPrettyPrinter$Indenter) {
            return this;
        }
        DefaultPrettyPrinter defaultPrettyPrinter = new DefaultPrettyPrinter(this);
        new DefaultPrettyPrinter(this)._arrayIndenter = defaultPrettyPrinter$Indenter;
        return defaultPrettyPrinter;
    }

    public DefaultPrettyPrinter withObjectIndenter(DefaultPrettyPrinter$Indenter defaultPrettyPrinter$Indenter) {
        if (defaultPrettyPrinter$Indenter == null) {
            defaultPrettyPrinter$Indenter = DefaultPrettyPrinter$NopIndenter.instance;
        }
        if (this._objectIndenter == defaultPrettyPrinter$Indenter) {
            return this;
        }
        DefaultPrettyPrinter defaultPrettyPrinter = new DefaultPrettyPrinter(this);
        new DefaultPrettyPrinter(this)._objectIndenter = defaultPrettyPrinter$Indenter;
        return defaultPrettyPrinter;
    }

    @Deprecated
    public DefaultPrettyPrinter withSpacesInObjectEntries() {
        return this._withSpaces(true);
    }

    @Deprecated
    public DefaultPrettyPrinter withoutSpacesInObjectEntries() {
        return this._withSpaces(false);
    }

    protected DefaultPrettyPrinter _withSpaces(boolean bl2) {
        if (this._spacesInObjectEntries == bl2) {
            return this;
        }
        Serializable serializable = this._separators.withObjectFieldValueSpacing(bl2 ? Separators$Spacing.BOTH : Separators$Spacing.NONE);
        serializable = this.withSeparators((Separators)serializable);
        v0._spacesInObjectEntries = bl2;
        return serializable;
    }

    public DefaultPrettyPrinter withSeparators(Separators separators) {
        DefaultPrettyPrinter defaultPrettyPrinter = new DefaultPrettyPrinter(this);
        new DefaultPrettyPrinter(this)._separators = separators;
        defaultPrettyPrinter._rootSeparator = separators.getRootSeparator() == null ? null : new SerializedString(separators.getRootSeparator());
        defaultPrettyPrinter._objectFieldValueSeparatorWithSpaces = separators.getObjectFieldValueSpacing().apply(separators.getObjectFieldValueSeparator());
        defaultPrettyPrinter._objectEntrySeparator = separators.getObjectEntrySpacing().apply(separators.getObjectEntrySeparator());
        defaultPrettyPrinter._objectEmptySeparator = separators.getObjectEmptySeparator();
        defaultPrettyPrinter._arrayValueSeparator = separators.getArrayValueSpacing().apply(separators.getArrayValueSeparator());
        defaultPrettyPrinter._arrayEmptySeparator = separators.getArrayEmptySeparator();
        return defaultPrettyPrinter;
    }

    @Override
    public DefaultPrettyPrinter createInstance() {
        if (this.getClass() != DefaultPrettyPrinter.class) {
            throw new IllegalStateException("Failed `createInstance()`: " + this.getClass().getName() + " does not override method; it has to");
        }
        return new DefaultPrettyPrinter(this);
    }

    @Override
    public void writeRootValueSeparator(JsonGenerator jsonGenerator) throws IOException {
        if (this._rootSeparator != null) {
            jsonGenerator.writeRaw(this._rootSeparator);
        }
    }

    @Override
    public void writeStartObject(JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeRaw('{');
        if (!this._objectIndenter.isInline()) {
            ++this._nesting;
        }
    }

    @Override
    public void beforeObjectEntries(JsonGenerator jsonGenerator) throws IOException {
        this._objectIndenter.writeIndentation(jsonGenerator, this._nesting);
    }

    @Override
    public void writeObjectFieldValueSeparator(JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeRaw(this._objectFieldValueSeparatorWithSpaces);
    }

    @Override
    public void writeObjectEntrySeparator(JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeRaw(this._objectEntrySeparator);
        this._objectIndenter.writeIndentation(jsonGenerator, this._nesting);
    }

    @Override
    public void writeEndObject(JsonGenerator jsonGenerator, int n2) throws IOException {
        if (!this._objectIndenter.isInline()) {
            --this._nesting;
        }
        if (n2 > 0) {
            this._objectIndenter.writeIndentation(jsonGenerator, this._nesting);
        } else {
            jsonGenerator.writeRaw(this._objectEmptySeparator);
        }
        jsonGenerator.writeRaw('}');
    }

    @Override
    public void writeStartArray(JsonGenerator jsonGenerator) throws IOException {
        if (!this._arrayIndenter.isInline()) {
            ++this._nesting;
        }
        jsonGenerator.writeRaw('[');
    }

    @Override
    public void beforeArrayValues(JsonGenerator jsonGenerator) throws IOException {
        this._arrayIndenter.writeIndentation(jsonGenerator, this._nesting);
    }

    @Override
    public void writeArrayValueSeparator(JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeRaw(this._arrayValueSeparator);
        this._arrayIndenter.writeIndentation(jsonGenerator, this._nesting);
    }

    @Override
    public void writeEndArray(JsonGenerator jsonGenerator, int n2) throws IOException {
        if (!this._arrayIndenter.isInline()) {
            --this._nesting;
        }
        if (n2 > 0) {
            this._arrayIndenter.writeIndentation(jsonGenerator, this._nesting);
        } else {
            jsonGenerator.writeRaw(this._arrayEmptySeparator);
        }
        jsonGenerator.writeRaw(']');
    }
}

