/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.util;

import com.fasterxml.jackson.core.util.BufferRecycler;
import com.fasterxml.jackson.core.util.ThreadLocalBufferManager$ThreadLocalBufferManagerHolder;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

class ThreadLocalBufferManager {
    private final ReentrantLock RELEASE_LOCK = new ReentrantLock();
    private final Map<SoftReference<BufferRecycler>, Boolean> _trackedRecyclers = new ConcurrentHashMap<SoftReference<BufferRecycler>, Boolean>();
    private final ReferenceQueue<BufferRecycler> _refQueue = new ReferenceQueue();

    ThreadLocalBufferManager() {
    }

    public static ThreadLocalBufferManager instance() {
        return ThreadLocalBufferManager$ThreadLocalBufferManagerHolder.manager;
    }

    public int releaseBuffers() {
        int n2 = 0;
        this.RELEASE_LOCK.lock();
        try {
            this.removeSoftRefsClearedByGc();
            for (SoftReference<BufferRecycler> softReference : this._trackedRecyclers.keySet()) {
                softReference.clear();
                ++n2;
            }
            this._trackedRecyclers.clear();
        }
        finally {
            this.RELEASE_LOCK.unlock();
        }
        return n2;
    }

    public SoftReference<BufferRecycler> wrapAndTrack(BufferRecycler object) {
        object = new SoftReference<BufferRecycler>((BufferRecycler)object, this._refQueue);
        this._trackedRecyclers.put((SoftReference<BufferRecycler>)object, Boolean.TRUE);
        this.removeSoftRefsClearedByGc();
        return object;
    }

    private void removeSoftRefsClearedByGc() {
        SoftReference softReference;
        while ((softReference = (SoftReference)this._refQueue.poll()) != null) {
            this._trackedRecyclers.remove(softReference);
        }
    }
}

