/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude$Value;
import com.fasterxml.jackson.annotation.JsonSetter$Value;
import com.fasterxml.jackson.annotation.JsonTypeInfo$As;
import com.fasterxml.jackson.annotation.JsonTypeInfo$Id;
import com.fasterxml.jackson.annotation.JsonTypeInfo$Value;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonFactory$Feature;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonGenerator$Feature;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonParser$Feature;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.core.StreamWriteFeature;
import com.fasterxml.jackson.core.TokenStreamFactory;
import com.fasterxml.jackson.core.TreeCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.Versioned;
import com.fasterxml.jackson.core.exc.StreamReadException;
import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.core.io.SegmentedStringWriter;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.core.util.BufferRecycler;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.EnumNamingStrategy;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper$1;
import com.fasterxml.jackson.databind.ObjectMapper$2;
import com.fasterxml.jackson.databind.ObjectMapper$DefaultTypeResolverBuilder;
import com.fasterxml.jackson.databind.ObjectMapper$DefaultTyping;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.BaseSettings;
import com.fasterxml.jackson.databind.cfg.CacheProvider;
import com.fasterxml.jackson.databind.cfg.CoercionConfigs;
import com.fasterxml.jackson.databind.cfg.ConfigOverrides;
import com.fasterxml.jackson.databind.cfg.ConstructorDetector;
import com.fasterxml.jackson.databind.cfg.ContextAttributes;
import com.fasterxml.jackson.databind.cfg.DatatypeFeature;
import com.fasterxml.jackson.databind.cfg.DatatypeFeatures;
import com.fasterxml.jackson.databind.cfg.DefaultCacheProvider;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.cfg.MutableCoercionConfig;
import com.fasterxml.jackson.databind.cfg.MutableConfigOverride;
import com.fasterxml.jackson.databind.cfg.PackageVersion;
import com.fasterxml.jackson.databind.deser.BeanDeserializerFactory;
import com.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import com.fasterxml.jackson.databind.deser.DefaultDeserializationContext$Impl;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.fasterxml.jackson.databind.introspect.AccessorNamingStrategy$Provider;
import com.fasterxml.jackson.databind.introspect.BasicClassIntrospector;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector$MixInResolver;
import com.fasterxml.jackson.databind.introspect.DefaultAccessorNamingStrategy$Provider;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.introspect.SimpleMixInResolver;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.fasterxml.jackson.databind.introspect.VisibilityChecker$Std;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonschema.JsonSchema;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.SubtypeResolver;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import com.fasterxml.jackson.databind.jsontype.impl.StdSubtypeResolver;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.POJONode;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import com.fasterxml.jackson.databind.ser.BeanSerializerFactory;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider$Impl;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.RootNameLookup;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Type;
import java.net.URL;
import java.security.AccessController;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public class ObjectMapper
extends ObjectCodec
implements Versioned,
Serializable {
    private static final long serialVersionUID = 2L;
    protected static final AnnotationIntrospector DEFAULT_ANNOTATION_INTROSPECTOR = new JacksonAnnotationIntrospector();
    protected static final BaseSettings DEFAULT_BASE = new BaseSettings(null, DEFAULT_ANNOTATION_INTROSPECTOR, null, null, TypeFactory.defaultInstance(), null, StdDateFormat.instance, null, Locale.getDefault(), null, Base64Variants.getDefaultVariant(), LaissezFaireSubTypeValidator.instance, new DefaultAccessorNamingStrategy$Provider(), DefaultCacheProvider.defaultInstance());
    protected final JsonFactory _jsonFactory;
    protected TypeFactory _typeFactory;
    protected InjectableValues _injectableValues;
    protected SubtypeResolver _subtypeResolver;
    protected final ConfigOverrides _configOverrides;
    protected final CoercionConfigs _coercionConfigs;
    protected SimpleMixInResolver _mixIns;
    protected SerializationConfig _serializationConfig;
    protected DefaultSerializerProvider _serializerProvider;
    protected SerializerFactory _serializerFactory;
    protected DeserializationConfig _deserializationConfig;
    protected DefaultDeserializationContext _deserializationContext;
    protected Set<Object> _registeredModuleTypes;
    protected final ConcurrentHashMap<JavaType, JsonDeserializer<Object>> _rootDeserializers = new ConcurrentHashMap(64, 0.6f, 2);

    public ObjectMapper() {
        this(null, null, null);
    }

    public ObjectMapper(JsonFactory jsonFactory) {
        this(jsonFactory, null, null);
    }

    protected ObjectMapper(ObjectMapper objectMapper) {
        this(objectMapper, null);
    }

    protected ObjectMapper(ObjectMapper object, JsonFactory serializable) {
        this._jsonFactory = serializable != null ? serializable : ((ObjectMapper)object)._jsonFactory.copy();
        this._jsonFactory.setCodec(this);
        this._subtypeResolver = ((ObjectMapper)object)._subtypeResolver.copy();
        this._typeFactory = ((ObjectMapper)object)._typeFactory;
        this._injectableValues = ((ObjectMapper)object)._injectableValues;
        this._configOverrides = ((ObjectMapper)object)._configOverrides.copy();
        this._coercionConfigs = ((ObjectMapper)object)._coercionConfigs.copy();
        this._mixIns = ((ObjectMapper)object)._mixIns.copy();
        serializable = new RootNameLookup();
        this._serializationConfig = new SerializationConfig(((ObjectMapper)object)._serializationConfig, this._subtypeResolver, this._mixIns, (RootNameLookup)serializable, this._configOverrides);
        this._deserializationConfig = new DeserializationConfig(((ObjectMapper)object)._deserializationConfig, this._subtypeResolver, this._mixIns, (RootNameLookup)serializable, this._configOverrides, this._coercionConfigs);
        this._serializerProvider = ((ObjectMapper)object)._serializerProvider.copy();
        this._deserializationContext = ((ObjectMapper)object)._deserializationContext.copy();
        this._serializerFactory = ((ObjectMapper)object)._serializerFactory;
        object = ((ObjectMapper)object)._registeredModuleTypes;
        if (object == null) {
            this._registeredModuleTypes = null;
            return;
        }
        this._registeredModuleTypes = new LinkedHashSet<Object>((Collection<Object>)object);
    }

    public ObjectMapper(JsonFactory serializable, DefaultSerializerProvider defaultSerializerProvider, DefaultDeserializationContext defaultDeserializationContext) {
        SimpleMixInResolver simpleMixInResolver;
        if (serializable == null) {
            this._jsonFactory = new MappingJsonFactory(this);
        } else {
            this._jsonFactory = serializable;
            if (serializable.getCodec() == null) {
                this._jsonFactory.setCodec(this);
            }
        }
        this._subtypeResolver = new StdSubtypeResolver();
        serializable = new RootNameLookup();
        this._typeFactory = TypeFactory.defaultInstance();
        this._mixIns = simpleMixInResolver = new SimpleMixInResolver(null);
        BaseSettings baseSettings = DEFAULT_BASE.withClassIntrospector(this.defaultClassIntrospector());
        this._configOverrides = new ConfigOverrides();
        this._coercionConfigs = new CoercionConfigs();
        this._serializationConfig = new SerializationConfig(baseSettings, this._subtypeResolver, simpleMixInResolver, (RootNameLookup)serializable, this._configOverrides, DatatypeFeatures.defaultFeatures());
        this._deserializationConfig = new DeserializationConfig(baseSettings, this._subtypeResolver, simpleMixInResolver, (RootNameLookup)serializable, this._configOverrides, this._coercionConfigs, DatatypeFeatures.defaultFeatures());
        boolean bl2 = ((TokenStreamFactory)this._jsonFactory).requiresPropertyOrdering();
        if (bl2 ^ this._serializationConfig.isEnabled(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY)) {
            this.configure(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, bl2);
        }
        this._serializerProvider = defaultSerializerProvider == null ? new DefaultSerializerProvider$Impl() : defaultSerializerProvider;
        this._deserializationContext = defaultDeserializationContext == null ? new DefaultDeserializationContext$Impl(BeanDeserializerFactory.instance) : defaultDeserializationContext;
        this._serializerFactory = BeanSerializerFactory.instance;
    }

    protected ClassIntrospector defaultClassIntrospector() {
        return new BasicClassIntrospector();
    }

    public ObjectMapper copy() {
        this._checkInvalidCopy(ObjectMapper.class);
        return new ObjectMapper(this);
    }

    public ObjectMapper copyWith(JsonFactory jsonFactory) {
        this._checkInvalidCopy(ObjectMapper.class);
        return new ObjectMapper(this, jsonFactory);
    }

    protected void _checkInvalidCopy(Class<?> clazz) {
        if (this.getClass() != clazz) {
            throw new IllegalStateException("Failed copy()/copyWith(): " + this.getClass().getName() + " (version: " + ((ObjectCodec)this).version() + ") does not override copy()/copyWith(); it has to");
        }
    }

    protected ObjectReader _newReader(DeserializationConfig deserializationConfig) {
        return new ObjectReader(this, deserializationConfig);
    }

    protected ObjectReader _newReader(DeserializationConfig deserializationConfig, JavaType javaType, Object object, FormatSchema formatSchema, InjectableValues injectableValues) {
        return new ObjectReader(this, deserializationConfig, javaType, object, formatSchema, injectableValues);
    }

    protected ObjectWriter _newWriter(SerializationConfig serializationConfig) {
        return new ObjectWriter(this, serializationConfig);
    }

    protected ObjectWriter _newWriter(SerializationConfig serializationConfig, FormatSchema formatSchema) {
        return new ObjectWriter(this, serializationConfig, formatSchema);
    }

    protected ObjectWriter _newWriter(SerializationConfig serializationConfig, JavaType javaType, PrettyPrinter prettyPrinter) {
        return new ObjectWriter(this, serializationConfig, javaType, prettyPrinter);
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    public ObjectMapper registerModule(Module module) {
        this._assertNotNull("module", module);
        Object object = module.getModuleName();
        if (object == null) {
            throw new IllegalArgumentException("Module without defined name");
        }
        object = module.version();
        if (object == null) {
            throw new IllegalArgumentException("Module without defined version");
        }
        object = module.getDependencies().iterator();
        while (object.hasNext()) {
            Module module2 = object.next();
            this.registerModule(module2);
        }
        if (this.isEnabled(MapperFeature.IGNORE_DUPLICATE_MODULE_REGISTRATIONS) && (object = module.getTypeId()) != null) {
            if (this._registeredModuleTypes == null) {
                this._registeredModuleTypes = new LinkedHashSet<Object>();
            }
            if (!this._registeredModuleTypes.add(object)) {
                return this;
            }
        }
        module.setupModule(new ObjectMapper$1(this));
        return this;
    }

    public ObjectMapper registerModules(Module ... moduleArray) {
        for (Module module : moduleArray) {
            this.registerModule(module);
        }
        return this;
    }

    public ObjectMapper registerModules(Iterable<? extends Module> object) {
        this._assertNotNull("modules", object);
        object = object.iterator();
        while (object.hasNext()) {
            Module module = (Module)object.next();
            this.registerModule(module);
        }
        return this;
    }

    public Set<Object> getRegisteredModuleIds() {
        if (this._registeredModuleTypes == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this._registeredModuleTypes);
    }

    public static List<Module> findModules() {
        return ObjectMapper.findModules(null);
    }

    public static List<Module> findModules(ClassLoader iterator) {
        ArrayList<Module> arrayList = new ArrayList<Module>();
        iterator = ObjectMapper.secureGetServiceLoader(Module.class, (ClassLoader)((Object)iterator));
        iterator = ((ServiceLoader)((Object)iterator)).iterator();
        while (iterator.hasNext()) {
            Module module = iterator.next();
            arrayList.add(module);
        }
        return arrayList;
    }

    private static <T> ServiceLoader<T> secureGetServiceLoader(Class<T> clazz, ClassLoader classLoader) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            if (classLoader == null) {
                return ServiceLoader.load(clazz);
            }
            return ServiceLoader.load(clazz, classLoader);
        }
        return (ServiceLoader)AccessController.doPrivileged(new ObjectMapper$2(classLoader, clazz));
    }

    public ObjectMapper findAndRegisterModules() {
        return this.registerModules(ObjectMapper.findModules());
    }

    public JsonGenerator createGenerator(OutputStream closeable) throws IOException {
        this._assertNotNull("out", closeable);
        closeable = ((TokenStreamFactory)this._jsonFactory).createGenerator((OutputStream)closeable, JsonEncoding.UTF8);
        this._serializationConfig.initialize((JsonGenerator)closeable);
        return closeable;
    }

    public JsonGenerator createGenerator(OutputStream closeable, JsonEncoding jsonEncoding) throws IOException {
        this._assertNotNull("out", closeable);
        closeable = ((TokenStreamFactory)this._jsonFactory).createGenerator((OutputStream)closeable, jsonEncoding);
        this._serializationConfig.initialize((JsonGenerator)closeable);
        return closeable;
    }

    public JsonGenerator createGenerator(Writer closeable) throws IOException {
        this._assertNotNull("w", closeable);
        closeable = ((TokenStreamFactory)this._jsonFactory).createGenerator((Writer)closeable);
        this._serializationConfig.initialize((JsonGenerator)closeable);
        return closeable;
    }

    public JsonGenerator createGenerator(File object, JsonEncoding jsonEncoding) throws IOException {
        this._assertNotNull("outputFile", object);
        object = ((TokenStreamFactory)this._jsonFactory).createGenerator((File)object, jsonEncoding);
        this._serializationConfig.initialize((JsonGenerator)object);
        return object;
    }

    public JsonGenerator createGenerator(DataOutput object) throws IOException {
        this._assertNotNull("out", object);
        object = ((TokenStreamFactory)this._jsonFactory).createGenerator((DataOutput)object);
        this._serializationConfig.initialize((JsonGenerator)object);
        return object;
    }

    public JsonParser createParser(File file) throws IOException {
        this._assertNotNull("src", file);
        return this._deserializationConfig.initialize(((TokenStreamFactory)this._jsonFactory).createParser(file));
    }

    public JsonParser createParser(URL uRL) throws IOException {
        this._assertNotNull("src", uRL);
        return this._deserializationConfig.initialize(((TokenStreamFactory)this._jsonFactory).createParser(uRL));
    }

    public JsonParser createParser(InputStream inputStream) throws IOException {
        this._assertNotNull("in", inputStream);
        return this._deserializationConfig.initialize(((TokenStreamFactory)this._jsonFactory).createParser(inputStream));
    }

    public JsonParser createParser(Reader reader) throws IOException {
        this._assertNotNull("r", reader);
        return this._deserializationConfig.initialize(((TokenStreamFactory)this._jsonFactory).createParser(reader));
    }

    public JsonParser createParser(byte[] byArray) throws IOException {
        this._assertNotNull("content", byArray);
        return this._deserializationConfig.initialize(((TokenStreamFactory)this._jsonFactory).createParser(byArray));
    }

    public JsonParser createParser(byte[] byArray, int n2, int n3) throws IOException {
        this._assertNotNull("content", byArray);
        return this._deserializationConfig.initialize(((TokenStreamFactory)this._jsonFactory).createParser(byArray, n2, n3));
    }

    public JsonParser createParser(String string) throws IOException {
        this._assertNotNull("content", string);
        return this._deserializationConfig.initialize(((TokenStreamFactory)this._jsonFactory).createParser(string));
    }

    public JsonParser createParser(char[] cArray) throws IOException {
        this._assertNotNull("content", cArray);
        return this._deserializationConfig.initialize(((TokenStreamFactory)this._jsonFactory).createParser(cArray));
    }

    public JsonParser createParser(char[] cArray, int n2, int n3) throws IOException {
        this._assertNotNull("content", cArray);
        return this._deserializationConfig.initialize(((TokenStreamFactory)this._jsonFactory).createParser(cArray, n2, n3));
    }

    public JsonParser createParser(DataInput dataInput) throws IOException {
        this._assertNotNull("content", dataInput);
        return this._deserializationConfig.initialize(((TokenStreamFactory)this._jsonFactory).createParser(dataInput));
    }

    public JsonParser createNonBlockingByteArrayParser() throws IOException {
        return this._deserializationConfig.initialize(((TokenStreamFactory)this._jsonFactory).createNonBlockingByteArrayParser());
    }

    public SerializationConfig getSerializationConfig() {
        return this._serializationConfig;
    }

    public DeserializationConfig getDeserializationConfig() {
        return this._deserializationConfig;
    }

    public DeserializationContext getDeserializationContext() {
        return this._deserializationContext;
    }

    public ObjectMapper setSerializerFactory(SerializerFactory serializerFactory) {
        this._serializerFactory = serializerFactory;
        return this;
    }

    public SerializerFactory getSerializerFactory() {
        return this._serializerFactory;
    }

    public ObjectMapper setSerializerProvider(DefaultSerializerProvider defaultSerializerProvider) {
        this._serializerProvider = defaultSerializerProvider;
        return this;
    }

    public SerializerProvider getSerializerProvider() {
        return this._serializerProvider;
    }

    public SerializerProvider getSerializerProviderInstance() {
        ObjectMapper objectMapper = this;
        return objectMapper._serializerProvider(objectMapper._serializationConfig);
    }

    public ObjectMapper setMixIns(Map<Class<?>, Class<?>> map) {
        this._mixIns.setLocalDefinitions(map);
        return this;
    }

    public ObjectMapper addMixIn(Class<?> clazz, Class<?> clazz2) {
        this._mixIns.addLocalDefinition(clazz, clazz2);
        return this;
    }

    public ObjectMapper setMixInResolver(ClassIntrospector$MixInResolver classIntrospector$MixInResolver) {
        if ((classIntrospector$MixInResolver = this._mixIns.withOverrides(classIntrospector$MixInResolver)) != this._mixIns) {
            this._mixIns = classIntrospector$MixInResolver;
            this._deserializationConfig = new DeserializationConfig(this._deserializationConfig, (SimpleMixInResolver)classIntrospector$MixInResolver);
            this._serializationConfig = new SerializationConfig(this._serializationConfig, (SimpleMixInResolver)classIntrospector$MixInResolver);
        }
        return this;
    }

    public Class<?> findMixInClassFor(Class<?> clazz) {
        return this._mixIns.findMixInClassFor(clazz);
    }

    public int mixInCount() {
        return this._mixIns.localSize();
    }

    @Deprecated
    public void setMixInAnnotations(Map<Class<?>, Class<?>> map) {
        this.setMixIns(map);
    }

    @Deprecated
    public final void addMixInAnnotations(Class<?> clazz, Class<?> clazz2) {
        this.addMixIn(clazz, clazz2);
    }

    public VisibilityChecker<?> getVisibilityChecker() {
        return ((MapperConfig)this._serializationConfig).getDefaultVisibilityChecker();
    }

    public ObjectMapper setVisibility(VisibilityChecker<?> visibilityChecker) {
        this._configOverrides.setDefaultVisibility(visibilityChecker);
        return this;
    }

    public ObjectMapper setVisibility(PropertyAccessor propertyAccessor, JsonAutoDetect.Visibility visibility) {
        VisibilityChecker<?> visibilityChecker = this._configOverrides.getDefaultVisibility();
        visibilityChecker = visibilityChecker.withVisibility(propertyAccessor, visibility);
        this._configOverrides.setDefaultVisibility(visibilityChecker);
        return this;
    }

    public SubtypeResolver getSubtypeResolver() {
        return this._subtypeResolver;
    }

    public ObjectMapper setSubtypeResolver(SubtypeResolver subtypeResolver) {
        this._subtypeResolver = subtypeResolver;
        this._deserializationConfig = this._deserializationConfig.with(subtypeResolver);
        this._serializationConfig = this._serializationConfig.with(subtypeResolver);
        return this;
    }

    public ObjectMapper setAnnotationIntrospector(AnnotationIntrospector annotationIntrospector) {
        this._serializationConfig = (SerializationConfig)this._serializationConfig.with(annotationIntrospector);
        this._deserializationConfig = (DeserializationConfig)this._deserializationConfig.with(annotationIntrospector);
        return this;
    }

    public ObjectMapper setAnnotationIntrospectors(AnnotationIntrospector annotationIntrospector, AnnotationIntrospector annotationIntrospector2) {
        this._serializationConfig = (SerializationConfig)this._serializationConfig.with(annotationIntrospector);
        this._deserializationConfig = (DeserializationConfig)this._deserializationConfig.with(annotationIntrospector2);
        return this;
    }

    public ObjectMapper setPropertyNamingStrategy(PropertyNamingStrategy propertyNamingStrategy) {
        this._serializationConfig = (SerializationConfig)this._serializationConfig.with(propertyNamingStrategy);
        this._deserializationConfig = (DeserializationConfig)this._deserializationConfig.with(propertyNamingStrategy);
        return this;
    }

    public PropertyNamingStrategy getPropertyNamingStrategy() {
        return this._serializationConfig.getPropertyNamingStrategy();
    }

    public ObjectMapper setEnumNamingStrategy(EnumNamingStrategy enumNamingStrategy) {
        this._serializationConfig = (SerializationConfig)this._serializationConfig.with(enumNamingStrategy);
        this._deserializationConfig = (DeserializationConfig)this._deserializationConfig.with(enumNamingStrategy);
        return this;
    }

    public EnumNamingStrategy getEnumNamingStrategy() {
        return this._serializationConfig.getEnumNamingStrategy();
    }

    public ObjectMapper setAccessorNaming(AccessorNamingStrategy$Provider accessorNamingStrategy$Provider) {
        this._serializationConfig = (SerializationConfig)this._serializationConfig.with(accessorNamingStrategy$Provider);
        this._deserializationConfig = (DeserializationConfig)this._deserializationConfig.with(accessorNamingStrategy$Provider);
        return this;
    }

    public ObjectMapper setDefaultPrettyPrinter(PrettyPrinter prettyPrinter) {
        this._serializationConfig = this._serializationConfig.withDefaultPrettyPrinter(prettyPrinter);
        return this;
    }

    @Deprecated
    public void setVisibilityChecker(VisibilityChecker<?> visibilityChecker) {
        this.setVisibility(visibilityChecker);
    }

    public ObjectMapper setPolymorphicTypeValidator(PolymorphicTypeValidator serializable) {
        serializable = this._deserializationConfig.getBaseSettings().with((PolymorphicTypeValidator)serializable);
        this._deserializationConfig = this._deserializationConfig._withBase((BaseSettings)serializable);
        return this;
    }

    public PolymorphicTypeValidator getPolymorphicTypeValidator() {
        return this._deserializationConfig.getBaseSettings().getPolymorphicTypeValidator();
    }

    public ObjectMapper setSerializationInclusion(JsonInclude.Include include) {
        JsonInclude.Include include2 = include;
        this.setPropertyInclusion(JsonInclude$Value.construct(include2, include2));
        return this;
    }

    @Deprecated
    public ObjectMapper setPropertyInclusion(JsonInclude$Value jsonInclude$Value) {
        return this.setDefaultPropertyInclusion(jsonInclude$Value);
    }

    public ObjectMapper setDefaultPropertyInclusion(JsonInclude$Value jsonInclude$Value) {
        this._configOverrides.setDefaultInclusion(jsonInclude$Value);
        return this;
    }

    public ObjectMapper setDefaultPropertyInclusion(JsonInclude.Include include) {
        JsonInclude.Include include2 = include;
        this._configOverrides.setDefaultInclusion(JsonInclude$Value.construct(include2, include2));
        return this;
    }

    public ObjectMapper setDefaultSetterInfo(JsonSetter$Value jsonSetter$Value) {
        this._configOverrides.setDefaultSetterInfo(jsonSetter$Value);
        return this;
    }

    public ObjectMapper setDefaultVisibility(JsonAutoDetect.Value value) {
        this._configOverrides.setDefaultVisibility(VisibilityChecker$Std.construct(value));
        return this;
    }

    public ObjectMapper setDefaultMergeable(Boolean bl2) {
        this._configOverrides.setDefaultMergeable(bl2);
        return this;
    }

    public ObjectMapper setDefaultLeniency(Boolean bl2) {
        this._configOverrides.setDefaultLeniency(bl2);
        return this;
    }

    public void registerSubtypes(Class<?> ... classArray) {
        this.getSubtypeResolver().registerSubtypes(classArray);
    }

    public void registerSubtypes(NamedType ... namedTypeArray) {
        this.getSubtypeResolver().registerSubtypes(namedTypeArray);
    }

    public void registerSubtypes(Collection<Class<?>> collection) {
        this.getSubtypeResolver().registerSubtypes(collection);
    }

    public ObjectMapper activateDefaultTyping(PolymorphicTypeValidator polymorphicTypeValidator) {
        return this.activateDefaultTyping(polymorphicTypeValidator, ObjectMapper$DefaultTyping.OBJECT_AND_NON_CONCRETE);
    }

    public ObjectMapper activateDefaultTyping(PolymorphicTypeValidator polymorphicTypeValidator, ObjectMapper$DefaultTyping objectMapper$DefaultTyping) {
        return this.activateDefaultTyping(polymorphicTypeValidator, objectMapper$DefaultTyping, JsonTypeInfo$As.WRAPPER_ARRAY);
    }

    public ObjectMapper activateDefaultTyping(PolymorphicTypeValidator object, ObjectMapper$DefaultTyping object2, JsonTypeInfo$As jsonTypeInfo$As) {
        if (jsonTypeInfo$As == JsonTypeInfo$As.EXTERNAL_PROPERTY) {
            throw new IllegalArgumentException("Cannot use includeAs of " + (Object)((Object)jsonTypeInfo$As));
        }
        object = this._constructDefaultTypeResolverBuilder((ObjectMapper$DefaultTyping)((Object)object2), (PolymorphicTypeValidator)object);
        object2 = JsonTypeInfo$Value.construct(JsonTypeInfo$Id.CLASS, jsonTypeInfo$As, null, null, false, null);
        object = object.withSettings((JsonTypeInfo$Value)object2);
        return this.setDefaultTyping((TypeResolverBuilder<?>)object);
    }

    public ObjectMapper activateDefaultTypingAsProperty(PolymorphicTypeValidator object, ObjectMapper$DefaultTyping object2, String string) {
        object = this._constructDefaultTypeResolverBuilder((ObjectMapper$DefaultTyping)((Object)object2), (PolymorphicTypeValidator)object);
        object2 = JsonTypeInfo$Value.construct(JsonTypeInfo$Id.CLASS, JsonTypeInfo$As.PROPERTY, string, null, false, null);
        object = object.withSettings((JsonTypeInfo$Value)object2);
        return this.setDefaultTyping((TypeResolverBuilder<?>)object);
    }

    public ObjectMapper deactivateDefaultTyping() {
        return this.setDefaultTyping(null);
    }

    public ObjectMapper setDefaultTyping(TypeResolverBuilder<?> typeResolverBuilder) {
        this._deserializationConfig = (DeserializationConfig)this._deserializationConfig.with(typeResolverBuilder);
        this._serializationConfig = (SerializationConfig)this._serializationConfig.with(typeResolverBuilder);
        return this;
    }

    @Deprecated
    public ObjectMapper enableDefaultTyping() {
        ObjectMapper objectMapper = this;
        return objectMapper.activateDefaultTyping(objectMapper.getPolymorphicTypeValidator());
    }

    @Deprecated
    public ObjectMapper enableDefaultTyping(ObjectMapper$DefaultTyping objectMapper$DefaultTyping) {
        return this.enableDefaultTyping(objectMapper$DefaultTyping, JsonTypeInfo$As.WRAPPER_ARRAY);
    }

    @Deprecated
    public ObjectMapper enableDefaultTyping(ObjectMapper$DefaultTyping objectMapper$DefaultTyping, JsonTypeInfo$As jsonTypeInfo$As) {
        ObjectMapper objectMapper = this;
        return objectMapper.activateDefaultTyping(objectMapper.getPolymorphicTypeValidator(), objectMapper$DefaultTyping, jsonTypeInfo$As);
    }

    @Deprecated
    public ObjectMapper enableDefaultTypingAsProperty(ObjectMapper$DefaultTyping objectMapper$DefaultTyping, String string) {
        ObjectMapper objectMapper = this;
        return objectMapper.activateDefaultTypingAsProperty(objectMapper.getPolymorphicTypeValidator(), objectMapper$DefaultTyping, string);
    }

    @Deprecated
    public ObjectMapper disableDefaultTyping() {
        return this.setDefaultTyping(null);
    }

    public MutableConfigOverride configOverride(Class<?> clazz) {
        return this._configOverrides.findOrCreateOverride(clazz);
    }

    public MutableCoercionConfig coercionConfigDefaults() {
        return this._coercionConfigs.defaultCoercions();
    }

    public MutableCoercionConfig coercionConfigFor(LogicalType logicalType) {
        return this._coercionConfigs.findOrCreateCoercion(logicalType);
    }

    public MutableCoercionConfig coercionConfigFor(Class<?> clazz) {
        return this._coercionConfigs.findOrCreateCoercion(clazz);
    }

    public TypeFactory getTypeFactory() {
        return this._typeFactory;
    }

    public ObjectMapper setTypeFactory(TypeFactory typeFactory) {
        this._typeFactory = typeFactory;
        this._deserializationConfig = (DeserializationConfig)this._deserializationConfig.with(typeFactory);
        this._serializationConfig = (SerializationConfig)this._serializationConfig.with(typeFactory);
        return this;
    }

    public JavaType constructType(Type type) {
        this._assertNotNull("t", type);
        return this._typeFactory.constructType(type);
    }

    public JavaType constructType(TypeReference<?> typeReference) {
        this._assertNotNull("typeRef", typeReference);
        return this._typeFactory.constructType(typeReference);
    }

    public JsonNodeFactory getNodeFactory() {
        return this._deserializationConfig.getNodeFactory();
    }

    public ObjectMapper setNodeFactory(JsonNodeFactory jsonNodeFactory) {
        this._deserializationConfig = this._deserializationConfig.with(jsonNodeFactory);
        return this;
    }

    public ObjectMapper setConstructorDetector(ConstructorDetector constructorDetector) {
        this._deserializationConfig = this._deserializationConfig.with(constructorDetector);
        this._serializationConfig = this._serializationConfig.with(constructorDetector);
        return this;
    }

    public ObjectMapper setCacheProvider(CacheProvider cacheProvider) {
        this._assertNotNull("cacheProvider", cacheProvider);
        this._deserializationConfig = (DeserializationConfig)this._deserializationConfig.with(cacheProvider);
        this._serializationConfig = (SerializationConfig)this._serializationConfig.with(cacheProvider);
        this._deserializationContext = this._deserializationContext.withCaches(cacheProvider);
        this._serializerProvider = this._serializerProvider.withCaches(cacheProvider);
        this._typeFactory = this._typeFactory.withCache(cacheProvider.forTypeFactory());
        return this;
    }

    public ObjectMapper addHandler(DeserializationProblemHandler deserializationProblemHandler) {
        this._deserializationConfig = this._deserializationConfig.withHandler(deserializationProblemHandler);
        return this;
    }

    public ObjectMapper clearProblemHandlers() {
        this._deserializationConfig = this._deserializationConfig.withNoProblemHandlers();
        return this;
    }

    public ObjectMapper setConfig(DeserializationConfig deserializationConfig) {
        this._assertNotNull("config", deserializationConfig);
        this._deserializationConfig = deserializationConfig;
        return this;
    }

    @Deprecated
    public void setFilters(FilterProvider filterProvider) {
        this._serializationConfig = this._serializationConfig.withFilters(filterProvider);
    }

    public ObjectMapper setFilterProvider(FilterProvider filterProvider) {
        this._serializationConfig = this._serializationConfig.withFilters(filterProvider);
        return this;
    }

    public ObjectMapper setBase64Variant(Base64Variant base64Variant) {
        this._serializationConfig = (SerializationConfig)this._serializationConfig.with(base64Variant);
        this._deserializationConfig = (DeserializationConfig)this._deserializationConfig.with(base64Variant);
        return this;
    }

    public ObjectMapper setConfig(SerializationConfig serializationConfig) {
        this._assertNotNull("config", serializationConfig);
        this._serializationConfig = serializationConfig;
        return this;
    }

    public JsonFactory tokenStreamFactory() {
        return this._jsonFactory;
    }

    @Override
    public JsonFactory getFactory() {
        return this._jsonFactory;
    }

    public ObjectMapper setDateFormat(DateFormat dateFormat) {
        this._deserializationConfig = (DeserializationConfig)this._deserializationConfig.with(dateFormat);
        this._serializationConfig = this._serializationConfig.with(dateFormat);
        return this;
    }

    public DateFormat getDateFormat() {
        return this._serializationConfig.getDateFormat();
    }

    public Object setHandlerInstantiator(HandlerInstantiator handlerInstantiator) {
        this._deserializationConfig = (DeserializationConfig)this._deserializationConfig.with(handlerInstantiator);
        this._serializationConfig = (SerializationConfig)this._serializationConfig.with(handlerInstantiator);
        return this;
    }

    public ObjectMapper setInjectableValues(InjectableValues injectableValues) {
        this._injectableValues = injectableValues;
        return this;
    }

    public InjectableValues getInjectableValues() {
        return this._injectableValues;
    }

    public ObjectMapper setLocale(Locale locale) {
        this._deserializationConfig = (DeserializationConfig)this._deserializationConfig.with(locale);
        this._serializationConfig = (SerializationConfig)this._serializationConfig.with(locale);
        return this;
    }

    public ObjectMapper setTimeZone(TimeZone timeZone) {
        this._deserializationConfig = (DeserializationConfig)this._deserializationConfig.with(timeZone);
        this._serializationConfig = (SerializationConfig)this._serializationConfig.with(timeZone);
        return this;
    }

    public ObjectMapper setDefaultAttributes(ContextAttributes contextAttributes) {
        this._deserializationConfig = this._deserializationConfig.with(contextAttributes);
        this._serializationConfig = this._serializationConfig.with(contextAttributes);
        return this;
    }

    public boolean isEnabled(MapperFeature mapperFeature) {
        return this._serializationConfig.isEnabled(mapperFeature);
    }

    @Deprecated
    public ObjectMapper configure(MapperFeature mapperFeature, boolean bl2) {
        this._serializationConfig = bl2 ? (SerializationConfig)this._serializationConfig.with(new MapperFeature[]{mapperFeature}) : (SerializationConfig)this._serializationConfig.without(new MapperFeature[]{mapperFeature});
        this._deserializationConfig = bl2 ? (DeserializationConfig)this._deserializationConfig.with(new MapperFeature[]{mapperFeature}) : (DeserializationConfig)this._deserializationConfig.without(new MapperFeature[]{mapperFeature});
        return this;
    }

    @Deprecated
    public ObjectMapper enable(MapperFeature ... mapperFeatureArray) {
        this._deserializationConfig = (DeserializationConfig)this._deserializationConfig.with(mapperFeatureArray);
        this._serializationConfig = (SerializationConfig)this._serializationConfig.with(mapperFeatureArray);
        return this;
    }

    @Deprecated
    public ObjectMapper disable(MapperFeature ... mapperFeatureArray) {
        this._deserializationConfig = (DeserializationConfig)this._deserializationConfig.without(mapperFeatureArray);
        this._serializationConfig = (SerializationConfig)this._serializationConfig.without(mapperFeatureArray);
        return this;
    }

    public boolean isEnabled(SerializationFeature serializationFeature) {
        return this._serializationConfig.isEnabled(serializationFeature);
    }

    public ObjectMapper configure(SerializationFeature serializationFeature, boolean bl2) {
        this._serializationConfig = bl2 ? this._serializationConfig.with(serializationFeature) : this._serializationConfig.without(serializationFeature);
        return this;
    }

    public ObjectMapper enable(SerializationFeature serializationFeature) {
        this._serializationConfig = this._serializationConfig.with(serializationFeature);
        return this;
    }

    public ObjectMapper enable(SerializationFeature serializationFeature, SerializationFeature ... serializationFeatureArray) {
        this._serializationConfig = this._serializationConfig.with(serializationFeature, serializationFeatureArray);
        return this;
    }

    public ObjectMapper disable(SerializationFeature serializationFeature) {
        this._serializationConfig = this._serializationConfig.without(serializationFeature);
        return this;
    }

    public ObjectMapper disable(SerializationFeature serializationFeature, SerializationFeature ... serializationFeatureArray) {
        this._serializationConfig = this._serializationConfig.without(serializationFeature, serializationFeatureArray);
        return this;
    }

    public boolean isEnabled(DeserializationFeature deserializationFeature) {
        return this._deserializationConfig.isEnabled(deserializationFeature);
    }

    public ObjectMapper configure(DeserializationFeature deserializationFeature, boolean bl2) {
        this._deserializationConfig = bl2 ? this._deserializationConfig.with(deserializationFeature) : this._deserializationConfig.without(deserializationFeature);
        return this;
    }

    public ObjectMapper enable(DeserializationFeature deserializationFeature) {
        this._deserializationConfig = this._deserializationConfig.with(deserializationFeature);
        return this;
    }

    public ObjectMapper enable(DeserializationFeature deserializationFeature, DeserializationFeature ... deserializationFeatureArray) {
        this._deserializationConfig = this._deserializationConfig.with(deserializationFeature, deserializationFeatureArray);
        return this;
    }

    public ObjectMapper disable(DeserializationFeature deserializationFeature) {
        this._deserializationConfig = this._deserializationConfig.without(deserializationFeature);
        return this;
    }

    public ObjectMapper disable(DeserializationFeature deserializationFeature, DeserializationFeature ... deserializationFeatureArray) {
        this._deserializationConfig = this._deserializationConfig.without(deserializationFeature, deserializationFeatureArray);
        return this;
    }

    public ObjectMapper configure(DatatypeFeature datatypeFeature, boolean bl2) {
        if (bl2) {
            this._deserializationConfig = (DeserializationConfig)this._deserializationConfig.with(datatypeFeature);
            this._serializationConfig = (SerializationConfig)this._serializationConfig.with(datatypeFeature);
        } else {
            this._deserializationConfig = (DeserializationConfig)this._deserializationConfig.without(datatypeFeature);
            this._serializationConfig = (SerializationConfig)this._serializationConfig.without(datatypeFeature);
        }
        return this;
    }

    public boolean isEnabled(JsonParser$Feature jsonParser$Feature) {
        return this._deserializationConfig.isEnabled(jsonParser$Feature, this._jsonFactory);
    }

    public ObjectMapper configure(JsonParser$Feature jsonParser$Feature, boolean bl2) {
        this._jsonFactory.configure(jsonParser$Feature, bl2);
        return this;
    }

    public ObjectMapper enable(JsonParser$Feature ... jsonParser$FeatureArray) {
        for (JsonParser$Feature jsonParser$Feature : jsonParser$FeatureArray) {
            this._jsonFactory.enable(jsonParser$Feature);
        }
        return this;
    }

    public ObjectMapper disable(JsonParser$Feature ... jsonParser$FeatureArray) {
        for (JsonParser$Feature jsonParser$Feature : jsonParser$FeatureArray) {
            this._jsonFactory.disable(jsonParser$Feature);
        }
        return this;
    }

    public boolean isEnabled(JsonGenerator$Feature jsonGenerator$Feature) {
        return this._serializationConfig.isEnabled(jsonGenerator$Feature, this._jsonFactory);
    }

    public ObjectMapper configure(JsonGenerator$Feature jsonGenerator$Feature, boolean bl2) {
        this._jsonFactory.configure(jsonGenerator$Feature, bl2);
        return this;
    }

    public ObjectMapper enable(JsonGenerator$Feature ... jsonGenerator$FeatureArray) {
        for (JsonGenerator$Feature jsonGenerator$Feature : jsonGenerator$FeatureArray) {
            this._jsonFactory.enable(jsonGenerator$Feature);
        }
        return this;
    }

    public ObjectMapper disable(JsonGenerator$Feature ... jsonGenerator$FeatureArray) {
        for (JsonGenerator$Feature jsonGenerator$Feature : jsonGenerator$FeatureArray) {
            this._jsonFactory.disable(jsonGenerator$Feature);
        }
        return this;
    }

    public boolean isEnabled(JsonFactory$Feature jsonFactory$Feature) {
        return ((TokenStreamFactory)this._jsonFactory).isEnabled(jsonFactory$Feature);
    }

    public boolean isEnabled(StreamReadFeature streamReadFeature) {
        return this.isEnabled(streamReadFeature.mappedFeature());
    }

    public boolean isEnabled(StreamWriteFeature streamWriteFeature) {
        return this.isEnabled(streamWriteFeature.mappedFeature());
    }

    @Override
    public <T> T readValue(JsonParser jsonParser, Class<T> clazz) throws IOException, StreamReadException, DatabindException {
        this._assertNotNull("p", jsonParser);
        ObjectMapper objectMapper = this;
        return (T)objectMapper._readValue(objectMapper.getDeserializationConfig(), jsonParser, this._typeFactory.constructType(clazz));
    }

    @Override
    public <T> T readValue(JsonParser jsonParser, TypeReference<T> typeReference) throws IOException, StreamReadException, DatabindException {
        this._assertNotNull("p", jsonParser);
        ObjectMapper objectMapper = this;
        return (T)objectMapper._readValue(objectMapper.getDeserializationConfig(), jsonParser, this._typeFactory.constructType(typeReference));
    }

    @Override
    public final <T> T readValue(JsonParser jsonParser, ResolvedType resolvedType) throws IOException, StreamReadException, DatabindException {
        this._assertNotNull("p", jsonParser);
        ObjectMapper objectMapper = this;
        return (T)objectMapper._readValue(objectMapper.getDeserializationConfig(), jsonParser, (JavaType)resolvedType);
    }

    public <T> T readValue(JsonParser jsonParser, JavaType javaType) throws IOException, StreamReadException, DatabindException {
        this._assertNotNull("p", jsonParser);
        ObjectMapper objectMapper = this;
        return (T)objectMapper._readValue(objectMapper.getDeserializationConfig(), jsonParser, javaType);
    }

    @Override
    public <T extends TreeNode> T readTree(JsonParser object) throws IOException {
        this._assertNotNull("p", object);
        DeserializationConfig deserializationConfig = this.getDeserializationConfig();
        JsonToken jsonToken = ((JsonParser)object).currentToken();
        if (jsonToken == null && (jsonToken = ((JsonParser)object).nextToken()) == null) {
            return null;
        }
        if ((object = (JsonNode)this._readValue(deserializationConfig, (JsonParser)object, this.constructType((Type)((Object)JsonNode.class)))) == null) {
            object = this.getNodeFactory().nullNode();
        }
        return (T)object;
    }

    public <T> MappingIterator<T> readValues(JsonParser jsonParser, ResolvedType resolvedType) throws IOException {
        return this.readValues(jsonParser, (JavaType)resolvedType);
    }

    public <T> MappingIterator<T> readValues(JsonParser jsonParser, JavaType javaType) throws IOException {
        this._assertNotNull("p", jsonParser);
        Serializable serializable = this.getDeserializationConfig();
        serializable = this.createDeserializationContext(jsonParser, (DeserializationConfig)serializable);
        JsonDeserializer<Object> jsonDeserializer = this._findRootDeserializer((DeserializationContext)serializable, javaType);
        return new MappingIterator(javaType, jsonParser, (DeserializationContext)serializable, jsonDeserializer, false, null);
    }

    public <T> MappingIterator<T> readValues(JsonParser jsonParser, Class<T> clazz) throws IOException {
        return this.readValues(jsonParser, this._typeFactory.constructType(clazz));
    }

    public <T> MappingIterator<T> readValues(JsonParser jsonParser, TypeReference<T> typeReference) throws IOException {
        return this.readValues(jsonParser, this._typeFactory.constructType(typeReference));
    }

    public JsonNode readTree(InputStream inputStream) throws IOException {
        this._assertNotNull("in", inputStream);
        ObjectMapper objectMapper = this;
        return objectMapper._readTreeAndClose(((TokenStreamFactory)objectMapper._jsonFactory).createParser(inputStream));
    }

    public JsonNode readTree(Reader reader) throws IOException {
        this._assertNotNull("r", reader);
        ObjectMapper objectMapper = this;
        return objectMapper._readTreeAndClose(((TokenStreamFactory)objectMapper._jsonFactory).createParser(reader));
    }

    public JsonNode readTree(String object) throws JsonProcessingException, JsonMappingException {
        this._assertNotNull("content", object);
        try {
            ObjectMapper objectMapper = this;
            return objectMapper._readTreeAndClose(((TokenStreamFactory)objectMapper._jsonFactory).createParser((String)object));
        }
        catch (JsonProcessingException jsonProcessingException) {
            object = jsonProcessingException;
            throw jsonProcessingException;
        }
        catch (IOException iOException) {
            object = iOException;
            throw JsonMappingException.fromUnexpectedIOE(iOException);
        }
    }

    public JsonNode readTree(byte[] byArray) throws IOException {
        this._assertNotNull("content", byArray);
        ObjectMapper objectMapper = this;
        return objectMapper._readTreeAndClose(((TokenStreamFactory)objectMapper._jsonFactory).createParser(byArray));
    }

    public JsonNode readTree(byte[] byArray, int n2, int n3) throws IOException {
        this._assertNotNull("content", byArray);
        ObjectMapper objectMapper = this;
        return objectMapper._readTreeAndClose(((TokenStreamFactory)objectMapper._jsonFactory).createParser(byArray, n2, n3));
    }

    public JsonNode readTree(File file) throws IOException {
        this._assertNotNull("file", file);
        ObjectMapper objectMapper = this;
        return objectMapper._readTreeAndClose(((TokenStreamFactory)objectMapper._jsonFactory).createParser(file));
    }

    public JsonNode readTree(URL uRL) throws IOException {
        this._assertNotNull("source", uRL);
        ObjectMapper objectMapper = this;
        return objectMapper._readTreeAndClose(((TokenStreamFactory)objectMapper._jsonFactory).createParser(uRL));
    }

    @Override
    public void writeValue(JsonGenerator jsonGenerator, Object object) throws IOException, StreamWriteException, DatabindException {
        this._assertNotNull("g", jsonGenerator);
        SerializationConfig serializationConfig = this.getSerializationConfig();
        if (serializationConfig.isEnabled(SerializationFeature.INDENT_OUTPUT) && jsonGenerator.getPrettyPrinter() == null) {
            jsonGenerator.setPrettyPrinter(serializationConfig.constructDefaultPrettyPrinter());
        }
        if (serializationConfig.isEnabled(SerializationFeature.CLOSE_CLOSEABLE) && object instanceof Closeable) {
            this._writeCloseableValue(jsonGenerator, object, serializationConfig);
            return;
        }
        this._serializerProvider(serializationConfig).serializeValue(jsonGenerator, object);
        if (serializationConfig.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
            jsonGenerator.flush();
        }
    }

    @Override
    public void writeTree(JsonGenerator jsonGenerator, TreeNode treeNode) throws IOException {
        this._assertNotNull("g", jsonGenerator);
        SerializationConfig serializationConfig = this.getSerializationConfig();
        this._serializerProvider(serializationConfig).serializeValue(jsonGenerator, treeNode);
        if (serializationConfig.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
            jsonGenerator.flush();
        }
    }

    public void writeTree(JsonGenerator jsonGenerator, JsonNode jsonNode) throws IOException {
        this._assertNotNull("g", jsonGenerator);
        SerializationConfig serializationConfig = this.getSerializationConfig();
        this._serializerProvider(serializationConfig).serializeValue(jsonGenerator, jsonNode);
        if (serializationConfig.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
            jsonGenerator.flush();
        }
    }

    @Override
    public ObjectNode createObjectNode() {
        return this._deserializationConfig.getNodeFactory().objectNode();
    }

    @Override
    public ArrayNode createArrayNode() {
        return this._deserializationConfig.getNodeFactory().arrayNode();
    }

    @Override
    public JsonNode missingNode() {
        return this._deserializationConfig.getNodeFactory().missingNode();
    }

    @Override
    public JsonNode nullNode() {
        return this._deserializationConfig.getNodeFactory().nullNode();
    }

    @Override
    public JsonParser treeAsTokens(TreeNode treeNode) {
        this._assertNotNull("n", treeNode);
        return new TreeTraversingParser((JsonNode)treeNode, this);
    }

    @Override
    public <T> T treeToValue(TreeNode treeNode, Class<T> clazz) throws IllegalArgumentException, JsonProcessingException {
        if (treeNode == null) {
            return null;
        }
        try {
            if (TreeNode.class.isAssignableFrom(clazz) && clazz.isAssignableFrom(treeNode.getClass())) {
                return (T)treeNode;
            }
            Object object = treeNode.asToken();
            if (object == JsonToken.VALUE_EMBEDDED_OBJECT && treeNode instanceof POJONode && ((object = ((POJONode)treeNode).getPojo()) == null || clazz.isInstance(object))) {
                return (T)object;
            }
            ObjectMapper objectMapper = this;
            return ((ObjectCodec)objectMapper).readValue(((TreeCodec)objectMapper).treeAsTokens(treeNode), clazz);
        }
        catch (JsonProcessingException jsonProcessingException) {
            JsonProcessingException jsonProcessingException2 = jsonProcessingException;
            throw jsonProcessingException;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getMessage(), iOException);
        }
    }

    public <T> T treeToValue(TreeNode treeNode, JavaType javaType) throws IllegalArgumentException, JsonProcessingException {
        if (treeNode == null) {
            return null;
        }
        try {
            if (javaType.isTypeOrSubTypeOf(TreeNode.class) && javaType.isTypeOrSuperTypeOf(treeNode.getClass())) {
                return (T)treeNode;
            }
            Object object = treeNode.asToken();
            if (object == JsonToken.VALUE_EMBEDDED_OBJECT && treeNode instanceof POJONode && ((object = ((POJONode)treeNode).getPojo()) == null || javaType.isTypeOrSuperTypeOf(((Object)object).getClass()))) {
                return (T)object;
            }
            ObjectMapper objectMapper = this;
            return objectMapper.readValue(((TreeCodec)objectMapper).treeAsTokens(treeNode), javaType);
        }
        catch (JsonProcessingException jsonProcessingException) {
            JsonProcessingException jsonProcessingException2 = jsonProcessingException;
            throw jsonProcessingException;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getMessage(), iOException);
        }
    }

    public <T> T treeToValue(TreeNode treeNode, TypeReference<T> object) throws IllegalArgumentException, JsonProcessingException {
        object = this.constructType((TypeReference<?>)object);
        return this.treeToValue(treeNode, (JavaType)object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T extends JsonNode> T valueToTree(Object object) throws IllegalArgumentException {
        if (object == null) {
            return (T)this.getNodeFactory().nullNode();
        }
        Serializable serializable = this.getSerializationConfig();
        serializable = this._serializerProvider((SerializationConfig)serializable);
        Object object2 = ((SerializerProvider)((Object)serializable)).bufferForValueConversion(this);
        if (this.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
            object2 = ((TokenBuffer)object2).forceUseOfBigDecimal(true);
        }
        try {
            ((DefaultSerializerProvider)serializable).serializeValue((JsonGenerator)object2, object);
            object = ((TokenBuffer)object2).asParser();
            serializable = null;
            try {
                object2 = (JsonNode)((TreeCodec)this).readTree((JsonParser)object);
                if (object == null) return (T)object2;
            }
            catch (Throwable throwable) {
                try {
                    object2 = throwable;
                    serializable = throwable;
                    throw object2;
                }
                catch (Throwable throwable2) {
                    if (object == null) throw throwable2;
                    if (serializable == null) {
                        ((JsonParser)object).close();
                        throw throwable2;
                    }
                    try {
                        ((JsonParser)object).close();
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        ((Throwable)serializable).addSuppressed(throwable3);
                        throw throwable2;
                    }
                }
            }
            ((JsonParser)object).close();
            return (T)object2;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getMessage(), iOException);
        }
    }

    @Deprecated
    public boolean canSerialize(Class<?> clazz) {
        ObjectMapper objectMapper = this;
        return objectMapper._serializerProvider(objectMapper.getSerializationConfig()).hasSerializerFor(clazz, null);
    }

    @Deprecated
    public boolean canSerialize(Class<?> clazz, AtomicReference<Throwable> atomicReference) {
        ObjectMapper objectMapper = this;
        return objectMapper._serializerProvider(objectMapper.getSerializationConfig()).hasSerializerFor(clazz, atomicReference);
    }

    @Deprecated
    public boolean canDeserialize(JavaType javaType) {
        return this.createDeserializationContext(null, this.getDeserializationConfig()).hasValueDeserializerFor(javaType, null);
    }

    @Deprecated
    public boolean canDeserialize(JavaType javaType, AtomicReference<Throwable> atomicReference) {
        return this.createDeserializationContext(null, this.getDeserializationConfig()).hasValueDeserializerFor(javaType, atomicReference);
    }

    public <T> T readValue(File file, Class<T> clazz) throws IOException, StreamReadException, DatabindException {
        this._assertNotNull("src", file);
        ObjectMapper objectMapper = this;
        return (T)objectMapper._readMapAndClose(((TokenStreamFactory)objectMapper._jsonFactory).createParser(file), this._typeFactory.constructType(clazz));
    }

    public <T> T readValue(File file, TypeReference<T> typeReference) throws IOException, StreamReadException, DatabindException {
        this._assertNotNull("src", file);
        ObjectMapper objectMapper = this;
        return (T)objectMapper._readMapAndClose(((TokenStreamFactory)objectMapper._jsonFactory).createParser(file), this._typeFactory.constructType(typeReference));
    }

    public <T> T readValue(File file, JavaType javaType) throws IOException, StreamReadException, DatabindException {
        this._assertNotNull("src", file);
        ObjectMapper objectMapper = this;
        return (T)objectMapper._readMapAndClose(((TokenStreamFactory)objectMapper._jsonFactory).createParser(file), javaType);
    }

    public <T> T readValue(URL uRL, Class<T> clazz) throws IOException, StreamReadException, DatabindException {
        this._assertNotNull("src", uRL);
        ObjectMapper objectMapper = this;
        return (T)objectMapper._readMapAndClose(((TokenStreamFactory)objectMapper._jsonFactory).createParser(uRL), this._typeFactory.constructType(clazz));
    }

    public <T> T readValue(URL uRL, TypeReference<T> typeReference) throws IOException, StreamReadException, DatabindException {
        this._assertNotNull("src", uRL);
        ObjectMapper objectMapper = this;
        return (T)objectMapper._readMapAndClose(((TokenStreamFactory)objectMapper._jsonFactory).createParser(uRL), this._typeFactory.constructType(typeReference));
    }

    public <T> T readValue(URL uRL, JavaType javaType) throws IOException, StreamReadException, DatabindException {
        this._assertNotNull("src", uRL);
        ObjectMapper objectMapper = this;
        return (T)objectMapper._readMapAndClose(((TokenStreamFactory)objectMapper._jsonFactory).createParser(uRL), javaType);
    }

    public <T> T readValue(String string, Class<T> clazz) throws JsonProcessingException, JsonMappingException {
        this._assertNotNull("content", string);
        return this.readValue(string, this._typeFactory.constructType(clazz));
    }

    public <T> T readValue(String string, TypeReference<T> typeReference) throws JsonProcessingException, JsonMappingException {
        this._assertNotNull("content", string);
        return this.readValue(string, this._typeFactory.constructType(typeReference));
    }

    public <T> T readValue(String object, JavaType javaType) throws JsonProcessingException, JsonMappingException {
        this._assertNotNull("content", object);
        try {
            ObjectMapper objectMapper = this;
            return (T)objectMapper._readMapAndClose(((TokenStreamFactory)objectMapper._jsonFactory).createParser((String)object), javaType);
        }
        catch (JsonProcessingException jsonProcessingException) {
            object = jsonProcessingException;
            throw jsonProcessingException;
        }
        catch (IOException iOException) {
            object = iOException;
            throw JsonMappingException.fromUnexpectedIOE(iOException);
        }
    }

    public <T> T readValue(Reader reader, Class<T> clazz) throws IOException, StreamReadException, DatabindException {
        this._assertNotNull("src", reader);
        ObjectMapper objectMapper = this;
        return (T)objectMapper._readMapAndClose(((TokenStreamFactory)objectMapper._jsonFactory).createParser(reader), this._typeFactory.constructType(clazz));
    }

    public <T> T readValue(Reader reader, TypeReference<T> typeReference) throws IOException, StreamReadException, DatabindException {
        this._assertNotNull("src", reader);
        ObjectMapper objectMapper = this;
        return (T)objectMapper._readMapAndClose(((TokenStreamFactory)objectMapper._jsonFactory).createParser(reader), this._typeFactory.constructType(typeReference));
    }

    public <T> T readValue(Reader reader, JavaType javaType) throws IOException, StreamReadException, DatabindException {
        this._assertNotNull("src", reader);
        ObjectMapper objectMapper = this;
        return (T)objectMapper._readMapAndClose(((TokenStreamFactory)objectMapper._jsonFactory).createParser(reader), javaType);
    }

    public <T> T readValue(InputStream inputStream, Class<T> clazz) throws IOException, StreamReadException, DatabindException {
        this._assertNotNull("src", inputStream);
        ObjectMapper objectMapper = this;
        return (T)objectMapper._readMapAndClose(((TokenStreamFactory)objectMapper._jsonFactory).createParser(inputStream), this._typeFactory.constructType(clazz));
    }

    public <T> T readValue(InputStream inputStream, TypeReference<T> typeReference) throws IOException, StreamReadException, DatabindException {
        this._assertNotNull("src", inputStream);
        ObjectMapper objectMapper = this;
        return (T)objectMapper._readMapAndClose(((TokenStreamFactory)objectMapper._jsonFactory).createParser(inputStream), this._typeFactory.constructType(typeReference));
    }

    public <T> T readValue(InputStream inputStream, JavaType javaType) throws IOException, StreamReadException, DatabindException {
        this._assertNotNull("src", inputStream);
        ObjectMapper objectMapper = this;
        return (T)objectMapper._readMapAndClose(((TokenStreamFactory)objectMapper._jsonFactory).createParser(inputStream), javaType);
    }

    public <T> T readValue(byte[] byArray, Class<T> clazz) throws IOException, StreamReadException, DatabindException {
        this._assertNotNull("src", byArray);
        ObjectMapper objectMapper = this;
        return (T)objectMapper._readMapAndClose(((TokenStreamFactory)objectMapper._jsonFactory).createParser(byArray), this._typeFactory.constructType(clazz));
    }

    public <T> T readValue(byte[] byArray, int n2, int n3, Class<T> clazz) throws IOException, StreamReadException, DatabindException {
        this._assertNotNull("src", byArray);
        ObjectMapper objectMapper = this;
        return (T)objectMapper._readMapAndClose(((TokenStreamFactory)objectMapper._jsonFactory).createParser(byArray, n2, n3), this._typeFactory.constructType(clazz));
    }

    public <T> T readValue(byte[] byArray, TypeReference<T> typeReference) throws IOException, StreamReadException, DatabindException {
        this._assertNotNull("src", byArray);
        ObjectMapper objectMapper = this;
        return (T)objectMapper._readMapAndClose(((TokenStreamFactory)objectMapper._jsonFactory).createParser(byArray), this._typeFactory.constructType(typeReference));
    }

    public <T> T readValue(byte[] byArray, int n2, int n3, TypeReference<T> typeReference) throws IOException, StreamReadException, DatabindException {
        this._assertNotNull("src", byArray);
        ObjectMapper objectMapper = this;
        return (T)objectMapper._readMapAndClose(((TokenStreamFactory)objectMapper._jsonFactory).createParser(byArray, n2, n3), this._typeFactory.constructType(typeReference));
    }

    public <T> T readValue(byte[] byArray, JavaType javaType) throws IOException, StreamReadException, DatabindException {
        this._assertNotNull("src", byArray);
        ObjectMapper objectMapper = this;
        return (T)objectMapper._readMapAndClose(((TokenStreamFactory)objectMapper._jsonFactory).createParser(byArray), javaType);
    }

    public <T> T readValue(byte[] byArray, int n2, int n3, JavaType javaType) throws IOException, StreamReadException, DatabindException {
        this._assertNotNull("src", byArray);
        ObjectMapper objectMapper = this;
        return (T)objectMapper._readMapAndClose(((TokenStreamFactory)objectMapper._jsonFactory).createParser(byArray, n2, n3), javaType);
    }

    public <T> T readValue(DataInput dataInput, Class<T> clazz) throws IOException {
        this._assertNotNull("src", dataInput);
        ObjectMapper objectMapper = this;
        return (T)objectMapper._readMapAndClose(((TokenStreamFactory)objectMapper._jsonFactory).createParser(dataInput), this._typeFactory.constructType(clazz));
    }

    public <T> T readValue(DataInput dataInput, JavaType javaType) throws IOException {
        this._assertNotNull("src", dataInput);
        ObjectMapper objectMapper = this;
        return (T)objectMapper._readMapAndClose(((TokenStreamFactory)objectMapper._jsonFactory).createParser(dataInput), javaType);
    }

    public void writeValue(File file, Object object) throws IOException, StreamWriteException, DatabindException {
        ObjectMapper objectMapper = this;
        objectMapper._writeValueAndClose(objectMapper.createGenerator(file, JsonEncoding.UTF8), object);
    }

    public void writeValue(OutputStream outputStream, Object object) throws IOException, StreamWriteException, DatabindException {
        ObjectMapper objectMapper = this;
        objectMapper._writeValueAndClose(objectMapper.createGenerator(outputStream, JsonEncoding.UTF8), object);
    }

    public void writeValue(DataOutput dataOutput, Object object) throws IOException {
        ObjectMapper objectMapper = this;
        objectMapper._writeValueAndClose(objectMapper.createGenerator(dataOutput), object);
    }

    public void writeValue(Writer writer, Object object) throws IOException, StreamWriteException, DatabindException {
        ObjectMapper objectMapper = this;
        objectMapper._writeValueAndClose(objectMapper.createGenerator(writer), object);
    }

    public String writeValueAsString(Object object) throws JsonProcessingException {
        BufferRecycler bufferRecycler = this._jsonFactory._getBufferRecycler();
        try {
            Object object2 = new SegmentedStringWriter(bufferRecycler);
            Throwable throwable = null;
            try {
                ObjectMapper objectMapper = this;
                objectMapper._writeValueAndClose(objectMapper.createGenerator((Writer)object2), object);
                object = ((SegmentedStringWriter)object2).getAndClear();
                ((SegmentedStringWriter)object2).close();
                return object;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        object = throwable2;
                        throwable = throwable2;
                        throw object;
                    }
                    catch (Throwable throwable3) {
                        if (throwable != null) {
                            try {
                                ((SegmentedStringWriter)object2).close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            ((SegmentedStringWriter)object2).close();
                        }
                        throw throwable3;
                    }
                }
                catch (JsonProcessingException jsonProcessingException) {
                    object2 = jsonProcessingException;
                    throw jsonProcessingException;
                }
                catch (IOException iOException) {
                    object2 = iOException;
                    throw JsonMappingException.fromUnexpectedIOE(iOException);
                }
            }
        }
        finally {
            bufferRecycler.releaseToPool();
        }
    }

    public byte[] writeValueAsBytes(Object object) throws JsonProcessingException {
        BufferRecycler bufferRecycler = this._jsonFactory._getBufferRecycler();
        try {
            Object object2 = new ByteArrayBuilder(bufferRecycler);
            Throwable throwable = null;
            try {
                ObjectMapper objectMapper = this;
                objectMapper._writeValueAndClose(objectMapper.createGenerator((OutputStream)object2, JsonEncoding.UTF8), object);
                object = ((ByteArrayBuilder)object2).toByteArray();
                ((ByteArrayBuilder)object2).release();
                ((ByteArrayBuilder)object2).close();
                return object;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        object = throwable2;
                        throwable = throwable2;
                        throw object;
                    }
                    catch (Throwable throwable3) {
                        if (throwable != null) {
                            try {
                                ((ByteArrayBuilder)object2).close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            ((ByteArrayBuilder)object2).close();
                        }
                        throw throwable3;
                    }
                }
                catch (JsonProcessingException jsonProcessingException) {
                    object2 = jsonProcessingException;
                    throw jsonProcessingException;
                }
                catch (IOException iOException) {
                    object2 = iOException;
                    throw JsonMappingException.fromUnexpectedIOE(iOException);
                }
            }
        }
        finally {
            bufferRecycler.releaseToPool();
        }
    }

    public ObjectWriter writer() {
        ObjectMapper objectMapper = this;
        return objectMapper._newWriter(objectMapper.getSerializationConfig());
    }

    public ObjectWriter writer(SerializationFeature serializationFeature) {
        ObjectMapper objectMapper = this;
        return objectMapper._newWriter(objectMapper.getSerializationConfig().with(serializationFeature));
    }

    public ObjectWriter writer(SerializationFeature serializationFeature, SerializationFeature ... serializationFeatureArray) {
        ObjectMapper objectMapper = this;
        return objectMapper._newWriter(objectMapper.getSerializationConfig().with(serializationFeature, serializationFeatureArray));
    }

    public ObjectWriter writer(DateFormat dateFormat) {
        ObjectMapper objectMapper = this;
        return objectMapper._newWriter(objectMapper.getSerializationConfig().with(dateFormat));
    }

    public ObjectWriter writerWithView(Class<?> clazz) {
        ObjectMapper objectMapper = this;
        return objectMapper._newWriter((SerializationConfig)objectMapper.getSerializationConfig().withView((Class)clazz));
    }

    public ObjectWriter writerFor(Class<?> clazz) {
        ObjectMapper objectMapper = this;
        return objectMapper._newWriter(objectMapper.getSerializationConfig(), clazz == null ? null : this._typeFactory.constructType(clazz), null);
    }

    public ObjectWriter writerFor(TypeReference<?> typeReference) {
        ObjectMapper objectMapper = this;
        return objectMapper._newWriter(objectMapper.getSerializationConfig(), typeReference == null ? null : this._typeFactory.constructType(typeReference), null);
    }

    public ObjectWriter writerFor(JavaType javaType) {
        ObjectMapper objectMapper = this;
        return objectMapper._newWriter(objectMapper.getSerializationConfig(), javaType, null);
    }

    public ObjectWriter writer(PrettyPrinter prettyPrinter) {
        if (prettyPrinter == null) {
            prettyPrinter = ObjectWriter.NULL_PRETTY_PRINTER;
        }
        ObjectMapper objectMapper = this;
        return objectMapper._newWriter(objectMapper.getSerializationConfig(), null, prettyPrinter);
    }

    public ObjectWriter writerWithDefaultPrettyPrinter() {
        SerializationConfig serializationConfig = this.getSerializationConfig();
        return this._newWriter(serializationConfig, null, serializationConfig.getDefaultPrettyPrinter());
    }

    public ObjectWriter writer(FilterProvider filterProvider) {
        ObjectMapper objectMapper = this;
        return objectMapper._newWriter(objectMapper.getSerializationConfig().withFilters(filterProvider));
    }

    public ObjectWriter writer(FormatSchema formatSchema) {
        this._verifySchemaType(formatSchema);
        ObjectMapper objectMapper = this;
        return objectMapper._newWriter(objectMapper.getSerializationConfig(), formatSchema);
    }

    public ObjectWriter writer(Base64Variant base64Variant) {
        ObjectMapper objectMapper = this;
        return objectMapper._newWriter((SerializationConfig)objectMapper.getSerializationConfig().with(base64Variant));
    }

    public ObjectWriter writer(CharacterEscapes characterEscapes) {
        ObjectMapper objectMapper = this;
        return objectMapper._newWriter(objectMapper.getSerializationConfig()).with(characterEscapes);
    }

    public ObjectWriter writer(ContextAttributes contextAttributes) {
        ObjectMapper objectMapper = this;
        return objectMapper._newWriter(objectMapper.getSerializationConfig().with(contextAttributes));
    }

    @Deprecated
    public ObjectWriter writerWithType(Class<?> clazz) {
        ObjectMapper objectMapper = this;
        return objectMapper._newWriter(objectMapper.getSerializationConfig(), clazz == null ? null : this._typeFactory.constructType(clazz), null);
    }

    @Deprecated
    public ObjectWriter writerWithType(TypeReference<?> typeReference) {
        ObjectMapper objectMapper = this;
        return objectMapper._newWriter(objectMapper.getSerializationConfig(), typeReference == null ? null : this._typeFactory.constructType(typeReference), null);
    }

    @Deprecated
    public ObjectWriter writerWithType(JavaType javaType) {
        ObjectMapper objectMapper = this;
        return objectMapper._newWriter(objectMapper.getSerializationConfig(), javaType, null);
    }

    public ObjectReader reader() {
        ObjectMapper objectMapper = this;
        return objectMapper._newReader(objectMapper.getDeserializationConfig()).with(this._injectableValues);
    }

    public ObjectReader reader(DeserializationFeature deserializationFeature) {
        ObjectMapper objectMapper = this;
        return objectMapper._newReader(objectMapper.getDeserializationConfig().with(deserializationFeature));
    }

    public ObjectReader reader(DeserializationFeature deserializationFeature, DeserializationFeature ... deserializationFeatureArray) {
        ObjectMapper objectMapper = this;
        return objectMapper._newReader(objectMapper.getDeserializationConfig().with(deserializationFeature, deserializationFeatureArray));
    }

    public ObjectReader readerForUpdating(Object object) {
        JavaType javaType = object == null ? null : this._typeFactory.constructType(object.getClass());
        ObjectMapper objectMapper = this;
        return objectMapper._newReader(objectMapper.getDeserializationConfig(), javaType, object, null, this._injectableValues);
    }

    public ObjectReader readerFor(JavaType javaType) {
        ObjectMapper objectMapper = this;
        return objectMapper._newReader(objectMapper.getDeserializationConfig(), javaType, null, null, this._injectableValues);
    }

    public ObjectReader readerFor(Class<?> clazz) {
        clazz = clazz == null ? null : this._typeFactory.constructType(clazz);
        ObjectMapper objectMapper = this;
        return objectMapper._newReader(objectMapper.getDeserializationConfig(), (JavaType)((Object)clazz), null, null, this._injectableValues);
    }

    public ObjectReader readerFor(TypeReference<?> typeReference) {
        this._assertNotNull("type", typeReference);
        ObjectMapper objectMapper = this;
        return objectMapper._newReader(objectMapper.getDeserializationConfig(), this._typeFactory.constructType(typeReference), null, null, this._injectableValues);
    }

    public ObjectReader readerForArrayOf(Class<?> clazz) {
        this._assertNotNull("type", clazz);
        ObjectMapper objectMapper = this;
        return objectMapper._newReader(objectMapper.getDeserializationConfig(), this._typeFactory.constructArrayType(clazz), null, null, this._injectableValues);
    }

    public ObjectReader readerForListOf(Class<?> clazz) {
        this._assertNotNull("type", clazz);
        ObjectMapper objectMapper = this;
        return objectMapper._newReader(objectMapper.getDeserializationConfig(), this._typeFactory.constructCollectionType(List.class, clazz), null, null, this._injectableValues);
    }

    public ObjectReader readerForMapOf(Class<?> clazz) {
        this._assertNotNull("type", clazz);
        ObjectMapper objectMapper = this;
        return objectMapper._newReader(objectMapper.getDeserializationConfig(), this._typeFactory.constructMapType(Map.class, String.class, clazz), null, null, this._injectableValues);
    }

    public ObjectReader reader(JsonNodeFactory jsonNodeFactory) {
        this._assertNotNull("nodeFactory", jsonNodeFactory);
        ObjectMapper objectMapper = this;
        return objectMapper._newReader(objectMapper.getDeserializationConfig()).with(jsonNodeFactory);
    }

    public ObjectReader reader(FormatSchema formatSchema) {
        this._verifySchemaType(formatSchema);
        ObjectMapper objectMapper = this;
        return objectMapper._newReader(objectMapper.getDeserializationConfig(), null, null, formatSchema, this._injectableValues);
    }

    public ObjectReader reader(InjectableValues injectableValues) {
        ObjectMapper objectMapper = this;
        return objectMapper._newReader(objectMapper.getDeserializationConfig(), null, null, null, injectableValues);
    }

    public ObjectReader readerWithView(Class<?> clazz) {
        ObjectMapper objectMapper = this;
        return objectMapper._newReader((DeserializationConfig)objectMapper.getDeserializationConfig().withView((Class)clazz));
    }

    public ObjectReader reader(Base64Variant base64Variant) {
        ObjectMapper objectMapper = this;
        return objectMapper._newReader((DeserializationConfig)objectMapper.getDeserializationConfig().with(base64Variant));
    }

    public ObjectReader reader(ContextAttributes contextAttributes) {
        ObjectMapper objectMapper = this;
        return objectMapper._newReader(objectMapper.getDeserializationConfig().with(contextAttributes));
    }

    @Deprecated
    public ObjectReader reader(JavaType javaType) {
        ObjectMapper objectMapper = this;
        return objectMapper._newReader(objectMapper.getDeserializationConfig(), javaType, null, null, this._injectableValues);
    }

    @Deprecated
    public ObjectReader reader(Class<?> clazz) {
        ObjectMapper objectMapper = this;
        return objectMapper._newReader(objectMapper.getDeserializationConfig(), this._typeFactory.constructType(clazz), null, null, this._injectableValues);
    }

    @Deprecated
    public ObjectReader reader(TypeReference<?> typeReference) {
        ObjectMapper objectMapper = this;
        return objectMapper._newReader(objectMapper.getDeserializationConfig(), this._typeFactory.constructType(typeReference), null, null, this._injectableValues);
    }

    public <T> T convertValue(Object object, Class<T> clazz) throws IllegalArgumentException {
        return (T)this._convert(object, this._typeFactory.constructType(clazz));
    }

    public <T> T convertValue(Object object, TypeReference<T> typeReference) throws IllegalArgumentException {
        return (T)this._convert(object, this._typeFactory.constructType(typeReference));
    }

    public <T> T convertValue(Object object, JavaType javaType) throws IllegalArgumentException {
        return (T)this._convert(object, javaType);
    }

    protected Object _convert(Object object, JavaType object2) throws IllegalArgumentException {
        Serializable serializable = this.getSerializationConfig().without(SerializationFeature.WRAP_ROOT_VALUE);
        serializable = this._serializerProvider((SerializationConfig)serializable);
        Object object3 = ((SerializerProvider)((Object)serializable)).bufferForValueConversion(this);
        if (this.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
            object3 = object3.forceUseOfBigDecimal(true);
        }
        try {
            ((DefaultSerializerProvider)serializable).serializeValue((JsonGenerator)object3, object);
            object = object3.asParser();
            serializable = this.getDeserializationConfig();
            object3 = this._initForReading((JsonParser)object, (JavaType)object2);
            if (object3 == JsonToken.VALUE_NULL) {
                serializable = this.createDeserializationContext((JsonParser)object, (DeserializationConfig)serializable);
                object2 = this._findRootDeserializer((DeserializationContext)serializable, (JavaType)object2).getNullValue((DeserializationContext)serializable);
            } else if (object3 == JsonToken.END_ARRAY || object3 == JsonToken.END_OBJECT) {
                object2 = null;
            } else {
                serializable = this.createDeserializationContext((JsonParser)object, (DeserializationConfig)serializable);
                object2 = this._findRootDeserializer((DeserializationContext)serializable, (JavaType)object2);
                object2 = ((JsonDeserializer)object2).deserialize((JsonParser)object, (DeserializationContext)serializable);
            }
            ((JsonParser)object).close();
            return object2;
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getMessage(), iOException);
        }
    }

    public <T> T updateValue(T t2, Object object) throws JsonMappingException {
        Object object2 = t2;
        if (t2 != null && object != null) {
            object2 = this.getSerializationConfig().without(SerializationFeature.WRAP_ROOT_VALUE);
            object2 = this._serializerProvider((SerializationConfig)object2);
            TokenBuffer tokenBuffer = ((SerializerProvider)object2).bufferForValueConversion(this);
            if (this.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
                tokenBuffer = tokenBuffer.forceUseOfBigDecimal(true);
            }
            try {
                ((DefaultSerializerProvider)object2).serializeValue(tokenBuffer, object);
                object = tokenBuffer.asParser();
                object2 = this.readerForUpdating(t2).readValue((JsonParser)object);
                ((JsonParser)object).close();
            }
            catch (IOException iOException) {
                object = iOException;
                if (iOException instanceof JsonMappingException) {
                    throw (JsonMappingException)object;
                }
                throw JsonMappingException.fromUnexpectedIOE((IOException)object);
            }
        }
        return object2;
    }

    @Deprecated
    public JsonSchema generateJsonSchema(Class<?> clazz) throws JsonMappingException {
        ObjectMapper objectMapper = this;
        return objectMapper._serializerProvider(objectMapper.getSerializationConfig()).generateJsonSchema(clazz);
    }

    public void acceptJsonFormatVisitor(Class<?> clazz, JsonFormatVisitorWrapper jsonFormatVisitorWrapper) throws JsonMappingException {
        ObjectMapper objectMapper = this;
        objectMapper.acceptJsonFormatVisitor(objectMapper._typeFactory.constructType(clazz), jsonFormatVisitorWrapper);
    }

    public void acceptJsonFormatVisitor(JavaType javaType, JsonFormatVisitorWrapper jsonFormatVisitorWrapper) throws JsonMappingException {
        if (javaType == null) {
            throw new IllegalArgumentException("type must be provided");
        }
        ObjectMapper objectMapper = this;
        objectMapper._serializerProvider(objectMapper.getSerializationConfig()).acceptJsonFormatVisitor(javaType, jsonFormatVisitorWrapper);
    }

    public void clearCaches() {
        this._rootDeserializers.clear();
        this._typeFactory.clearCache();
        this._deserializationContext.flushCachedDeserializers();
        this._serializerProvider.flushCachedSerializers();
    }

    protected TypeResolverBuilder<?> _constructDefaultTypeResolverBuilder(ObjectMapper$DefaultTyping objectMapper$DefaultTyping, PolymorphicTypeValidator polymorphicTypeValidator) {
        return ObjectMapper$DefaultTypeResolverBuilder.construct(objectMapper$DefaultTyping, polymorphicTypeValidator);
    }

    protected DefaultSerializerProvider _serializerProvider(SerializationConfig serializationConfig) {
        return this._serializerProvider.createInstance(serializationConfig, this._serializerFactory);
    }

    protected final void _writeValueAndClose(JsonGenerator jsonGenerator, Object object) throws IOException {
        SerializationConfig serializationConfig = this.getSerializationConfig();
        if (serializationConfig.isEnabled(SerializationFeature.CLOSE_CLOSEABLE) && object instanceof Closeable) {
            this._writeCloseable(jsonGenerator, object, serializationConfig);
            return;
        }
        try {
            this._serializerProvider(serializationConfig).serializeValue(jsonGenerator, object);
        }
        catch (Exception exception) {
            ClassUtil.closeOnFailAndThrowAsIOE(jsonGenerator, exception);
            return;
        }
        jsonGenerator.close();
    }

    private final void _writeCloseable(JsonGenerator jsonGenerator, Object object, SerializationConfig serializationConfig) throws IOException {
        Closeable closeable = (Closeable)object;
        try {
            this._serializerProvider(serializationConfig).serializeValue(jsonGenerator, object);
            object = closeable;
            closeable = null;
            object.close();
        }
        catch (Exception exception) {
            ClassUtil.closeOnFailAndThrowAsIOE(jsonGenerator, closeable, exception);
            return;
        }
        jsonGenerator.close();
    }

    private final void _writeCloseableValue(JsonGenerator jsonGenerator, Object object, SerializationConfig serializationConfig) throws IOException {
        Closeable closeable = (Closeable)object;
        try {
            this._serializerProvider(serializationConfig).serializeValue(jsonGenerator, object);
            if (serializationConfig.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
                jsonGenerator.flush();
            }
        }
        catch (Exception exception) {
            ClassUtil.closeOnFailAndThrowAsIOE(null, closeable, exception);
            return;
        }
        closeable.close();
    }

    @Deprecated
    protected final void _configAndWriteValue(JsonGenerator jsonGenerator, Object object) throws IOException {
        this.getSerializationConfig().initialize(jsonGenerator);
        this._writeValueAndClose(jsonGenerator, object);
    }

    protected Object _readValue(DeserializationConfig deserializationConfig, JsonParser jsonParser, JavaType javaType) throws IOException {
        Object object = this._initForReading(jsonParser, javaType);
        DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser, deserializationConfig);
        object = object == JsonToken.VALUE_NULL ? this._findRootDeserializer(defaultDeserializationContext, javaType).getNullValue(defaultDeserializationContext) : (object == JsonToken.END_ARRAY || object == JsonToken.END_OBJECT ? null : (object == JsonToken.NOT_AVAILABLE ? null : defaultDeserializationContext.readRootValue(jsonParser, javaType, this._findRootDeserializer(defaultDeserializationContext, javaType), null)));
        jsonParser.clearCurrentToken();
        if (deserializationConfig.isEnabled(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)) {
            this._verifyNoTrailingTokens(jsonParser, defaultDeserializationContext, javaType);
        }
        return object;
    }

    protected Object _readMapAndClose(JsonParser jsonParser, JavaType object) throws IOException {
        block16: {
            Throwable throwable = null;
            try {
                DeserializationConfig deserializationConfig = this.getDeserializationConfig();
                DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser, deserializationConfig);
                Object object2 = this._initForReading(jsonParser, (JavaType)object);
                if (object2 == JsonToken.VALUE_NULL) {
                    object2 = this._findRootDeserializer(defaultDeserializationContext, (JavaType)object).getNullValue(defaultDeserializationContext);
                } else if (object2 == JsonToken.END_ARRAY || object2 == JsonToken.END_OBJECT) {
                    object2 = null;
                } else if (object2 == JsonToken.NOT_AVAILABLE) {
                    object2 = null;
                } else {
                    object2 = defaultDeserializationContext.readRootValue(jsonParser, (JavaType)object, this._findRootDeserializer(defaultDeserializationContext, (JavaType)object), null);
                    ((DeserializationContext)defaultDeserializationContext).checkUnresolvedObjectId();
                }
                if (deserializationConfig.isEnabled(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)) {
                    this._verifyNoTrailingTokens(jsonParser, defaultDeserializationContext, (JavaType)object);
                }
                object = object2;
                if (jsonParser == null) break block16;
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (jsonParser != null) {
                        if (throwable != null) {
                            try {
                                jsonParser.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            jsonParser.close();
                        }
                    }
                    throw throwable4;
                }
            }
            jsonParser.close();
        }
        return object;
    }

    protected JsonNode _readTreeAndClose(JsonParser jsonParser) throws IOException {
        Object object;
        block13: {
            Object object2;
            DeserializationConfig deserializationConfig;
            Throwable throwable;
            block11: {
                block12: {
                    throwable = null;
                    object = this.constructType((Type)((Object)JsonNode.class));
                    deserializationConfig = this.getDeserializationConfig();
                    deserializationConfig.initialize(jsonParser);
                    object2 = jsonParser.currentToken();
                    if (object2 != null || (object2 = jsonParser.nextToken()) != null) break block11;
                    object2 = deserializationConfig.getNodeFactory().missingNode();
                    if (jsonParser == null) break block12;
                    jsonParser.close();
                }
                return object2;
            }
            try {
                DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser, deserializationConfig);
                object2 = object2 == JsonToken.VALUE_NULL ? deserializationConfig.getNodeFactory().nullNode() : (JsonNode)defaultDeserializationContext.readRootValue(jsonParser, (JavaType)object, this._findRootDeserializer(defaultDeserializationContext, (JavaType)object), null);
                if (deserializationConfig.isEnabled(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)) {
                    this._verifyNoTrailingTokens(jsonParser, defaultDeserializationContext, (JavaType)object);
                }
                object = object2;
                if (jsonParser == null) break block13;
            }
            catch (Throwable throwable2) {
                try {
                    object = throwable2;
                    throwable = throwable2;
                    throw object;
                }
                catch (Throwable throwable3) {
                    if (jsonParser != null) {
                        if (throwable != null) {
                            try {
                                jsonParser.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            jsonParser.close();
                        }
                    }
                    throw throwable3;
                }
            }
            jsonParser.close();
        }
        return object;
    }

    protected DefaultDeserializationContext createDeserializationContext(JsonParser jsonParser, DeserializationConfig deserializationConfig) {
        return this._deserializationContext.createInstance(deserializationConfig, jsonParser, this._injectableValues);
    }

    protected JsonToken _initForReading(JsonParser jsonParser, JavaType javaType) throws IOException {
        this._deserializationConfig.initialize(jsonParser);
        JsonToken jsonToken = jsonParser.currentToken();
        if (jsonToken == null && (jsonToken = jsonParser.nextToken()) == null) {
            throw MismatchedInputException.from(jsonParser, javaType, "No content to map due to end-of-input");
        }
        return jsonToken;
    }

    protected final void _verifyNoTrailingTokens(JsonParser jsonParser, DeserializationContext deserializationContext, JavaType type) throws IOException {
        JsonToken jsonToken = jsonParser.nextToken();
        if (jsonToken != null) {
            type = ClassUtil.rawClass(type);
            deserializationContext.reportTrailingTokens((Class<?>)type, jsonParser, jsonToken);
        }
    }

    protected JsonDeserializer<Object> _findRootDeserializer(DeserializationContext deserializationContext, JavaType javaType) throws DatabindException {
        JsonDeserializer<Object> jsonDeserializer = this._rootDeserializers.get(javaType);
        if (jsonDeserializer != null) {
            return jsonDeserializer;
        }
        jsonDeserializer = deserializationContext.findRootValueDeserializer(javaType);
        if (jsonDeserializer == null) {
            return (JsonDeserializer)((DatabindContext)deserializationContext).reportBadDefinition(javaType, "Cannot find a deserializer for type " + javaType);
        }
        this._rootDeserializers.put(javaType, jsonDeserializer);
        return jsonDeserializer;
    }

    protected void _verifySchemaType(FormatSchema formatSchema) {
        if (formatSchema != null && !((TokenStreamFactory)this._jsonFactory).canUseSchema(formatSchema)) {
            throw new IllegalArgumentException("Cannot use FormatSchema of type " + formatSchema.getClass().getName() + " for format " + ((TokenStreamFactory)this._jsonFactory).getFormatName());
        }
    }

    protected final void _assertNotNull(String string, Object object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("argument \"%s\" is null", string));
        }
    }
}

