/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.Versioned;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectWriter$Prefetch;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.PackageVersion;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap$SerializerAndMapResult;
import com.fasterxml.jackson.databind.ser.impl.TypeWrappedSerializer;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.util.Collection;

public class SequenceWriter
implements Versioned,
Closeable,
Flushable {
    protected final DefaultSerializerProvider _provider;
    protected final SerializationConfig _config;
    protected final JsonGenerator _generator;
    protected final JsonSerializer<Object> _rootSerializer;
    protected final TypeSerializer _typeSerializer;
    protected final boolean _closeGenerator;
    protected final boolean _cfgFlush;
    protected final boolean _cfgCloseCloseable;
    protected PropertySerializerMap _dynamicSerializers;
    protected boolean _openArray;
    protected boolean _closed;

    public SequenceWriter(DefaultSerializerProvider defaultSerializerProvider, JsonGenerator jsonGenerator, boolean bl2, ObjectWriter$Prefetch objectWriter$Prefetch) throws IOException {
        this._provider = defaultSerializerProvider;
        this._generator = jsonGenerator;
        this._closeGenerator = bl2;
        this._rootSerializer = objectWriter$Prefetch.getValueSerializer();
        this._typeSerializer = objectWriter$Prefetch.getTypeSerializer();
        this._config = defaultSerializerProvider.getConfig();
        this._cfgFlush = this._config.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE);
        this._cfgCloseCloseable = this._config.isEnabled(SerializationFeature.CLOSE_CLOSEABLE);
        this._dynamicSerializers = PropertySerializerMap.emptyForRootValues();
    }

    public SequenceWriter init(boolean bl2) throws IOException {
        if (bl2) {
            this._generator.writeStartArray();
            this._openArray = true;
        }
        return this;
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    public SequenceWriter write(Object object) throws IOException {
        Class<?> clazz;
        if (object == null) {
            this._provider.serializeValue(this._generator, null);
            return this;
        }
        if (this._cfgCloseCloseable && object instanceof Closeable) {
            return this._writeCloseableValue(object);
        }
        JsonSerializer<Object> jsonSerializer = this._rootSerializer;
        if (jsonSerializer == null && (jsonSerializer = this._dynamicSerializers.serializerFor(clazz = object.getClass())) == null) {
            jsonSerializer = this._findAndAddDynamic(clazz);
        }
        this._provider.serializeValue(this._generator, object, null, jsonSerializer);
        if (this._cfgFlush) {
            this._generator.flush();
        }
        return this;
    }

    public SequenceWriter write(Object object, JavaType javaType) throws IOException {
        if (object == null) {
            this._provider.serializeValue(this._generator, null);
            return this;
        }
        if (this._cfgCloseCloseable && object instanceof Closeable) {
            return this._writeCloseableValue(object, javaType);
        }
        JsonSerializer<Object> jsonSerializer = this._dynamicSerializers.serializerFor(((ResolvedType)javaType).getRawClass());
        if (jsonSerializer == null) {
            jsonSerializer = this._findAndAddDynamic(javaType);
        }
        this._provider.serializeValue(this._generator, object, javaType, jsonSerializer);
        if (this._cfgFlush) {
            this._generator.flush();
        }
        return this;
    }

    public SequenceWriter writeAll(Object[] objectArray) throws IOException {
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.write(objectArray[i2]);
        }
        return this;
    }

    public <C extends Collection<?>> SequenceWriter writeAll(C object) throws IOException {
        object = object.iterator();
        while (object.hasNext()) {
            Object e2 = object.next();
            this.write(e2);
        }
        return this;
    }

    public SequenceWriter writeAll(Iterable<?> object) throws IOException {
        object = object.iterator();
        while (object.hasNext()) {
            Object e2 = object.next();
            this.write(e2);
        }
        return this;
    }

    @Override
    public void flush() throws IOException {
        if (!this._closed) {
            this._generator.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (!this._closed) {
            this._closed = true;
            if (this._openArray) {
                this._openArray = false;
                this._generator.writeEndArray();
            }
            if (this._closeGenerator) {
                this._generator.close();
            }
        }
    }

    protected SequenceWriter _writeCloseableValue(Object object) throws IOException {
        Closeable closeable = (Closeable)object;
        try {
            Object object2;
            JsonSerializer<Object> jsonSerializer = this._rootSerializer;
            if (jsonSerializer == null && (jsonSerializer = this._dynamicSerializers.serializerFor((Class<?>)(object2 = object.getClass()))) == null) {
                jsonSerializer = this._findAndAddDynamic((Class<?>)object2);
            }
            this._provider.serializeValue(this._generator, object, null, jsonSerializer);
            if (this._cfgFlush) {
                this._generator.flush();
            }
            object2 = closeable;
            closeable = null;
            object2.close();
        }
        catch (Throwable throwable) {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        return this;
    }

    protected SequenceWriter _writeCloseableValue(Object object, JavaType javaType) throws IOException {
        Closeable closeable = (Closeable)object;
        try {
            JsonSerializer<Object> jsonSerializer = this._dynamicSerializers.serializerFor(((ResolvedType)javaType).getRawClass());
            if (jsonSerializer == null) {
                jsonSerializer = this._findAndAddDynamic(javaType);
            }
            this._provider.serializeValue(this._generator, object, javaType, jsonSerializer);
            if (this._cfgFlush) {
                this._generator.flush();
            }
            object = closeable;
            closeable = null;
            object.close();
        }
        catch (Throwable throwable) {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        return this;
    }

    private final JsonSerializer<Object> _findAndAddDynamic(Class<?> object) throws JsonMappingException {
        object = this._typeSerializer == null ? this._dynamicSerializers.findAndAddRootValueSerializer((Class<?>)object, (SerializerProvider)this._provider) : this._dynamicSerializers.addSerializer((Class<?>)object, (JsonSerializer<Object>)new TypeWrappedSerializer(this._typeSerializer, this._provider.findValueSerializer((Class<?>)object, null)));
        this._dynamicSerializers = ((PropertySerializerMap$SerializerAndMapResult)object).map;
        return ((PropertySerializerMap$SerializerAndMapResult)object).serializer;
    }

    private final JsonSerializer<Object> _findAndAddDynamic(JavaType object) throws JsonMappingException {
        object = this._typeSerializer == null ? this._dynamicSerializers.findAndAddRootValueSerializer((JavaType)object, (SerializerProvider)this._provider) : this._dynamicSerializers.addSerializer((JavaType)object, (JsonSerializer<Object>)new TypeWrappedSerializer(this._typeSerializer, this._provider.findValueSerializer((JavaType)object, null)));
        this._dynamicSerializers = ((PropertySerializerMap$SerializerAndMapResult)object).map;
        return ((PropertySerializerMap$SerializerAndMapResult)object).serializer;
    }
}

