/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.cfg;

import com.fasterxml.jackson.databind.cfg.ConstructorDetector$SingleArgConstructor;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;

public final class ConstructorDetector
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final ConstructorDetector DEFAULT = new ConstructorDetector(ConstructorDetector$SingleArgConstructor.HEURISTIC);
    public static final ConstructorDetector USE_PROPERTIES_BASED = new ConstructorDetector(ConstructorDetector$SingleArgConstructor.PROPERTIES);
    public static final ConstructorDetector USE_DELEGATING = new ConstructorDetector(ConstructorDetector$SingleArgConstructor.DELEGATING);
    public static final ConstructorDetector EXPLICIT_ONLY = new ConstructorDetector(ConstructorDetector$SingleArgConstructor.REQUIRE_MODE);
    protected final ConstructorDetector$SingleArgConstructor _singleArgMode;
    protected final boolean _requireCtorAnnotation;
    protected final boolean _allowJDKTypeCtors;

    protected ConstructorDetector(ConstructorDetector$SingleArgConstructor constructorDetector$SingleArgConstructor, boolean bl2, boolean bl3) {
        this._singleArgMode = constructorDetector$SingleArgConstructor;
        this._requireCtorAnnotation = bl2;
        this._allowJDKTypeCtors = bl3;
    }

    protected ConstructorDetector(ConstructorDetector$SingleArgConstructor constructorDetector$SingleArgConstructor) {
        this(constructorDetector$SingleArgConstructor, false, false);
    }

    public final ConstructorDetector withSingleArgMode(ConstructorDetector$SingleArgConstructor constructorDetector$SingleArgConstructor) {
        return new ConstructorDetector(constructorDetector$SingleArgConstructor, this._requireCtorAnnotation, this._allowJDKTypeCtors);
    }

    public final ConstructorDetector withRequireAnnotation(boolean bl2) {
        return new ConstructorDetector(this._singleArgMode, bl2, this._allowJDKTypeCtors);
    }

    public final ConstructorDetector withAllowJDKTypeConstructors(boolean bl2) {
        return new ConstructorDetector(this._singleArgMode, this._requireCtorAnnotation, bl2);
    }

    public final ConstructorDetector$SingleArgConstructor singleArgMode() {
        return this._singleArgMode;
    }

    public final boolean requireCtorAnnotation() {
        return this._requireCtorAnnotation;
    }

    public final boolean allowJDKTypeConstructors() {
        return this._allowJDKTypeCtors;
    }

    public final boolean singleArgCreatorDefaultsToDelegating() {
        return this._singleArgMode == ConstructorDetector$SingleArgConstructor.DELEGATING;
    }

    public final boolean singleArgCreatorDefaultsToProperties() {
        return this._singleArgMode == ConstructorDetector$SingleArgConstructor.PROPERTIES;
    }

    public final boolean shouldIntrospectorImplicitConstructors(Class<?> clazz) {
        if (this._requireCtorAnnotation) {
            return false;
        }
        return this._allowJDKTypeCtors || !ClassUtil.isJDKClass(clazz) || Throwable.class.isAssignableFrom(clazz);
    }
}

