/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.cfg;

import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.cfg.CacheProvider;
import com.fasterxml.jackson.databind.cfg.DefaultCacheProvider$Builder;
import com.fasterxml.jackson.databind.util.LRUMap;
import com.fasterxml.jackson.databind.util.LookupCache;
import com.fasterxml.jackson.databind.util.TypeKey;

public class DefaultCacheProvider
implements CacheProvider {
    private static final long serialVersionUID = 1L;
    private static final DefaultCacheProvider DEFAULT = new DefaultCacheProvider(2000, 4000, 200);
    protected final int _maxDeserializerCacheSize;
    protected final int _maxSerializerCacheSize;
    protected final int _maxTypeFactoryCacheSize;

    protected DefaultCacheProvider(int n2, int n3, int n4) {
        this._maxDeserializerCacheSize = n2;
        this._maxSerializerCacheSize = n3;
        this._maxTypeFactoryCacheSize = n4;
    }

    public static CacheProvider defaultInstance() {
        return DEFAULT;
    }

    @Override
    public LookupCache<JavaType, JsonDeserializer<Object>> forDeserializerCache(DeserializationConfig deserializationConfig) {
        DefaultCacheProvider defaultCacheProvider = this;
        return defaultCacheProvider._buildCache(defaultCacheProvider._maxDeserializerCacheSize);
    }

    @Override
    public LookupCache<TypeKey, JsonSerializer<Object>> forSerializerCache(SerializationConfig serializationConfig) {
        DefaultCacheProvider defaultCacheProvider = this;
        return defaultCacheProvider._buildCache(defaultCacheProvider._maxSerializerCacheSize);
    }

    @Override
    public LookupCache<Object, JavaType> forTypeFactory() {
        DefaultCacheProvider defaultCacheProvider = this;
        return defaultCacheProvider._buildCache(defaultCacheProvider._maxTypeFactoryCacheSize);
    }

    protected <K, V> LookupCache<K, V> _buildCache(int n2) {
        int n3 = Math.min(64, n2 >> 2);
        return new LRUMap(n3, n2);
    }

    public static DefaultCacheProvider$Builder builder() {
        return new DefaultCacheProvider$Builder();
    }
}

