/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser;

import com.fasterxml.jackson.annotation.JsonFormat$Feature;
import com.fasterxml.jackson.annotation.JsonFormat$Value;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder$Value;
import com.fasterxml.jackson.databind.deser.AbstractDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializer;
import com.fasterxml.jackson.databind.deser.BuilderBasedDeserializer;
import com.fasterxml.jackson.databind.deser.SettableAnyProperty;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.impl.BeanPropertyMap;
import com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.fasterxml.jackson.databind.deser.impl.ObjectIdValueProperty;
import com.fasterxml.jackson.databind.deser.impl.ValueInjector;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.util.Annotations;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.IgnorePropertiesUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BeanDeserializerBuilder {
    protected final DeserializationConfig _config;
    protected final DeserializationContext _context;
    protected final BeanDescription _beanDesc;
    protected final Map<String, SettableBeanProperty> _properties = new LinkedHashMap<String, SettableBeanProperty>();
    protected SettableBeanProperty[] _propsBasedCreatorParams;
    protected List<ValueInjector> _injectables;
    protected HashMap<String, SettableBeanProperty> _backRefProperties;
    protected HashSet<String> _ignorableProps;
    protected HashSet<String> _includableProps;
    protected ValueInstantiator _valueInstantiator;
    protected ObjectIdReader _objectIdReader;
    protected SettableAnyProperty _anySetter;
    protected boolean _ignoreAllUnknown;
    protected AnnotatedMethod _buildMethod;
    protected JsonPOJOBuilder$Value _builderConfig;

    public BeanDeserializerBuilder(BeanDescription beanDescription, DeserializationContext deserializationContext) {
        this._beanDesc = beanDescription;
        this._context = deserializationContext;
        this._config = deserializationContext.getConfig();
    }

    protected BeanDeserializerBuilder(BeanDeserializerBuilder beanDeserializerBuilder) {
        this._beanDesc = beanDeserializerBuilder._beanDesc;
        this._context = beanDeserializerBuilder._context;
        this._config = beanDeserializerBuilder._config;
        this._properties.putAll(beanDeserializerBuilder._properties);
        this._injectables = BeanDeserializerBuilder._copy(beanDeserializerBuilder._injectables);
        this._backRefProperties = BeanDeserializerBuilder._copy(beanDeserializerBuilder._backRefProperties);
        this._ignorableProps = beanDeserializerBuilder._ignorableProps;
        this._includableProps = beanDeserializerBuilder._includableProps;
        this._valueInstantiator = beanDeserializerBuilder._valueInstantiator;
        this._propsBasedCreatorParams = beanDeserializerBuilder._propsBasedCreatorParams;
        this._objectIdReader = beanDeserializerBuilder._objectIdReader;
        this._anySetter = beanDeserializerBuilder._anySetter;
        this._ignoreAllUnknown = beanDeserializerBuilder._ignoreAllUnknown;
        this._buildMethod = beanDeserializerBuilder._buildMethod;
        this._builderConfig = beanDeserializerBuilder._builderConfig;
    }

    private static HashMap<String, SettableBeanProperty> _copy(HashMap<String, SettableBeanProperty> hashMap) {
        if (hashMap == null) {
            return null;
        }
        return new HashMap<String, SettableBeanProperty>(hashMap);
    }

    private static <T> List<T> _copy(List<T> list) {
        if (list == null) {
            return null;
        }
        return new ArrayList<T>(list);
    }

    public void addOrReplaceProperty(SettableBeanProperty settableBeanProperty, boolean bl2) {
        SettableBeanProperty settableBeanProperty2 = this._properties.put(settableBeanProperty.getName(), settableBeanProperty);
        if (settableBeanProperty2 != null && this._propsBasedCreatorParams != null) {
            int n2 = this._propsBasedCreatorParams.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this._propsBasedCreatorParams[i2] != settableBeanProperty2) continue;
                this._propsBasedCreatorParams[i2] = settableBeanProperty;
            }
        }
    }

    public void addProperty(SettableBeanProperty settableBeanProperty) {
        SettableBeanProperty settableBeanProperty2 = this._properties.put(settableBeanProperty.getName(), settableBeanProperty);
        if (settableBeanProperty2 != null && settableBeanProperty2 != settableBeanProperty) {
            throw new IllegalArgumentException("Duplicate property '" + settableBeanProperty.getName() + "' for " + this._beanDesc.getType());
        }
    }

    public void addBackReferenceProperty(String string, SettableBeanProperty settableBeanProperty) throws JsonMappingException {
        if (this._backRefProperties == null) {
            this._backRefProperties = new HashMap(4);
        }
        if (this._config.canOverrideAccessModifiers()) {
            try {
                settableBeanProperty.fixAccess(this._config);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this._handleBadAccess(illegalArgumentException);
            }
        }
        this._backRefProperties.put(string, settableBeanProperty);
    }

    public void addInjectable(PropertyName propertyName, JavaType javaType, Annotations annotations, AnnotatedMember annotatedMember, Object object) throws JsonMappingException {
        if (this._injectables == null) {
            this._injectables = new ArrayList<ValueInjector>();
        }
        if (this._config.canOverrideAccessModifiers()) {
            try {
                annotatedMember.fixAccess(this._config.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this._handleBadAccess(illegalArgumentException);
            }
        }
        this._injectables.add(new ValueInjector(propertyName, javaType, annotatedMember, object));
    }

    public void addIgnorable(String string) {
        if (this._ignorableProps == null) {
            this._ignorableProps = new HashSet();
        }
        this._ignorableProps.add(string);
    }

    public void addIncludable(String string) {
        if (this._includableProps == null) {
            this._includableProps = new HashSet();
        }
        this._includableProps.add(string);
    }

    public void addCreatorProperty(SettableBeanProperty settableBeanProperty) {
        this.addProperty(settableBeanProperty);
    }

    public void setAnySetter(SettableAnyProperty settableAnyProperty) {
        if (this._anySetter != null && settableAnyProperty != null) {
            throw new IllegalStateException("_anySetter already set to non-null");
        }
        this._anySetter = settableAnyProperty;
    }

    public void setIgnoreUnknownProperties(boolean bl2) {
        this._ignoreAllUnknown = bl2;
    }

    public void setValueInstantiator(ValueInstantiator valueInstantiator) {
        this._valueInstantiator = valueInstantiator;
        this._propsBasedCreatorParams = valueInstantiator.getFromObjectArguments(this._config);
    }

    public void setObjectIdReader(ObjectIdReader objectIdReader) {
        this._objectIdReader = objectIdReader;
    }

    public void setPOJOBuilder(AnnotatedMethod annotatedMethod, JsonPOJOBuilder$Value jsonPOJOBuilder$Value) {
        this._buildMethod = annotatedMethod;
        this._builderConfig = jsonPOJOBuilder$Value;
    }

    public Iterator<SettableBeanProperty> getProperties() {
        return this._properties.values().iterator();
    }

    public SettableBeanProperty findProperty(PropertyName propertyName) {
        return this._properties.get(propertyName.getSimpleName());
    }

    public boolean hasProperty(PropertyName propertyName) {
        return this.findProperty(propertyName) != null;
    }

    public SettableBeanProperty removeProperty(PropertyName propertyName) {
        return this._properties.remove(propertyName.getSimpleName());
    }

    public SettableAnyProperty getAnySetter() {
        return this._anySetter;
    }

    public ValueInstantiator getValueInstantiator() {
        return this._valueInstantiator;
    }

    public List<ValueInjector> getInjectables() {
        return this._injectables;
    }

    public ObjectIdReader getObjectIdReader() {
        return this._objectIdReader;
    }

    public AnnotatedMethod getBuildMethod() {
        return this._buildMethod;
    }

    public JsonPOJOBuilder$Value getBuilderConfig() {
        return this._builderConfig;
    }

    public boolean hasIgnorable(String string) {
        return IgnorePropertiesUtil.shouldIgnore(string, this._ignorableProps, this._includableProps);
    }

    public JsonDeserializer<?> build() throws JsonMappingException {
        Object object = this._properties.values();
        this._fixAccess((Collection<SettableBeanProperty>)object);
        BeanPropertyMap beanPropertyMap = BeanPropertyMap.construct(this._config, object, this._collectAliases((Collection<SettableBeanProperty>)object), this._findCaseInsensitivity());
        beanPropertyMap.assignIndexes();
        boolean bl2 = !this._config.isEnabled(MapperFeature.DEFAULT_VIEW_INCLUSION);
        if (!bl2) {
            object = object.iterator();
            while (object.hasNext()) {
                SettableBeanProperty settableBeanProperty = (SettableBeanProperty)object.next();
                if (!settableBeanProperty.hasViews()) continue;
                bl2 = true;
                break;
            }
        }
        if (this._objectIdReader != null) {
            object = new ObjectIdValueProperty(this._objectIdReader, PropertyMetadata.STD_REQUIRED);
            beanPropertyMap = beanPropertyMap.withProperty((SettableBeanProperty)object);
        }
        BeanDeserializerBuilder beanDeserializerBuilder = this;
        return new BeanDeserializer(beanDeserializerBuilder, beanDeserializerBuilder._beanDesc, beanPropertyMap, (Map<String, SettableBeanProperty>)this._backRefProperties, this._ignorableProps, this._ignoreAllUnknown, (Set<String>)this._includableProps, bl2);
    }

    public AbstractDeserializer buildAbstract() {
        BeanDeserializerBuilder beanDeserializerBuilder = this;
        return new AbstractDeserializer(beanDeserializerBuilder, beanDeserializerBuilder._beanDesc, this._backRefProperties, this._properties);
    }

    public JsonDeserializer<?> buildBuilderBased(JavaType javaType, String clazz) throws JsonMappingException {
        Serializable serializable;
        if (this._buildMethod == null) {
            if (!((String)((Object)clazz)).isEmpty()) {
                ((DatabindContext)this._context).reportBadDefinition(this._beanDesc.getType(), String.format("Builder class %s does not have build method (name: '%s')", ClassUtil.getTypeDescription(this._beanDesc.getType()), clazz));
            }
        } else {
            clazz = this._buildMethod.getRawReturnType();
            if (clazz != (serializable = ((ResolvedType)javaType).getRawClass()) && !clazz.isAssignableFrom((Class<?>)serializable) && !((Class)serializable).isAssignableFrom(clazz)) {
                ((DatabindContext)this._context).reportBadDefinition(this._beanDesc.getType(), String.format("Build method `%s` has wrong return type (%s), not compatible with POJO type (%s)", ((AnnotatedMember)this._buildMethod).getFullName(), ClassUtil.getClassDescription(clazz), ClassUtil.getTypeDescription(javaType)));
            }
        }
        clazz = this._properties.values();
        this._fixAccess((Collection<SettableBeanProperty>)((Object)clazz));
        serializable = BeanPropertyMap.construct(this._config, clazz, this._collectAliases((Collection<SettableBeanProperty>)((Object)clazz)), this._findCaseInsensitivity());
        ((BeanPropertyMap)serializable).assignIndexes();
        boolean bl2 = !this._config.isEnabled(MapperFeature.DEFAULT_VIEW_INCLUSION);
        if (!bl2) {
            clazz = clazz.iterator();
            while (clazz.hasNext()) {
                SettableBeanProperty settableBeanProperty = (SettableBeanProperty)clazz.next();
                if (!settableBeanProperty.hasViews()) continue;
                bl2 = true;
                break;
            }
        }
        if (this._objectIdReader != null) {
            clazz = new ObjectIdValueProperty(this._objectIdReader, PropertyMetadata.STD_REQUIRED);
            serializable = ((BeanPropertyMap)serializable).withProperty((SettableBeanProperty)((Object)clazz));
        }
        return this.createBuilderBasedDeserializer(javaType, (BeanPropertyMap)serializable, bl2);
    }

    protected JsonDeserializer<?> createBuilderBasedDeserializer(JavaType javaType, BeanPropertyMap beanPropertyMap, boolean bl2) {
        BeanDeserializerBuilder beanDeserializerBuilder = this;
        return new BuilderBasedDeserializer(beanDeserializerBuilder, beanDeserializerBuilder._beanDesc, javaType, beanPropertyMap, this._backRefProperties, this._ignorableProps, this._ignoreAllUnknown, this._includableProps, bl2);
    }

    protected void _fixAccess(Collection<SettableBeanProperty> object) throws JsonMappingException {
        if (this._config.canOverrideAccessModifiers()) {
            object = object.iterator();
            while (object.hasNext()) {
                SettableBeanProperty settableBeanProperty = (SettableBeanProperty)object.next();
                try {
                    settableBeanProperty.fixAccess(this._config);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this._handleBadAccess(illegalArgumentException);
                }
            }
        }
        if (this._anySetter != null) {
            try {
                this._anySetter.fixAccess(this._config);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this._handleBadAccess(illegalArgumentException);
            }
        }
        if (this._buildMethod != null) {
            try {
                this._buildMethod.fixAccess(this._config.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this._handleBadAccess(illegalArgumentException);
            }
        }
    }

    protected Map<String, List<PropertyName>> _collectAliases(Collection<SettableBeanProperty> object) {
        HashMap<String, List<PropertyName>> hashMap = null;
        object = object.iterator();
        while (object.hasNext()) {
            SettableBeanProperty settableBeanProperty = (SettableBeanProperty)object.next();
            List<PropertyName> list = settableBeanProperty.findAliases(this._config);
            if (list == null || list.isEmpty()) continue;
            if (hashMap == null) {
                hashMap = new HashMap<String, List<PropertyName>>();
            }
            hashMap.put(settableBeanProperty.getName(), list);
        }
        if (hashMap == null) {
            return Collections.emptyMap();
        }
        return hashMap;
    }

    protected boolean _findCaseInsensitivity() {
        Serializable serializable = this._beanDesc.findExpectedFormat();
        if ((serializable = ((JsonFormat$Value)serializable).getFeature(JsonFormat$Feature.ACCEPT_CASE_INSENSITIVE_PROPERTIES)) == null) {
            return this._config.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES);
        }
        return (Boolean)serializable;
    }

    protected void _handleBadAccess(IllegalArgumentException illegalArgumentException) throws JsonMappingException {
        try {
            ((DatabindContext)this._context).reportBadTypeDefinition(this._beanDesc, illegalArgumentException.getMessage(), new Object[0]);
            return;
        }
        catch (DatabindException databindException) {
            DatabindException databindException2 = databindException;
            if (databindException.getCause() == null) {
                databindException2.initCause(illegalArgumentException);
            }
            throw databindException2;
        }
    }
}

