/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TokenStreamFactory;
import com.fasterxml.jackson.core.format.MatchStrength;
import com.fasterxml.jackson.core.io.MergedStream;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class DataFormatReaders$Match {
    protected final InputStream _originalStream;
    protected final byte[] _bufferedData;
    protected final int _bufferedStart;
    protected final int _bufferedLength;
    protected final ObjectReader _match;
    protected final MatchStrength _matchStrength;

    protected DataFormatReaders$Match(InputStream inputStream, byte[] byArray, int n2, int n3, ObjectReader objectReader, MatchStrength matchStrength) {
        this._originalStream = inputStream;
        this._bufferedData = byArray;
        this._bufferedStart = n2;
        this._bufferedLength = n3;
        this._match = objectReader;
        this._matchStrength = matchStrength;
    }

    public boolean hasMatch() {
        return this._match != null;
    }

    public MatchStrength getMatchStrength() {
        if (this._matchStrength == null) {
            return MatchStrength.INCONCLUSIVE;
        }
        return this._matchStrength;
    }

    public ObjectReader getReader() {
        return this._match;
    }

    public String getMatchedFormatName() {
        return ((TokenStreamFactory)((ObjectCodec)this._match).getFactory()).getFormatName();
    }

    public JsonParser createParserWithMatch() throws IOException {
        if (this._match == null) {
            return null;
        }
        JsonFactory jsonFactory = ((ObjectCodec)this._match).getFactory();
        if (this._originalStream == null) {
            return ((TokenStreamFactory)jsonFactory).createParser(this._bufferedData, this._bufferedStart, this._bufferedLength);
        }
        return ((TokenStreamFactory)jsonFactory).createParser(this.getDataStream());
    }

    public InputStream getDataStream() {
        if (this._originalStream == null) {
            return new ByteArrayInputStream(this._bufferedData, this._bufferedStart, this._bufferedLength);
        }
        return new MergedStream(null, this._originalStream, this._bufferedData, this._bufferedStart, this._bufferedLength);
    }
}

