/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.impl;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.Converter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

class JavaUtilCollectionsDeserializers$JavaUtilCollectionsConverter
implements Converter<Object, Object> {
    private final JavaType _inputType;
    private final int _kind;

    JavaUtilCollectionsDeserializers$JavaUtilCollectionsConverter(int n2, JavaType javaType) {
        this._inputType = javaType;
        this._kind = n2;
    }

    @Override
    public Object convert(Object entry) {
        if (entry == null) {
            return null;
        }
        switch (this._kind) {
            case 1: {
                entry = (Set)((Object)entry);
                this._checkSingleton(entry.size());
                return Collections.singleton(entry.iterator().next());
            }
            case 2: {
                entry = (List)((Object)entry);
                this._checkSingleton(entry.size());
                return Collections.singletonList(entry.get(0));
            }
            case 3: {
                entry = (Map)((Object)entry);
                this._checkSingleton(entry.size());
                entry = entry.entrySet().iterator().next();
                return Collections.singletonMap(entry.getKey(), entry.getValue());
            }
            case 4: {
                return Collections.unmodifiableSet((Set)((Object)entry));
            }
            case 5: {
                return Collections.unmodifiableList((List)((Object)entry));
            }
            case 6: {
                return Collections.unmodifiableMap((Map)((Object)entry));
            }
            case 7: {
                return Collections.synchronizedSet((Set)((Object)entry));
            }
            case 9: {
                return Collections.synchronizedList((List)((Object)entry));
            }
            case 8: {
                return Collections.synchronizedCollection((Collection)((Object)entry));
            }
            case 10: {
                return Collections.synchronizedMap((Map)((Object)entry));
            }
        }
        return entry;
    }

    @Override
    public JavaType getInputType(TypeFactory typeFactory) {
        return this._inputType;
    }

    @Override
    public JavaType getOutputType(TypeFactory typeFactory) {
        return this._inputType;
    }

    private void _checkSingleton(int n2) {
        if (n2 != 1) {
            throw new IllegalArgumentException("Can not deserialize Singleton container from " + n2 + " entries");
        }
    }
}

