/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.deser.SettableAnyProperty;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.impl.BeanPropertyMap;
import com.fasterxml.jackson.databind.deser.impl.ObjectIdReader;
import com.fasterxml.jackson.databind.deser.impl.PropertyBasedCreator$CaseInsensitiveMap;
import com.fasterxml.jackson.databind.deser.impl.PropertyValue;
import com.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public final class PropertyBasedCreator {
    protected final int _propertyCount;
    protected final ValueInstantiator _valueInstantiator;
    protected final HashMap<String, SettableBeanProperty> _propertyLookup;
    protected final SettableBeanProperty[] _allProperties;

    protected PropertyBasedCreator(DeserializationContext serializable, ValueInstantiator valueInstantiator, SettableBeanProperty[] settableBeanPropertyArray, boolean bl2, boolean n2) {
        int n3;
        this._valueInstantiator = valueInstantiator;
        this._propertyLookup = bl2 ? PropertyBasedCreator$CaseInsensitiveMap.construct(serializable.getConfig().getLocale()) : new HashMap();
        this._propertyCount = n3 = settableBeanPropertyArray.length;
        this._allProperties = new SettableBeanProperty[n3];
        if (n2) {
            serializable = serializable.getConfig();
            SettableBeanProperty[] settableBeanPropertyArray2 = settableBeanPropertyArray;
            n2 = settableBeanPropertyArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object;
                SettableBeanProperty settableBeanProperty = settableBeanPropertyArray2[i2];
                if (settableBeanProperty.isIgnorable() || (object = settableBeanProperty.findAliases((MapperConfig<?>)serializable)).isEmpty()) continue;
                object = object.iterator();
                while (object.hasNext()) {
                    PropertyName propertyName = (PropertyName)object.next();
                    this._propertyLookup.put(propertyName.getSimpleName(), settableBeanProperty);
                }
            }
        }
        for (int i3 = 0; i3 < n3; ++i3) {
            SettableBeanProperty settableBeanProperty;
            this._allProperties[i3] = settableBeanProperty = settableBeanPropertyArray[i3];
            if (settableBeanProperty.isIgnorable()) continue;
            this._propertyLookup.put(settableBeanProperty.getName(), settableBeanProperty);
        }
    }

    protected PropertyBasedCreator(PropertyBasedCreator propertyBasedCreator, HashMap<String, SettableBeanProperty> hashMap, SettableBeanProperty[] settableBeanPropertyArray) {
        this._propertyCount = propertyBasedCreator._propertyCount;
        this._valueInstantiator = propertyBasedCreator._valueInstantiator;
        this._propertyLookup = hashMap;
        this._allProperties = settableBeanPropertyArray;
    }

    public static PropertyBasedCreator construct(DeserializationContext deserializationContext, ValueInstantiator valueInstantiator, SettableBeanProperty[] settableBeanPropertyArray, BeanPropertyMap beanPropertyMap) throws JsonMappingException {
        int n2 = settableBeanPropertyArray.length;
        SettableBeanProperty[] settableBeanPropertyArray2 = new SettableBeanProperty[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            SettableBeanProperty settableBeanProperty = settableBeanPropertyArray[i2];
            if (!settableBeanProperty.hasValueDeserializer() && !settableBeanProperty.isInjectionOnly()) {
                settableBeanProperty = settableBeanProperty.withValueDeserializer(deserializationContext.findContextualValueDeserializer(settableBeanProperty.getType(), settableBeanProperty));
            }
            settableBeanPropertyArray2[i2] = settableBeanProperty;
        }
        return new PropertyBasedCreator(deserializationContext, valueInstantiator, settableBeanPropertyArray2, beanPropertyMap.isCaseInsensitive(), true);
    }

    public static PropertyBasedCreator construct(DeserializationContext deserializationContext, ValueInstantiator valueInstantiator, SettableBeanProperty[] settableBeanPropertyArray, boolean bl2) throws JsonMappingException {
        int n2 = settableBeanPropertyArray.length;
        SettableBeanProperty[] settableBeanPropertyArray2 = new SettableBeanProperty[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            SettableBeanProperty settableBeanProperty = settableBeanPropertyArray[i2];
            if (!settableBeanProperty.hasValueDeserializer()) {
                settableBeanProperty = settableBeanProperty.withValueDeserializer(deserializationContext.findContextualValueDeserializer(settableBeanProperty.getType(), settableBeanProperty));
            }
            settableBeanPropertyArray2[i2] = settableBeanProperty;
        }
        return new PropertyBasedCreator(deserializationContext, valueInstantiator, settableBeanPropertyArray2, bl2, false);
    }

    @Deprecated
    public static PropertyBasedCreator construct(DeserializationContext deserializationContext, ValueInstantiator valueInstantiator, SettableBeanProperty[] settableBeanPropertyArray) throws JsonMappingException {
        return PropertyBasedCreator.construct(deserializationContext, valueInstantiator, settableBeanPropertyArray, ((DatabindContext)deserializationContext).isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES));
    }

    public final PropertyBasedCreator renameAll(NameTransformer nameTransformer) {
        if (nameTransformer == null || nameTransformer == NameTransformer.NOP) {
            return this;
        }
        int n2 = this._allProperties.length;
        HashMap<String, SettableBeanProperty> hashMap = new HashMap<String, SettableBeanProperty>(this._propertyLookup);
        ArrayList<SettableBeanProperty> arrayList = new ArrayList<SettableBeanProperty>(n2);
        SettableBeanProperty[] settableBeanPropertyArray = this._allProperties;
        int n3 = this._allProperties.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            Object object = settableBeanPropertyArray[i2];
            if (object == null) {
                arrayList.add(null);
                continue;
            }
            SettableBeanProperty settableBeanProperty = ((SettableBeanProperty)object).unwrapped(nameTransformer);
            object = ((SettableBeanProperty)object).getName();
            String string = settableBeanProperty.getName();
            arrayList.add(settableBeanProperty);
            if (((String)object).equals(string) || !hashMap.containsKey(object)) continue;
            hashMap.remove(object);
            hashMap.put(string, settableBeanProperty);
        }
        return new PropertyBasedCreator(this, hashMap, arrayList.toArray(new SettableBeanProperty[0]));
    }

    public final Collection<SettableBeanProperty> properties() {
        return this._propertyLookup.values();
    }

    public final SettableBeanProperty findCreatorProperty(String string) {
        return this._propertyLookup.get(string);
    }

    public final SettableBeanProperty findCreatorProperty(int n2) {
        for (SettableBeanProperty settableBeanProperty : this._propertyLookup.values()) {
            if (settableBeanProperty.getPropertyIndex() != n2) continue;
            return settableBeanProperty;
        }
        return null;
    }

    public final PropertyValueBuffer startBuilding(JsonParser jsonParser, DeserializationContext deserializationContext, ObjectIdReader objectIdReader) {
        return new PropertyValueBuffer(jsonParser, deserializationContext, this._propertyCount, objectIdReader, null);
    }

    public final PropertyValueBuffer startBuildingWithAnySetter(JsonParser jsonParser, DeserializationContext deserializationContext, ObjectIdReader objectIdReader, SettableAnyProperty settableAnyProperty) {
        return new PropertyValueBuffer(jsonParser, deserializationContext, this._propertyCount, objectIdReader, settableAnyProperty);
    }

    public final Object build(DeserializationContext object, PropertyValueBuffer propertyValueBuffer) throws IOException {
        Object object2 = this._valueInstantiator.createFromObjectWith((DeserializationContext)object, this._allProperties, propertyValueBuffer);
        if (object2 != null) {
            object2 = propertyValueBuffer.handleIdValue((DeserializationContext)object, object2);
            object = propertyValueBuffer.buffered();
            while (object != null) {
                ((PropertyValue)object).assign(object2);
                object = ((PropertyValue)object).next;
            }
        }
        return object2;
    }
}

