/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import com.fasterxml.jackson.databind.util.NameTransformer;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UnwrappedPropertyHandler {
    public static final String JSON_UNWRAPPED_NAME_PREFIX = "@JsonUnwrapped/";
    protected final List<SettableBeanProperty> _creatorProperties;
    protected final List<SettableBeanProperty> _properties;

    public UnwrappedPropertyHandler() {
        this._creatorProperties = new ArrayList<SettableBeanProperty>();
        this._properties = new ArrayList<SettableBeanProperty>();
    }

    @Deprecated
    protected UnwrappedPropertyHandler(List<SettableBeanProperty> list) {
        this(new ArrayList<SettableBeanProperty>(), list);
    }

    protected UnwrappedPropertyHandler(List<SettableBeanProperty> list, List<SettableBeanProperty> list2) {
        this._creatorProperties = list;
        this._properties = list2;
    }

    public void addCreatorProperty(SettableBeanProperty settableBeanProperty) {
        this._creatorProperties.add(settableBeanProperty);
    }

    public void addProperty(SettableBeanProperty settableBeanProperty) {
        this._properties.add(settableBeanProperty);
    }

    public UnwrappedPropertyHandler renameAll(NameTransformer nameTransformer) {
        UnwrappedPropertyHandler unwrappedPropertyHandler = this;
        UnwrappedPropertyHandler unwrappedPropertyHandler2 = this;
        return new UnwrappedPropertyHandler(unwrappedPropertyHandler.renameProperties(unwrappedPropertyHandler._creatorProperties, nameTransformer), unwrappedPropertyHandler2.renameProperties(unwrappedPropertyHandler2._properties, nameTransformer));
    }

    private List<SettableBeanProperty> renameProperties(Collection<SettableBeanProperty> object, NameTransformer nameTransformer) {
        ArrayList<SettableBeanProperty> arrayList = new ArrayList<SettableBeanProperty>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            SettableBeanProperty settableBeanProperty = (SettableBeanProperty)object.next();
            if (settableBeanProperty == null) {
                arrayList.add(null);
                continue;
            }
            arrayList.add(settableBeanProperty.unwrapped(nameTransformer));
        }
        return arrayList;
    }

    public PropertyValueBuffer processUnwrappedCreatorProperties(JsonParser jsonParser, DeserializationContext deserializationContext, PropertyValueBuffer propertyValueBuffer, TokenBuffer tokenBuffer) throws IOException {
        for (SettableBeanProperty settableBeanProperty : this._creatorProperties) {
            JsonParser jsonParser2 = tokenBuffer.asParser(jsonParser.streamReadConstraints());
            jsonParser2.nextToken();
            SettableBeanProperty settableBeanProperty2 = settableBeanProperty;
            propertyValueBuffer.assignParameter(settableBeanProperty2, settableBeanProperty2.deserialize(jsonParser2, deserializationContext));
        }
        return propertyValueBuffer;
    }

    public Object processUnwrapped(JsonParser jsonParser, DeserializationContext deserializationContext, Object object, TokenBuffer tokenBuffer) throws IOException {
        for (SettableBeanProperty settableBeanProperty : this._properties) {
            JsonParser jsonParser2 = tokenBuffer.asParser(jsonParser.streamReadConstraints());
            jsonParser2.nextToken();
            settableBeanProperty.deserializeAndSet(jsonParser2, deserializationContext, object);
        }
        return object;
    }

    public static PropertyName creatorParamName(int n2) {
        return new PropertyName(JSON_UNWRAPPED_NAME_PREFIX + n2);
    }
}

