/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;

public class AtomicLongDeserializer
extends StdScalarDeserializer<AtomicLong> {
    private static final long serialVersionUID = 1L;

    public AtomicLongDeserializer() {
        super(AtomicLong.class);
    }

    @Override
    public AtomicLong deserialize(JsonParser object, DeserializationContext deserializationContext) throws IOException {
        if (((JsonParser)object).isExpectedNumberIntToken()) {
            return new AtomicLong(((JsonParser)object).getLongValue());
        }
        if ((object = this._parseLong((JsonParser)object, deserializationContext, AtomicLong.class)) == null) {
            return null;
        }
        return new AtomicLong(((Long)object).intValue());
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Integer;
    }

    @Override
    public Object getEmptyValue(DeserializationContext deserializationContext) throws JsonMappingException {
        return new AtomicLong();
    }
}

