/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.annotation.JsonFormat$Value;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public abstract class DateDeserializers$DateBasedDeserializer<T>
extends StdScalarDeserializer<T>
implements ContextualDeserializer {
    protected final DateFormat _customFormat;
    protected final String _formatString;

    protected DateDeserializers$DateBasedDeserializer(Class<?> clazz) {
        super(clazz);
        this._customFormat = null;
        this._formatString = null;
    }

    protected DateDeserializers$DateBasedDeserializer(DateDeserializers$DateBasedDeserializer<T> dateDeserializers$DateBasedDeserializer, DateFormat dateFormat, String string) {
        super(dateDeserializers$DateBasedDeserializer._valueClass);
        this._customFormat = dateFormat;
        this._formatString = string;
    }

    protected abstract DateDeserializers$DateBasedDeserializer<T> withDateFormat(DateFormat var1, String var2);

    @Override
    public LogicalType logicalType() {
        return LogicalType.DateTime;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty object) throws JsonMappingException {
        if ((object = this.findFormatOverrides(deserializationContext, (BeanProperty)object, ((JsonDeserializer)this).handledType())) != null) {
            TimeZone timeZone = ((JsonFormat$Value)object).getTimeZone();
            Boolean bl2 = ((JsonFormat$Value)object).getLenient();
            if (((JsonFormat$Value)object).hasPattern()) {
                String string = ((JsonFormat$Value)object).getPattern();
                object = ((JsonFormat$Value)object).hasLocale() ? ((JsonFormat$Value)object).getLocale() : ((DatabindContext)deserializationContext).getLocale();
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, (Locale)object);
                if (timeZone == null) {
                    timeZone = ((DatabindContext)deserializationContext).getTimeZone();
                }
                simpleDateFormat.setTimeZone(timeZone);
                if (bl2 != null) {
                    simpleDateFormat.setLenient(bl2);
                }
                return this.withDateFormat(simpleDateFormat, string);
            }
            if (timeZone != null) {
                DateFormat dateFormat = deserializationContext.getConfig().getDateFormat();
                if (dateFormat.getClass() == StdDateFormat.class) {
                    object = ((JsonFormat$Value)object).hasLocale() ? ((JsonFormat$Value)object).getLocale() : ((DatabindContext)deserializationContext).getLocale();
                    StdDateFormat stdDateFormat = (StdDateFormat)dateFormat;
                    stdDateFormat = stdDateFormat.withTimeZone(timeZone);
                    stdDateFormat = stdDateFormat.withLocale((Locale)object);
                    if (bl2 != null) {
                        stdDateFormat = stdDateFormat.withLenient(bl2);
                    }
                    dateFormat = stdDateFormat;
                } else {
                    dateFormat = (DateFormat)dateFormat.clone();
                    dateFormat.setTimeZone(timeZone);
                    if (bl2 != null) {
                        dateFormat.setLenient(bl2);
                    }
                }
                return this.withDateFormat(dateFormat, this._formatString);
            }
            if (bl2 != null) {
                DateFormat dateFormat = deserializationContext.getConfig().getDateFormat();
                object = this._formatString;
                if (dateFormat.getClass() == StdDateFormat.class) {
                    StdDateFormat stdDateFormat = (StdDateFormat)dateFormat;
                    stdDateFormat = stdDateFormat.withLenient(bl2);
                    dateFormat = stdDateFormat;
                    object = stdDateFormat.toPattern();
                } else {
                    dateFormat = (DateFormat)dateFormat.clone();
                    dateFormat.setLenient(bl2);
                    if (dateFormat instanceof SimpleDateFormat) {
                        ((SimpleDateFormat)dateFormat).toPattern();
                    }
                }
                if (object == null) {
                    object = "[unknown]";
                }
                return this.withDateFormat(dateFormat, (String)object);
            }
        }
        return this;
    }

    @Override
    protected Date _parseDate(JsonParser object, DeserializationContext deserializationContext) throws IOException {
        if (this._customFormat != null && ((JsonParser)object).hasToken(JsonToken.VALUE_STRING)) {
            if (((String)(object = ((JsonParser)object).getText().trim())).isEmpty()) {
                CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, (String)object);
                switch (coercionAction) {
                    case AsEmpty: {
                        return new Date(0L);
                    }
                }
                return null;
            }
            DateFormat dateFormat = this._customFormat;
            synchronized (dateFormat) {
                try {
                    return this._customFormat.parse((String)object);
                }
                catch (ParseException parseException) {
                    return (Date)deserializationContext.handleWeirdStringValue(((JsonDeserializer)this).handledType(), (String)object, "expected format \"%s\"", this._formatString);
                }
            }
        }
        return super._parseDate((JsonParser)object, deserializationContext);
    }
}

