/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.impl.PropertyBasedCreator;
import com.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.EnumResolver;
import java.io.IOException;

class FactoryBasedEnumDeserializer
extends StdDeserializer<Object>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    protected final JavaType _inputType;
    protected final AnnotatedMethod _factory;
    protected final JsonDeserializer<?> _deser;
    protected final ValueInstantiator _valueInstantiator;
    protected final SettableBeanProperty[] _creatorProps;
    protected final Enum<?> _defaultValue;
    protected final boolean _hasArgs;
    private volatile transient PropertyBasedCreator _propCreator;

    @Deprecated
    public FactoryBasedEnumDeserializer(Class<?> clazz, AnnotatedMethod annotatedMethod, JavaType javaType, ValueInstantiator valueInstantiator, SettableBeanProperty[] settableBeanPropertyArray) {
        this(clazz, annotatedMethod, javaType, valueInstantiator, settableBeanPropertyArray, null);
    }

    public FactoryBasedEnumDeserializer(Class<?> clazz, AnnotatedMethod annotatedMethod, JavaType javaType, ValueInstantiator valueInstantiator, SettableBeanProperty[] settableBeanPropertyArray, EnumResolver enumResolver) {
        super(clazz);
        this._factory = annotatedMethod;
        this._hasArgs = true;
        this._inputType = ((ResolvedType)javaType).hasRawClass(String.class) || ((ResolvedType)javaType).hasRawClass(CharSequence.class) ? null : javaType;
        this._deser = null;
        this._valueInstantiator = valueInstantiator;
        this._creatorProps = settableBeanPropertyArray;
        this._defaultValue = enumResolver == null ? null : enumResolver.getDefaultValue();
    }

    public FactoryBasedEnumDeserializer(Class<?> clazz, AnnotatedMethod annotatedMethod) {
        super(clazz);
        this._factory = annotatedMethod;
        this._hasArgs = false;
        this._inputType = null;
        this._deser = null;
        this._valueInstantiator = null;
        this._creatorProps = null;
        this._defaultValue = null;
    }

    protected FactoryBasedEnumDeserializer(FactoryBasedEnumDeserializer factoryBasedEnumDeserializer, JsonDeserializer<?> jsonDeserializer) {
        super(factoryBasedEnumDeserializer._valueClass);
        this._inputType = factoryBasedEnumDeserializer._inputType;
        this._factory = factoryBasedEnumDeserializer._factory;
        this._hasArgs = factoryBasedEnumDeserializer._hasArgs;
        this._valueInstantiator = factoryBasedEnumDeserializer._valueInstantiator;
        this._creatorProps = factoryBasedEnumDeserializer._creatorProps;
        this._defaultValue = factoryBasedEnumDeserializer._defaultValue;
        this._deser = jsonDeserializer;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
        if (this._deser == null && this._inputType != null && this._creatorProps == null) {
            return new FactoryBasedEnumDeserializer(this, deserializationContext.findContextualValueDeserializer(this._inputType, beanProperty));
        }
        return this;
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig deserializationConfig) {
        return Boolean.FALSE;
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Enum;
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public ValueInstantiator getValueInstantiator() {
        return this._valueInstantiator;
    }

    @Override
    public Object deserialize(JsonParser object, DeserializationContext deserializationContext) throws IOException {
        Object object2;
        Object object3;
        if (this._deser != null) {
            object3 = this._deser.deserialize((JsonParser)object, deserializationContext);
        } else if (this._hasArgs) {
            boolean bl2;
            if (this._creatorProps != null) {
                if (((JsonParser)object).isExpectedStartObjectToken()) {
                    PropertyBasedCreator propertyBasedCreator = this._propCreator;
                    if (propertyBasedCreator == null) {
                        this._propCreator = propertyBasedCreator = PropertyBasedCreator.construct(deserializationContext, this._valueInstantiator, this._creatorProps, ((DatabindContext)deserializationContext).isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES));
                    }
                    ((JsonParser)object).nextToken();
                    return this.deserializeEnumUsingPropertyBased((JsonParser)object, deserializationContext, propertyBasedCreator);
                }
                if (!this._valueInstantiator.canCreateFromString()) {
                    JavaType javaType = this.getValueType(deserializationContext);
                    JsonToken jsonToken = ((JsonParser)object).currentToken();
                    return deserializationContext.reportInputMismatch(javaType, "Input mismatch reading Enum %s: properties-based `@JsonCreator` (%s) expects Object Value, got %s (`JsonToken.%s`)", ClassUtil.getTypeDescription(javaType), this._factory, JsonToken.valueDescFor(jsonToken), jsonToken.name());
                }
            }
            if (bl2 = (object2 = ((JsonParser)object).currentToken()) == JsonToken.START_ARRAY && deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                object2 = ((JsonParser)object).nextToken();
            }
            if (object2 == JsonToken.START_OBJECT) {
                FactoryBasedEnumDeserializer factoryBasedEnumDeserializer = this;
                object3 = deserializationContext.extractScalarFromObject((JsonParser)object, factoryBasedEnumDeserializer, factoryBasedEnumDeserializer._valueClass);
            } else {
                if (object2 == null || !((JsonToken)((Object)object2)).isScalarValue()) {
                    object = this.getValueType(deserializationContext);
                    return deserializationContext.reportInputMismatch((JavaType)object, "Input mismatch reading Enum %s: properties-based `@JsonCreator` (%s) expects String Value, got %s (`JsonToken.%s`)", ClassUtil.getTypeDescription((JavaType)object), this._factory, JsonToken.valueDescFor((JsonToken)((Object)object2)), ((Enum)object2).name());
                }
                object3 = ((JsonParser)object).getValueAsString();
            }
            if (bl2 && ((JsonParser)object).nextToken() != JsonToken.END_ARRAY) {
                this.handleMissingEndArrayForSingle((JsonParser)object, deserializationContext);
            }
        } else {
            ((JsonParser)object).skipChildren();
            try {
                return ((AnnotatedWithParams)this._factory).call();
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                Throwable throwable = ClassUtil.throwRootCauseIfIOE(exception);
                return deserializationContext.handleInstantiationProblem(this._valueClass, null, throwable);
            }
        }
        try {
            return this._factory.callOnWith(this._valueClass, object3);
        }
        catch (Exception exception) {
            object2 = exception;
            Throwable throwable = ClassUtil.throwRootCauseIfIOE(exception);
            if (throwable instanceof IllegalArgumentException) {
                if (deserializationContext.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE) && this._defaultValue != null) {
                    return this._defaultValue;
                }
                if (deserializationContext.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL)) {
                    return null;
                }
            }
            return deserializationContext.handleInstantiationProblem(this._valueClass, object3, throwable);
        }
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromAny(jsonParser, deserializationContext);
    }

    protected Object deserializeEnumUsingPropertyBased(JsonParser jsonParser, DeserializationContext deserializationContext, PropertyBasedCreator propertyBasedCreator) throws IOException {
        PropertyValueBuffer propertyValueBuffer = propertyBasedCreator.startBuilding(jsonParser, deserializationContext, null);
        Object object = jsonParser.currentToken();
        while (object == JsonToken.FIELD_NAME) {
            object = jsonParser.currentName();
            jsonParser.nextToken();
            SettableBeanProperty settableBeanProperty = propertyBasedCreator.findCreatorProperty((String)object);
            if (!propertyValueBuffer.readIdProperty((String)object) || settableBeanProperty != null) {
                if (settableBeanProperty != null) {
                    propertyValueBuffer.assignParameter(settableBeanProperty, this._deserializeWithErrorWrapping(jsonParser, deserializationContext, settableBeanProperty));
                } else {
                    jsonParser.skipChildren();
                }
            }
            object = jsonParser.nextToken();
        }
        return propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
    }

    protected final Object _deserializeWithErrorWrapping(JsonParser jsonParser, DeserializationContext deserializationContext, SettableBeanProperty settableBeanProperty) throws IOException {
        try {
            return settableBeanProperty.deserialize(jsonParser, deserializationContext);
        }
        catch (Exception exception) {
            return this.wrapAndThrow(exception, ((JsonDeserializer)this).handledType(), settableBeanProperty.getName(), deserializationContext);
        }
    }

    protected Object wrapAndThrow(Throwable throwable, Object object, String string, DeserializationContext deserializationContext) throws IOException {
        throw JsonMappingException.wrapWithPath(this.throwOrReturnThrowable(throwable, deserializationContext), object, string);
    }

    private Throwable throwOrReturnThrowable(Throwable throwable, DeserializationContext deserializationContext) throws IOException {
        boolean bl2;
        throwable = ClassUtil.getRootCause(throwable);
        ClassUtil.throwIfError(throwable);
        boolean bl3 = bl2 = deserializationContext == null || deserializationContext.isEnabled(DeserializationFeature.WRAP_EXCEPTIONS);
        if (throwable instanceof IOException) {
            if (!bl2 || !(throwable instanceof JacksonException)) {
                throw (IOException)throwable;
            }
        } else if (!bl2) {
            ClassUtil.throwIfRTE(throwable);
        }
        return throwable;
    }
}

