/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.core.io.NumberInput;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import java.io.IOException;
import java.math.BigDecimal;

@JacksonStdImpl
public class NumberDeserializers$BigDecimalDeserializer
extends StdScalarDeserializer<BigDecimal> {
    public static final NumberDeserializers$BigDecimalDeserializer instance = new NumberDeserializers$BigDecimalDeserializer();

    public NumberDeserializers$BigDecimalDeserializer() {
        super(BigDecimal.class);
    }

    @Override
    public Object getEmptyValue(DeserializationContext deserializationContext) {
        return BigDecimal.ZERO;
    }

    @Override
    public final LogicalType logicalType() {
        return LogicalType.Float;
    }

    @Override
    public BigDecimal deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        String string;
        switch (jsonParser.currentTokenId()) {
            case 7: {
                CoercionAction coercionAction = this._checkIntToFloatCoercion(jsonParser, deserializationContext, this._valueClass);
                if (coercionAction == CoercionAction.AsNull) {
                    return (BigDecimal)this.getNullValue(deserializationContext);
                }
                if (coercionAction == CoercionAction.AsEmpty) {
                    return (BigDecimal)((JsonDeserializer)this).getEmptyValue(deserializationContext);
                }
            }
            case 8: {
                return jsonParser.getDecimalValue();
            }
            case 6: {
                string = jsonParser.getText();
                break;
            }
            case 1: {
                NumberDeserializers$BigDecimalDeserializer numberDeserializers$BigDecimalDeserializer = this;
                string = deserializationContext.extractScalarFromObject(jsonParser, numberDeserializers$BigDecimalDeserializer, numberDeserializers$BigDecimalDeserializer._valueClass);
                break;
            }
            case 3: {
                return (BigDecimal)this._deserializeFromArray(jsonParser, deserializationContext);
            }
            default: {
                return (BigDecimal)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser);
            }
        }
        CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, string);
        if (coercionAction == CoercionAction.AsNull) {
            return (BigDecimal)this.getNullValue(deserializationContext);
        }
        if (coercionAction == CoercionAction.AsEmpty) {
            return (BigDecimal)((JsonDeserializer)this).getEmptyValue(deserializationContext);
        }
        if (this._hasTextualNull(string = string.trim())) {
            return (BigDecimal)this.getNullValue(deserializationContext);
        }
        if (NumberInput.looksLikeValidNumber(string)) {
            jsonParser.streamReadConstraints().validateFPLength(string.length());
            try {
                return NumberInput.parseBigDecimal(string, jsonParser.isEnabled(StreamReadFeature.USE_FAST_BIG_NUMBER_PARSER));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return (BigDecimal)deserializationContext.handleWeirdStringValue(this._valueClass, string, "not a valid representation", new Object[0]);
    }
}

