/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.core.io.NumberInput;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

@JacksonStdImpl
public class NumberDeserializers$BigIntegerDeserializer
extends StdScalarDeserializer<BigInteger> {
    public static final NumberDeserializers$BigIntegerDeserializer instance = new NumberDeserializers$BigIntegerDeserializer();

    public NumberDeserializers$BigIntegerDeserializer() {
        super(BigInteger.class);
    }

    @Override
    public Object getEmptyValue(DeserializationContext deserializationContext) {
        return BigInteger.ZERO;
    }

    @Override
    public final LogicalType logicalType() {
        return LogicalType.Integer;
    }

    @Override
    public BigInteger deserialize(JsonParser jsonParser, DeserializationContext serializable) throws IOException {
        String string;
        if (jsonParser.isExpectedNumberIntToken()) {
            return jsonParser.getBigIntegerValue();
        }
        switch (jsonParser.currentTokenId()) {
            case 6: {
                string = jsonParser.getText();
                break;
            }
            case 8: {
                CoercionAction coercionAction = this._checkFloatToIntCoercion(jsonParser, (DeserializationContext)serializable, this._valueClass);
                if (coercionAction == CoercionAction.AsNull) {
                    return (BigInteger)this.getNullValue((DeserializationContext)serializable);
                }
                if (coercionAction == CoercionAction.AsEmpty) {
                    return (BigInteger)((JsonDeserializer)this).getEmptyValue((DeserializationContext)serializable);
                }
                serializable = jsonParser.getDecimalValue();
                jsonParser.streamReadConstraints().validateBigIntegerScale(((BigDecimal)serializable).scale());
                return ((BigDecimal)serializable).toBigInteger();
            }
            case 1: {
                NumberDeserializers$BigIntegerDeserializer numberDeserializers$BigIntegerDeserializer = this;
                string = ((DeserializationContext)serializable).extractScalarFromObject(jsonParser, numberDeserializers$BigIntegerDeserializer, numberDeserializers$BigIntegerDeserializer._valueClass);
                break;
            }
            case 3: {
                return (BigInteger)this._deserializeFromArray(jsonParser, (DeserializationContext)serializable);
            }
            default: {
                return (BigInteger)((DeserializationContext)serializable).handleUnexpectedToken(this.getValueType((DeserializationContext)serializable), jsonParser);
            }
        }
        CoercionAction coercionAction = this._checkFromStringCoercion((DeserializationContext)serializable, string);
        if (coercionAction == CoercionAction.AsNull) {
            return (BigInteger)this.getNullValue((DeserializationContext)serializable);
        }
        if (coercionAction == CoercionAction.AsEmpty) {
            return (BigInteger)((JsonDeserializer)this).getEmptyValue((DeserializationContext)serializable);
        }
        if (this._hasTextualNull(string = string.trim())) {
            return (BigInteger)this.getNullValue((DeserializationContext)serializable);
        }
        if (this._isIntNumber(string)) {
            jsonParser.streamReadConstraints().validateIntegerLength(string.length());
            try {
                return NumberInput.parseBigInteger(string, jsonParser.isEnabled(StreamReadFeature.USE_FAST_BIG_NUMBER_PARSER));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return (BigInteger)((DeserializationContext)serializable).handleWeirdStringValue(this._valueClass, string, "not a valid representation", new Object[0]);
    }
}

