/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.core.io.NumberInput;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import java.io.IOException;

@JacksonStdImpl
public class NumberDeserializers$NumberDeserializer
extends StdScalarDeserializer<Object> {
    public static final NumberDeserializers$NumberDeserializer instance = new NumberDeserializers$NumberDeserializer();

    public NumberDeserializers$NumberDeserializer() {
        super(Number.class);
    }

    @Override
    public final LogicalType logicalType() {
        return LogicalType.Integer;
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        String string;
        switch (jsonParser.currentTokenId()) {
            case 6: {
                string = jsonParser.getText();
                break;
            }
            case 7: {
                if (deserializationContext.hasSomeOfFeatures(F_MASK_INT_COERCIONS)) {
                    return this._coerceIntegral(jsonParser, deserializationContext);
                }
                return jsonParser.getNumberValue();
            }
            case 8: {
                if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS) && !jsonParser.isNaN()) {
                    return jsonParser.getDecimalValue();
                }
                return jsonParser.getNumberValue();
            }
            case 1: {
                NumberDeserializers$NumberDeserializer numberDeserializers$NumberDeserializer = this;
                string = deserializationContext.extractScalarFromObject(jsonParser, numberDeserializers$NumberDeserializer, numberDeserializers$NumberDeserializer._valueClass);
                break;
            }
            case 3: {
                return this._deserializeFromArray(jsonParser, deserializationContext);
            }
            default: {
                return deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser);
            }
        }
        CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, string);
        if (coercionAction == CoercionAction.AsNull) {
            return this.getNullValue(deserializationContext);
        }
        if (coercionAction == CoercionAction.AsEmpty) {
            return this.getEmptyValue(deserializationContext);
        }
        if (this._hasTextualNull(string = string.trim())) {
            return this.getNullValue(deserializationContext);
        }
        if (this._isPosInf(string)) {
            return Double.POSITIVE_INFINITY;
        }
        if (this._isNegInf(string)) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this._isNaN(string)) {
            return Double.NaN;
        }
        try {
            if (this._isIntNumber(string)) {
                jsonParser.streamReadConstraints().validateIntegerLength(string.length());
                if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS)) {
                    return NumberInput.parseBigInteger(string, jsonParser.isEnabled(StreamReadFeature.USE_FAST_BIG_NUMBER_PARSER));
                }
                long l2 = NumberInput.parseLong(string);
                if (!deserializationContext.isEnabled(DeserializationFeature.USE_LONG_FOR_INTS) && l2 <= Integer.MAX_VALUE && l2 >= Integer.MIN_VALUE) {
                    return (int)l2;
                }
                return l2;
            }
            if (NumberInput.looksLikeValidNumber(string)) {
                jsonParser.streamReadConstraints().validateFPLength(string.length());
                if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
                    return NumberInput.parseBigDecimal(string, jsonParser.isEnabled(StreamReadFeature.USE_FAST_BIG_NUMBER_PARSER));
                }
                return NumberInput.parseDouble(string, jsonParser.isEnabled(StreamReadFeature.USE_FAST_DOUBLE_PARSER));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        return deserializationContext.handleWeirdStringValue(this._valueClass, string, "not a valid number", new Object[0]);
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
        switch (jsonParser.currentTokenId()) {
            case 6: 
            case 7: 
            case 8: {
                return ((JsonDeserializer)this).deserialize(jsonParser, deserializationContext);
            }
        }
        return typeDeserializer.deserializeTypedFromScalar(jsonParser, deserializationContext);
    }
}

