/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.io.NumberInput;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.fasterxml.jackson.databind.deser.std.NumberDeserializers$PrimitiveOrWrapperDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import java.io.IOException;

@JacksonStdImpl
public class NumberDeserializers$ShortDeserializer
extends NumberDeserializers$PrimitiveOrWrapperDeserializer<Short> {
    private static final long serialVersionUID = 1L;
    static final NumberDeserializers$ShortDeserializer primitiveInstance = new NumberDeserializers$ShortDeserializer(Short.TYPE, (short)0);
    static final NumberDeserializers$ShortDeserializer wrapperInstance = new NumberDeserializers$ShortDeserializer(Short.class, null);

    public NumberDeserializers$ShortDeserializer(Class<Short> clazz, Short s2) {
        super(clazz, LogicalType.Integer, s2, (short)0);
    }

    @Override
    public Short deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (jsonParser.isExpectedNumberIntToken()) {
            return jsonParser.getShortValue();
        }
        if (this._primitive) {
            return this._parseShortPrimitive(jsonParser, deserializationContext);
        }
        return this._parseShort(jsonParser, deserializationContext);
    }

    protected Short _parseShort(JsonParser object, DeserializationContext deserializationContext) throws IOException {
        int n2;
        switch (((JsonParser)object).currentTokenId()) {
            case 6: {
                object = ((JsonParser)object).getText();
                break;
            }
            case 8: {
                CoercionAction coercionAction = this._checkFloatToIntCoercion((JsonParser)object, deserializationContext, this._valueClass);
                if (coercionAction == CoercionAction.AsNull) {
                    return (Short)((JsonDeserializer)this).getNullValue(deserializationContext);
                }
                if (coercionAction == CoercionAction.AsEmpty) {
                    return (Short)((JsonDeserializer)this).getEmptyValue(deserializationContext);
                }
                return ((JsonParser)object).getShortValue();
            }
            case 11: {
                return (Short)((JsonDeserializer)this).getNullValue(deserializationContext);
            }
            case 7: {
                return ((JsonParser)object).getShortValue();
            }
            case 1: {
                NumberDeserializers$ShortDeserializer numberDeserializers$ShortDeserializer = this;
                object = deserializationContext.extractScalarFromObject((JsonParser)object, numberDeserializers$ShortDeserializer, numberDeserializers$ShortDeserializer._valueClass);
                break;
            }
            case 3: {
                return (Short)this._deserializeFromArray((JsonParser)object, deserializationContext);
            }
            default: {
                return (Short)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), (JsonParser)object);
            }
        }
        CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, (String)object);
        if (coercionAction == CoercionAction.AsNull) {
            return (Short)((JsonDeserializer)this).getNullValue(deserializationContext);
        }
        if (coercionAction == CoercionAction.AsEmpty) {
            return (Short)((JsonDeserializer)this).getEmptyValue(deserializationContext);
        }
        if (this._checkTextualNull(deserializationContext, (String)(object = ((String)object).trim()))) {
            return (Short)((JsonDeserializer)this).getNullValue(deserializationContext);
        }
        try {
            n2 = NumberInput.parseInt((String)object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return (Short)deserializationContext.handleWeirdStringValue(this._valueClass, (String)object, "not a valid Short value", new Object[0]);
        }
        if (this._shortOverflow(n2)) {
            return (Short)deserializationContext.handleWeirdStringValue(this._valueClass, (String)object, "overflow, value cannot be represented as 16-bit value", new Object[0]);
        }
        return (short)n2;
    }
}

