/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.annotation.JsonFormat$Feature;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.fasterxml.jackson.databind.cfg.CoercionInputShape;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.fasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.databind.util.AccessPattern;
import com.fasterxml.jackson.databind.util.ObjectBuffer;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Objects;

@JacksonStdImpl
public class ObjectArrayDeserializer
extends ContainerDeserializerBase<Object>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    protected final boolean _untyped;
    protected final Class<?> _elementClass;
    protected JsonDeserializer<Object> _elementDeserializer;
    protected final TypeDeserializer _elementTypeDeserializer;
    protected final Object[] _emptyValue;

    public ObjectArrayDeserializer(JavaType javaType, JsonDeserializer<Object> jsonDeserializer, TypeDeserializer typeDeserializer) {
        super(javaType, null, null);
        javaType = (ArrayType)javaType;
        this._elementClass = ((ResolvedType)javaType.getContentType()).getRawClass();
        this._untyped = this._elementClass == Object.class;
        this._elementDeserializer = jsonDeserializer;
        this._elementTypeDeserializer = typeDeserializer;
        this._emptyValue = ((ArrayType)javaType).getEmptyArray();
    }

    protected ObjectArrayDeserializer(ObjectArrayDeserializer objectArrayDeserializer, JsonDeserializer<Object> jsonDeserializer, TypeDeserializer typeDeserializer, NullValueProvider nullValueProvider, Boolean bl2) {
        super(objectArrayDeserializer, nullValueProvider, bl2);
        this._elementClass = objectArrayDeserializer._elementClass;
        this._untyped = objectArrayDeserializer._untyped;
        this._emptyValue = objectArrayDeserializer._emptyValue;
        this._elementDeserializer = jsonDeserializer;
        this._elementTypeDeserializer = typeDeserializer;
    }

    public ObjectArrayDeserializer withDeserializer(TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer) {
        return this.withResolved(typeDeserializer, jsonDeserializer, this._nullProvider, this._unwrapSingle);
    }

    public ObjectArrayDeserializer withResolved(TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer, NullValueProvider nullValueProvider, Boolean bl2) {
        if (Objects.equals(bl2, this._unwrapSingle) && nullValueProvider == this._nullProvider && jsonDeserializer == this._elementDeserializer && typeDeserializer == this._elementTypeDeserializer) {
            return this;
        }
        return new ObjectArrayDeserializer(this, jsonDeserializer, typeDeserializer, nullValueProvider, bl2);
    }

    @Override
    public boolean isCachable() {
        return this._elementDeserializer == null && this._elementTypeDeserializer == null;
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Array;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext object, BeanProperty beanProperty) throws JsonMappingException {
        JsonDeserializer<Object> jsonDeserializer = this._elementDeserializer;
        Boolean bl2 = this.findFormatFeature((DeserializationContext)object, beanProperty, ((ResolvedType)this._containerType).getRawClass(), JsonFormat$Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        jsonDeserializer = this.findConvertingContentDeserializer((DeserializationContext)object, beanProperty, jsonDeserializer);
        Object object2 = this._containerType.getContentType();
        jsonDeserializer = jsonDeserializer == null ? ((DeserializationContext)object).findContextualValueDeserializer((JavaType)object2, beanProperty) : ((DeserializationContext)object).handleSecondaryContextualization(jsonDeserializer, beanProperty, (JavaType)object2);
        object2 = this._elementTypeDeserializer;
        if (object2 != null) {
            object2 = ((TypeDeserializer)object2).forProperty(beanProperty);
        }
        object = this.findContentNullProvider((DeserializationContext)object, beanProperty, jsonDeserializer);
        return this.withResolved((TypeDeserializer)object2, jsonDeserializer, (NullValueProvider)object, bl2);
    }

    @Override
    public JsonDeserializer<Object> getContentDeserializer() {
        return this._elementDeserializer;
    }

    @Override
    public AccessPattern getEmptyAccessPattern() {
        return AccessPattern.CONSTANT;
    }

    @Override
    public Object getEmptyValue(DeserializationContext deserializationContext) throws JsonMappingException {
        return this._emptyValue;
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        Object object;
        if (!jsonParser.isExpectedStartArrayToken()) {
            return this.handleNonArray(jsonParser, deserializationContext);
        }
        ObjectBuffer objectBuffer = deserializationContext.leaseObjectBuffer();
        Object[] objectArray = objectBuffer.resetAndStart();
        int n2 = 0;
        try {
            while ((object = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
                if (object == JsonToken.VALUE_NULL) {
                    if (this._skipNullValues) continue;
                    object = null;
                } else {
                    object = this._deserializeNoNullChecks(jsonParser, deserializationContext);
                }
                if (object == null && (object = this._nullProvider.getNullValue(deserializationContext)) == null && this._skipNullValues) continue;
                if (n2 >= objectArray.length) {
                    objectArray = objectBuffer.appendCompletedChunk(objectArray);
                    n2 = 0;
                }
                objectArray[n2++] = object;
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw JsonMappingException.wrapWithPath((Throwable)exception, (Object)objectArray, objectBuffer.bufferedSize() + n2);
        }
        object = this._untyped ? objectBuffer.completeAndClearBuffer(objectArray, n2) : objectBuffer.completeAndClearBuffer(objectArray, n2, this._elementClass);
        deserializationContext.returnObjectBuffer(objectBuffer);
        return object;
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
        return (Object[])typeDeserializer.deserializeTypedFromArray(jsonParser, deserializationContext);
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Object objectArray) throws IOException {
        Object object;
        objectArray = objectArray;
        if (!jsonParser.isExpectedStartArrayToken()) {
            Object[] objectArray2 = (Object[])this.handleNonArray(jsonParser, deserializationContext);
            if (objectArray2 == null) {
                return objectArray;
            }
            int n2 = objectArray.length;
            objectArray = Arrays.copyOf(objectArray, n2 + objectArray2.length);
            System.arraycopy(objectArray2, 0, objectArray, n2, objectArray2.length);
            return objectArray;
        }
        ObjectBuffer objectBuffer = deserializationContext.leaseObjectBuffer();
        int n3 = objectArray.length;
        objectArray = objectBuffer.resetAndStart(objectArray, n3);
        try {
            while ((object = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
                if (object == JsonToken.VALUE_NULL) {
                    if (this._skipNullValues) continue;
                    object = null;
                } else {
                    object = this._deserializeNoNullChecks(jsonParser, deserializationContext);
                }
                if (object == null && (object = this._nullProvider.getNullValue(deserializationContext)) == null && this._skipNullValues) continue;
                if (n3 >= objectArray.length) {
                    objectArray = objectBuffer.appendCompletedChunk(objectArray);
                    n3 = 0;
                }
                objectArray[n3++] = object;
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw JsonMappingException.wrapWithPath((Throwable)exception, (Object)objectArray, objectBuffer.bufferedSize() + n3);
        }
        object = this._untyped ? objectBuffer.completeAndClearBuffer(objectArray, n3) : objectBuffer.completeAndClearBuffer(objectArray, n3, this._elementClass);
        deserializationContext.returnObjectBuffer(objectBuffer);
        return object;
    }

    protected Byte[] deserializeFromBase64(JsonParser object, DeserializationContext byteArray) throws IOException {
        byte[] byArray = ((JsonParser)object).getBinaryValue(byteArray.getBase64Variant());
        object = byArray;
        byteArray = new Byte[byArray.length];
        int n2 = ((Object)object).length;
        for (int i2 = 0; i2 < n2; ++i2) {
            byteArray[i2] = (byte)object[i2];
        }
        return byteArray;
    }

    protected Object handleNonArray(JsonParser object, DeserializationContext deserializationContext) throws IOException {
        boolean bl2 = this._unwrapSingle == Boolean.TRUE || this._unwrapSingle == null && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        if (!bl2) {
            if (((JsonParser)object).hasToken(JsonToken.VALUE_STRING)) {
                if (this._elementClass == Byte.class) {
                    return this.deserializeFromBase64((JsonParser)object, deserializationContext);
                }
                return this._deserializeFromString((JsonParser)object, deserializationContext);
            }
            return deserializationContext.handleUnexpectedToken(this._containerType, (JsonParser)object);
        }
        if (((JsonParser)object).hasToken(JsonToken.VALUE_NULL)) {
            if (this._skipNullValues) {
                return this._emptyValue;
            }
            object = null;
        } else {
            if (((JsonParser)object).hasToken(JsonToken.VALUE_STRING)) {
                Object object2 = ((JsonParser)object).getText();
                if (object2.isEmpty()) {
                    object2 = deserializationContext.findCoercionAction(((JsonDeserializer)this).logicalType(), ((JsonDeserializer)this).handledType(), CoercionInputShape.EmptyString);
                    if (object2 != CoercionAction.Fail) {
                        return (Object[])this._deserializeFromEmptyString((JsonParser)object, deserializationContext, (CoercionAction)((Object)object2), ((JsonDeserializer)this).handledType(), "empty String (\"\")");
                    }
                } else if (ObjectArrayDeserializer._isBlank(object2) && (object2 = deserializationContext.findCoercionFromBlankString(((JsonDeserializer)this).logicalType(), ((JsonDeserializer)this).handledType(), CoercionAction.Fail)) != CoercionAction.Fail) {
                    return (Object[])this._deserializeFromEmptyString((JsonParser)object, deserializationContext, (CoercionAction)((Object)object2), ((JsonDeserializer)this).handledType(), "blank String (all whitespace)");
                }
            }
            object = this._deserializeNoNullChecks((JsonParser)object, deserializationContext);
        }
        if (object == null && (object = this._nullProvider.getNullValue(deserializationContext)) == null && this._skipNullValues) {
            return this._emptyValue;
        }
        Object[] objectArray = this._untyped ? new Object[1] : (Object[])Array.newInstance(this._elementClass, 1);
        objectArray[0] = object;
        return objectArray;
    }

    protected Object _deserializeNoNullChecks(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (this._elementTypeDeserializer == null) {
            return this._elementDeserializer.deserialize(jsonParser, deserializationContext);
        }
        return this._elementDeserializer.deserializeWithType(jsonParser, deserializationContext, this._elementTypeDeserializer);
    }
}

