/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.fasterxml.jackson.databind.deser.std.PrimitiveArrayDeserializers;
import com.fasterxml.jackson.databind.util.ArrayBuilders$FloatBuilder;
import java.io.IOException;
import java.util.Arrays;

@JacksonStdImpl
final class PrimitiveArrayDeserializers$FloatDeser
extends PrimitiveArrayDeserializers<float[]> {
    private static final long serialVersionUID = 1L;

    public PrimitiveArrayDeserializers$FloatDeser() {
        super(float[].class);
    }

    protected PrimitiveArrayDeserializers$FloatDeser(PrimitiveArrayDeserializers$FloatDeser primitiveArrayDeserializers$FloatDeser, NullValueProvider nullValueProvider, Boolean bl2) {
        super(primitiveArrayDeserializers$FloatDeser, nullValueProvider, bl2);
    }

    @Override
    protected final PrimitiveArrayDeserializers<?> withResolved(NullValueProvider nullValueProvider, Boolean bl2) {
        return new PrimitiveArrayDeserializers$FloatDeser(this, nullValueProvider, bl2);
    }

    @Override
    protected final float[] _constructEmpty() {
        return new float[0];
    }

    @Override
    public final float[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (!jsonParser.isExpectedStartArrayToken()) {
            return (float[])this.handleNonArray(jsonParser, deserializationContext);
        }
        ArrayBuilders$FloatBuilder arrayBuilders$FloatBuilder = deserializationContext.getArrayBuilders().getFloatBuilder();
        float[] fArray = (float[])arrayBuilders$FloatBuilder.resetAndStart();
        int n2 = 0;
        try {
            JsonToken jsonToken;
            while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
                if (jsonToken == JsonToken.VALUE_NULL && this._nuller != null) {
                    this._nuller.getNullValue(deserializationContext);
                    continue;
                }
                float f2 = this._parseFloatPrimitive(jsonParser, deserializationContext);
                if (n2 >= fArray.length) {
                    fArray = arrayBuilders$FloatBuilder.appendCompletedChunk(fArray, n2);
                    n2 = 0;
                }
                fArray[n2++] = f2;
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw JsonMappingException.wrapWithPath((Throwable)exception, (Object)fArray, arrayBuilders$FloatBuilder.bufferedSize() + n2);
        }
        return arrayBuilders$FloatBuilder.completeAndClearBuffer(fArray, n2);
    }

    @Override
    protected final float[] handleSingleElementUnwrapped(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        return new float[]{this._parseFloatPrimitive(jsonParser, deserializationContext)};
    }

    @Override
    protected final float[] _concat(float[] fArray, float[] fArray2) {
        int n2 = fArray.length;
        int n3 = fArray2.length;
        fArray = Arrays.copyOf(fArray, n2 + n3);
        System.arraycopy(fArray2, 0, fArray, n2, n3);
        return fArray;
    }
}

