/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.cfg.EnumFeature;
import com.fasterxml.jackson.databind.deser.std.StdKeyDeserializer;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.EnumResolver;
import java.io.IOException;
import java.io.Serializable;

@JacksonStdImpl
final class StdKeyDeserializer$EnumKD
extends StdKeyDeserializer {
    private static final long serialVersionUID = 1L;
    protected final EnumResolver _byNameResolver;
    protected final AnnotatedMethod _factory;
    protected volatile EnumResolver _byToStringResolver;
    protected volatile EnumResolver _byIndexResolver;
    protected final EnumResolver _byEnumNamingResolver;
    protected final Enum<?> _enumDefaultValue;

    protected StdKeyDeserializer$EnumKD(EnumResolver enumResolver, AnnotatedMethod annotatedMethod) {
        super(-1, enumResolver.getEnumClass());
        this._byNameResolver = enumResolver;
        this._factory = annotatedMethod;
        this._enumDefaultValue = enumResolver.getDefaultValue();
        this._byEnumNamingResolver = null;
        this._byToStringResolver = null;
    }

    protected StdKeyDeserializer$EnumKD(EnumResolver enumResolver, AnnotatedMethod annotatedMethod, EnumResolver enumResolver2, EnumResolver enumResolver3, EnumResolver enumResolver4) {
        super(-1, enumResolver.getEnumClass());
        this._byNameResolver = enumResolver;
        this._factory = annotatedMethod;
        this._enumDefaultValue = enumResolver.getDefaultValue();
        this._byEnumNamingResolver = enumResolver2;
        this._byToStringResolver = enumResolver3;
        this._byIndexResolver = enumResolver4;
    }

    @Override
    public final Object _parse(String string, DeserializationContext deserializationContext) throws IOException {
        Enum<?> enum_;
        Serializable serializable;
        if (this._factory != null) {
            try {
                return ((AnnotatedWithParams)this._factory).call1(string);
            }
            catch (Exception exception) {
                serializable = exception;
                ClassUtil.unwrapAndThrowAsIAE(exception);
            }
        }
        if ((enum_ = ((EnumResolver)(serializable = this._resolveCurrentResolver(deserializationContext))).findEnum(string)) == null && ((DatabindContext)deserializationContext).isEnabled(EnumFeature.READ_ENUM_KEYS_USING_INDEX)) {
            serializable = this._getIndexResolver(deserializationContext);
            enum_ = ((EnumResolver)serializable).findEnum(string);
        }
        if (enum_ == null) {
            if (this._enumDefaultValue != null && deserializationContext.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE)) {
                enum_ = this._enumDefaultValue;
            } else if (!deserializationContext.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL)) {
                return deserializationContext.handleWeirdKey(this._keyClass, string, "not one of the values accepted for Enum class: %s", ((EnumResolver)serializable).getEnumIds());
            }
        }
        return enum_;
    }

    protected final EnumResolver _resolveCurrentResolver(DeserializationContext deserializationContext) {
        if (this._byEnumNamingResolver != null) {
            return this._byEnumNamingResolver;
        }
        if (deserializationContext.isEnabled(DeserializationFeature.READ_ENUMS_USING_TO_STRING)) {
            return this._getToStringResolver(deserializationContext);
        }
        return this._byNameResolver;
    }

    @Deprecated
    private EnumResolver _getToStringResolver(DeserializationContext deserializationContext) {
        EnumResolver enumResolver = this._byToStringResolver;
        if (enumResolver == null) {
            StdKeyDeserializer$EnumKD stdKeyDeserializer$EnumKD = this;
            synchronized (stdKeyDeserializer$EnumKD) {
                enumResolver = this._byToStringResolver;
                if (enumResolver == null) {
                    this._byToStringResolver = enumResolver = EnumResolver.constructUsingToString(deserializationContext.getConfig(), this._byNameResolver.getEnumClass());
                }
            }
        }
        return enumResolver;
    }

    @Deprecated
    private EnumResolver _getIndexResolver(DeserializationContext deserializationContext) {
        EnumResolver enumResolver = this._byIndexResolver;
        if (enumResolver == null) {
            StdKeyDeserializer$EnumKD stdKeyDeserializer$EnumKD = this;
            synchronized (stdKeyDeserializer$EnumKD) {
                enumResolver = this._byIndexResolver;
                if (enumResolver == null) {
                    this._byIndexResolver = enumResolver = EnumResolver.constructUsingIndex(deserializationContext.getConfig(), this._byNameResolver.getEnumClass());
                }
            }
        }
        return enumResolver;
    }
}

