/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotationCollector;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector$MixInResolver;
import com.fasterxml.jackson.databind.introspect.SimpleMixInResolver;
import com.fasterxml.jackson.databind.type.TypeBindings;
import com.fasterxml.jackson.databind.util.Annotations;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class AnnotatedClassResolver {
    private static final Annotations NO_ANNOTATIONS = AnnotationCollector.emptyAnnotations();
    private static final Class<?> CLS_OBJECT = Object.class;
    private static final Class<?> CLS_ENUM = Enum.class;
    private static final Class<?> CLS_LIST = List.class;
    private static final Class<?> CLS_MAP = Map.class;
    private final MapperConfig<?> _config;
    private final AnnotationIntrospector _intr;
    private final ClassIntrospector$MixInResolver _mixInResolver;
    private final TypeBindings _bindings;
    private final JavaType _type;
    private final Class<?> _class;
    private final Class<?> _primaryMixin;
    private final boolean _collectAnnotations;

    AnnotatedClassResolver(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector$MixInResolver classIntrospector$MixInResolver) {
        this._config = mapperConfig;
        this._type = javaType;
        this._class = ((ResolvedType)javaType).getRawClass();
        this._mixInResolver = classIntrospector$MixInResolver;
        this._bindings = javaType.getBindings();
        this._intr = mapperConfig.isAnnotationProcessingEnabled() ? mapperConfig.getAnnotationIntrospector() : null;
        this._primaryMixin = classIntrospector$MixInResolver == null ? null : classIntrospector$MixInResolver.findMixInClassFor(this._class);
        this._collectAnnotations = this._intr != null && !ClassUtil.isJDKClass(this._class);
    }

    AnnotatedClassResolver(MapperConfig<?> mapperConfig, Class<?> clazz, ClassIntrospector$MixInResolver classIntrospector$MixInResolver) {
        Class<?> clazz2;
        AnnotatedClassResolver annotatedClassResolver;
        this._config = mapperConfig;
        this._type = null;
        this._class = clazz;
        this._mixInResolver = classIntrospector$MixInResolver;
        this._bindings = TypeBindings.emptyBindings();
        if (mapperConfig == null) {
            this._intr = null;
            annotatedClassResolver = this;
            clazz2 = null;
        } else {
            this._intr = mapperConfig.isAnnotationProcessingEnabled() ? mapperConfig.getAnnotationIntrospector() : null;
            annotatedClassResolver = this;
            clazz2 = classIntrospector$MixInResolver == null ? null : classIntrospector$MixInResolver.findMixInClassFor(this._class);
        }
        annotatedClassResolver._primaryMixin = clazz2;
        this._collectAnnotations = this._intr != null && !ClassUtil.isJDKClass(this._class);
    }

    public static AnnotatedClass resolve(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector$MixInResolver classIntrospector$MixInResolver) {
        if (((ResolvedType)javaType).isArrayType() && AnnotatedClassResolver.skippableArray(mapperConfig, ((ResolvedType)javaType).getRawClass())) {
            return AnnotatedClassResolver.createArrayType(mapperConfig, ((ResolvedType)javaType).getRawClass());
        }
        return new AnnotatedClassResolver(mapperConfig, javaType, classIntrospector$MixInResolver).resolveFully();
    }

    public static AnnotatedClass resolveWithoutSuperTypes(MapperConfig<?> mapperConfig, Class<?> clazz) {
        return AnnotatedClassResolver.resolveWithoutSuperTypes(mapperConfig, clazz, mapperConfig);
    }

    public static AnnotatedClass resolveWithoutSuperTypes(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector$MixInResolver classIntrospector$MixInResolver) {
        if (((ResolvedType)javaType).isArrayType() && AnnotatedClassResolver.skippableArray(mapperConfig, ((ResolvedType)javaType).getRawClass())) {
            return AnnotatedClassResolver.createArrayType(mapperConfig, ((ResolvedType)javaType).getRawClass());
        }
        return new AnnotatedClassResolver(mapperConfig, javaType, classIntrospector$MixInResolver).resolveWithoutSuperTypes();
    }

    public static AnnotatedClass resolveWithoutSuperTypes(MapperConfig<?> mapperConfig, Class<?> clazz, ClassIntrospector$MixInResolver classIntrospector$MixInResolver) {
        if (clazz.isArray() && AnnotatedClassResolver.skippableArray(mapperConfig, clazz)) {
            return AnnotatedClassResolver.createArrayType(mapperConfig, clazz);
        }
        return new AnnotatedClassResolver(mapperConfig, clazz, classIntrospector$MixInResolver).resolveWithoutSuperTypes();
    }

    private static boolean skippableArray(MapperConfig<?> mapperConfig, Class<?> clazz) {
        return mapperConfig == null || mapperConfig.findMixInClassFor(clazz) == null;
    }

    static AnnotatedClass createPrimordial(Class<?> clazz) {
        return new AnnotatedClass(clazz);
    }

    static AnnotatedClass createArrayType(MapperConfig<?> mapperConfig, Class<?> clazz) {
        return new AnnotatedClass(clazz);
    }

    AnnotatedClass resolveFully() {
        ArrayList<JavaType> arrayList = new ArrayList<JavaType>(8);
        if (!((ResolvedType)this._type).hasRawClass(Object.class)) {
            if (((ResolvedType)this._type).isInterface()) {
                AnnotatedClassResolver._addSuperInterfaces(this._type, arrayList, false);
            } else {
                AnnotatedClassResolver._addSuperTypes(this._type, arrayList, false);
            }
        }
        return new AnnotatedClass(this._type, this._class, arrayList, this._primaryMixin, this.resolveClassAnnotations(arrayList), this._bindings, this._intr, this._mixInResolver, this._config.getTypeFactory(), this._collectAnnotations);
    }

    AnnotatedClass resolveWithoutSuperTypes() {
        List<JavaType> list = Collections.emptyList();
        return new AnnotatedClass(null, this._class, list, this._primaryMixin, this.resolveClassAnnotations(list), this._bindings, this._intr, this._mixInResolver, this._config.getTypeFactory(), this._collectAnnotations);
    }

    private static void _addSuperTypes(JavaType object, List<JavaType> list, boolean bl2) {
        while (true) {
            Class<?> clazz;
            if ((clazz = ((ResolvedType)object).getRawClass()) == CLS_OBJECT || clazz == CLS_ENUM) {
                return;
            }
            if (bl2) {
                if (AnnotatedClassResolver._contains(list, clazz)) {
                    return;
                }
                list.add((JavaType)object);
            }
            for (JavaType javaType : ((JavaType)object).getInterfaces()) {
                AnnotatedClassResolver._addSuperInterfaces(javaType, list, true);
            }
            JavaType javaType = ((JavaType)object).getSuperClass();
            if (javaType == null) break;
            bl2 = true;
            object = javaType;
        }
    }

    private static void _addSuperInterfaces(JavaType object, List<JavaType> list, boolean bl2) {
        Class<?> clazz = ((ResolvedType)object).getRawClass();
        if (bl2) {
            if (AnnotatedClassResolver._contains(list, clazz)) {
                return;
            }
            list.add((JavaType)object);
            if (clazz == CLS_LIST || clazz == CLS_MAP) {
                return;
            }
        }
        for (JavaType javaType : ((JavaType)object).getInterfaces()) {
            AnnotatedClassResolver._addSuperInterfaces(javaType, list, true);
        }
    }

    private static boolean _contains(List<JavaType> list, Class<?> clazz) {
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (((ResolvedType)list.get(i2)).getRawClass() != clazz) continue;
            return true;
        }
        return false;
    }

    private Annotations resolveClassAnnotations(List<JavaType> object) {
        if (this._intr == null) {
            return NO_ANNOTATIONS;
        }
        boolean bl2 = this._mixInResolver != null && (!(this._mixInResolver instanceof SimpleMixInResolver) || ((SimpleMixInResolver)this._mixInResolver).hasMixIns());
        if (!bl2 && !this._collectAnnotations) {
            return NO_ANNOTATIONS;
        }
        AnnotationCollector annotationCollector = AnnotationCollector.emptyCollector();
        if (this._primaryMixin != null) {
            annotationCollector = this._addClassMixIns(annotationCollector, this._class, this._primaryMixin);
        }
        if (this._collectAnnotations) {
            annotationCollector = this._addAnnotationsIfNotPresent(annotationCollector, ClassUtil.findClassAnnotations(this._class));
        }
        object = object.iterator();
        while (object.hasNext()) {
            JavaType javaType = (JavaType)object.next();
            if (bl2) {
                Class<?> clazz = ((ResolvedType)javaType).getRawClass();
                annotationCollector = this._addClassMixIns(annotationCollector, clazz, this._mixInResolver.findMixInClassFor(clazz));
            }
            if (!this._collectAnnotations) continue;
            annotationCollector = this._addAnnotationsIfNotPresent(annotationCollector, ClassUtil.findClassAnnotations(((ResolvedType)javaType).getRawClass()));
        }
        if (bl2) {
            annotationCollector = this._addClassMixIns(annotationCollector, Object.class, this._mixInResolver.findMixInClassFor(Object.class));
        }
        return annotationCollector.asAnnotations();
    }

    private AnnotationCollector _addClassMixIns(AnnotationCollector annotationCollector, Class<?> object, Class<?> clazz2) {
        if (clazz2 != null) {
            annotationCollector = this._addAnnotationsIfNotPresent(annotationCollector, ClassUtil.findClassAnnotations(clazz2));
            for (Class<?> clazz : ClassUtil.findSuperClasses(clazz2, object, false)) {
                annotationCollector = this._addAnnotationsIfNotPresent(annotationCollector, ClassUtil.findClassAnnotations(clazz));
            }
        }
        return annotationCollector;
    }

    private AnnotationCollector _addAnnotationsIfNotPresent(AnnotationCollector annotationCollector, Annotation[] annotationArray) {
        if (annotationArray != null) {
            for (Annotation annotation : annotationArray) {
                if (annotationCollector.isPresent(annotation)) continue;
                annotationCollector = annotationCollector.addOrOverride(annotation);
                if (!this._intr.isAnnotationBundle(annotation)) continue;
                annotationCollector = this._addFromBundleIfNotPresent(annotationCollector, annotation);
            }
        }
        return annotationCollector;
    }

    private AnnotationCollector _addFromBundleIfNotPresent(AnnotationCollector annotationCollector, Annotation annotationArray) {
        for (Annotation annotation : ClassUtil.findClassAnnotations(annotationArray.annotationType())) {
            if (annotation instanceof Target || annotation instanceof Retention || annotationCollector.isPresent(annotation)) continue;
            annotationCollector = annotationCollector.addOrOverride(annotation);
            if (!this._intr.isAnnotationBundle(annotation)) continue;
            annotationCollector = this._addFromBundleIfNotPresent(annotationCollector, annotation);
        }
        return annotationCollector;
    }
}

