/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AccessorNamingStrategy;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.DefaultAccessorNamingStrategy$BaseNameValidator;
import java.util.concurrent.atomic.AtomicBoolean;

public class DefaultAccessorNamingStrategy
extends AccessorNamingStrategy {
    protected final MapperConfig<?> _config;
    protected final AnnotatedClass _forClass;
    protected final DefaultAccessorNamingStrategy$BaseNameValidator _baseNameValidator;
    protected final boolean _stdBeanNaming;
    protected final boolean _isGettersNonBoolean;
    protected final String _getterPrefix;
    protected final String _isGetterPrefix;
    protected final String _mutatorPrefix;

    protected DefaultAccessorNamingStrategy(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass, String string, String string2, String string3, DefaultAccessorNamingStrategy$BaseNameValidator defaultAccessorNamingStrategy$BaseNameValidator) {
        this._config = mapperConfig;
        this._forClass = annotatedClass;
        this._stdBeanNaming = mapperConfig.isEnabled(MapperFeature.USE_STD_BEAN_NAMING);
        this._isGettersNonBoolean = mapperConfig.isEnabled(MapperFeature.ALLOW_IS_GETTERS_FOR_NON_BOOLEAN);
        this._mutatorPrefix = string;
        this._getterPrefix = string2;
        this._isGetterPrefix = string3;
        this._baseNameValidator = defaultAccessorNamingStrategy$BaseNameValidator;
    }

    @Override
    public String findNameForIsGetter(AnnotatedMethod annotatedMethod, String string) {
        if (this._isGetterPrefix != null && (this._isGettersNonBoolean || this._booleanType(((Annotated)annotatedMethod).getType())) && string.startsWith(this._isGetterPrefix)) {
            if (this._stdBeanNaming) {
                return this.stdManglePropertyName(string, this._isGetterPrefix.length());
            }
            return this.legacyManglePropertyName(string, this._isGetterPrefix.length());
        }
        return null;
    }

    private boolean _booleanType(JavaType javaType) {
        if (javaType.isReferenceType()) {
            javaType = javaType.getReferencedType();
        }
        return ((ResolvedType)javaType).hasRawClass(Boolean.TYPE) || ((ResolvedType)javaType).hasRawClass(Boolean.class) || ((ResolvedType)javaType).hasRawClass(AtomicBoolean.class);
    }

    @Override
    public String findNameForRegularGetter(AnnotatedMethod annotatedMethod, String string) {
        if (this._getterPrefix != null && string.startsWith(this._getterPrefix)) {
            if ("getCallbacks".equals(string) ? this._isCglibGetCallbacks(annotatedMethod) : "getMetaClass".equals(string) && this._isGroovyMetaClassGetter(annotatedMethod)) {
                return null;
            }
            if (this._stdBeanNaming) {
                return this.stdManglePropertyName(string, this._getterPrefix.length());
            }
            return this.legacyManglePropertyName(string, this._getterPrefix.length());
        }
        return null;
    }

    @Override
    public String findNameForMutator(AnnotatedMethod annotatedMethod, String string) {
        if (this._mutatorPrefix != null && string.startsWith(this._mutatorPrefix)) {
            if (this._stdBeanNaming) {
                return this.stdManglePropertyName(string, this._mutatorPrefix.length());
            }
            return this.legacyManglePropertyName(string, this._mutatorPrefix.length());
        }
        return null;
    }

    @Override
    public String modifyFieldName(AnnotatedField annotatedField, String string) {
        return string;
    }

    protected String legacyManglePropertyName(String string, int n2) {
        int n3 = string.length();
        if (n3 == n2) {
            return null;
        }
        char c2 = string.charAt(n2);
        if (this._baseNameValidator != null && !this._baseNameValidator.accept(c2, string, n2)) {
            return null;
        }
        char c3 = Character.toLowerCase(c2);
        if (c2 == c3) {
            return string.substring(n2);
        }
        StringBuilder stringBuilder = new StringBuilder(n3 - n2);
        stringBuilder.append(c3);
        ++n2;
        while (n2 < n3) {
            c2 = string.charAt(n2);
            if (c2 == (c3 = Character.toLowerCase(c2))) {
                stringBuilder.append(string, n2, n3);
                break;
            }
            stringBuilder.append(c3);
            ++n2;
        }
        return stringBuilder.toString();
    }

    protected String stdManglePropertyName(String string, int n2) {
        int n3 = string.length();
        if (n3 == n2) {
            return null;
        }
        char c2 = string.charAt(n2);
        if (this._baseNameValidator != null && !this._baseNameValidator.accept(c2, string, n2)) {
            return null;
        }
        char c3 = Character.toLowerCase(c2);
        if (c2 == c3) {
            return string.substring(n2);
        }
        if (n2 + 1 < n3 && Character.isUpperCase(string.charAt(n2 + 1))) {
            return string.substring(n2);
        }
        StringBuilder stringBuilder = new StringBuilder(n3 - n2);
        stringBuilder.append(c3);
        stringBuilder.append(string, n2 + 1, n3);
        return stringBuilder.toString();
    }

    protected boolean _isCglibGetCallbacks(AnnotatedMethod object) {
        if (((Class)(object = ((Annotated)object).getRawType())).isArray()) {
            object = ((Class)object).getComponentType();
            if (((String)(object = ((Class)object).getName())).contains(".cglib")) {
                return ((String)object).startsWith("net.sf.cglib") || ((String)object).startsWith("org.hibernate.repackage.cglib") || ((String)object).startsWith("org.springframework.cglib");
            }
        }
        return false;
    }

    protected boolean _isGroovyMetaClassGetter(AnnotatedMethod annotatedMethod) {
        return ((Annotated)annotatedMethod).getRawType().getName().startsWith("groovy.lang");
    }
}

