/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.annotation.JsonCreator$Mode;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import java.io.Serializable;
import java.util.List;

public class PotentialCreator {
    private static final PropertyName[] NO_NAMES = new PropertyName[0];
    private final AnnotatedWithParams _creator;
    private final boolean _isAnnotated;
    private JsonCreator$Mode _creatorMode;
    private PropertyName[] _implicitParamNames;
    private PropertyName[] _explicitParamNames;
    private List<BeanPropertyDefinition> _propertyDefs;

    public PotentialCreator(AnnotatedWithParams annotatedWithParams, JsonCreator$Mode jsonCreator$Mode) {
        this._creator = annotatedWithParams;
        this._isAnnotated = jsonCreator$Mode != null;
        this._creatorMode = jsonCreator$Mode == null ? JsonCreator$Mode.DEFAULT : jsonCreator$Mode;
    }

    public PotentialCreator overrideMode(JsonCreator$Mode jsonCreator$Mode) {
        this._creatorMode = jsonCreator$Mode;
        return this;
    }

    public void assignPropertyDefs(List<? extends BeanPropertyDefinition> list) {
        this._propertyDefs = list;
    }

    public PotentialCreator introspectParamNames(MapperConfig<?> serializable) {
        if (this._implicitParamNames != null) {
            return this;
        }
        int n2 = this._creator.getParameterCount();
        if (n2 == 0) {
            PotentialCreator potentialCreator = this;
            potentialCreator._explicitParamNames = NO_NAMES;
            potentialCreator._implicitParamNames = NO_NAMES;
            return this;
        }
        this._explicitParamNames = new PropertyName[n2];
        this._implicitParamNames = new PropertyName[n2];
        serializable = ((MapperConfig)serializable).getAnnotationIntrospector();
        for (int i2 = 0; i2 < n2; ++i2) {
            Serializable serializable2 = this._creator.getParameter(i2);
            String string = ((AnnotationIntrospector)serializable).findImplicitPropertyName((AnnotatedMember)serializable2);
            if (string != null && !string.isEmpty()) {
                this._implicitParamNames[i2] = PropertyName.construct(string);
            }
            if ((serializable2 = ((AnnotationIntrospector)serializable).findNameForDeserialization((Annotated)((Object)serializable2))) == null || ((PropertyName)serializable2).isEmpty()) continue;
            this._explicitParamNames[i2] = serializable2;
        }
        return this;
    }

    public PotentialCreator introspectParamNames(MapperConfig<?> serializable, PropertyName[] propertyNameArray) {
        if (this._implicitParamNames != null) {
            return this;
        }
        int n2 = this._creator.getParameterCount();
        if (n2 == 0) {
            PotentialCreator potentialCreator = this;
            potentialCreator._explicitParamNames = NO_NAMES;
            potentialCreator._implicitParamNames = NO_NAMES;
            return this;
        }
        this._explicitParamNames = new PropertyName[n2];
        this._implicitParamNames = propertyNameArray;
        serializable = ((MapperConfig)serializable).getAnnotationIntrospector();
        for (int i2 = 0; i2 < n2; ++i2) {
            Serializable serializable2 = this._creator.getParameter(i2);
            if ((serializable2 = ((AnnotationIntrospector)serializable).findNameForDeserialization((Annotated)((Object)serializable2))) == null || ((PropertyName)serializable2).isEmpty()) continue;
            this._explicitParamNames[i2] = serializable2;
        }
        return this;
    }

    public boolean isAnnotated() {
        return this._isAnnotated;
    }

    public AnnotatedWithParams creator() {
        return this._creator;
    }

    public JsonCreator$Mode creatorMode() {
        return this._creatorMode;
    }

    public JsonCreator$Mode creatorModeOrDefault() {
        if (this._creatorMode == null) {
            return JsonCreator$Mode.DEFAULT;
        }
        return this._creatorMode;
    }

    public int paramCount() {
        return this._creator.getParameterCount();
    }

    public AnnotatedParameter param(int n2) {
        return this._creator.getParameter(n2);
    }

    public boolean hasExplicitNames() {
        int n2 = this._explicitParamNames.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this._explicitParamNames[i2] == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasNameFor(int n2) {
        return this._explicitParamNames[n2] != null || this._implicitParamNames[n2] != null;
    }

    public boolean hasNameOrInjectForAllParams(MapperConfig<?> serializable) {
        serializable = ((MapperConfig)serializable).getAnnotationIntrospector();
        int n2 = this._implicitParamNames.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.hasNameFor(i2) || serializable != null && ((AnnotationIntrospector)serializable).findInjectableValue(this._creator.getParameter(i2)) != null) continue;
            return false;
        }
        return true;
    }

    public PropertyName explicitName(int n2) {
        return this._explicitParamNames[n2];
    }

    public PropertyName implicitName(int n2) {
        return this._implicitParamNames[n2];
    }

    public String implicitNameSimple(int n2) {
        PropertyName propertyName = this._implicitParamNames[n2];
        if (propertyName == null) {
            return null;
        }
        return propertyName.getSimpleName();
    }

    public BeanPropertyDefinition[] propertyDefs() {
        if (this._propertyDefs == null || this._propertyDefs.isEmpty()) {
            return new BeanPropertyDefinition[0];
        }
        return this._propertyDefs.toArray(new BeanPropertyDefinition[this._propertyDefs.size()]);
    }

    public String toString() {
        return "(mode=" + (Object)((Object)this._creatorMode) + ")" + this._creator;
    }
}

