/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.PotentialCreator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PotentialCreators {
    public PotentialCreator propertiesBased;
    private List<PotentialCreator> explicitDelegating;
    private List<PotentialCreator> implicitDelegatingConstructors;
    private List<PotentialCreator> implicitDelegatingFactories;

    public void setPropertiesBased(MapperConfig<?> mapperConfig, PotentialCreator potentialCreator, String string) {
        if (this.propertiesBased != null) {
            throw new IllegalArgumentException(String.format("Conflicting property-based creators: already had %s creator %s, encountered another: %s", string, this.propertiesBased.creator(), potentialCreator.creator()));
        }
        this.propertiesBased = potentialCreator.introspectParamNames(mapperConfig);
    }

    public void addExplicitDelegating(PotentialCreator potentialCreator) {
        if (this.explicitDelegating == null) {
            this.explicitDelegating = new ArrayList<PotentialCreator>();
        }
        this.explicitDelegating.add(potentialCreator);
    }

    public void setImplicitDelegating(List<PotentialCreator> list, List<PotentialCreator> list2) {
        this.implicitDelegatingConstructors = list;
        this.implicitDelegatingFactories = list2;
    }

    public boolean hasDelegating() {
        return this.explicitDelegating != null && !this.explicitDelegating.isEmpty();
    }

    public boolean hasPropertiesBased() {
        return this.propertiesBased != null;
    }

    public boolean hasPropertiesBasedOrDelegating() {
        return this.propertiesBased != null || this.explicitDelegating != null && !this.explicitDelegating.isEmpty();
    }

    public List<PotentialCreator> getExplicitDelegating() {
        if (this.explicitDelegating == null) {
            return Collections.emptyList();
        }
        return this.explicitDelegating;
    }

    public List<PotentialCreator> getImplicitDelegatingFactories() {
        if (this.implicitDelegatingFactories == null) {
            return Collections.emptyList();
        }
        return this.implicitDelegatingFactories;
    }

    public List<PotentialCreator> getImplicitDelegatingConstructors() {
        if (this.implicitDelegatingConstructors == null) {
            return Collections.emptyList();
        }
        return this.implicitDelegatingConstructors;
    }
}

