/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo$As;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.util.JsonParserSequence;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.impl.TypeDeserializerBase;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.io.Serializable;

public class AsArrayTypeDeserializer
extends TypeDeserializerBase
implements Serializable {
    private static final long serialVersionUID = 1L;

    public AsArrayTypeDeserializer(JavaType javaType, TypeIdResolver typeIdResolver, String string, boolean bl2, JavaType javaType2) {
        super(javaType, typeIdResolver, string, bl2, javaType2);
    }

    public AsArrayTypeDeserializer(AsArrayTypeDeserializer asArrayTypeDeserializer, BeanProperty beanProperty) {
        super(asArrayTypeDeserializer, beanProperty);
    }

    @Override
    public TypeDeserializer forProperty(BeanProperty beanProperty) {
        if (beanProperty == this._property) {
            return this;
        }
        return new AsArrayTypeDeserializer(this, beanProperty);
    }

    @Override
    public JsonTypeInfo$As getTypeInclusion() {
        return JsonTypeInfo$As.WRAPPER_ARRAY;
    }

    @Override
    public Object deserializeTypedFromArray(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        return this._deserialize(jsonParser, deserializationContext);
    }

    @Override
    public Object deserializeTypedFromObject(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        return this._deserialize(jsonParser, deserializationContext);
    }

    @Override
    public Object deserializeTypedFromScalar(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        return this._deserialize(jsonParser, deserializationContext);
    }

    @Override
    public Object deserializeTypedFromAny(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        return this._deserialize(jsonParser, deserializationContext);
    }

    protected Object _deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        Object object;
        Object object2;
        if (jsonParser.canReadTypeId() && (object2 = jsonParser.getTypeId()) != null) {
            return this._deserializeWithNativeTypeId(jsonParser, deserializationContext, object2);
        }
        boolean bl2 = jsonParser.isExpectedStartArrayToken();
        String string = this._locateTypeId(jsonParser, deserializationContext);
        JsonDeserializer<Object> jsonDeserializer = this._findDeserializer(deserializationContext, string);
        if (this._typeIdVisible && !this._usesExternalId() && jsonParser.hasToken(JsonToken.START_OBJECT)) {
            object = deserializationContext.bufferForInputBuffering(jsonParser);
            ((JsonGenerator)object).writeStartObject();
            ((JsonGenerator)object).writeFieldName(this._typePropertyName);
            ((JsonGenerator)object).writeString(string);
            jsonParser.clearCurrentToken();
            jsonParser = JsonParserSequence.createFlattened(false, ((TokenBuffer)object).asParser(jsonParser), jsonParser);
            jsonParser.nextToken();
        }
        if (bl2 && jsonParser.currentToken() == JsonToken.END_ARRAY) {
            return jsonDeserializer.getNullValue(deserializationContext);
        }
        object = jsonDeserializer.deserialize(jsonParser, deserializationContext);
        if (bl2 && jsonParser.nextToken() != JsonToken.END_ARRAY) {
            deserializationContext.reportWrongTokenException(this.baseType(), JsonToken.END_ARRAY, "expected closing `JsonToken.END_ARRAY` after type information and deserialized value", new Object[0]);
        }
        return object;
    }

    protected String _locateTypeId(JsonParser jsonParser, DeserializationContext object) throws IOException {
        if (!jsonParser.isExpectedStartArrayToken()) {
            if (this._defaultImpl != null) {
                String string = this._idResolver.idFromBaseType();
                if (string == null) {
                    ((DatabindContext)object).reportBadDefinition(this._idResolver.getClass(), "`idFromBaseType()` (of " + ClassUtil.classNameOf(this._idResolver) + ") returned `null`");
                }
                return string;
            }
            ((DeserializationContext)object).reportWrongTokenException(this.baseType(), JsonToken.START_ARRAY, "need Array value to contain `As.WRAPPER_ARRAY` type information for class " + this.baseTypeName(), new Object[0]);
            return null;
        }
        JsonToken jsonToken = jsonParser.nextToken();
        if (jsonToken == JsonToken.VALUE_STRING || jsonToken != null && jsonToken.isScalarValue()) {
            object = jsonParser.getText();
            jsonParser.nextToken();
            return object;
        }
        ((DeserializationContext)object).reportWrongTokenException(this.baseType(), JsonToken.VALUE_STRING, "need String, Number of Boolean value that contains type id (for subtype of %s)", this.baseTypeName());
        return null;
    }

    protected boolean _usesExternalId() {
        return false;
    }
}

