/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo$Id;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.impl.ClassNameIdResolver;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.Collection;

public class MinimalClassNameIdResolver
extends ClassNameIdResolver {
    private static final long serialVersionUID = 1L;
    protected final String _basePackageName;
    protected final String _basePackagePrefix;

    @Deprecated
    protected MinimalClassNameIdResolver(JavaType javaType, TypeFactory typeFactory, PolymorphicTypeValidator polymorphicTypeValidator) {
        this(javaType, typeFactory, null, polymorphicTypeValidator);
    }

    protected MinimalClassNameIdResolver(JavaType object, TypeFactory typeFactory, Collection<NamedType> collection, PolymorphicTypeValidator polymorphicTypeValidator) {
        super((JavaType)object, typeFactory, collection, polymorphicTypeValidator);
        object = ((ResolvedType)object).getRawClass().getName();
        int n2 = ((String)object).lastIndexOf(46);
        if (n2 < 0) {
            this._basePackageName = "";
            this._basePackagePrefix = ".";
            return;
        }
        this._basePackagePrefix = ((String)object).substring(0, n2 + 1);
        this._basePackageName = ((String)object).substring(0, n2);
    }

    @Deprecated
    public static MinimalClassNameIdResolver construct(JavaType javaType, MapperConfig<?> mapperConfig, PolymorphicTypeValidator polymorphicTypeValidator) {
        return new MinimalClassNameIdResolver(javaType, mapperConfig.getTypeFactory(), polymorphicTypeValidator);
    }

    public static MinimalClassNameIdResolver construct(JavaType javaType, MapperConfig<?> mapperConfig, Collection<NamedType> collection, PolymorphicTypeValidator polymorphicTypeValidator) {
        return new MinimalClassNameIdResolver(javaType, mapperConfig.getTypeFactory(), collection, polymorphicTypeValidator);
    }

    @Override
    public JsonTypeInfo$Id getMechanism() {
        return JsonTypeInfo$Id.MINIMAL_CLASS;
    }

    @Override
    public String idFromValue(Object object) {
        Object object2 = object;
        return ((ClassNameIdResolver)this).idFromValueAndType(object2, object2.getClass());
    }

    @Override
    public String idFromValueAndType(Object object, Class<?> clazz) {
        object = (clazz = this._resolveToParentAsNecessary(clazz)).getName();
        if (((String)object).startsWith(this._basePackagePrefix)) {
            return ((String)object).substring(this._basePackagePrefix.length() - 1);
        }
        return object;
    }

    @Override
    protected JavaType _typeFromId(String string, DatabindContext databindContext) throws IOException {
        if (string.startsWith(".")) {
            StringBuilder stringBuilder = new StringBuilder(string.length() + this._basePackageName.length());
            if (this._basePackageName.isEmpty()) {
                stringBuilder.append(string.substring(1));
            } else {
                stringBuilder.append(this._basePackageName).append(string);
            }
            string = stringBuilder.toString();
        }
        return super._typeFromId(string, databindContext);
    }
}

