/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.node;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonParser$NumberType;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.core.exc.StreamConstraintsException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonNode$OverwriteMode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.InternalNodeMapper;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.NodeSerialization;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import com.fasterxml.jackson.databind.util.ExceptionUtil;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;

public abstract class BaseJsonNode
extends JsonNode
implements Serializable {
    private static final long serialVersionUID = 1L;

    Object writeReplace() {
        return NodeSerialization.from(this);
    }

    protected BaseJsonNode() {
    }

    @Override
    public final JsonNode findPath(String object) {
        if ((object = this.findValue((String)object)) == null) {
            return MissingNode.getInstance();
        }
        return object;
    }

    public abstract int hashCode();

    @Override
    public JsonNode required(String string) {
        return (JsonNode)this._reportRequiredViolation("Node of type `%s` has no fields", this.getClass().getSimpleName());
    }

    @Override
    public JsonNode required(int n2) {
        return (JsonNode)this._reportRequiredViolation("Node of type `%s` has no indexed values", this.getClass().getSimpleName());
    }

    @Override
    public JsonParser traverse() {
        return new TreeTraversingParser(this);
    }

    @Override
    public JsonParser traverse(ObjectCodec objectCodec) {
        return new TreeTraversingParser(this, objectCodec);
    }

    @Override
    public abstract JsonToken asToken();

    @Override
    public JsonParser$NumberType numberType() {
        return null;
    }

    @Override
    public ObjectNode withObject(JsonPointer jsonPointer, JsonNode$OverwriteMode object, boolean bl2) {
        if (jsonPointer.matches()) {
            if (this instanceof ObjectNode) {
                return (ObjectNode)this;
            }
            this._reportWrongNodeType("Can only call `withObject()` with empty JSON Pointer on `ObjectNode`, not `%s`", this.getClass().getName());
        }
        JsonPointer jsonPointer2 = jsonPointer;
        if ((object = this._withObject(jsonPointer2, jsonPointer2, (JsonNode$OverwriteMode)((Object)object), bl2)) == null) {
            this._reportWrongNodeType("Cannot replace context node (of type `%s`) using `withObject()` with  JSON Pointer '%s'", this.getClass().getName(), jsonPointer);
        }
        return object;
    }

    protected ObjectNode _withObject(JsonPointer jsonPointer, JsonPointer jsonPointer2, JsonNode$OverwriteMode jsonNode$OverwriteMode, boolean bl2) {
        return null;
    }

    protected void _withXxxVerifyReplace(JsonPointer jsonPointer, JsonPointer jsonPointer2, JsonNode$OverwriteMode jsonNode$OverwriteMode, boolean bl2, JsonNode jsonNode) {
        if (!this._withXxxMayReplace(jsonNode, jsonNode$OverwriteMode)) {
            this._reportWrongNodeType("Cannot replace `JsonNode` of type `%s` for property \"%s\" in JSON Pointer \"%s\" (mode `OverwriteMode.%s`)", new Object[]{jsonNode.getClass().getName(), jsonPointer2.getMatchingProperty(), jsonPointer, jsonNode$OverwriteMode});
        }
    }

    protected boolean _withXxxMayReplace(JsonNode jsonNode, JsonNode$OverwriteMode jsonNode$OverwriteMode) {
        switch (jsonNode$OverwriteMode) {
            case NONE: {
                return false;
            }
            case NULLS: {
                return jsonNode.isNull();
            }
            case SCALARS: {
                return !jsonNode.isContainerNode();
            }
        }
        return true;
    }

    @Override
    public ArrayNode withArray(JsonPointer jsonPointer, JsonNode$OverwriteMode object, boolean bl2) {
        if (jsonPointer.matches()) {
            if (this instanceof ArrayNode) {
                return (ArrayNode)this;
            }
            this._reportWrongNodeType("Can only call `withArray()` with empty JSON Pointer on `ArrayNode`, not `%s`", this.getClass().getName());
        }
        JsonPointer jsonPointer2 = jsonPointer;
        if ((object = this._withArray(jsonPointer2, jsonPointer2, (JsonNode$OverwriteMode)((Object)object), bl2)) == null) {
            this._reportWrongNodeType("Cannot replace context node (of type `%s`) using `withArray()` with  JSON Pointer '%s'", this.getClass().getName(), jsonPointer);
        }
        return object;
    }

    protected ArrayNode _withArray(JsonPointer jsonPointer, JsonPointer jsonPointer2, JsonNode$OverwriteMode jsonNode$OverwriteMode, boolean bl2) {
        return null;
    }

    @Override
    public abstract void serialize(JsonGenerator var1, SerializerProvider var2) throws IOException;

    @Override
    public abstract void serializeWithType(JsonGenerator var1, SerializerProvider var2, TypeSerializer var3) throws IOException;

    @Override
    public String toString() {
        return InternalNodeMapper.nodeToString(this);
    }

    @Override
    public String toPrettyString() {
        return InternalNodeMapper.nodeToPrettyString(this);
    }

    protected <T> T _reportWrongNodeType(String string, Object ... objectArray) {
        throw new UnsupportedOperationException(String.format(string, objectArray));
    }

    protected <T> T _reportWrongNodeOperation(String string, Object ... objectArray) {
        throw new UnsupportedOperationException(String.format(string, objectArray));
    }

    protected JsonPointer _jsonPointerIfValid(String string) {
        if (string.isEmpty() || string.charAt(0) == '/') {
            return JsonPointer.compile(string);
        }
        return null;
    }

    protected BigInteger _bigIntFromBigDec(BigDecimal bigDecimal) {
        try {
            StreamReadConstraints.defaults().validateBigIntegerScale(bigDecimal.scale());
        }
        catch (StreamConstraintsException streamConstraintsException) {
            StreamConstraintsException streamConstraintsException2 = streamConstraintsException;
            ExceptionUtil.throwSneaky(streamConstraintsException);
        }
        return bigDecimal.toBigInteger();
    }
}

