/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.node;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.io.IOException;
import java.util.Optional;

public final class MissingNode
extends ValueNode {
    private static final long serialVersionUID = 1L;
    private static final MissingNode instance = new MissingNode();

    protected MissingNode() {
    }

    protected final Object readResolve() {
        return instance;
    }

    @Override
    public final boolean isMissingNode() {
        return true;
    }

    @Override
    public final <T extends JsonNode> T deepCopy() {
        return (T)this;
    }

    public static MissingNode getInstance() {
        return instance;
    }

    @Override
    public final JsonNodeType getNodeType() {
        return JsonNodeType.MISSING;
    }

    @Override
    public final JsonToken asToken() {
        return JsonToken.NOT_AVAILABLE;
    }

    @Override
    public final String asText() {
        return "";
    }

    @Override
    public final String asText(String string) {
        return string;
    }

    @Override
    public final Optional<JsonNode> asOptional() {
        return Optional.empty();
    }

    @Override
    public final void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeNull();
    }

    @Override
    public final void serializeWithType(JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        jsonGenerator.writeNull();
    }

    public final JsonNode require() {
        return (JsonNode)this._reportRequiredViolation("require() called on `MissingNode`", new Object[0]);
    }

    public final JsonNode requireNonNull() {
        return (JsonNode)this._reportRequiredViolation("requireNonNull() called on `MissingNode`", new Object[0]);
    }

    @Override
    public final int hashCode() {
        return JsonNodeType.MISSING.ordinal();
    }

    @Override
    public final String toString() {
        return "";
    }

    @Override
    public final String toPrettyString() {
        return "";
    }

    @Override
    public final boolean equals(Object object) {
        return object == this;
    }
}

