/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.node;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonParser$NumberType;
import com.fasterxml.jackson.core.JsonParser$NumberTypeFP;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.StreamReadCapability;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.ParserMinimalBase;
import com.fasterxml.jackson.core.util.JacksonFeatureSet;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.cfg.PackageVersion;
import com.fasterxml.jackson.databind.node.BinaryNode;
import com.fasterxml.jackson.databind.node.NodeCursor;
import com.fasterxml.jackson.databind.node.NodeCursor$RootCursor;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.POJONode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;

public class TreeTraversingParser
extends ParserMinimalBase {
    protected ObjectCodec _objectCodec;
    protected NodeCursor _nodeCursor;
    protected boolean _closed;

    public TreeTraversingParser(JsonNode jsonNode) {
        this(jsonNode, null);
    }

    public TreeTraversingParser(JsonNode jsonNode, ObjectCodec objectCodec) {
        super(StreamReadConstraints.defaults());
        this._objectCodec = objectCodec;
        this._nodeCursor = new NodeCursor$RootCursor(jsonNode, null);
    }

    @Override
    public void setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
    }

    @Override
    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public JacksonFeatureSet<StreamReadCapability> getReadCapabilities() {
        return DEFAULT_READ_CAPABILITIES;
    }

    @Override
    public void close() throws IOException {
        if (!this._closed) {
            this._closed = true;
            this._nodeCursor = null;
            this._updateTokenToNull();
        }
    }

    @Override
    public JsonToken nextToken() throws IOException {
        TreeTraversingParser treeTraversingParser = this;
        treeTraversingParser._nullSafeUpdateToken(treeTraversingParser._nodeCursor.nextToken());
        if (this._currToken == null) {
            this._closed = true;
            return null;
        }
        switch (this._currToken) {
            case START_OBJECT: {
                this._nodeCursor = this._nodeCursor.startObject();
                break;
            }
            case START_ARRAY: {
                this._nodeCursor = this._nodeCursor.startArray();
                break;
            }
            case END_OBJECT: 
            case END_ARRAY: {
                this._nodeCursor = this._nodeCursor.getParent();
            }
        }
        return this._currToken;
    }

    @Override
    public JsonParser skipChildren() throws IOException {
        if (this._currToken == JsonToken.START_OBJECT) {
            this._nodeCursor = this._nodeCursor.getParent();
            this._updateToken(JsonToken.END_OBJECT);
        } else if (this._currToken == JsonToken.START_ARRAY) {
            this._nodeCursor = this._nodeCursor.getParent();
            this._updateToken(JsonToken.END_ARRAY);
        }
        return this;
    }

    @Override
    public boolean isClosed() {
        return this._closed;
    }

    @Override
    public String currentName() {
        NodeCursor nodeCursor = this._nodeCursor;
        if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
            nodeCursor = nodeCursor.getParent();
        }
        if (nodeCursor == null) {
            return null;
        }
        return ((JsonStreamContext)nodeCursor).getCurrentName();
    }

    @Override
    @Deprecated
    public String getCurrentName() {
        return ((JsonParser)this).currentName();
    }

    @Override
    public void overrideCurrentName(String string) {
        NodeCursor nodeCursor = this._nodeCursor;
        if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
            nodeCursor = nodeCursor.getParent();
        }
        if (nodeCursor != null) {
            nodeCursor.overrideCurrentName(string);
        }
    }

    @Override
    public JsonStreamContext getParsingContext() {
        return this._nodeCursor;
    }

    @Override
    public JsonLocation currentLocation() {
        return JsonLocation.NA;
    }

    @Override
    public JsonLocation currentTokenLocation() {
        return JsonLocation.NA;
    }

    @Override
    @Deprecated
    public JsonLocation getTokenLocation() {
        return ((JsonParser)this).currentTokenLocation();
    }

    @Override
    @Deprecated
    public JsonLocation getCurrentLocation() {
        return ((JsonParser)this).currentLocation();
    }

    @Override
    public String getText() {
        if (this._currToken == null) {
            return null;
        }
        switch (this._currToken) {
            case FIELD_NAME: {
                return ((JsonStreamContext)this._nodeCursor).getCurrentName();
            }
            case VALUE_STRING: {
                return this.currentNode().textValue();
            }
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: {
                return String.valueOf(this.currentNode().numberValue());
            }
            case VALUE_EMBEDDED_OBJECT: {
                JsonNode jsonNode = this.currentNode();
                if (jsonNode == null || !jsonNode.isBinary()) break;
                return jsonNode.asText();
            }
        }
        return this._currToken.asString();
    }

    @Override
    public char[] getTextCharacters() throws IOException {
        return ((JsonParser)this).getText().toCharArray();
    }

    @Override
    public int getTextLength() throws IOException {
        return ((JsonParser)this).getText().length();
    }

    @Override
    public int getTextOffset() throws IOException {
        return 0;
    }

    @Override
    public boolean hasTextCharacters() {
        return false;
    }

    @Override
    public JsonParser$NumberType getNumberType() throws IOException {
        JsonNode jsonNode = this.currentNumericNode();
        if (jsonNode == null) {
            return null;
        }
        return jsonNode.numberType();
    }

    @Override
    public JsonParser$NumberTypeFP getNumberTypeFP() throws IOException {
        JsonParser$NumberType jsonParser$NumberType = ((JsonParser)this).getNumberType();
        if (jsonParser$NumberType == JsonParser$NumberType.BIG_DECIMAL) {
            return JsonParser$NumberTypeFP.BIG_DECIMAL;
        }
        if (jsonParser$NumberType == JsonParser$NumberType.DOUBLE) {
            return JsonParser$NumberTypeFP.DOUBLE64;
        }
        if (jsonParser$NumberType == JsonParser$NumberType.FLOAT) {
            return JsonParser$NumberTypeFP.FLOAT32;
        }
        return JsonParser$NumberTypeFP.UNKNOWN;
    }

    @Override
    public BigInteger getBigIntegerValue() throws IOException {
        return this.currentNumericNode().bigIntegerValue();
    }

    @Override
    public BigDecimal getDecimalValue() throws IOException {
        return this.currentNumericNode().decimalValue();
    }

    @Override
    public double getDoubleValue() throws IOException {
        return this.currentNumericNode().doubleValue();
    }

    @Override
    public float getFloatValue() throws IOException {
        return (float)this.currentNumericNode().doubleValue();
    }

    @Override
    public int getIntValue() throws IOException {
        NumericNode numericNode = (NumericNode)this.currentNumericNode();
        if (!((JsonNode)numericNode).canConvertToInt()) {
            this.reportOverflowInt();
        }
        return ((JsonNode)numericNode).intValue();
    }

    @Override
    public long getLongValue() throws IOException {
        NumericNode numericNode = (NumericNode)this.currentNumericNode();
        if (!((JsonNode)numericNode).canConvertToLong()) {
            this.reportOverflowLong();
        }
        return ((JsonNode)numericNode).longValue();
    }

    @Override
    public Number getNumberValue() throws IOException {
        return this.currentNumericNode().numberValue();
    }

    @Override
    public Object getEmbeddedObject() {
        JsonNode jsonNode;
        if (!this._closed && (jsonNode = this.currentNode()) != null) {
            if (jsonNode.isPojo()) {
                return ((POJONode)jsonNode).getPojo();
            }
            if (jsonNode.isBinary()) {
                return ((JsonNode)((BinaryNode)jsonNode)).binaryValue();
            }
        }
        return null;
    }

    @Override
    public boolean isNaN() {
        JsonNode jsonNode;
        if (!this._closed && (jsonNode = this.currentNode()) instanceof NumericNode) {
            return ((NumericNode)jsonNode).isNaN();
        }
        return false;
    }

    @Override
    public byte[] getBinaryValue(Base64Variant base64Variant) throws IOException {
        JsonNode jsonNode = this.currentNode();
        if (jsonNode != null) {
            if (jsonNode instanceof TextNode) {
                return ((TextNode)jsonNode).getBinaryValue(base64Variant);
            }
            return jsonNode.binaryValue();
        }
        return null;
    }

    @Override
    public int readBinaryValue(Base64Variant object, OutputStream outputStream) throws IOException {
        byte[] byArray = ((JsonParser)this).getBinaryValue((Base64Variant)object);
        object = byArray;
        if (byArray != null) {
            outputStream.write((byte[])object, 0, ((Object)object).length);
            return ((Object)object).length;
        }
        return 0;
    }

    protected JsonNode currentNode() {
        if (this._closed || this._nodeCursor == null) {
            return null;
        }
        return this._nodeCursor.currentNode();
    }

    protected JsonNode currentNumericNode() throws JacksonException {
        Object object = this.currentNode();
        if (object == null || !object.isNumber()) {
            object = object == null ? null : object.asToken();
            throw this._constructError("Current token (" + object + ") not numeric, cannot use numeric value accessors");
        }
        return object;
    }

    @Override
    protected void _handleEOF() {
        this._throwInternal();
    }
}

