/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.impl;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ser.impl.ReadOnlyClassToSerializerMap$Bucket;
import com.fasterxml.jackson.databind.util.LookupCache;
import com.fasterxml.jackson.databind.util.TypeKey;

public final class ReadOnlyClassToSerializerMap {
    private final ReadOnlyClassToSerializerMap$Bucket[] _buckets;
    private final int _size;
    private final int _mask;

    public ReadOnlyClassToSerializerMap(LookupCache<TypeKey, JsonSerializer<Object>> lookupCache) {
        this._size = ReadOnlyClassToSerializerMap.findSize(lookupCache.size());
        this._mask = this._size - 1;
        ReadOnlyClassToSerializerMap$Bucket[] readOnlyClassToSerializerMap$BucketArray = new ReadOnlyClassToSerializerMap$Bucket[this._size];
        lookupCache.contents((typeKey, jsonSerializer) -> {
            int n2 = typeKey.hashCode() & this._mask;
            readOnlyClassToSerializerMap$BucketArray[n2] = new ReadOnlyClassToSerializerMap$Bucket(readOnlyClassToSerializerMap$BucketArray[n2], (TypeKey)typeKey, (JsonSerializer<Object>)jsonSerializer);
        });
        this._buckets = readOnlyClassToSerializerMap$BucketArray;
    }

    private static final int findSize(int n2) {
        int n3;
        if (n2 <= 64) {
            int n4 = n2;
            n3 = n4 + n4;
        } else {
            int n5 = n2;
            n3 = n5 + (n5 >> 2);
        }
        n2 = n3;
        int n6 = 8;
        while (n6 < n2) {
            int n7 = n6;
            n6 = n7 + n7;
        }
        return n6;
    }

    public static ReadOnlyClassToSerializerMap from(LookupCache<TypeKey, JsonSerializer<Object>> lookupCache) {
        return new ReadOnlyClassToSerializerMap(lookupCache);
    }

    public final int size() {
        return this._size;
    }

    public final JsonSerializer<Object> typedValueSerializer(JavaType javaType) {
        ReadOnlyClassToSerializerMap$Bucket readOnlyClassToSerializerMap$Bucket = this._buckets[TypeKey.typedHash(javaType) & this._mask];
        if (readOnlyClassToSerializerMap$Bucket == null) {
            return null;
        }
        if (readOnlyClassToSerializerMap$Bucket.matchesTyped(javaType)) {
            return readOnlyClassToSerializerMap$Bucket.value;
        }
        while ((readOnlyClassToSerializerMap$Bucket = readOnlyClassToSerializerMap$Bucket.next) != null) {
            if (!readOnlyClassToSerializerMap$Bucket.matchesTyped(javaType)) continue;
            return readOnlyClassToSerializerMap$Bucket.value;
        }
        return null;
    }

    public final JsonSerializer<Object> typedValueSerializer(Class<?> clazz) {
        ReadOnlyClassToSerializerMap$Bucket readOnlyClassToSerializerMap$Bucket = this._buckets[TypeKey.typedHash(clazz) & this._mask];
        if (readOnlyClassToSerializerMap$Bucket == null) {
            return null;
        }
        if (readOnlyClassToSerializerMap$Bucket.matchesTyped(clazz)) {
            return readOnlyClassToSerializerMap$Bucket.value;
        }
        while ((readOnlyClassToSerializerMap$Bucket = readOnlyClassToSerializerMap$Bucket.next) != null) {
            if (!readOnlyClassToSerializerMap$Bucket.matchesTyped(clazz)) continue;
            return readOnlyClassToSerializerMap$Bucket.value;
        }
        return null;
    }

    public final JsonSerializer<Object> untypedValueSerializer(JavaType javaType) {
        ReadOnlyClassToSerializerMap$Bucket readOnlyClassToSerializerMap$Bucket = this._buckets[TypeKey.untypedHash(javaType) & this._mask];
        if (readOnlyClassToSerializerMap$Bucket == null) {
            return null;
        }
        if (readOnlyClassToSerializerMap$Bucket.matchesUntyped(javaType)) {
            return readOnlyClassToSerializerMap$Bucket.value;
        }
        while ((readOnlyClassToSerializerMap$Bucket = readOnlyClassToSerializerMap$Bucket.next) != null) {
            if (!readOnlyClassToSerializerMap$Bucket.matchesUntyped(javaType)) continue;
            return readOnlyClassToSerializerMap$Bucket.value;
        }
        return null;
    }

    public final JsonSerializer<Object> untypedValueSerializer(Class<?> clazz) {
        ReadOnlyClassToSerializerMap$Bucket readOnlyClassToSerializerMap$Bucket = this._buckets[TypeKey.untypedHash(clazz) & this._mask];
        if (readOnlyClassToSerializerMap$Bucket == null) {
            return null;
        }
        if (readOnlyClassToSerializerMap$Bucket.matchesUntyped(clazz)) {
            return readOnlyClassToSerializerMap$Bucket.value;
        }
        while ((readOnlyClassToSerializerMap$Bucket = readOnlyClassToSerializerMap$Bucket.next) != null) {
            if (!readOnlyClassToSerializerMap$Bucket.matchesUntyped(clazz)) continue;
            return readOnlyClassToSerializerMap$Bucket.value;
        }
        return null;
    }
}

