/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.impl;

import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.impl.ObjectIdWriter;
import java.io.IOException;

public final class WritableObjectId {
    public final ObjectIdGenerator<?> generator;
    public Object id;
    protected boolean idWritten = false;

    public WritableObjectId(ObjectIdGenerator<?> objectIdGenerator) {
        this.generator = objectIdGenerator;
    }

    public final boolean writeAsId(JsonGenerator jsonGenerator, SerializerProvider serializerProvider, ObjectIdWriter objectIdWriter) throws IOException {
        if (this.id != null && (this.idWritten || objectIdWriter.alwaysAsId)) {
            if (jsonGenerator.canWriteObjectId()) {
                jsonGenerator.writeObjectRef(String.valueOf(this.id));
            } else {
                objectIdWriter.serializer.serialize(this.id, jsonGenerator, serializerProvider);
            }
            return true;
        }
        return false;
    }

    public final Object generateId(Object object) {
        if (this.id == null) {
            this.id = this.generator.generateId(object);
        }
        return this.id;
    }

    public final void writeAsField(JsonGenerator jsonGenerator, SerializerProvider serializerProvider, ObjectIdWriter objectIdWriter) throws IOException {
        this.idWritten = true;
        if (jsonGenerator.canWriteObjectId()) {
            String string = this.id == null ? null : String.valueOf(this.id);
            jsonGenerator.writeObjectId(string);
            return;
        }
        SerializableString serializableString = objectIdWriter.propertyName;
        if (serializableString != null) {
            jsonGenerator.writeFieldName(serializableString);
            objectIdWriter.serializer.serialize(this.id, jsonGenerator, serializerProvider);
        }
    }
}

