/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.annotation.JsonFormat$Feature;
import com.fasterxml.jackson.annotation.JsonFormat$Value;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonschema.JsonSchema;
import com.fasterxml.jackson.databind.jsonschema.SchemaAware;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap$SerializerAndMapResult;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Objects;

public abstract class AsArraySerializerBase<T>
extends ContainerSerializer<T>
implements ContextualSerializer {
    protected final JavaType _elementType;
    protected final BeanProperty _property;
    protected final boolean _staticTyping;
    protected final Boolean _unwrapSingle;
    protected final TypeSerializer _valueTypeSerializer;
    protected final JsonSerializer<Object> _elementSerializer;
    protected PropertySerializerMap _dynamicSerializers;

    protected AsArraySerializerBase(Class<?> clazz, JavaType javaType, boolean bl2, TypeSerializer typeSerializer, JsonSerializer<Object> jsonSerializer) {
        this(clazz, javaType, bl2, typeSerializer, null, jsonSerializer, null);
    }

    @Deprecated
    protected AsArraySerializerBase(Class<?> clazz, JavaType javaType, boolean bl2, TypeSerializer typeSerializer, BeanProperty beanProperty, JsonSerializer<Object> jsonSerializer) {
        this(clazz, javaType, bl2, typeSerializer, beanProperty, jsonSerializer, null);
    }

    protected AsArraySerializerBase(Class<?> clazz, JavaType javaType, boolean bl2, TypeSerializer typeSerializer, BeanProperty beanProperty, JsonSerializer<?> jsonSerializer, Boolean bl3) {
        super(clazz, false);
        this._elementType = javaType;
        this._staticTyping = bl2 || javaType != null && ((ResolvedType)javaType).isFinal();
        this._valueTypeSerializer = typeSerializer;
        this._property = beanProperty;
        this._elementSerializer = jsonSerializer;
        this._dynamicSerializers = PropertySerializerMap.emptyForProperties();
        this._unwrapSingle = bl3;
    }

    protected AsArraySerializerBase(AsArraySerializerBase<?> asArraySerializerBase, BeanProperty beanProperty, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer, Boolean bl2) {
        super((ContainerSerializer<?>)asArraySerializerBase);
        this._elementType = asArraySerializerBase._elementType;
        this._staticTyping = asArraySerializerBase._staticTyping;
        this._valueTypeSerializer = typeSerializer;
        this._property = beanProperty;
        this._elementSerializer = jsonSerializer;
        this._dynamicSerializers = PropertySerializerMap.emptyForProperties();
        this._unwrapSingle = bl2;
    }

    @Deprecated
    protected AsArraySerializerBase(AsArraySerializerBase<?> asArraySerializerBase, BeanProperty beanProperty, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer) {
        this(asArraySerializerBase, beanProperty, typeSerializer, jsonSerializer, asArraySerializerBase._unwrapSingle);
    }

    @Deprecated
    public final AsArraySerializerBase<T> withResolved(BeanProperty beanProperty, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer) {
        return this.withResolved(beanProperty, typeSerializer, jsonSerializer, this._unwrapSingle);
    }

    public abstract AsArraySerializerBase<T> withResolved(BeanProperty var1, TypeSerializer var2, JsonSerializer<?> var3, Boolean var4);

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        Object object;
        TypeSerializer typeSerializer = this._valueTypeSerializer;
        if (typeSerializer != null) {
            typeSerializer = typeSerializer.forProperty(beanProperty);
        }
        JsonSerializer<Object> jsonSerializer = null;
        Boolean bl2 = null;
        if (beanProperty != null) {
            object = ((DatabindContext)serializerProvider).getAnnotationIntrospector();
            AnnotatedMember annotatedMember = beanProperty.getMember();
            if (annotatedMember != null && (object = ((AnnotationIntrospector)object).findContentSerializer(annotatedMember)) != null) {
                jsonSerializer = serializerProvider.serializerInstance(annotatedMember, object);
            }
        }
        if ((object = this.findFormatOverrides(serializerProvider, beanProperty, ((JsonSerializer)this).handledType())) != null) {
            bl2 = ((JsonFormat$Value)object).getFeature(JsonFormat$Feature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED);
        }
        if (jsonSerializer == null) {
            jsonSerializer = this._elementSerializer;
        }
        if ((jsonSerializer = this.findContextualConvertingSerializer(serializerProvider, beanProperty, jsonSerializer)) == null && this._elementType != null && this._staticTyping && !this._elementType.isJavaLangObject()) {
            jsonSerializer = serializerProvider.findContentValueSerializer(this._elementType, beanProperty);
        }
        if (jsonSerializer != this._elementSerializer || beanProperty != this._property || this._valueTypeSerializer != typeSerializer || !Objects.equals(this._unwrapSingle, bl2)) {
            return this.withResolved(beanProperty, typeSerializer, jsonSerializer, bl2);
        }
        return this;
    }

    @Override
    public JavaType getContentType() {
        return this._elementType;
    }

    @Override
    public JsonSerializer<?> getContentSerializer() {
        return this._elementSerializer;
    }

    @Override
    public void serialize(T t2, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (serializerProvider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) && this.hasSingleElement(t2)) {
            this.serializeContents(t2, jsonGenerator, serializerProvider);
            return;
        }
        jsonGenerator.writeStartArray(t2);
        this.serializeContents(t2, jsonGenerator, serializerProvider);
        jsonGenerator.writeEndArray();
    }

    @Override
    public void serializeWithType(T t2, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        WritableTypeId writableTypeId = typeSerializer.writeTypePrefix(jsonGenerator, typeSerializer.typeId(t2, JsonToken.START_ARRAY));
        jsonGenerator.assignCurrentValue(t2);
        this.serializeContents(t2, jsonGenerator, serializerProvider);
        typeSerializer.writeTypeSuffix(jsonGenerator, writableTypeId);
    }

    protected abstract void serializeContents(T var1, JsonGenerator var2, SerializerProvider var3) throws IOException;

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider serializerProvider, Type object) throws JsonMappingException {
        object = this.createSchemaNode("array", true);
        if (this._elementSerializer != null) {
            JsonNode jsonNode = null;
            if (this._elementSerializer instanceof SchemaAware) {
                jsonNode = ((SchemaAware)((Object)this._elementSerializer)).getSchema(serializerProvider, null);
            }
            if (jsonNode == null) {
                jsonNode = JsonSchema.getDefaultSchemaNode();
            }
            ((ObjectNode)object).set("items", jsonNode);
        }
        return object;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
        JsonSerializer<Object> jsonSerializer = this._elementSerializer;
        if (jsonSerializer == null && this._elementType != null) {
            jsonSerializer = jsonFormatVisitorWrapper.getProvider().findContentValueSerializer(this._elementType, this._property);
        }
        this.visitArrayFormat(jsonFormatVisitorWrapper, javaType, jsonSerializer, this._elementType);
    }

    protected final JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap propertySerializerMap, Class<?> object, SerializerProvider serializerProvider) throws JsonMappingException {
        object = propertySerializerMap.findAndAddSecondarySerializer((Class<?>)object, serializerProvider, this._property);
        if (propertySerializerMap != ((PropertySerializerMap$SerializerAndMapResult)object).map) {
            this._dynamicSerializers = ((PropertySerializerMap$SerializerAndMapResult)object).map;
        }
        return ((PropertySerializerMap$SerializerAndMapResult)object).serializer;
    }

    protected final JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap propertySerializerMap, JavaType object, SerializerProvider serializerProvider) throws JsonMappingException {
        object = propertySerializerMap.findAndAddSecondarySerializer((JavaType)object, serializerProvider, this._property);
        if (propertySerializerMap != ((PropertySerializerMap$SerializerAndMapResult)object).map) {
            this._dynamicSerializers = ((PropertySerializerMap$SerializerAndMapResult)object).map;
        }
        return ((PropertySerializerMap$SerializerAndMapResult)object).serializer;
    }
}

