/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.annotation.JsonFormat$Shape;
import com.fasterxml.jackson.annotation.JsonFormat$Value;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser$NumberType;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.EnumNamingStrategy;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.EnumNamingStrategyFactory;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.fasterxml.jackson.databind.util.EnumValues;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

@JacksonStdImpl
public class EnumSerializer
extends StdScalarSerializer<Enum<?>>
implements ContextualSerializer {
    private static final long serialVersionUID = 1L;
    protected final EnumValues _values;
    protected final Boolean _serializeAsIndex;
    protected final EnumValues _valuesByEnumNaming;
    protected final EnumValues _valuesByToString;

    @Deprecated
    public EnumSerializer(EnumValues enumValues, Boolean bl2) {
        this(enumValues, bl2, null, null);
    }

    @Deprecated
    public EnumSerializer(EnumValues enumValues, Boolean bl2, EnumValues enumValues2) {
        this(enumValues, bl2, enumValues2, null);
    }

    public EnumSerializer(EnumValues enumValues, Boolean bl2, EnumValues enumValues2, EnumValues enumValues3) {
        super(enumValues.getEnumClass(), false);
        this._values = enumValues;
        this._serializeAsIndex = bl2;
        this._valuesByEnumNaming = enumValues2;
        this._valuesByToString = enumValues3;
    }

    public static EnumSerializer construct(Class<?> constable, SerializationConfig serializable, BeanDescription beanDescription, JsonFormat$Value jsonFormat$Value) {
        EnumValues enumValues = EnumValues.constructFromName(serializable, beanDescription.getClassInfo());
        EnumValues enumValues2 = EnumSerializer.constructEnumNamingStrategyValues(serializable, constable, beanDescription.getClassInfo());
        serializable = EnumValues.constructFromToString(serializable, beanDescription.getClassInfo());
        constable = EnumSerializer._isShapeWrittenUsingIndex(constable, jsonFormat$Value, true, null);
        return new EnumSerializer(enumValues, (Boolean)constable, enumValues2, (EnumValues)serializable);
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider object, BeanProperty object2) throws JsonMappingException {
        if ((object = this.findFormatOverrides((SerializerProvider)object, (BeanProperty)object2, ((JsonSerializer)this).handledType())) != null && !Objects.equals(object = EnumSerializer._isShapeWrittenUsingIndex(object2 = ((JsonSerializer)this).handledType(), (JsonFormat$Value)object, false, this._serializeAsIndex), this._serializeAsIndex)) {
            return new EnumSerializer(this._values, (Boolean)object, this._valuesByEnumNaming, this._valuesByToString);
        }
        return this;
    }

    public EnumValues getEnumValues() {
        return this._values;
    }

    @Override
    public final void serialize(Enum<?> enum_, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (this._valuesByEnumNaming != null) {
            jsonGenerator.writeString(this._valuesByEnumNaming.serializedValueFor(enum_));
            return;
        }
        if (this._serializeAsIndex(serializerProvider)) {
            jsonGenerator.writeNumber(enum_.ordinal());
            return;
        }
        if (serializerProvider.isEnabled(SerializationFeature.WRITE_ENUMS_USING_TO_STRING)) {
            jsonGenerator.writeString(this._valuesByToString.serializedValueFor(enum_));
            return;
        }
        jsonGenerator.writeString(this._values.serializedValueFor(enum_));
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider object, Type object2) {
        if (this._serializeAsIndex((SerializerProvider)object)) {
            return this.createSchemaNode("integer", true);
        }
        ObjectNode objectNode = this.createSchemaNode("string", true);
        if (object2 != null && ((ResolvedType)(object = ((DatabindContext)object).constructType((Type)object2))).isEnumType()) {
            object = objectNode.putArray("enum");
            for (SerializableString serializableString : this._values.values()) {
                ((ArrayNode)object).add(serializableString.getValue());
            }
        }
        return objectNode;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper object, JavaType serializable) throws JsonMappingException {
        SerializerProvider serializerProvider = object.getProvider();
        if (this._serializeAsIndex(serializerProvider)) {
            this.visitIntFormat((JsonFormatVisitorWrapper)object, (JavaType)serializable, JsonParser$NumberType.INT);
            return;
        }
        if ((object = object.expectStringFormat((JavaType)serializable)) != null) {
            serializable = new LinkedHashSet();
            if (serializerProvider != null && serializerProvider.isEnabled(SerializationFeature.WRITE_ENUMS_USING_TO_STRING)) {
                for (SerializableString serializableString : this._valuesByToString.values()) {
                    serializable.add(serializableString.getValue());
                }
            } else {
                for (SerializableString serializableString : this._values.values()) {
                    serializable.add(serializableString.getValue());
                }
            }
            object.enumTypes((Set<String>)((Object)serializable));
        }
    }

    protected final boolean _serializeAsIndex(SerializerProvider serializerProvider) {
        if (this._serializeAsIndex != null) {
            return this._serializeAsIndex;
        }
        return serializerProvider.isEnabled(SerializationFeature.WRITE_ENUMS_USING_INDEX);
    }

    protected static Boolean _isShapeWrittenUsingIndex(Class<?> clazz, JsonFormat$Value object, boolean bl2, Boolean bl3) {
        if ((object = object == null ? null : ((JsonFormat$Value)object).getShape()) == null) {
            return bl3;
        }
        if (object == JsonFormat$Shape.ANY || object == JsonFormat$Shape.SCALAR) {
            return bl3;
        }
        if (object == JsonFormat$Shape.STRING || object == JsonFormat$Shape.NATURAL) {
            return Boolean.FALSE;
        }
        if (((JsonFormat$Shape)((Object)object)).isNumeric() || object == JsonFormat$Shape.ARRAY) {
            return Boolean.TRUE;
        }
        throw new IllegalArgumentException(String.format("Unsupported serialization shape (%s) for Enum %s, not supported as %s annotation", object, clazz.getName(), bl2 ? "class" : "property"));
    }

    protected static EnumValues constructEnumNamingStrategyValues(SerializationConfig serializationConfig, Class<Enum<?>> object, AnnotatedClass annotatedClass) {
        object = serializationConfig.getAnnotationIntrospector().findEnumNamingStrategy(serializationConfig, annotatedClass);
        if ((object = EnumNamingStrategyFactory.createEnumNamingStrategyInstance(object, serializationConfig.canOverrideAccessModifiers(), serializationConfig.getEnumNamingStrategy())) == null) {
            return null;
        }
        return EnumValues.constructUsingEnumNamingStrategy(serializationConfig, annotatedClass, (EnumNamingStrategy)object);
    }
}

