/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.ser.std.StdArraySerializers;
import com.fasterxml.jackson.databind.ser.std.StdArraySerializers$TypedPrimitiveArraySerializer;
import java.io.IOException;
import java.lang.reflect.Type;

@JacksonStdImpl
public class StdArraySerializers$LongArraySerializer
extends StdArraySerializers$TypedPrimitiveArraySerializer<long[]> {
    private static final JavaType VALUE_TYPE = StdArraySerializers.simpleElementType(Long.TYPE);

    public StdArraySerializers$LongArraySerializer() {
        super(long[].class);
    }

    public StdArraySerializers$LongArraySerializer(StdArraySerializers$LongArraySerializer stdArraySerializers$LongArraySerializer, BeanProperty beanProperty, Boolean bl2) {
        super(stdArraySerializers$LongArraySerializer, beanProperty, bl2);
    }

    @Override
    public JsonSerializer<?> _withResolved(BeanProperty beanProperty, Boolean bl2) {
        return new StdArraySerializers$LongArraySerializer(this, beanProperty, bl2);
    }

    @Override
    public JavaType getContentType() {
        return VALUE_TYPE;
    }

    @Override
    public JsonSerializer<?> getContentSerializer() {
        return null;
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider, long[] lArray) {
        return lArray.length == 0;
    }

    @Override
    public boolean hasSingleElement(long[] lArray) {
        return lArray.length == 1;
    }

    @Override
    public final void serialize(long[] lArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        int n2 = lArray.length;
        if (n2 == 1 && this._shouldUnwrapSingle(serializerProvider)) {
            this.serializeContents(lArray, jsonGenerator, serializerProvider);
            return;
        }
        jsonGenerator.writeArray(lArray, 0, lArray.length);
    }

    @Override
    public void serializeContents(long[] lArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        int n2 = lArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            jsonGenerator.writeNumber(lArray[i2]);
        }
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        return this.createSchemaNode("array", true).set("items", this.createSchemaNode("number", true));
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
        this.visitArrayFormat(jsonFormatVisitorWrapper, javaType, JsonFormatTypes.NUMBER);
    }
}

