/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.ser.std.EnumSerializer;
import com.fasterxml.jackson.databind.ser.std.StdKeySerializer;
import com.fasterxml.jackson.databind.ser.std.StdKeySerializers$Default;
import com.fasterxml.jackson.databind.ser.std.StdKeySerializers$Dynamic;
import com.fasterxml.jackson.databind.ser.std.StdKeySerializers$EnumKeySerializer;
import com.fasterxml.jackson.databind.ser.std.StdKeySerializers$StringKeySerializer;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.EnumValues;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;

public abstract class StdKeySerializers {
    protected static final JsonSerializer<Object> DEFAULT_KEY_SERIALIZER = new StdKeySerializer();
    protected static final JsonSerializer<Object> DEFAULT_STRING_SERIALIZER = new StdKeySerializers$StringKeySerializer();

    public static JsonSerializer<Object> getStdKeySerializer(SerializationConfig serializationConfig, Class<?> clazz, boolean bl2) {
        if (clazz == null || clazz == Object.class) {
            return new StdKeySerializers$Dynamic();
        }
        if (clazz == String.class) {
            return DEFAULT_STRING_SERIALIZER;
        }
        if (clazz.isPrimitive()) {
            clazz = ClassUtil.wrapperType(clazz);
        }
        if (clazz == Integer.class) {
            return new StdKeySerializers$Default(5, clazz);
        }
        if (clazz == Long.class) {
            return new StdKeySerializers$Default(6, clazz);
        }
        if (clazz.isPrimitive() || Number.class.isAssignableFrom(clazz)) {
            return new StdKeySerializers$Default(8, clazz);
        }
        if (clazz == Class.class) {
            return new StdKeySerializers$Default(3, clazz);
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return new StdKeySerializers$Default(1, clazz);
        }
        if (Calendar.class.isAssignableFrom(clazz)) {
            return new StdKeySerializers$Default(2, clazz);
        }
        if (clazz == UUID.class) {
            return new StdKeySerializers$Default(8, clazz);
        }
        if (clazz == byte[].class) {
            return new StdKeySerializers$Default(7, clazz);
        }
        if (bl2) {
            return new StdKeySerializers$Default(8, clazz);
        }
        return null;
    }

    public static JsonSerializer<Object> getFallbackKeySerializer(SerializationConfig serializationConfig, Class<?> clazz, AnnotatedClass annotatedClass) {
        if (clazz != null) {
            if (clazz == Enum.class) {
                return new StdKeySerializers$Dynamic();
            }
            if (ClassUtil.isEnumType(clazz)) {
                return StdKeySerializers$EnumKeySerializer.construct(clazz, EnumValues.constructFromName(serializationConfig, annotatedClass), EnumSerializer.constructEnumNamingStrategyValues(serializationConfig, clazz, annotatedClass));
            }
        }
        return new StdKeySerializers$Default(8, clazz);
    }

    @Deprecated
    public static JsonSerializer<Object> getDefault() {
        return DEFAULT_KEY_SERIALIZER;
    }
}

